/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.copy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.CrossRepositoryCopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public class CrossRepositoryCopyServiceImpl
implements CrossRepositoryCopyService {
    private NodeService fNodeService;
    private FileFolderService fFileFolderService;
    private CopyService fCopyService;
    private AVMService fAVMService;
    private ContentService fContentService;
    private DictionaryService fDictionaryService;

    public void setAvmService(AVMService service) {
        this.fAVMService = service;
    }

    public void setContentService(ContentService service) {
        this.fContentService = service;
    }

    public void setCopyService(CopyService service) {
        this.fCopyService = service;
    }

    public void setDictionaryService(DictionaryService service) {
        this.fDictionaryService = service;
    }

    public void setFileFolderService(FileFolderService service) {
        this.fFileFolderService = service;
    }

    public void setNodeService(NodeService service) {
        this.fNodeService = service;
    }

    public void copy(NodeRef src, NodeRef dst, String name) {
        StoreRef srcStoreRef = src.getStoreRef();
        StoreRef dstStoreRef = dst.getStoreRef();
        if (srcStoreRef.getProtocol().equals("avm")) {
            if (dstStoreRef.getProtocol().equals("avm")) {
                this.copyAVMToAVM(src, dst, name);
            } else if (dstStoreRef.getProtocol().equals("workspace")) {
                this.copyAVMToRepo(src, dst, name);
            }
        } else if (srcStoreRef.getProtocol().equals("workspace")) {
            if (dstStoreRef.getProtocol().equals("avm")) {
                this.copyRepoToAVM(src, dst, name);
            } else if (dstStoreRef.getProtocol().equals("workspace")) {
                this.copyRepoToRepo(src, dst, name);
            }
        }
    }

    private void copyAVMToAVM(NodeRef src, NodeRef dst, String name) {
        Pair<Integer, String> srcStorePath = AVMNodeConverter.ToAVMVersionPath(src);
        Pair<Integer, String> dstStorePath = AVMNodeConverter.ToAVMVersionPath(dst);
        this.fAVMService.copy((Integer)srcStorePath.getFirst(), (String)srcStorePath.getSecond(), (String)dstStorePath.getSecond(), name);
    }

    private void copyAVMToRepo(NodeRef src, NodeRef dst, String name) {
        Pair<Integer, String> versionPath = AVMNodeConverter.ToAVMVersionPath(src);
        AVMNodeDescriptor desc = this.fAVMService.lookup((Integer)versionPath.getFirst(), (String)versionPath.getSecond());
        NodeRef existing = this.fFileFolderService.searchSimple(dst, name);
        if (desc.isFile()) {
            if (existing != null && !this.fNodeService.getType(existing).equals((Object)ContentModel.TYPE_CONTENT)) {
                this.fFileFolderService.delete(existing);
                existing = null;
            }
            NodeRef childRef = null;
            childRef = existing == null ? this.fFileFolderService.create(dst, name, ContentModel.TYPE_CONTENT).getNodeRef() : existing;
            InputStream in = this.fAVMService.getFileInputStream(desc);
            ContentData cd = this.fAVMService.getContentDataForRead((Integer)versionPath.getFirst(), desc.getPath());
            ContentWriter writer = this.fContentService.getWriter(childRef, ContentModel.PROP_CONTENT, true);
            writer.setEncoding(cd.getEncoding());
            writer.setMimetype(cd.getMimetype());
            OutputStream out = writer.getContentOutputStream();
            this.copyData(in, out);
            this.copyPropsAndAspectsAVMToRepo(src, childRef);
        } else {
            if (existing != null && !this.fNodeService.getType(existing).equals((Object)ContentModel.TYPE_FOLDER)) {
                this.fFileFolderService.delete(existing);
                existing = null;
            }
            NodeRef childRef = null;
            childRef = existing == null ? this.fFileFolderService.create(dst, name, ContentModel.TYPE_FOLDER).getNodeRef() : existing;
            this.copyPropsAndAspectsAVMToRepo(src, childRef);
            SortedMap<String, AVMNodeDescriptor> listing = this.fAVMService.getDirectoryListing(desc);
            for (Map.Entry entry : listing.entrySet()) {
                NodeRef srcChild = AVMNodeConverter.ToNodeRef((Integer)versionPath.getFirst(), ((AVMNodeDescriptor)entry.getValue()).getPath());
                this.copyAVMToRepo(srcChild, childRef, (String)entry.getKey());
            }
        }
    }

    private void copyPropsAndAspectsAVMToRepo(NodeRef src, NodeRef dst) {
        Map props = this.fNodeService.getProperties(src);
        this.fNodeService.setProperties(dst, props);
        Set aspects = this.fNodeService.getAspects(src);
        HashMap empty = new HashMap();
        for (QName aspect : aspects) {
            this.fNodeService.addAspect(dst, aspect, empty);
        }
    }

    private void copyRepoToAVM(NodeRef src, NodeRef dst, String name) {
        QName srcType = this.fNodeService.getType(src);
        Pair<Integer, String> versionPath = AVMNodeConverter.ToAVMVersionPath(dst);
        String childPath = AVMNodeConverter.ExtendAVMPath((String)versionPath.getSecond(), name);
        NodeRef childNodeRef = AVMNodeConverter.ToNodeRef(-1, childPath);
        if (this.fDictionaryService.isSubClass(srcType, ContentModel.TYPE_CONTENT)) {
            ContentReader reader = this.fContentService.getReader(src, ContentModel.PROP_CONTENT);
            InputStream in = reader.getContentInputStream();
            AVMNodeDescriptor desc = this.fAVMService.lookup(-1, childPath);
            if (desc != null && !desc.isFile()) {
                this.fAVMService.removeNode(childPath);
                desc = null;
            }
            if (desc == null) {
                try {
                    this.fAVMService.createFile((String)versionPath.getSecond(), name).close();
                }
                catch (IOException e) {
                    throw new AlfrescoRuntimeException("I/O Error.", (Throwable)e);
                }
            }
            ContentWriter writer = this.fAVMService.getContentWriter(childPath, true);
            writer.setEncoding(reader.getEncoding());
            writer.setMimetype(reader.getMimetype());
            OutputStream out = writer.getContentOutputStream();
            this.copyData(in, out);
            this.copyPropsAndAspectsRepoToAVM(src, childNodeRef, childPath);
            return;
        }
        if (this.fDictionaryService.isSubClass(srcType, ContentModel.TYPE_FOLDER)) {
            AVMNodeDescriptor desc = this.fAVMService.lookup(-1, childPath);
            if (desc != null && !desc.isDirectory()) {
                this.fAVMService.removeNode(childPath);
                desc = null;
            }
            if (desc == null) {
                this.fAVMService.createDirectory((String)versionPath.getSecond(), name);
            }
            this.copyPropsAndAspectsRepoToAVM(src, childNodeRef, childPath);
            List<FileInfo> listing = this.fFileFolderService.list(src);
            for (FileInfo info : listing) {
                this.copyRepoToAVM(info.getNodeRef(), childNodeRef, info.getName());
            }
            return;
        }
    }

    private void copyPropsAndAspectsRepoToAVM(NodeRef src, NodeRef dst, String dstPath) {
        Map props = this.fNodeService.getProperties(src);
        this.fNodeService.setProperties(dst, props);
        Set aspects = this.fNodeService.getAspects(src);
        for (QName aspect : aspects) {
            this.fAVMService.addAspect(dstPath, aspect);
        }
    }

    private void copyRepoToRepo(NodeRef src, NodeRef dst, String name) {
        ChildAssociationRef assocRef = this.fNodeService.getPrimaryParent(src);
        this.fCopyService.copyAndRename(src, dst, ContentModel.ASSOC_CONTAINS, assocRef.getQName(), true);
    }

    private void copyData(InputStream in, OutputStream out) {
        try {
            byte[] buff = new byte[8192];
            int read = 0;
            while ((read = in.read(buff)) != -1) {
                out.write(buff, 0, read);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("I/O Error.", (Throwable)e);
        }
    }
}

