/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.avm.ibatis;

import java.util.HashMap;
import java.util.List;
import org.alfresco.repo.domain.avm.AVMAspectEntity;
import org.alfresco.repo.domain.avm.AVMNodeDAO;
import org.alfresco.repo.domain.avm.AVMNodeEntity;
import org.alfresco.repo.domain.avm.AVMNodePropertyEntity;
import org.alfresco.repo.domain.avm.AbstractAVMNodeDAOImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.mybatis.spring.SqlSessionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMNodeDAOImpl
extends AbstractAVMNodeDAOImpl {
    private static Log logger = LogFactory.getLog(AVMNodeDAOImpl.class);
    private static final String INSERT_AVM_NODE = "alfresco.avm.insert.insert_AVMNode";
    private static final String SELECT_AVM_NODE_BY_ID = "alfresco.avm.select_AVMNodeById";
    private static final String UPDATE_AVM_NODE = "alfresco.avm.update_AVMNode";
    private static final String UPDATE_AVM_NODE_MODTIME_AND_GUID = "alfresco.avm.update_AVMNode_modTimeAndGuid";
    private static final String UPDATE_AVM_NODE_MODTIME_AND_CDATA = "alfresco.avm.update_AVMNode_modTimeAndContentData";
    private static final String DELETE_AVM_NODE = "alfresco.avm.delete_AVMNode";
    private static final String SELECT_AVM_NODES_NEW_IN_STORE = "alfresco.avm.select_AVMNodes_newInStore";
    private static final String SELECT_AVM_NODES_NEW_LAYERED_IN_STORE = "alfresco.avm.select_AVMNodes_newLayeredInStore";
    private static final String SELECT_AVM_NODE_IDS_NEW_LAYERED_IN_STORE = "alfresco.avm.select_AVMNodes_IDs_newLayeredInStore";
    private static final String UPDATE_AVM_NODES_CLEAR_NEW_IN_STORE = "alfresco.avm.update_AVMNodes_clearNewInStore";
    private static final String SELECT_AVM_NODES_NULL_PARENT_AND_ISROOT_TF = "alfresco.avm.select_AVMNodes_nullParentAndIsRootTF";
    private static final String SELECT_AVM_NODES_LAYERED_DIRECTORIES_AND_PRIMARY_TF = "alfresco.avm.select_AVMNodes_layeredDirectoriesAndPrimaryTF";
    private static final String SELECT_AVM_NODES_LAYERED_FILES = "alfresco.avm.select_AVMNodes_layeredFiles";
    private static final String SELECT_AVM_CONTENT_URLS_FOR_PLAIN_FILES = "alfresco.avm.select_ContentUrlsForPlainFiles";
    private static final String SELECT_AVM_NODE_ASPECTS = "alfresco.avm.select_AVMNodeAspects";
    private static final String INSERT_AVM_NODE_ASPECT = "alfresco.avm.insert.insert_AVMNodeAspect";
    private static final String DELETE_AVM_NODE_ASPECT = "alfresco.avm.delete_AVMNodeAspect";
    private static final String DELETE_AVM_NODE_ASPECTS = "alfresco.avm.delete_AVMNodeAspects";
    private static final String INSERT_AVM_NODE_PROP = "alfresco.avm.insert.insert_AVMNodeProperty";
    private static final String UPDATE_AVM_NODE_PROP = "alfresco.avm.update_AVMNodeProperty";
    private static final String SELECT_AVM_NODE_PROP = "alfresco.avm.select_AVMNodeProperty";
    private static final String SELECT_AVM_NODE_PROPS = "alfresco.avm.select_AVMNodeProperties";
    private static final String DELETE_AVM_NODE_PROP = "alfresco.avm.delete_AVMNodeProperty";
    private static final String DELETE_AVM_NODE_PROPS = "alfresco.avm.delete_AVMNodeProperties";
    private SqlSessionTemplate template;

    public final void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.template = sqlSessionTemplate;
    }

    @Override
    protected AVMNodeEntity createNodeEntity(AVMNodeEntity nodeEntity) {
        this.template.insert(INSERT_AVM_NODE, (Object)nodeEntity);
        return nodeEntity;
    }

    @Override
    protected AVMNodeEntity getNodeEntity(long id) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", id);
        return (AVMNodeEntity)this.template.selectOne(SELECT_AVM_NODE_BY_ID, params);
    }

    @Override
    protected int updateNodeEntity(AVMNodeEntity updateNodeEntity) {
        updateNodeEntity.incrementVers();
        return this.template.update(UPDATE_AVM_NODE, (Object)updateNodeEntity);
    }

    @Override
    protected int updateNodeEntityModTimeAndGuid(AVMNodeEntity updateNodeEntity) {
        updateNodeEntity.incrementVers();
        return this.template.update(UPDATE_AVM_NODE_MODTIME_AND_GUID, (Object)updateNodeEntity);
    }

    @Override
    protected int updateNodeEntityModTimeAndContentData(AVMNodeEntity updateNodeEntity) {
        updateNodeEntity.incrementVers();
        return this.template.update(UPDATE_AVM_NODE_MODTIME_AND_CDATA, (Object)updateNodeEntity);
    }

    @Override
    protected int deleteNodeEntity(long nodeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", nodeId);
        return this.template.delete(DELETE_AVM_NODE, params);
    }

    @Override
    protected void updateNodeEntitiesClearNewInStore(long storeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", storeId);
        this.template.update(UPDATE_AVM_NODES_CLEAR_NEW_IN_STORE, params);
    }

    @Override
    protected List<AVMNodeEntity> getNodeEntitiesNewInStore(long storeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", storeId);
        return this.template.selectList(SELECT_AVM_NODES_NEW_IN_STORE, params);
    }

    @Override
    protected List<AVMNodeEntity> getLayeredNodeEntitiesNewInStore(long storeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", storeId);
        return this.template.selectList(SELECT_AVM_NODES_NEW_LAYERED_IN_STORE, params);
    }

    @Override
    protected List<Long> getLayeredNodeEntityIdsNewInStore(long storeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", storeId);
        return this.template.selectList(SELECT_AVM_NODE_IDS_NEW_LAYERED_IN_STORE, params);
    }

    @Override
    protected List<AVMNodeEntity> getNodeEntityOrphans(int maxSize) {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>(1);
        params.put("bool", false);
        return this.template.selectList(SELECT_AVM_NODES_NULL_PARENT_AND_ISROOT_TF, params, new RowBounds(0, maxSize));
    }

    @Override
    protected List<AVMNodeEntity> getAllLayeredDirectoryNodeEntities() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>(1);
        params.put("bool", true);
        return this.template.selectList(SELECT_AVM_NODES_LAYERED_DIRECTORIES_AND_PRIMARY_TF, params);
    }

    @Override
    protected List<AVMNodeEntity> getAllLayeredFileNodeEntities() {
        return this.template.selectList(SELECT_AVM_NODES_LAYERED_FILES);
    }

    @Override
    protected void getPlainFileContentUrls(AVMNodeDAO.ContentUrlHandler handler) {
        CleanResultHandler resultHandler = new CleanResultHandler(handler);
        this.template.selectList(SELECT_AVM_CONTENT_URLS_FOR_PLAIN_FILES, (Object)resultHandler);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("   Listed " + resultHandler.total + " content URLs"));
        }
    }

    @Override
    protected List<Long> getAspectEntities(long nodeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", nodeId);
        return this.template.selectList(SELECT_AVM_NODE_ASPECTS, params);
    }

    @Override
    protected void createAspectEntity(long nodeId, long qnameId) {
        AVMAspectEntity aspectEntity = new AVMAspectEntity(nodeId, qnameId);
        this.template.insert(INSERT_AVM_NODE_ASPECT, (Object)aspectEntity);
    }

    @Override
    protected int deleteAspectEntity(long nodeId, long qnameId) {
        AVMAspectEntity aspectEntity = new AVMAspectEntity(nodeId, qnameId);
        return this.template.delete(DELETE_AVM_NODE_ASPECT, (Object)aspectEntity);
    }

    @Override
    protected int deleteAspectEntities(long nodeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", nodeId);
        return this.template.delete(DELETE_AVM_NODE_ASPECTS, params);
    }

    @Override
    protected void insertNodePropertyEntity(AVMNodePropertyEntity propEntity) {
        this.template.insert(INSERT_AVM_NODE_PROP, (Object)propEntity);
    }

    @Override
    protected int updateNodePropertyEntity(AVMNodePropertyEntity updatePropEntity) {
        return this.template.update(UPDATE_AVM_NODE_PROP, (Object)updatePropEntity);
    }

    @Override
    protected AVMNodePropertyEntity getNodePropertyEntity(long nodeId, long qnameId) {
        AVMNodePropertyEntity propEntity = new AVMNodePropertyEntity();
        propEntity.setNodeId(nodeId);
        propEntity.setQnameId(qnameId);
        return (AVMNodePropertyEntity)this.template.selectOne(SELECT_AVM_NODE_PROP, (Object)propEntity);
    }

    @Override
    protected List<AVMNodePropertyEntity> getNodePropertyEntities(long nodeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", nodeId);
        return this.template.selectList(SELECT_AVM_NODE_PROPS, params);
    }

    @Override
    protected int deleteNodePropertyEntity(long nodeId, long qnameId) {
        AVMNodePropertyEntity propEntity = new AVMNodePropertyEntity();
        propEntity.setNodeId(nodeId);
        propEntity.setQnameId(qnameId);
        return this.template.delete(DELETE_AVM_NODE_PROP, (Object)propEntity);
    }

    @Override
    protected int deleteNodePropertyEntities(long nodeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", nodeId);
        return this.template.delete(DELETE_AVM_NODE_PROPS, params);
    }

    private static class CleanResultHandler
    implements ResultHandler {
        private final AVMNodeDAO.ContentUrlHandler handler;
        private int total = 0;

        private CleanResultHandler(AVMNodeDAO.ContentUrlHandler handler) {
            this.handler = handler;
        }

        public void handleResult(ResultContext context) {
            this.handler.handle((String)context.getResultObject());
            ++this.total;
            if (logger.isDebugEnabled() && (this.total == 0 || this.total % 1000 == 0)) {
                logger.debug((Object)("   Listed " + this.total + " content URLs"));
            }
        }
    }
}

