/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.encoding;

import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.lookup.EntityLookupCache;
import org.alfresco.repo.domain.encoding.EncodingDAO;
import org.alfresco.repo.domain.encoding.EncodingEntity;
import org.alfresco.util.Pair;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEncodingDAOImpl
implements EncodingDAO {
    private static final String CACHE_REGION_ENCODING = "Encoding";
    private EntityLookupCache<Long, String, String> encodingEntityCache;

    public void setEncodingEntityCache(SimpleCache<Long, String> encodingEntityCache) {
        this.encodingEntityCache = new EntityLookupCache<Long, String, String>(encodingEntityCache, CACHE_REGION_ENCODING, new EncodingEntityCallbackDAO());
    }

    @Override
    public Pair<Long, String> getEncoding(Long id) {
        return this.encodingEntityCache.getByKey(id);
    }

    @Override
    public Pair<Long, String> getEncoding(String encoding) {
        encoding = encoding.toUpperCase();
        ParameterCheck.mandatory((String)"encoding", (Object)encoding);
        return this.encodingEntityCache.getByValue(encoding);
    }

    @Override
    public Pair<Long, String> getOrCreateEncoding(String encoding) {
        encoding = encoding.toUpperCase();
        ParameterCheck.mandatory((String)"encoding", (Object)encoding);
        return this.encodingEntityCache.getOrCreateByValue(encoding);
    }

    protected abstract EncodingEntity getEncodingEntity(Long var1);

    protected abstract EncodingEntity getEncodingEntity(String var1);

    protected abstract EncodingEntity createEncodingEntity(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EncodingEntityCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<Long, String, String> {
        private EncodingEntityCallbackDAO() {
        }

        @Override
        public String getValueKey(String value) {
            return value;
        }

        @Override
        public Pair<Long, String> findByKey(Long id) {
            EncodingEntity entity = AbstractEncodingDAOImpl.this.getEncodingEntity(id);
            if (entity == null) {
                return null;
            }
            return new Pair((Object)id, (Object)entity.getEncoding().toUpperCase());
        }

        @Override
        public Pair<Long, String> findByValue(String encoding) {
            EncodingEntity entity = AbstractEncodingDAOImpl.this.getEncodingEntity(encoding);
            if (entity == null) {
                return null;
            }
            return new Pair((Object)entity.getId(), (Object)encoding);
        }

        @Override
        public Pair<Long, String> createValue(String encoding) {
            EncodingEntity entity = AbstractEncodingDAOImpl.this.createEncodingEntity(encoding);
            return new Pair((Object)entity.getId(), (Object)encoding);
        }
    }
}

