/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.locks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.alfresco.repo.domain.locks.LockDAO;
import org.alfresco.repo.domain.locks.LockEntity;
import org.alfresco.repo.domain.locks.LockResourceEntity;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLockDAOImpl
implements LockDAO {
    private static final String LOCK_TOKEN_RELEASED = "not-locked";
    private QNameDAO qnameDAO;

    protected QNameDAO getQNameDAO() {
        return this.qnameDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    @Override
    public void getLock(QName lockQName, String lockToken, long timeToLive) {
        String qnameNamespaceUri = lockQName.getNamespaceURI();
        String qnameLocalName = lockQName.getLocalName();
        if (!qnameLocalName.toLowerCase().equals(qnameLocalName)) {
            lockQName = QName.createQName((String)qnameNamespaceUri, (String)qnameLocalName.toLowerCase());
            qnameLocalName = lockQName.getLocalName();
        }
        lockToken = lockToken.toLowerCase();
        Long qnameNamespaceId = (Long)this.qnameDAO.getOrCreateNamespace(qnameNamespaceUri).getFirst();
        LockResourceEntity exclusiveLockResource = this.getLockResource(qnameNamespaceId, qnameLocalName);
        if (exclusiveLockResource == null) {
            exclusiveLockResource = this.createLockResource(qnameNamespaceId, qnameLocalName);
        }
        Long requiredExclusiveLockResourceId = exclusiveLockResource.getId();
        List<QName> lockQNames = this.splitLockQName(lockQName);
        ArrayList<Long> requiredLockResourceIds = new ArrayList<Long>(lockQNames.size());
        for (QName lockQNameIter : lockQNames) {
            String localname = lockQNameIter.getLocalName();
            LockResourceEntity lockResource = this.getLockResource(qnameNamespaceId, localname);
            if (lockResource == null) {
                lockResource = this.createLockResource(qnameNamespaceId, localname);
            }
            requiredLockResourceIds.add(lockResource.getId());
        }
        List<LockEntity> existingLocks = this.getLocksBySharedResourceIds(requiredLockResourceIds);
        HashMap<LockEntity, LockEntity> existingLocksMap = new HashMap<LockEntity, LockEntity>();
        for (LockEntity existingLock : existingLocks) {
            boolean canTakeLock = this.canTakeLock(existingLock, lockToken, requiredExclusiveLockResourceId);
            if (!canTakeLock) {
                throw new LockAcquisitionException("system.locks.err.excl_lock_exists", lockQName, lockToken, existingLock);
            }
            existingLocksMap.put(existingLock, existingLock);
        }
        for (Long requiredLockResourceId : requiredLockResourceIds) {
            LockEntity requiredLock = new LockEntity();
            requiredLock.setSharedResourceId(requiredLockResourceId);
            requiredLock.setExclusiveResourceId(requiredExclusiveLockResourceId);
            if (existingLocksMap.containsKey(requiredLock)) {
                requiredLock = (LockEntity)existingLocksMap.get(requiredLock);
                try {
                    this.updateLock(requiredLock, lockToken, timeToLive);
                    continue;
                }
                catch (Throwable e) {
                    throw new LockAcquisitionException(e, "system.locks.err.failed_to_acquire_lock", lockQName, lockToken);
                }
            }
            try {
                requiredLock = this.createLock(requiredLockResourceId, requiredExclusiveLockResourceId, lockToken, timeToLive);
            }
            catch (Throwable e) {
                throw new LockAcquisitionException(e, "system.locks.err.failed_to_acquire_lock", lockQName, lockToken);
            }
        }
    }

    @Override
    public void refreshLock(QName lockQName, String lockToken, long timeToLive) {
        this.updateLocks(lockQName, lockToken, lockToken, timeToLive);
    }

    @Override
    public void releaseLock(QName lockQName, String lockToken) {
        this.updateLocks(lockQName, lockToken, LOCK_TOKEN_RELEASED, 0L);
    }

    private void updateLocks(QName lockQName, String lockToken, String newLockToken, long timeToLive) {
        String qnameNamespaceUri = lockQName.getNamespaceURI();
        String qnameLocalName = lockQName.getLocalName();
        if (!qnameLocalName.toLowerCase().equals(qnameLocalName)) {
            lockQName = QName.createQName((String)qnameNamespaceUri, (String)qnameLocalName.toLowerCase());
            qnameLocalName = lockQName.getLocalName();
        }
        lockToken = lockToken.toLowerCase();
        Long qnameNamespaceId = (Long)this.qnameDAO.getOrCreateNamespace(qnameNamespaceUri).getFirst();
        LockResourceEntity exclusiveLockResource = this.getLockResource(qnameNamespaceId, qnameLocalName);
        if (exclusiveLockResource == null) {
            throw new LockAcquisitionException("system.locks.err.lock_resource_missing", lockQName, lockToken);
        }
        Long exclusiveLockResourceId = exclusiveLockResource.getId();
        List<QName> lockQNames = this.splitLockQName(lockQName);
        int requiredUpdateCount = lockQNames.size();
        int updateCount = this.updateLocks(exclusiveLockResourceId, lockToken, newLockToken, timeToLive);
        if (updateCount != requiredUpdateCount) {
            if (LOCK_TOKEN_RELEASED.equals(newLockToken)) {
                throw new LockAcquisitionException("system.locks.err.failed_to_release_lock", lockQName, lockToken);
            }
            throw new LockAcquisitionException("system.locks.err.lock_update_count", lockQName, lockToken, new Integer(updateCount), new Integer(requiredUpdateCount));
        }
    }

    private boolean canTakeLock(LockEntity existingLock, String lockToken, Long desiredExclusiveLock) {
        if (EqualsHelper.nullSafeEquals((Object)existingLock.getLockToken(), (Object)lockToken)) {
            return true;
        }
        if (existingLock.hasExpired()) {
            return true;
        }
        if (existingLock.isExclusive()) {
            return false;
        }
        return !desiredExclusiveLock.equals(existingLock.getSharedResourceId());
    }

    protected abstract LockResourceEntity getLockResource(Long var1, String var2);

    protected abstract LockResourceEntity createLockResource(Long var1, String var2);

    protected abstract LockEntity getLock(Long var1);

    protected abstract LockEntity getLock(Long var1, Long var2);

    protected abstract List<LockEntity> getLocksBySharedResourceIds(List<Long> var1);

    protected abstract LockEntity createLock(Long var1, Long var2, String var3, long var4);

    protected abstract LockEntity updateLock(LockEntity var1, String var2, long var3);

    protected abstract int updateLocks(Long var1, String var2, String var3, long var4);

    protected List<QName> splitLockQName(QName lockQName) {
        String ns = lockQName.getNamespaceURI();
        String name = lockQName.getLocalName();
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        ArrayList<QName> ret = new ArrayList<QName>(tokenizer.countTokens());
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        while (tokenizer.hasMoreTokens()) {
            if (first) {
                first = false;
            } else {
                sb.append(".");
            }
            sb.append(tokenizer.nextToken());
            QName parentLockQName = QName.createQName((String)ns, (String)sb.toString());
            ret.add(parentLockQName);
        }
        return ret;
    }
}

