/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.ibatis.BatchingDAO;
import org.alfresco.ibatis.RetryingCallbackHelper;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.NullCache;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.TransactionalCache;
import org.alfresco.repo.cache.lookup.EntityLookupCache;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.domain.control.ControlDAO;
import org.alfresco.repo.domain.locale.LocaleDAO;
import org.alfresco.repo.domain.node.AuditablePropertiesEntity;
import org.alfresco.repo.domain.node.ChildAssocEntity;
import org.alfresco.repo.domain.node.ChildByNameKey;
import org.alfresco.repo.domain.node.ContentDataWithId;
import org.alfresco.repo.domain.node.LocalizedPropertiesEntity;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.node.NodeAssocEntity;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.NodeEntity;
import org.alfresco.repo.domain.node.NodeExistsException;
import org.alfresco.repo.domain.node.NodeIdAndAclId;
import org.alfresco.repo.domain.node.NodePropertyHelper;
import org.alfresco.repo.domain.node.NodePropertyKey;
import org.alfresco.repo.domain.node.NodePropertyValue;
import org.alfresco.repo.domain.node.NodeUpdateEntity;
import org.alfresco.repo.domain.node.NodeVersionKey;
import org.alfresco.repo.domain.node.ParentAssocsInfo;
import org.alfresco.repo.domain.node.ReferenceablePropertiesEntity;
import org.alfresco.repo.domain.node.ServerEntity;
import org.alfresco.repo.domain.node.StoreEntity;
import org.alfresco.repo.domain.node.Transaction;
import org.alfresco.repo.domain.node.TransactionEntity;
import org.alfresco.repo.domain.permissions.AccessControlListDAO;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.usage.UsageDAO;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.permissions.AccessControlListProperties;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionAwareSingleton;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.AssociationExistsException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.CyclicChildRelationshipException;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.InvalidStoreRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.ReadOnlyServerException;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.ReadWriteLockExecuter;
import org.alfresco.util.SerializationUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNodeDAOImpl
implements NodeDAO,
BatchingDAO {
    private static final String CACHE_REGION_ROOT_NODES = "N.RN";
    private static final String CACHE_REGION_NODES = "N.N";
    private static final String CACHE_REGION_ASPECTS = "N.A";
    private static final String CACHE_REGION_PROPERTIES = "N.P";
    private static final String CACHE_REGION_PARENT_ASSOCS = "N.PA";
    protected Log logger = LogFactory.getLog(this.getClass());
    private Log loggerPaths = LogFactory.getLog((String)(this.getClass().getName() + ".paths"));
    protected final boolean isDebugEnabled = this.logger.isDebugEnabled();
    private NodePropertyHelper nodePropertyHelper;
    private ServerIdCallback serverIdCallback = new ServerIdCallback();
    private UpdateTransactionListener updateTransactionListener = new UpdateTransactionListener();
    private RetryingCallbackHelper childAssocRetryingHelper = new RetryingCallbackHelper();
    private TransactionService transactionService;
    private DictionaryService dictionaryService;
    private BehaviourFilter policyBehaviourFilter;
    private AclDAO aclDAO;
    private AccessControlListDAO accessControlListDAO;
    private ControlDAO controlDAO;
    private QNameDAO qnameDAO;
    private ContentDataDAO contentDataDAO;
    private LocaleDAO localeDAO;
    private UsageDAO usageDAO;
    private EntityLookupCache<StoreRef, Node, Serializable> rootNodesCache;
    private SimpleCache<StoreRef, Set<NodeRef>> allRootNodesCache;
    private EntityLookupCache<Long, Node, NodeRef> nodesCache;
    private TransactionalCache<Serializable, Serializable> nodesTransactionalCache;
    private EntityLookupCache<NodeVersionKey, Set<QName>, Serializable> aspectsCache;
    private EntityLookupCache<NodeVersionKey, Map<QName, Serializable>, Serializable> propertiesCache;
    private EntityLookupCache<NodeVersionKey, ParentAssocsInfo, Serializable> parentAssocsCache;
    private SimpleCache<ChildByNameKey, ChildAssocEntity> childByNameCache;
    private static final String KEY_TRANSACTION = "node.transaction.id";
    private static final int PARENT_ASSOCS_CACHE_FILTER_THRESHOLD = 2000;
    public static final Long LONG_ZERO = 0L;

    public AbstractNodeDAOImpl() {
        this.childAssocRetryingHelper.setRetryWaitMs(10);
        this.childAssocRetryingHelper.setMaxRetries(5);
        this.rootNodesCache = new EntityLookupCache<StoreRef, Node, Serializable>(new RootNodesCacheCallbackDAO());
        this.nodesCache = new EntityLookupCache<Long, Node, NodeRef>(new NodesCacheCallbackDAO());
        this.aspectsCache = new EntityLookupCache<NodeVersionKey, Set<QName>, Serializable>(new AspectsCallbackDAO());
        this.propertiesCache = new EntityLookupCache<NodeVersionKey, Map<QName, Serializable>, Serializable>(new PropertiesCallbackDAO());
        this.parentAssocsCache = new EntityLookupCache<NodeVersionKey, ParentAssocsInfo, Serializable>(new ParentAssocsCallbackDAO());
        this.childByNameCache = new NullCache<ChildByNameKey, ChildAssocEntity>();
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setPolicyBehaviourFilter(BehaviourFilter policyBehaviourFilter) {
        this.policyBehaviourFilter = policyBehaviourFilter;
    }

    public void setAclDAO(AclDAO aclDAO) {
        this.aclDAO = aclDAO;
    }

    public void setAccessControlListDAO(AccessControlListDAO accessControlListDAO) {
        this.accessControlListDAO = accessControlListDAO;
    }

    public void setControlDAO(ControlDAO controlDAO) {
        this.controlDAO = controlDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setContentDataDAO(ContentDataDAO contentDataDAO) {
        this.contentDataDAO = contentDataDAO;
    }

    public void setLocaleDAO(LocaleDAO localeDAO) {
        this.localeDAO = localeDAO;
    }

    public void setUsageDAO(UsageDAO usageDAO) {
        this.usageDAO = usageDAO;
    }

    public void setRootNodesCache(SimpleCache<Serializable, Serializable> cache) {
        this.rootNodesCache = new EntityLookupCache<StoreRef, Node, Serializable>(cache, CACHE_REGION_ROOT_NODES, new RootNodesCacheCallbackDAO());
    }

    public void setAllRootNodesCache(SimpleCache<StoreRef, Set<NodeRef>> allRootNodesCache) {
        this.allRootNodesCache = allRootNodesCache;
    }

    public void setNodesCache(SimpleCache<Serializable, Serializable> cache) {
        this.nodesCache = new EntityLookupCache<Long, Node, NodeRef>(cache, CACHE_REGION_NODES, new NodesCacheCallbackDAO());
        if (cache instanceof TransactionalCache) {
            this.nodesTransactionalCache = (TransactionalCache)cache;
        }
    }

    public void setAspectsCache(SimpleCache<NodeVersionKey, Set<QName>> aspectsCache) {
        this.aspectsCache = new EntityLookupCache<NodeVersionKey, Set<QName>, Serializable>(aspectsCache, CACHE_REGION_ASPECTS, new AspectsCallbackDAO());
    }

    public void setPropertiesCache(SimpleCache<NodeVersionKey, Map<QName, Serializable>> propertiesCache) {
        this.propertiesCache = new EntityLookupCache<NodeVersionKey, Map<QName, Serializable>, Serializable>(propertiesCache, CACHE_REGION_PROPERTIES, new PropertiesCallbackDAO());
    }

    public void setParentAssocsCache(SimpleCache<NodeVersionKey, Serializable> parentAssocsCache) {
        this.parentAssocsCache = new EntityLookupCache<NodeVersionKey, ParentAssocsInfo, Serializable>(parentAssocsCache, CACHE_REGION_PARENT_ASSOCS, new ParentAssocsCallbackDAO());
    }

    public void setChildByNameCache(SimpleCache<ChildByNameKey, ChildAssocEntity> childByNameCache) {
        this.childByNameCache = childByNameCache;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"aclDAO", (Object)this.aclDAO);
        PropertyCheck.mandatory((Object)this, (String)"accessControlListDAO", (Object)this.accessControlListDAO);
        PropertyCheck.mandatory((Object)this, (String)"qnameDAO", (Object)this.qnameDAO);
        PropertyCheck.mandatory((Object)this, (String)"contentDataDAO", (Object)this.contentDataDAO);
        PropertyCheck.mandatory((Object)this, (String)"localeDAO", (Object)this.localeDAO);
        PropertyCheck.mandatory((Object)this, (String)"usageDAO", (Object)this.usageDAO);
        this.nodePropertyHelper = new NodePropertyHelper(this.dictionaryService, this.qnameDAO, this.localeDAO, this.contentDataDAO);
    }

    private Long getServerId() {
        return (Long)this.serverIdCallback.execute();
    }

    private void clearCaches() {
        this.nodesCache.clear();
        this.aspectsCache.clear();
        this.propertiesCache.clear();
        this.parentAssocsCache.clear();
    }

    private int invalidateNodeChildrenCaches(Long parentNodeId, boolean primary, boolean touchNodes) {
        Long txnId = this.getCurrentTransaction().getId();
        int count = 0;
        ArrayList<Long> childNodeIds = new ArrayList<Long>(256);
        Long minAssocIdInclusive = Long.MIN_VALUE;
        while (minAssocIdInclusive != null) {
            childNodeIds.clear();
            List<ChildAssocEntity> childAssocs = this.selectChildNodeIds(parentNodeId, primary, minAssocIdInclusive, 256);
            for (ChildAssocEntity childAssoc : childAssocs) {
                Long childAssocId = childAssoc.getId();
                if (childAssocId.compareTo(minAssocIdInclusive) < 0) {
                    throw new RuntimeException("Query results did not increase for assoc ID");
                }
                minAssocIdInclusive = new Long(childAssocId + 1L);
                Long childNodeId = childAssoc.getChildNode().getId();
                childNodeIds.add(childNodeId);
                this.invalidateNodeCaches(childNodeId);
                ++count;
            }
            if (touchNodes) {
                this.updateNodes(txnId, childNodeIds);
            }
            if (childAssocs.size() >= 256) continue;
            break;
        }
        return count;
    }

    private void invalidateNodeCaches(Long nodeId) {
        Node node = this.nodesCache.getValue(nodeId);
        if (node != null) {
            NodeVersionKey nodeVersionKey = node.getNodeVersionKey();
            this.invalidateNodeCaches(nodeVersionKey, true, true, true);
        }
        this.nodesCache.removeByKey(nodeId);
    }

    private void invalidateNodeCaches(NodeVersionKey nodeVersionKey, boolean invalidateNodeAspectsCache, boolean invalidateNodePropertiesCache, boolean invalidateParentAssocsCache) {
        if (invalidateNodeAspectsCache) {
            this.aspectsCache.removeByKey(nodeVersionKey);
        }
        if (invalidateNodePropertiesCache) {
            this.propertiesCache.removeByKey(nodeVersionKey);
        }
        if (invalidateParentAssocsCache) {
            this.parentAssocsCache.removeByKey(nodeVersionKey);
        }
    }

    private TransactionEntity getCurrentTransaction() {
        TransactionEntity txn = (TransactionEntity)AlfrescoTransactionSupport.getResource(KEY_TRANSACTION);
        if (txn != null) {
            return txn;
        }
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE) {
            throw new ReadOnlyServerException();
        }
        Long serverId = this.getServerId();
        Long now = System.currentTimeMillis();
        String changeTxnId = AlfrescoTransactionSupport.getTransactionId();
        Long txnId = this.insertTransaction(serverId, changeTxnId, now);
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Create txn: " + txnId));
        }
        txn = new TransactionEntity();
        txn.setId(txnId);
        txn.setChangeTxnId(changeTxnId);
        txn.setCommitTimeMs(now);
        ServerEntity server = new ServerEntity();
        server.setId(serverId);
        txn.setServer(server);
        AlfrescoTransactionSupport.bindResource(KEY_TRANSACTION, txn);
        AlfrescoTransactionSupport.bindListener(this.updateTransactionListener);
        return txn;
    }

    @Override
    public Long getCurrentTransactionId(boolean ensureNew) {
        TransactionEntity txn = ensureNew ? this.getCurrentTransaction() : (TransactionEntity)AlfrescoTransactionSupport.getResource(KEY_TRANSACTION);
        return txn == null ? null : txn.getId();
    }

    @Override
    public List<Pair<Long, StoreRef>> getStores() {
        List<StoreEntity> storeEntities = this.selectAllStores();
        ArrayList<Pair<Long, StoreRef>> storeRefs = new ArrayList<Pair<Long, StoreRef>>(storeEntities.size());
        for (StoreEntity storeEntity : storeEntities) {
            storeRefs.add((Pair<Long, StoreRef>)new Pair((Object)storeEntity.getId(), (Object)storeEntity.getStoreRef()));
        }
        return storeRefs;
    }

    private StoreEntity getStoreNotNull(StoreRef storeRef) {
        Pair<StoreRef, Node> rootNodePair = this.rootNodesCache.getByKey(storeRef);
        if (rootNodePair == null) {
            throw new InvalidStoreRefException(storeRef);
        }
        return ((Node)rootNodePair.getSecond()).getStore();
    }

    @Override
    public boolean exists(StoreRef storeRef) {
        Pair<StoreRef, Node> rootNodePair = this.rootNodesCache.getByKey(storeRef);
        return rootNodePair != null;
    }

    @Override
    public Pair<Long, NodeRef> getRootNode(StoreRef storeRef) {
        Pair<StoreRef, Node> rootNodePair = this.rootNodesCache.getByKey(storeRef);
        if (rootNodePair == null) {
            throw new InvalidStoreRefException(storeRef);
        }
        return ((Node)rootNodePair.getSecond()).getNodePair();
    }

    @Override
    public Set<NodeRef> getAllRootNodes(StoreRef storeRef) {
        Set rootNodes = (Set)this.allRootNodesCache.get((Serializable)storeRef);
        if (rootNodes == null) {
            final HashMap allRootNodes = new HashMap(97);
            this.getNodesWithAspects(Collections.singleton(ContentModel.ASPECT_ROOT), 0L, Long.MAX_VALUE, new NodeDAO.NodeRefQueryCallback(){

                @Override
                public boolean handle(Pair<Long, NodeRef> nodePair) {
                    NodeRef nodeRef = (NodeRef)nodePair.getSecond();
                    StoreRef storeRef = nodeRef.getStoreRef();
                    HashSet<NodeRef> rootNodes = (HashSet<NodeRef>)allRootNodes.get(storeRef);
                    if (rootNodes == null) {
                        rootNodes = new HashSet<NodeRef>(97);
                        allRootNodes.put(storeRef, rootNodes);
                    }
                    rootNodes.add(nodeRef);
                    return true;
                }
            });
            rootNodes = (Set)allRootNodes.get(storeRef);
            if (rootNodes == null) {
                rootNodes = Collections.emptySet();
                allRootNodes.put(storeRef, rootNodes);
            }
            for (Map.Entry entry : allRootNodes.entrySet()) {
                StoreRef entryStoreRef = (StoreRef)entry.getKey();
                if (this.allRootNodesCache.contains((Serializable)entryStoreRef)) continue;
                this.allRootNodesCache.put((Serializable)entryStoreRef, entry.getValue());
            }
        }
        return rootNodes;
    }

    @Override
    public Pair<Long, NodeRef> newStore(StoreRef storeRef) {
        StoreEntity store = new StoreEntity();
        store.setProtocol(storeRef.getProtocol());
        store.setIdentifier(storeRef.getIdentifier());
        Long storeId = this.insertStore(store);
        store.setId(storeId);
        Long aclId = this.aclDAO.createAccessControlList();
        Long nodeTypeQNameId = (Long)this.qnameDAO.getOrCreateQName(ContentModel.TYPE_STOREROOT).getFirst();
        NodeEntity rootNode = this.newNodeImpl(store, null, nodeTypeQNameId, null, aclId, false, null);
        Long rootNodeId = rootNode.getId();
        this.addNodeAspects(rootNodeId, Collections.singleton(ContentModel.ASPECT_ROOT));
        store.setRootNode(rootNode);
        this.updateStoreRoot(store);
        this.rootNodesCache.setValue(storeRef, rootNode);
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Created store: \n   " + store));
        }
        return new Pair((Object)rootNode.getId(), (Object)rootNode.getNodeRef());
    }

    @Override
    public void moveStore(StoreRef oldStoreRef, StoreRef newStoreRef) {
        StoreEntity store = this.getStoreNotNull(oldStoreRef);
        store.setProtocol(newStoreRef.getProtocol());
        store.setIdentifier(newStoreRef.getIdentifier());
        int count = this.updateStore(store);
        if (count != 1) {
            throw new ConcurrencyFailureException("Store not updated: " + oldStoreRef);
        }
        this.rootNodesCache.removeByKey(oldStoreRef);
        this.allRootNodesCache.remove((Serializable)oldStoreRef);
        this.nodesCache.clear();
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Moved store: " + oldStoreRef + " --> " + newStoreRef));
        }
    }

    @Override
    public boolean exists(Long nodeId) {
        Pair<Long, Node> pair = this.nodesCache.getByKey(nodeId);
        return pair != null && ((Node)pair.getSecond()).getDeleted() == false;
    }

    @Override
    public boolean exists(NodeRef nodeRef) {
        NodeEntity node = new NodeEntity(nodeRef);
        Pair<Long, Node> pair = this.nodesCache.getByValue(node);
        return pair != null && ((Node)pair.getSecond()).getDeleted() == false;
    }

    @Override
    public boolean isInCurrentTxn(Long nodeId) {
        Long currentTxnId = this.getCurrentTransactionId(false);
        if (currentTxnId == null) {
            return false;
        }
        Node node = this.getNodeNotNull(nodeId);
        Long nodeTxnId = node.getTransaction().getId();
        return nodeTxnId.equals(currentTxnId);
    }

    @Override
    public NodeRef.Status getNodeRefStatus(NodeRef nodeRef) {
        NodeEntity node = new NodeEntity(nodeRef);
        Pair<Long, Node> nodePair = this.nodesCache.getByValue(node);
        if (nodePair == null) {
            return null;
        }
        return ((Node)nodePair.getSecond()).getNodeStatus();
    }

    @Override
    public Pair<Long, NodeRef> getNodePair(NodeRef nodeRef) {
        NodeEntity node = new NodeEntity(nodeRef);
        Pair<Long, Node> pair = this.nodesCache.getByValue(node);
        return pair == null || ((Node)pair.getSecond()).getDeleted() != false ? null : ((Node)pair.getSecond()).getNodePair();
    }

    @Override
    public Pair<Long, NodeRef> getNodePair(Long nodeId) {
        Pair<Long, Node> pair = this.nodesCache.getByKey(nodeId);
        return pair == null || ((Node)pair.getSecond()).getDeleted() != false ? null : ((Node)pair.getSecond()).getNodePair();
    }

    private Node getNodeNotNull(Long nodeId) {
        Pair<Long, Node> pair = this.nodesCache.getByKey(nodeId);
        if (pair == null || ((Node)pair.getSecond()).getDeleted().booleanValue()) {
            this.nodesCache.removeByKey(nodeId);
            NodeEntity dbNode = this.selectNodeById(nodeId, null);
            if (pair == null) {
                throw new ConcurrencyFailureException("No node exists: \n   ID:        " + nodeId + "\n" + "   DB row:    " + dbNode);
            }
            throw new ConcurrencyFailureException("No live node exists: \n   ID:        " + nodeId + "\n" + "   Cache row: " + pair.getSecond() + "\n" + "   DB row:    " + dbNode);
        }
        return (Node)pair.getSecond();
    }

    @Override
    public QName getNodeType(Long nodeId) {
        Node node = this.getNodeNotNull(nodeId);
        Long nodeTypeQNameId = node.getTypeQNameId();
        return (QName)this.qnameDAO.getQName(nodeTypeQNameId).getSecond();
    }

    @Override
    public Long getNodeAclId(Long nodeId) {
        Node node = this.getNodeNotNull(nodeId);
        return node.getAclId();
    }

    @Override
    public ChildAssocEntity newNode(Long parentNodeId, QName assocTypeQName, QName assocQName, StoreRef storeRef, String uuid, QName nodeTypeQName, Locale nodeLocale, String childNodeName, Map<QName, Serializable> auditableProperties) throws InvalidTypeException {
        AuditablePropertiesEntity auditableProps;
        boolean setAuditProps;
        Assert.notNull((Object)parentNodeId, (String)"parentNodeId");
        Assert.notNull((Object)assocTypeQName, (String)"assocTypeQName");
        Assert.notNull((Object)assocQName, (String)"assocQName");
        Assert.notNull((Object)storeRef, (String)"storeRef");
        if (auditableProperties == null) {
            auditableProperties = Collections.emptyMap();
        }
        Node parentNode = this.getNodeNotNull(parentNodeId);
        Long parentAclId = parentNode.getAclId();
        Long childAclId = null;
        if (parentAclId != null) {
            try {
                Long inheritedACL = this.aclDAO.getInheritedAccessControlList(parentAclId);
                AccessControlListProperties inheritedAcl = this.aclDAO.getAccessControlListProperties(inheritedACL);
                if (inheritedAcl != null) {
                    childAclId = inheritedAcl.getId();
                }
            }
            catch (Throwable e) {
                this.invalidateNodeCaches(parentNodeId);
            }
        }
        if (!(setAuditProps = (auditableProps = new AuditablePropertiesEntity()).setAuditValues(null, null, auditableProperties))) {
            auditableProps = null;
        }
        StoreEntity store = this.getStoreNotNull(storeRef);
        Long nodeTypeQNameId = (Long)this.qnameDAO.getOrCreateQName(nodeTypeQName).getFirst();
        Long nodeLocaleId = (Long)this.localeDAO.getOrCreateLocalePair(nodeLocale).getFirst();
        NodeEntity node = this.newNodeImpl(store, uuid, nodeTypeQNameId, nodeLocaleId, childAclId, false, auditableProps);
        Long nodeId = node.getId();
        if (setAuditProps) {
            NodeRef nodeRef = node.getNodeRef();
            this.policyBehaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
        }
        if (childNodeName == null) {
            childNodeName = node.getUuid();
        }
        ChildAssocEntity assoc = this.newChildAssocImpl(parentNodeId, nodeId, true, assocTypeQName, assocQName, childNodeName);
        boolean isRoot = false;
        boolean isStoreRoot = nodeTypeQName.equals((Object)ContentModel.TYPE_STOREROOT);
        ParentAssocsInfo parentAssocsInfo = new ParentAssocsInfo(isRoot, isStoreRoot, assoc);
        this.setParentAssocsCached(nodeId, parentAssocsInfo);
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Created new node: \n   Node: " + node + "\n" + "   Assoc: " + assoc));
        }
        return assoc;
    }

    private NodeEntity newNodeImpl(StoreEntity store, String uuid, Long nodeTypeQNameId, Long nodeLocaleId, Long aclId, boolean deleted, AuditablePropertiesEntity auditableProps) throws InvalidTypeException {
        NodeEntity node = new NodeEntity();
        node.setStore(store);
        if (uuid == null) {
            node.setUuid(GUID.generate());
        } else {
            node.setUuid(uuid);
        }
        node.setTypeQNameId(nodeTypeQNameId);
        QName nodeTypeQName = (QName)this.qnameDAO.getQName(nodeTypeQNameId).getSecond();
        if (nodeLocaleId == null) {
            nodeLocaleId = (Long)this.localeDAO.getOrCreateDefaultLocalePair().getFirst();
        }
        node.setLocaleId(nodeLocaleId);
        node.setAclId(aclId);
        node.setDeleted(deleted);
        TransactionEntity txn = this.getCurrentTransaction();
        node.setTransaction(txn);
        boolean addAuditableAspect = false;
        if (auditableProps != null) {
            node.setAuditableProperties(auditableProps);
            addAuditableAspect = true;
        } else if (AuditablePropertiesEntity.hasAuditableAspect(nodeTypeQName, this.dictionaryService)) {
            auditableProps = new AuditablePropertiesEntity();
            auditableProps.setAuditValues(null, null, true, 0L);
            node.setAuditableProperties(auditableProps);
            addAuditableAspect = true;
        }
        Long id = null;
        Savepoint savepoint = this.controlDAO.createSavepoint("newNodeImpl");
        try {
            id = this.insertNode(node);
            this.controlDAO.releaseSavepoint(savepoint);
        }
        catch (Throwable e) {
            this.controlDAO.rollbackToSavepoint(savepoint);
            NodeRef targetNodeRef = node.getNodeRef();
            NodeEntity liveNode = this.selectNodeByNodeRef(targetNodeRef, false);
            if (liveNode != null) {
                throw new NodeExistsException(liveNode.getNodePair(), e);
            }
            NodeEntity deletedNode = this.selectNodeByNodeRef(targetNodeRef, true);
            if (deletedNode != null) {
                Long deletedNodeId = deletedNode.getId();
                this.deleteNodeById(deletedNodeId, true);
                id = this.insertNode(node);
            }
            throw new AlfrescoRuntimeException("Failed to insert new node: " + node, e);
        }
        node.setId(id);
        Set<QName> nodeAspects = null;
        if (addAuditableAspect && !deleted) {
            Long auditableAspectQNameId = (Long)this.qnameDAO.getOrCreateQName(ContentModel.ASPECT_AUDITABLE).getFirst();
            this.insertNodeAspect(id, auditableAspectQNameId);
            nodeAspects = Collections.singleton(ContentModel.ASPECT_AUDITABLE);
        } else {
            nodeAspects = Collections.emptySet();
        }
        node.lock();
        this.nodesCache.setValue(id, node);
        this.setNodeAspectsCached(id, nodeAspects);
        this.setNodePropertiesCached(id, Collections.<QName, Serializable>emptyMap());
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Created new node: \n   " + node));
        }
        return node;
    }

    @Override
    public Pair<Pair<Long, ChildAssociationRef>, Pair<Long, NodeRef>> moveNode(Long childNodeId, final Long newParentNodeId, final QName assocTypeQName, final QName assocQName) {
        Long oldParentAclId;
        final Node newParentNode = this.getNodeNotNull(newParentNodeId);
        StoreEntity newParentStore = newParentNode.getStore();
        final Node childNode = this.getNodeNotNull(childNodeId);
        StoreEntity childStore = childNode.getStore();
        ChildAssocEntity primaryParentAssoc = this.getPrimaryParentAssocImpl(childNodeId);
        if (primaryParentAssoc == null) {
            oldParentAclId = null;
        } else if (primaryParentAssoc.getParentNode() == null) {
            oldParentAclId = null;
        } else {
            Long oldParentNodeId = primaryParentAssoc.getParentNode().getId();
            oldParentAclId = this.getNodeNotNull(oldParentNodeId).getAclId();
        }
        final String childNodeName = (String)((Object)this.getNodeProperty(childNodeId, ContentModel.PROP_NAME));
        Node newChildNode = childNode;
        if (!childStore.getId().equals(newParentStore.getId())) {
            Set<Long> aspectIdsToDelete = this.qnameDAO.convertQNamesToIds(Collections.singleton(ContentModel.ASPECT_AUDITABLE), true);
            this.deleteNodeAspects(childNodeId, aspectIdsToDelete);
            AuditablePropertiesEntity auditableProps = childNode.getAuditableProperties();
            newChildNode = this.newNodeImpl(newParentStore, childNode.getUuid(), childNode.getTypeQNameId(), childNode.getLocaleId(), childNode.getAclId(), false, auditableProps);
            Long newChildNodeId = newChildNode.getId();
            this.moveNodeData(childNode.getId(), newChildNodeId);
            this.invalidateNodeCaches(newChildNodeId);
            this.invalidateNodeChildrenCaches(newChildNodeId, true, true);
            this.invalidateNodeChildrenCaches(newChildNodeId, false, true);
            NodeUpdateEntity childNodeUpdate = new NodeUpdateEntity();
            childNodeUpdate.setId(childNodeId);
            childNodeUpdate.setAclId(null);
            childNodeUpdate.setUpdateAclId(true);
            childNodeUpdate.setTypeQNameId((Long)this.qnameDAO.getOrCreateQName(ContentModel.TYPE_CMOBJECT).getFirst());
            childNodeUpdate.setUpdateTypeQNameId(true);
            childNodeUpdate.setLocaleId((Long)this.localeDAO.getOrCreateDefaultLocalePair().getFirst());
            childNodeUpdate.setUpdateLocaleId(true);
            childNodeUpdate.setDeleted(Boolean.TRUE);
            childNodeUpdate.setUpdateDeleted(true);
            this.updateNodeImpl(childNode, childNodeUpdate, null);
        } else {
            this.touchNode(childNodeId, null, null, false, false, true);
        }
        final Long newChildNodeId = newChildNode.getId();
        RetryingCallbackHelper.RetryingCallback<Integer> callback = new RetryingCallbackHelper.RetryingCallback<Integer>(){

            public Integer execute() throws Throwable {
                Savepoint savepoint = AbstractNodeDAOImpl.this.controlDAO.createSavepoint("DuplicateChildNodeNameException");
                String childNodeNameToUse = childNodeName == null ? childNode.getUuid() : childNodeName;
                try {
                    int updated = AbstractNodeDAOImpl.this.updatePrimaryParentAssocs(newChildNodeId, newParentNodeId, assocTypeQName, assocQName, childNodeNameToUse);
                    AbstractNodeDAOImpl.this.controlDAO.releaseSavepoint(savepoint);
                    return updated;
                }
                catch (Throwable e) {
                    AbstractNodeDAOImpl.this.controlDAO.rollbackToSavepoint(savepoint);
                    throw new DuplicateChildNodeNameException(newParentNode.getNodeRef(), assocTypeQName, childNodeName, e);
                }
            }
        };
        this.childAssocRetryingHelper.doWithRetry((RetryingCallbackHelper.RetryingCallback)callback);
        this.getPaths(newChildNode.getNodePair(), false);
        Long newParentAclId = newParentNode.getAclId();
        this.accessControlListDAO.updateInheritance(newChildNodeId, oldParentAclId, newParentAclId);
        Pair<Long, ChildAssociationRef> assocPair = this.getPrimaryParentAssoc(newChildNode.getId());
        Pair<Long, NodeRef> nodePair = newChildNode.getNodePair();
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Moved node: " + assocPair + " ... " + nodePair));
        }
        return new Pair(assocPair, nodePair);
    }

    @Override
    public boolean updateNode(Long nodeId, QName nodeTypeQName, Locale nodeLocale) {
        Node oldNode = this.getNodeNotNull(nodeId);
        Long nodeTypeQNameId = nodeTypeQName == null ? oldNode.getTypeQNameId() : (Long)this.qnameDAO.getOrCreateQName(nodeTypeQName).getFirst();
        Long nodeLocaleId = nodeLocale == null ? oldNode.getLocaleId() : (Long)this.localeDAO.getOrCreateLocalePair(nodeLocale).getFirst();
        NodeUpdateEntity nodeUpdate = new NodeUpdateEntity();
        nodeUpdate.setId(nodeId);
        nodeUpdate.setStore(oldNode.getStore());
        nodeUpdate.setUuid(oldNode.getUuid());
        if (!nodeTypeQNameId.equals(oldNode.getTypeQNameId())) {
            nodeUpdate.setTypeQNameId(nodeTypeQNameId);
            nodeUpdate.setUpdateTypeQNameId(true);
        }
        if (!nodeLocaleId.equals(oldNode.getLocaleId())) {
            nodeUpdate.setLocaleId(nodeLocaleId);
            nodeUpdate.setUpdateLocaleId(true);
        }
        return this.updateNodeImpl(oldNode, nodeUpdate, null);
    }

    private boolean touchNode(Long nodeId, AuditablePropertiesEntity auditableProps, Set<QName> nodeAspects, boolean invalidateNodeAspectsCache, boolean invalidateNodePropertiesCache, boolean invalidateParentAssocsCache) {
        Node node = null;
        try {
            node = this.getNodeNotNull(nodeId);
        }
        catch (DataIntegrityViolationException e) {
            return false;
        }
        NodeUpdateEntity nodeUpdate = new NodeUpdateEntity();
        nodeUpdate.setId(nodeId);
        nodeUpdate.setAuditableProperties(auditableProps);
        boolean updatedNode = this.updateNodeImpl(node, nodeUpdate, nodeAspects);
        NodeVersionKey nodeVersionKey = node.getNodeVersionKey();
        if (updatedNode) {
            Node newNode = this.getNodeNotNull(nodeId);
            NodeVersionKey newNodeVersionKey = newNode.getNodeVersionKey();
            if (!invalidateNodeAspectsCache) {
                this.copyNodeAspectsCached(nodeVersionKey, newNodeVersionKey);
            }
            if (!invalidateNodePropertiesCache) {
                this.copyNodePropertiesCached(nodeVersionKey, newNodeVersionKey);
            }
            if (!invalidateParentAssocsCache) {
                this.copyParentAssocsCached(nodeVersionKey, newNodeVersionKey);
            }
        } else {
            this.invalidateNodeCaches(nodeVersionKey, invalidateNodeAspectsCache, invalidateNodePropertiesCache, invalidateParentAssocsCache);
        }
        return updatedNode;
    }

    private boolean updateNodeImpl(Node oldNode, NodeUpdateEntity nodeUpdate, Set<QName> nodeAspects) {
        Long nodeId = oldNode.getId();
        if (!EqualsHelper.nullSafeEquals((Object)nodeId, (Object)nodeUpdate.getId())) {
            throw new IllegalArgumentException("NodeUpdateEntity node ID is not correct: " + nodeUpdate);
        }
        nodeUpdate.setStore(oldNode.getStore());
        nodeUpdate.setUuid(oldNode.getUuid());
        if (!nodeUpdate.isUpdateTypeQNameId()) {
            nodeUpdate.setTypeQNameId(oldNode.getTypeQNameId());
        }
        if (!nodeUpdate.isUpdateLocaleId()) {
            nodeUpdate.setLocaleId(oldNode.getLocaleId());
        }
        if (!nodeUpdate.isUpdateAclId()) {
            nodeUpdate.setAclId(oldNode.getAclId());
        }
        if (!nodeUpdate.isUpdateDeleted()) {
            nodeUpdate.setDeleted(oldNode.getDeleted());
        }
        nodeUpdate.setVersion(oldNode.getVersion());
        TransactionEntity txn = this.getCurrentTransaction();
        nodeUpdate.setTransaction(txn);
        if (!txn.getId().equals(oldNode.getTransaction().getId())) {
            nodeUpdate.setUpdateTransaction(true);
        }
        if (nodeAspects == null) {
            nodeAspects = this.getNodeAspects(nodeId);
        }
        if (nodeAspects.contains(ContentModel.ASPECT_AUDITABLE)) {
            AuditablePropertiesEntity auditableProps;
            NodeRef oldNodeRef = oldNode.getNodeRef();
            if (this.policyBehaviourFilter.isEnabled(oldNodeRef, ContentModel.ASPECT_AUDITABLE)) {
                auditableProps = oldNode.getAuditableProperties();
                auditableProps = auditableProps == null ? new AuditablePropertiesEntity() : new AuditablePropertiesEntity(auditableProps);
                long modifiedDateToleranceMs = 1000L;
                if (nodeUpdate.isUpdateTransaction()) {
                    modifiedDateToleranceMs = 0L;
                }
                boolean updateAuditableProperties = auditableProps.setAuditValues(null, null, false, modifiedDateToleranceMs);
                nodeUpdate.setAuditableProperties(auditableProps);
                nodeUpdate.setUpdateAuditableProperties(updateAuditableProperties);
            } else if (nodeUpdate.getAuditableProperties() == null) {
                auditableProps = oldNode.getAuditableProperties();
                if (auditableProps != null) {
                    nodeUpdate.setAuditableProperties(auditableProps);
                    nodeUpdate.setUpdateAuditableProperties(true);
                }
            } else {
                nodeUpdate.setUpdateAuditableProperties(true);
            }
        } else {
            AuditablePropertiesEntity auditableProps = oldNode.getAuditableProperties();
            if (auditableProps != null) {
                nodeUpdate.setAuditableProperties(null);
                nodeUpdate.setUpdateAuditableProperties(true);
            }
        }
        if (!nodeUpdate.isUpdateAnything()) {
            return false;
        }
        int count = 0;
        Throwable concurrencyException = null;
        try {
            count = this.updateNode(nodeUpdate);
        }
        catch (Throwable e) {
            concurrencyException = e;
        }
        if (count != 1) {
            this.nodesCache.removeByKey(nodeId);
            this.nodesCache.removeByValue(nodeUpdate);
            throw new ConcurrencyFailureException("Failed to update node " + nodeId, concurrencyException);
        }
        if (nodeUpdate.getVersion().equals(LONG_ZERO)) {
            this.propertiesCache.clear();
            this.aspectsCache.clear();
            this.parentAssocsCache.clear();
        }
        nodeUpdate.lock();
        this.nodesCache.setValue(nodeId, nodeUpdate);
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Updated Node: \n   OLD: " + oldNode + "\n" + "   NEW: " + nodeUpdate));
        }
        return true;
    }

    @Override
    public void setNodeAclId(Long nodeId, Long aclId) {
        Node oldNode = this.getNodeNotNull(nodeId);
        NodeUpdateEntity nodeUpdateEntity = new NodeUpdateEntity();
        nodeUpdateEntity.setId(nodeId);
        nodeUpdateEntity.setAclId(aclId);
        nodeUpdateEntity.setUpdateAclId(true);
        this.updateNodeImpl(oldNode, nodeUpdateEntity, null);
    }

    @Override
    public void setPrimaryChildrenSharedAclId(Long primaryParentNodeId, Long optionalOldSharedAlcIdInAdditionToNull, Long newSharedAclId) {
        Long txnId = this.getCurrentTransaction().getId();
        this.updatePrimaryChildrenSharedAclId(txnId, primaryParentNodeId, optionalOldSharedAlcIdInAdditionToNull, newSharedAclId);
        this.invalidateNodeChildrenCaches(primaryParentNodeId, true, false);
    }

    @Override
    public void deleteNode(Long nodeId) {
        Node node = this.getNodeNotNull(nodeId);
        Long aclId = node.getAclId();
        Set<QName> nodeAspects = this.getNodeAspects(nodeId);
        NodeUpdateEntity nodeUpdate = new NodeUpdateEntity();
        nodeUpdate.setId(nodeId);
        nodeUpdate.setAclId(null);
        nodeUpdate.setUpdateAclId(true);
        nodeUpdate.setDeleted(true);
        nodeUpdate.setUpdateDeleted(true);
        Long deletedQNameId = (Long)this.qnameDAO.getOrCreateQName(ContentModel.TYPE_DELETED).getFirst();
        nodeUpdate.setTypeQNameId(deletedQNameId);
        nodeUpdate.setUpdateTypeQNameId(true);
        boolean updated = this.updateNodeImpl(node, nodeUpdate, nodeAspects);
        if (!updated) {
            this.invalidateNodeCaches(nodeId);
            throw new ConcurrencyFailureException("Failed to delete an existing live node: \n   Before: " + node + "\n" + "   Update: " + nodeUpdate);
        }
        HashSet<QName> contentQNames = new HashSet<QName>(this.dictionaryService.getAllProperties(DataTypeDefinition.CONTENT));
        Set<Long> contentQNamesToRemoveIds = this.qnameDAO.convertQNamesToIds(contentQNames, false);
        this.contentDataDAO.deleteContentDataForNode(nodeId, contentQNamesToRemoveIds);
        this.usageDAO.deleteDeltas(nodeId);
        if (nodeAspects.contains(ContentModel.ASPECT_ROOT)) {
            StoreRef storeRef = node.getStore().getStoreRef();
            this.allRootNodesCache.remove((Serializable)storeRef);
        }
        this.deleteNodeAssocsToAndFrom(nodeId);
        this.invalidateNodeChildrenCaches(nodeId, true, true);
        this.invalidateNodeChildrenCaches(nodeId, false, true);
        this.deleteChildAssocsToAndFrom(nodeId);
        this.deleteNodeAspects(nodeId, null);
        this.deleteNodeProperties(nodeId, (Set<Long>)null);
        this.deleteSubscriptions(nodeId);
        if (aclId != null) {
            this.aclDAO.deleteAclForNode(aclId, false);
        }
    }

    @Override
    public int purgeNodes(long maxTxnCommitTimeMs) {
        return this.deleteNodesByCommitTime(true, maxTxnCommitTimeMs);
    }

    @Override
    public Map<QName, Serializable> getNodeProperties(Long nodeId) {
        Map<QName, Serializable> props = this.getNodePropertiesCached(nodeId);
        Node node = this.getNodeNotNull(nodeId);
        ReferenceablePropertiesEntity.addReferenceableProperties(node, props);
        LocalizedPropertiesEntity.addLocalizedProperties(this.localeDAO, node, props);
        if (this.hasNodeAspect(nodeId, ContentModel.ASPECT_AUDITABLE)) {
            AuditablePropertiesEntity auditableProperties = node.getAuditableProperties();
            if (auditableProperties == null) {
                auditableProperties = new AuditablePropertiesEntity();
            }
            props.putAll(auditableProperties.getAuditableProperties());
        }
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Fetched properties for Node: \n   Node:  " + nodeId + "\n" + "   Props: " + props));
        }
        return props;
    }

    @Override
    public Serializable getNodeProperty(Long nodeId, QName propertyQName) {
        Serializable value = null;
        if (AuditablePropertiesEntity.isAuditableProperty(propertyQName)) {
            Node node = this.getNodeNotNull(nodeId);
            AuditablePropertiesEntity auditableProperties = node.getAuditableProperties();
            if (auditableProperties != null) {
                value = auditableProperties.getAuditableProperty(propertyQName);
            }
        } else if (ReferenceablePropertiesEntity.isReferenceableProperty(propertyQName)) {
            Node node = this.getNodeNotNull(nodeId);
            value = ReferenceablePropertiesEntity.getReferenceableProperty(node, propertyQName);
        } else if (LocalizedPropertiesEntity.isLocalizedProperty(propertyQName)) {
            Node node = this.getNodeNotNull(nodeId);
            value = LocalizedPropertiesEntity.getLocalizedProperty(this.localeDAO, node, propertyQName);
        } else {
            Map<QName, Serializable> props = this.getNodePropertiesCached(nodeId);
            value = props.get(propertyQName);
        }
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Fetched property for Node: \n   Node:  " + nodeId + "\n" + "   QName: " + propertyQName + "\n" + "   Value: " + value));
        }
        return value;
    }

    private boolean setNodePropertiesImpl(Long nodeId, Map<QName, Serializable> newProps, boolean isAddOnly) {
        boolean updated;
        Long newNodeLocaleId;
        if (isAddOnly && newProps.size() == 0) {
            return false;
        }
        Node node = this.getNodeNotNull(nodeId);
        NodeUpdateEntity nodeUpdate = new NodeUpdateEntity();
        nodeUpdate.setId(nodeId);
        newProps = new HashMap<QName, Serializable>(newProps);
        if (!this.policyBehaviourFilter.isEnabled(node.getNodeRef(), ContentModel.ASPECT_AUDITABLE) && AuditablePropertiesEntity.hasAuditableProperty(newProps.keySet())) {
            AuditablePropertiesEntity auditableProps = node.getAuditableProperties();
            auditableProps = auditableProps == null ? new AuditablePropertiesEntity() : new AuditablePropertiesEntity(auditableProps);
            boolean containedAuditProperties = auditableProps.setAuditValues(null, null, newProps);
            if (!containedAuditProperties) {
                auditableProps = null;
            }
            nodeUpdate.setAuditableProperties(auditableProps);
            nodeUpdate.setUpdateAuditableProperties(true);
        }
        newProps.keySet().removeAll(AuditablePropertiesEntity.getAuditablePropertyQNames());
        Long oldNodeLocaleId = node.getLocaleId();
        Locale newLocale = (Locale)DefaultTypeConverter.INSTANCE.convert(Locale.class, (Object)newProps.get(ContentModel.PROP_LOCALE));
        if (newLocale != null && !(newNodeLocaleId = (Long)this.localeDAO.getOrCreateLocalePair(newLocale).getFirst()).equals(oldNodeLocaleId)) {
            nodeUpdate.setLocaleId(newNodeLocaleId);
            nodeUpdate.setUpdateLocaleId(true);
        }
        LocalizedPropertiesEntity.removeLocalizedProperties(node, newProps);
        ReferenceablePropertiesEntity.removeReferenceableProperties(node, newProps);
        Map<QName, Serializable> oldPropsCached = this.getNodePropertiesCached(nodeId);
        HashMap<QName, Serializable> oldProps = new HashMap<QName, Serializable>(oldPropsCached);
        if (isAddOnly) {
            oldProps.keySet().retainAll(newProps.keySet());
        }
        Map<NodePropertyKey, NodePropertyValue> newPropsRaw = this.nodePropertyHelper.convertToPersistentProperties(newProps);
        newProps = this.nodePropertyHelper.convertToPublicProperties(newPropsRaw);
        Map diff = EqualsHelper.getMapComparison(oldProps, newProps);
        HashSet<QName> propsToDelete = new HashSet<QName>(oldProps.size() * 2);
        HashMap<QName, Serializable> propsToAdd = new HashMap<QName, Serializable>(newProps.size() * 2);
        HashSet<QName> contentQNamesToDelete = new HashSet<QName>(5);
        block10: for (Map.Entry entry : diff.entrySet()) {
            QName qname = (QName)entry.getKey();
            PropertyDefinition removePropDef = this.dictionaryService.getProperty(qname);
            boolean isContent = removePropDef != null && removePropDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT);
            switch ((EqualsHelper.MapValueComparison)entry.getValue()) {
                case EQUAL: {
                    continue block10;
                }
                case LEFT_ONLY: {
                    propsToDelete.add(qname);
                    if (!isContent) continue block10;
                    contentQNamesToDelete.add(qname);
                    continue block10;
                }
                case NOT_EQUAL: {
                    propsToDelete.add(qname);
                    if (isContent) {
                        contentQNamesToDelete.add(qname);
                    }
                }
                case RIGHT_ONLY: {
                    Object value = newProps.get(qname);
                    if (isContent && value != null) {
                        ContentData newContentData = (ContentData)value;
                        Long newContentDataId = (Long)this.contentDataDAO.createContentData(newContentData).getFirst();
                        value = new ContentDataWithId(newContentData, newContentDataId);
                    }
                    propsToAdd.put(qname, (Serializable)value);
                    continue block10;
                }
            }
            throw new IllegalStateException("Unknown MapValueComparison: " + entry.getValue());
        }
        boolean modifyProps = propsToDelete.size() > 0 || propsToAdd.size() > 0;
        boolean bl = updated = modifyProps || nodeUpdate.isUpdateAnything();
        if (nodeUpdate.isUpdateAnything()) {
            if (this.updateNodeImpl(node, nodeUpdate, null)) {
                NodeVersionKey nodeVersionKey = node.getNodeVersionKey();
                NodeVersionKey newNodeVersionKey = this.getNodeNotNull(nodeId).getNodeVersionKey();
                this.copyNodeAspectsCached(nodeVersionKey, newNodeVersionKey);
                this.copyNodePropertiesCached(nodeVersionKey, newNodeVersionKey);
                this.copyParentAssocsCached(nodeVersionKey, newNodeVersionKey);
            }
        } else if (modifyProps) {
            this.touchNode(nodeId, null, null, false, false, false);
        }
        if (modifyProps) {
            try {
                if (contentQNamesToDelete.size() > 0) {
                    Set<Long> contentQNameIdsToDelete = this.qnameDAO.convertQNamesToIds(contentQNamesToDelete, false);
                    this.contentDataDAO.deleteContentDataForNode(nodeId, contentQNameIdsToDelete);
                }
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException("Failed to delete content properties: \n  Node:          " + nodeId + "\n" + "  Delete Tried:  " + contentQNamesToDelete, e);
            }
            try {
                Set<Long> propQNameIdsToDelete = this.qnameDAO.convertQNamesToIds(propsToDelete, true);
                this.deleteNodeProperties(nodeId, propQNameIdsToDelete);
                newPropsRaw = this.nodePropertyHelper.convertToPersistentProperties(propsToAdd);
                this.insertNodeProperties(nodeId, newPropsRaw);
            }
            catch (Throwable e) {
                this.invalidateNodeCaches(nodeId);
                throw new AlfrescoRuntimeException("Failed to write property deltas: \n  Node:          " + nodeId + "\n" + "  Old:           " + oldProps + "\n" + "  New:           " + newProps + "\n" + "  Diff:          " + diff + "\n" + "  Delete Tried:  " + propsToDelete + "\n" + "  Add Tried:     " + propsToAdd, e);
            }
            Map<QName, Serializable> propsToCache = null;
            if (isAddOnly) {
                propsToCache = oldPropsCached;
                propsToCache.putAll(propsToAdd);
            } else {
                propsToCache = newProps;
                propsToCache.putAll(propsToAdd);
            }
            this.setNodePropertiesCached(nodeId, propsToCache);
        }
        if (this.isDebugEnabled && updated) {
            this.logger.debug((Object)("Modified node properties: " + nodeId + "\n" + "   Removed:     " + propsToDelete + "\n" + "   Added:       " + propsToAdd + "\n" + "   Node Update: " + nodeUpdate));
        }
        return updated;
    }

    @Override
    public boolean setNodeProperties(Long nodeId, Map<QName, Serializable> properties) {
        boolean modified = this.setNodePropertiesImpl(nodeId, properties, false);
        return modified;
    }

    @Override
    public boolean addNodeProperty(Long nodeId, QName qname, Serializable value) {
        HashMap<QName, Serializable> newProps = new HashMap<QName, Serializable>(3);
        newProps.put(qname, value);
        boolean modified = this.setNodePropertiesImpl(nodeId, newProps, true);
        return modified;
    }

    @Override
    public boolean addNodeProperties(Long nodeId, Map<QName, Serializable> properties) {
        boolean modified = this.setNodePropertiesImpl(nodeId, properties, true);
        return modified;
    }

    @Override
    public boolean removeNodeProperties(Long nodeId, Set<QName> propertyQNames) {
        propertyQNames = new HashSet<QName>(propertyQNames);
        ReferenceablePropertiesEntity.removeReferenceableProperties(propertyQNames);
        if (propertyQNames.size() == 0) {
            return false;
        }
        LocalizedPropertiesEntity.removeLocalizedProperties(propertyQNames);
        if (propertyQNames.size() == 0) {
            return false;
        }
        Set<Long> qnameIds = this.qnameDAO.convertQNamesToIds(propertyQNames, false);
        int deleteCount = this.deleteNodeProperties(nodeId, qnameIds);
        if (deleteCount > 0) {
            this.touchNode(nodeId, null, null, false, false, false);
            Map<QName, Serializable> cachedProps = this.getNodePropertiesCached(nodeId);
            cachedProps.keySet().removeAll(propertyQNames);
            this.setNodePropertiesCached(nodeId, cachedProps);
        }
        return deleteCount > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setModifiedDate(Long nodeId, Date modifiedDate) {
        if (!this.hasNodeAspect(nodeId, ContentModel.ASPECT_AUDITABLE)) {
            return false;
        }
        Node node = this.getNodeNotNull(nodeId);
        NodeRef nodeRef = node.getNodeRef();
        AuditablePropertiesEntity auditableProps = node.getAuditableProperties();
        boolean dateChanged = false;
        if (auditableProps == null) {
            auditableProps = new AuditablePropertiesEntity();
            auditableProps.setAuditValues(null, modifiedDate, true, 1000L);
            dateChanged = true;
        } else {
            auditableProps = new AuditablePropertiesEntity(auditableProps);
            dateChanged = auditableProps.setAuditModified(modifiedDate, 1000L);
        }
        if (dateChanged) {
            try {
                this.policyBehaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                boolean bl = this.touchNode(nodeId, auditableProps, null, false, false, false);
                Object var9_8 = null;
                this.policyBehaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                return bl;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.policyBehaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                throw throwable;
            }
        }
        return false;
    }

    private Map<QName, Serializable> getNodePropertiesCached(Long nodeId) {
        NodeVersionKey nodeVersionKey = this.getNodeNotNull(nodeId).getNodeVersionKey();
        Pair<NodeVersionKey, Map<QName, Serializable>> cacheEntry = this.propertiesCache.getByKey(nodeVersionKey);
        if (cacheEntry == null) {
            this.invalidateNodeCaches(nodeId);
            throw new DataIntegrityViolationException("Invalid node ID: " + nodeId);
        }
        Map cachedProperties = (Map)cacheEntry.getSecond();
        Map<QName, Serializable> properties = this.copyPropertiesAgainstModification(cachedProperties);
        return properties;
    }

    private void setNodePropertiesCached(Long nodeId, Map<QName, Serializable> properties) {
        NodeVersionKey nodeVersionKey = this.getNodeNotNull(nodeId).getNodeVersionKey();
        properties = this.copyPropertiesAgainstModification(properties);
        this.propertiesCache.setValue(nodeVersionKey, Collections.unmodifiableMap(properties));
    }

    private void copyNodePropertiesCached(NodeVersionKey from, NodeVersionKey to) {
        Map<QName, Serializable> cacheEntry = this.propertiesCache.getValue(from);
        if (cacheEntry != null) {
            this.propertiesCache.setValue(to, cacheEntry);
        }
    }

    private Map<QName, Serializable> copyPropertiesAgainstModification(Map<QName, Serializable> original) {
        HashMap<QName, Serializable> copy = new HashMap<QName, Serializable>((int)((double)original.size() * 1.3));
        for (Map.Entry<QName, Serializable> element : original.entrySet()) {
            QName key = element.getKey();
            Serializable value = element.getValue();
            if (value instanceof Collection || value instanceof Map) {
                value = (Serializable)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)value));
            }
            copy.put(key, value);
        }
        return copy;
    }

    @Override
    public Set<QName> getNodeAspects(Long nodeId) {
        Set<QName> nodeAspects = this.getNodeAspectsCached(nodeId);
        nodeAspects.add(ContentModel.ASPECT_REFERENCEABLE);
        nodeAspects.add(ContentModel.ASPECT_LOCALIZED);
        return nodeAspects;
    }

    @Override
    public boolean hasNodeAspect(Long nodeId, QName aspectQName) {
        if (aspectQName.equals((Object)ContentModel.ASPECT_REFERENCEABLE)) {
            return true;
        }
        if (aspectQName.equals((Object)ContentModel.ASPECT_LOCALIZED)) {
            return true;
        }
        Set<QName> nodeAspects = this.getNodeAspectsCached(nodeId);
        return nodeAspects.contains(aspectQName);
    }

    @Override
    public boolean addNodeAspects(Long nodeId, Set<QName> aspectQNames) {
        if (aspectQNames.size() == 0) {
            return false;
        }
        HashSet<QName> aspectQNamesToAdd = new HashSet<QName>(aspectQNames);
        Set<QName> existingAspectQNames = this.getNodeAspectsCached(nodeId);
        aspectQNamesToAdd.removeAll(existingAspectQNames);
        aspectQNamesToAdd.remove(ContentModel.ASPECT_REFERENCEABLE);
        aspectQNamesToAdd.remove(ContentModel.ASPECT_LOCALIZED);
        if (aspectQNamesToAdd.isEmpty()) {
            return false;
        }
        Set<Long> aspectQNameIds = this.qnameDAO.convertQNamesToIds(aspectQNamesToAdd, true);
        this.startBatch();
        try {
            try {
                for (Long aspectQNameId : aspectQNameIds) {
                    this.insertNodeAspect(nodeId, aspectQNameId);
                }
                Object var9_9 = null;
            }
            catch (RuntimeException e) {
                this.invalidateNodeCaches(nodeId);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.executeBatch();
            throw throwable;
        }
        this.executeBatch();
        HashSet<QName> newAspectQNames = new HashSet<QName>(existingAspectQNames);
        newAspectQNames.addAll(aspectQNamesToAdd);
        if (aspectQNames.contains(ContentModel.ASPECT_ROOT)) {
            StoreRef storeRef = this.getNodeNotNull(nodeId).getStore().getStoreRef();
            this.allRootNodesCache.remove((Serializable)storeRef);
            this.touchNode(nodeId, null, newAspectQNames, false, false, true);
        } else {
            this.touchNode(nodeId, null, newAspectQNames, false, false, false);
        }
        this.setNodeAspectsCached(nodeId, newAspectQNames);
        return true;
    }

    @Override
    public boolean removeNodeAspects(Long nodeId) {
        Set<QName> newAspectQNames = Collections.emptySet();
        this.touchNode(nodeId, null, newAspectQNames, false, false, false);
        int deleteCount = this.deleteNodeAspects(nodeId, null);
        this.setNodeAspectsCached(nodeId, newAspectQNames);
        return deleteCount > 0;
    }

    @Override
    public boolean removeNodeAspects(Long nodeId, Set<QName> aspectQNames) {
        if (aspectQNames.size() == 0) {
            return false;
        }
        Set<QName> existingAspectQNames = this.getNodeAspects(nodeId);
        HashSet<QName> newAspectQNames = new HashSet<QName>(existingAspectQNames);
        newAspectQNames.removeAll(aspectQNames);
        this.touchNode(nodeId, null, newAspectQNames, false, false, false);
        Set<Long> aspectQNameIdsToRemove = this.qnameDAO.convertQNamesToIds(aspectQNames, false);
        int deleteCount = this.deleteNodeAspects(nodeId, aspectQNameIdsToRemove);
        if (deleteCount == 0) {
            return false;
        }
        if (aspectQNames.contains(ContentModel.ASPECT_ROOT)) {
            StoreRef storeRef = this.getNodeNotNull(nodeId).getStore().getStoreRef();
            this.allRootNodesCache.remove((Serializable)storeRef);
            this.touchNode(nodeId, null, newAspectQNames, false, false, true);
        } else {
            this.touchNode(nodeId, null, newAspectQNames, false, false, false);
        }
        this.setNodeAspectsCached(nodeId, newAspectQNames);
        return deleteCount > 0;
    }

    @Override
    public void getNodesWithAspects(Set<QName> aspectQNames, Long minNodeId, Long maxNodeId, NodeDAO.NodeRefQueryCallback resultsCallback) {
        Set<Long> qnameIdsSet = this.qnameDAO.convertQNamesToIds(aspectQNames, false);
        if (qnameIdsSet.size() == 0) {
            return;
        }
        ArrayList<Long> qnameIds = new ArrayList<Long>(qnameIdsSet);
        this.selectNodesWithAspects(qnameIds, minNodeId, maxNodeId, resultsCallback);
    }

    private Set<QName> getNodeAspectsCached(Long nodeId) {
        NodeVersionKey nodeVersionKey = this.getNodeNotNull(nodeId).getNodeVersionKey();
        Pair<NodeVersionKey, Set<QName>> cacheEntry = this.aspectsCache.getByKey(nodeVersionKey);
        if (cacheEntry == null) {
            this.invalidateNodeCaches(nodeId);
            throw new DataIntegrityViolationException("Invalid node ID: " + nodeId);
        }
        return new HashSet<QName>((Collection)cacheEntry.getSecond());
    }

    private void setNodeAspectsCached(Long nodeId, Set<QName> aspects) {
        NodeVersionKey nodeVersionKey = this.getNodeNotNull(nodeId).getNodeVersionKey();
        this.aspectsCache.setValue(nodeVersionKey, Collections.unmodifiableSet(aspects));
    }

    private void copyNodeAspectsCached(NodeVersionKey from, NodeVersionKey to) {
        Set<QName> cacheEntry = this.aspectsCache.getValue(from);
        if (cacheEntry != null) {
            this.aspectsCache.setValue(to, cacheEntry);
        }
    }

    @Override
    public Long newNodeAssoc(Long sourceNodeId, Long targetNodeId, QName assocTypeQName, int assocIndex) {
        if (assocIndex == 0) {
            throw new IllegalArgumentException("Index is 1-based, or -1 to indicate 'next value'.");
        }
        this.touchNode(sourceNodeId, null, null, false, false, false);
        Long assocTypeQNameId = (Long)this.qnameDAO.getOrCreateQName(assocTypeQName).getFirst();
        if (assocIndex <= 0) {
            int maxIndex = this.selectNodeAssocMaxIndex(sourceNodeId, assocTypeQNameId);
            assocIndex = maxIndex + 1;
        }
        Long result = null;
        Savepoint savepoint = this.controlDAO.createSavepoint("NodeService.newNodeAssoc");
        try {
            result = this.insertNodeAssoc(sourceNodeId, targetNodeId, assocTypeQNameId, assocIndex);
            this.controlDAO.releaseSavepoint(savepoint);
            return result;
        }
        catch (Throwable e) {
            this.controlDAO.rollbackToSavepoint(savepoint);
            throw new AssociationExistsException(sourceNodeId, targetNodeId, assocTypeQName);
        }
    }

    @Override
    public void setNodeAssocIndex(Long id, int assocIndex) {
        int updated = this.updateNodeAssoc(id, assocIndex);
        if (updated != 1) {
            throw new ConcurrencyFailureException("Expected to update exactly one row: " + id);
        }
    }

    @Override
    public int removeNodeAssoc(Long sourceNodeId, Long targetNodeId, QName assocTypeQName) {
        Pair<Long, QName> assocTypeQNamePair = this.qnameDAO.getQName(assocTypeQName);
        if (assocTypeQNamePair == null) {
            return 0;
        }
        Long assocTypeQNameId = (Long)assocTypeQNamePair.getFirst();
        int deleted = this.deleteNodeAssoc(sourceNodeId, targetNodeId, assocTypeQNameId);
        if (deleted > 0) {
            this.touchNode(sourceNodeId, null, null, false, false, false);
        }
        return deleted;
    }

    @Override
    public int removeNodeAssocsToAndFrom(Long nodeId) {
        int deleted = this.deleteNodeAssocsToAndFrom(nodeId);
        if (deleted > 0) {
            this.touchNode(nodeId, null, null, false, false, false);
        }
        return deleted;
    }

    @Override
    public int removeNodeAssocsToAndFrom(Long nodeId, Set<QName> assocTypeQNames) {
        Set<Long> assocTypeQNameIds = this.qnameDAO.convertQNamesToIds(assocTypeQNames, false);
        if (assocTypeQNameIds.size() == 0) {
            return 0;
        }
        int deleted = this.deleteNodeAssocsToAndFrom(nodeId, assocTypeQNameIds);
        if (deleted > 0) {
            this.touchNode(nodeId, null, null, false, false, false);
        }
        return deleted;
    }

    @Override
    public int removeNodeAssocs(List<Long> ids) {
        int toDelete = ids.size();
        if (toDelete == 0) {
            return 0;
        }
        int deleted = this.deleteNodeAssocs(ids);
        if (toDelete != deleted) {
            throw new ConcurrencyFailureException("Deleted " + deleted + " but expected " + toDelete);
        }
        return deleted;
    }

    @Override
    public Collection<Pair<Long, AssociationRef>> getSourceNodeAssocs(Long targetNodeId, QName typeQName) {
        Long typeQNameId = null;
        if (typeQName != null) {
            Pair<Long, QName> typeQNamePair = this.qnameDAO.getQName(typeQName);
            if (typeQNamePair == null) {
                return Collections.emptyList();
            }
            typeQNameId = (Long)typeQNamePair.getFirst();
        }
        List<NodeAssocEntity> nodeAssocEntities = this.selectNodeAssocsByTarget(targetNodeId, typeQNameId);
        ArrayList<Pair<Long, AssociationRef>> results = new ArrayList<Pair<Long, AssociationRef>>(nodeAssocEntities.size());
        for (NodeAssocEntity nodeAssocEntity : nodeAssocEntities) {
            Long assocId = nodeAssocEntity.getId();
            AssociationRef assocRef = nodeAssocEntity.getAssociationRef(this.qnameDAO);
            results.add((Pair<Long, AssociationRef>)new Pair((Object)assocId, (Object)assocRef));
        }
        return results;
    }

    @Override
    public Collection<Pair<Long, AssociationRef>> getTargetNodeAssocs(Long sourceNodeId, QName typeQName) {
        Long typeQNameId = null;
        if (typeQName != null) {
            Pair<Long, QName> typeQNamePair = this.qnameDAO.getQName(typeQName);
            if (typeQNamePair == null) {
                return Collections.emptyList();
            }
            typeQNameId = (Long)typeQNamePair.getFirst();
        }
        List<NodeAssocEntity> nodeAssocEntities = this.selectNodeAssocsBySource(sourceNodeId, typeQNameId);
        ArrayList<Pair<Long, AssociationRef>> results = new ArrayList<Pair<Long, AssociationRef>>(nodeAssocEntities.size());
        for (NodeAssocEntity nodeAssocEntity : nodeAssocEntities) {
            Long assocId = nodeAssocEntity.getId();
            AssociationRef assocRef = nodeAssocEntity.getAssociationRef(this.qnameDAO);
            results.add((Pair<Long, AssociationRef>)new Pair((Object)assocId, (Object)assocRef));
        }
        return results;
    }

    @Override
    public Pair<Long, AssociationRef> getNodeAssocOrNull(Long assocId) {
        NodeAssocEntity nodeAssocEntity = this.selectNodeAssocById(assocId);
        if (nodeAssocEntity == null) {
            return null;
        }
        AssociationRef assocRef = nodeAssocEntity.getAssociationRef(this.qnameDAO);
        return new Pair((Object)assocId, (Object)assocRef);
    }

    @Override
    public Pair<Long, AssociationRef> getNodeAssoc(Long assocId) {
        Pair<Long, AssociationRef> ret = this.getNodeAssocOrNull(assocId);
        if (ret == null) {
            throw new ConcurrencyFailureException("Assoc ID does not point to a valid association: " + assocId);
        }
        return ret;
    }

    private ChildAssocEntity newChildAssocImpl(Long parentNodeId, Long childNodeId, boolean isPrimary, final QName assocTypeQName, QName assocQName, final String childNodeName) {
        Assert.notNull((Object)parentNodeId, (String)"parentNodeId");
        Assert.notNull((Object)childNodeId, (String)"childNodeId");
        Assert.notNull((Object)assocTypeQName, (String)"assocTypeQName");
        Assert.notNull((Object)assocQName, (String)"assocQName");
        Assert.notNull((Object)childNodeName, (String)"childNodeName");
        final Node parentNode = this.getNodeNotNull(parentNodeId);
        Node childNode = this.getNodeNotNull(childNodeId);
        final ChildAssocEntity assoc = new ChildAssocEntity();
        assoc.setParentNode(new NodeEntity(parentNode));
        assoc.setChildNode(new NodeEntity(childNode));
        assoc.setTypeQNameAll(this.qnameDAO, assocTypeQName, true);
        assoc.setChildNodeNameAll(this.dictionaryService, assocTypeQName, childNodeName);
        assoc.setQNameAll(this.qnameDAO, assocQName, true);
        assoc.setPrimary(isPrimary);
        assoc.setAssocIndex(-1);
        RetryingCallbackHelper.RetryingCallback<Long> callback = new RetryingCallbackHelper.RetryingCallback<Long>(){

            public Long execute() throws Throwable {
                Savepoint savepoint = AbstractNodeDAOImpl.this.controlDAO.createSavepoint("DuplicateChildNodeNameException");
                try {
                    Long id = AbstractNodeDAOImpl.this.insertChildAssoc(assoc);
                    AbstractNodeDAOImpl.this.controlDAO.releaseSavepoint(savepoint);
                    return id;
                }
                catch (Throwable e) {
                    AbstractNodeDAOImpl.this.controlDAO.rollbackToSavepoint(savepoint);
                    if (e.getMessage().contains("Snapshot isolation transaction aborted")) {
                        throw new ConcurrencyFailureException("SQL Server snapshot isolation retry...", e);
                    }
                    if (e.getMessage().contains("The INSERT statement conflicted with the FOREIGN KEY constraint")) {
                        throw new ConcurrencyFailureException("SQL Server FK conflict retry...", e);
                    }
                    throw new DuplicateChildNodeNameException(parentNode.getNodeRef(), assocTypeQName, childNodeName, e);
                }
            }
        };
        Long assocId = (Long)this.childAssocRetryingHelper.doWithRetry((RetryingCallbackHelper.RetryingCallback)callback);
        assoc.setId(assocId);
        if (!isPrimary) {
            this.updateNode(childNodeId, null, null);
        }
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Created child association: " + assoc));
        }
        return assoc;
    }

    @Override
    public Pair<Long, ChildAssociationRef> newChildAssoc(Long parentNodeId, Long childNodeId, QName assocTypeQName, QName assocQName, String childNodeName) {
        ParentAssocsInfo parentAssocInfo = this.getParentAssocsCached(childNodeId);
        ChildAssocEntity assoc = this.newChildAssocImpl(parentNodeId, childNodeId, false, assocTypeQName, assocQName, childNodeName);
        Long assocId = assoc.getId();
        this.touchNode(childNodeId, null, null, false, false, false);
        parentAssocInfo = parentAssocInfo.addAssoc(assocId, assoc);
        this.setParentAssocsCached(childNodeId, parentAssocInfo);
        return assoc.getPair(this.qnameDAO);
    }

    @Override
    public void deleteChildAssoc(Long assocId) {
        ChildAssocEntity assoc = this.selectChildAssoc(assocId);
        if (assoc == null) {
            throw new ConcurrencyFailureException("Child association not found: " + assocId);
        }
        Long childNodeId = assoc.getChildNode().getId();
        ParentAssocsInfo parentAssocInfo = this.getParentAssocsCached(childNodeId);
        int count = this.deleteChildAssocById(assocId);
        if (count != 1) {
            throw new ConcurrencyFailureException("Child association not deleted: " + assocId);
        }
        this.touchNode(childNodeId, null, null, false, false, false);
        parentAssocInfo = parentAssocInfo.removeAssoc(assocId);
        this.setParentAssocsCached(childNodeId, parentAssocInfo);
    }

    @Override
    public int setChildAssocIndex(Long parentNodeId, Long childNodeId, QName assocTypeQName, QName assocQName, int index) {
        int count = this.updateChildAssocIndex(parentNodeId, childNodeId, assocTypeQName, assocQName, index);
        if (count > 0) {
            this.touchNode(childNodeId, null, null, false, false, true);
        }
        return count;
    }

    @Override
    public void setChildAssocsUniqueName(final Long childNodeId, final String childName) {
        RetryingCallbackHelper.RetryingCallback<Integer> callback = new RetryingCallbackHelper.RetryingCallback<Integer>(){

            public Integer execute() throws Throwable {
                Savepoint savepoint = AbstractNodeDAOImpl.this.controlDAO.createSavepoint("DuplicateChildNodeNameException");
                try {
                    Integer count = AbstractNodeDAOImpl.this.updateChildAssocsUniqueName(childNodeId, childName);
                    AbstractNodeDAOImpl.this.controlDAO.releaseSavepoint(savepoint);
                    return count;
                }
                catch (Throwable e) {
                    AbstractNodeDAOImpl.this.controlDAO.rollbackToSavepoint(savepoint);
                    throw new DuplicateChildNodeNameException(null, null, childName, e);
                }
            }
        };
        Integer count = (Integer)this.childAssocRetryingHelper.doWithRetry((RetryingCallbackHelper.RetryingCallback)callback);
        if (count > 0) {
            this.touchNode(childNodeId, null, null, false, false, true);
        }
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("Updated cm:name to parent assocs: \n   Node:    " + childNodeId + "\n" + "   Name:    " + childName + "\n" + "   Updated: " + count));
        }
    }

    @Override
    public Pair<Long, ChildAssociationRef> getChildAssoc(Long assocId) {
        ChildAssocEntity assoc = this.selectChildAssoc(assocId);
        if (assoc == null) {
            throw new ConcurrencyFailureException("Child association not found: " + assocId);
        }
        return assoc.getPair(this.qnameDAO);
    }

    @Override
    public List<NodeIdAndAclId> getPrimaryChildrenAcls(Long nodeId) {
        return this.selectPrimaryChildAcls(nodeId);
    }

    @Override
    public Pair<Long, ChildAssociationRef> getChildAssoc(Long parentNodeId, Long childNodeId, QName assocTypeQName, QName assocQName) {
        List<ChildAssocEntity> assocs = this.selectChildAssoc(parentNodeId, childNodeId, assocTypeQName, assocQName);
        if (assocs.size() == 0) {
            return null;
        }
        if (assocs.size() == 1) {
            return assocs.get(0).getPair(this.qnameDAO);
        }
        HashMap<Long, ChildAssocEntity> assocsToDeleteById = new HashMap<Long, ChildAssocEntity>(assocs.size() * 2);
        Long minId = null;
        Long primaryId = null;
        for (ChildAssocEntity assoc : assocs) {
            Long assocId = assoc.getId();
            assocsToDeleteById.put(assocId, assoc);
            if (minId == null || minId.compareTo(assocId) > 0) {
                minId = assocId;
            }
            if (!assoc.isPrimary().booleanValue()) continue;
            primaryId = assocId;
        }
        Long assocToKeepId = primaryId == null ? minId : primaryId;
        ChildAssocEntity assocToKeep = (ChildAssocEntity)assocsToDeleteById.remove(assocToKeepId);
        if (AlfrescoTransactionSupport.getTransactionReadState() == AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE) {
            for (Long assocIdToDelete : assocsToDeleteById.keySet()) {
                this.deleteChildAssoc(assocIdToDelete);
            }
        }
        return assocToKeep.getPair(this.qnameDAO);
    }

    @Override
    public void getChildAssocs(Long parentNodeId, Long childNodeId, QName assocTypeQName, QName assocQName, Boolean isPrimary, Boolean sameStore, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        this.selectChildAssocs(parentNodeId, childNodeId, assocTypeQName, assocQName, isPrimary, sameStore, new ChildAssocRefBatchingQueryCallback(resultsCallback));
    }

    @Override
    public void getChildAssocs(Long parentNodeId, QName assocTypeQName, QName assocQName, int maxResults, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        this.selectChildAssocs(parentNodeId, assocTypeQName, assocQName, maxResults, new ChildAssocRefBatchingQueryCallback(resultsCallback));
    }

    @Override
    public void getChildAssocs(Long parentNodeId, Set<QName> assocTypeQNames, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        switch (assocTypeQNames.size()) {
            case 0: {
                return;
            }
            case 1: {
                QName assocTypeQName = assocTypeQNames.iterator().next();
                this.selectChildAssocs(parentNodeId, null, assocTypeQName, null, null, null, new ChildAssocRefBatchingQueryCallback(resultsCallback));
                break;
            }
            default: {
                this.selectChildAssocs(parentNodeId, assocTypeQNames, new ChildAssocRefBatchingQueryCallback(resultsCallback));
            }
        }
    }

    @Override
    public Pair<Long, ChildAssociationRef> getChildAssoc(Long parentNodeId, QName assocTypeQName, String childName) {
        ChildByNameKey key = new ChildByNameKey(parentNodeId, assocTypeQName, childName);
        ChildAssocEntity assoc = (ChildAssocEntity)this.childByNameCache.get((Serializable)key);
        boolean query = false;
        if (assoc == null) {
            query = true;
        } else {
            NodeEntity childNode = assoc.getChildNode();
            Long childNodeId = childNode.getId();
            NodeVersionKey childNodeVersionKey = childNode.getNodeVersionKey();
            Pair<Long, Node> childNodeFromCache = this.nodesCache.getByKey(childNodeId);
            if (childNodeFromCache == null) {
                query = true;
            } else {
                NodeVersionKey childNodeFromCacheVersionKey = ((Node)childNodeFromCache.getSecond()).getNodeVersionKey();
                if (!childNodeFromCacheVersionKey.equals(childNodeVersionKey)) {
                    query = true;
                }
            }
        }
        if (query && (assoc = this.selectChildAssoc(parentNodeId, assocTypeQName, childName)) != null) {
            this.childByNameCache.put((Serializable)key, (Object)assoc);
        }
        return assoc == null ? null : assoc.getPair(this.qnameDAO);
    }

    @Override
    public void getChildAssocs(Long parentNodeId, QName assocTypeQName, Collection<String> childNames, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        this.selectChildAssocs(parentNodeId, assocTypeQName, childNames, new ChildAssocRefBatchingQueryCallback(resultsCallback));
    }

    @Override
    public void getChildAssocsByPropertyValue(Long parentNodeId, QName propertyQName, Serializable value, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyQName);
        NodePropertyValue nodeValue = this.nodePropertyHelper.makeNodePropertyValue(propertyDef, value);
        if (nodeValue != null) {
            switch (nodeValue.getPersistedType()) {
                case 1: 
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("method not supported for persisted value type " + nodeValue.getPersistedType());
                }
            }
            this.selectChildAssocsByPropertyValue(parentNodeId, propertyQName, nodeValue, new ChildAssocRefBatchingQueryCallback(resultsCallback));
        }
    }

    @Override
    public void getChildAssocsByChildTypes(Long parentNodeId, Set<QName> childNodeTypeQNames, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        this.selectChildAssocsByChildTypes(parentNodeId, childNodeTypeQNames, new ChildAssocRefBatchingQueryCallback(resultsCallback));
    }

    @Override
    public void getChildAssocsWithoutParentAssocsOfType(Long parentNodeId, QName assocTypeQName, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        this.selectChildAssocsWithoutParentAssocsOfType(parentNodeId, assocTypeQName, new ChildAssocRefBatchingQueryCallback(resultsCallback));
    }

    @Override
    public Pair<Long, ChildAssociationRef> getPrimaryParentAssoc(Long childNodeId) {
        ChildAssocEntity childAssocEntity = this.getPrimaryParentAssocImpl(childNodeId);
        if (childAssocEntity == null) {
            return null;
        }
        return childAssocEntity.getPair(this.qnameDAO);
    }

    private ChildAssocEntity getPrimaryParentAssocImpl(Long childNodeId) {
        ParentAssocsInfo parentAssocs = this.getParentAssocsCached(childNodeId);
        return parentAssocs.getPrimaryParentAssoc();
    }

    @Override
    public void getParentAssocs(Long childNodeId, QName assocTypeQName, QName assocQName, Boolean isPrimary, NodeDAO.ChildAssocRefQueryCallback resultsCallback) {
        if (assocTypeQName == null && assocQName == null && isPrimary == null) {
            ParentAssocsInfo parentAssocs = this.getParentAssocsCached(childNodeId);
            for (ChildAssocEntity assoc : parentAssocs.getParentAssocs().values()) {
                resultsCallback.handle(assoc.getPair(this.qnameDAO), assoc.getParentNode().getNodePair(), assoc.getChildNode().getNodePair());
            }
            resultsCallback.done();
        } else {
            ParentAssocsInfo parentAssocs = this.getParentAssocsCached(childNodeId);
            if (parentAssocs.getParentAssocs().size() > 2000) {
                this.selectParentAssocs(childNodeId, assocTypeQName, assocQName, isPrimary, resultsCallback);
            } else {
                for (ChildAssocEntity assoc : parentAssocs.getParentAssocs().values()) {
                    Pair<Long, ChildAssociationRef> assocPair = assoc.getPair(this.qnameDAO);
                    if (assocTypeQName != null && !((ChildAssociationRef)assocPair.getSecond()).getTypeQName().equals((Object)assocTypeQName) || assocQName != null && !((ChildAssociationRef)assocPair.getSecond()).getQName().equals((Object)assocQName)) continue;
                    resultsCallback.handle(assocPair, assoc.getParentNode().getNodePair(), assoc.getChildNode().getNodePair());
                }
                resultsCallback.done();
            }
        }
    }

    @Override
    public void cycleCheck(Long nodeId) {
        CycleCallBack callback = new CycleCallBack();
        callback.cycleCheck(nodeId);
        if (callback.toThrow != null) {
            throw callback.toThrow;
        }
    }

    @Override
    public List<Path> getPaths(Pair<Long, NodeRef> nodePair, boolean primaryOnly) throws InvalidNodeRefException {
        ArrayList<Path> paths = new ArrayList<Path>(primaryOnly ? 1 : 10);
        Path currentPath = new Path();
        Stack<Long> assocIdStack = new Stack<Long>();
        this.prependPaths(nodePair, null, currentPath, paths, assocIdStack, primaryOnly);
        if (primaryOnly && paths.size() != 1) {
            throw new RuntimeException("Node has " + paths.size() + " primary paths: " + nodePair);
        }
        if (this.loggerPaths.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(256);
            if (primaryOnly) {
                sb.append("Primary paths");
            } else {
                sb.append("Paths");
            }
            sb.append(" for node ").append(nodePair);
            for (Path path : paths) {
                sb.append("\n").append("   ").append(path);
            }
            this.loggerPaths.debug((Object)sb);
        }
        return paths;
    }

    private void prependPaths(Pair<Long, NodeRef> currentNodePair, Pair<StoreRef, NodeRef> currentRootNodePair, Path currentPath, Collection<Path> completedPaths, Stack<Long> assocIdStack, boolean primaryOnly) throws CyclicChildRelationshipException {
        ParentAssocsInfo parentAssocInfo;
        boolean hasParents;
        if (this.isDebugEnabled) {
            this.logger.debug((Object)("\nPrepending paths: \n   Current node: " + currentNodePair + "\n" + "   Current root: " + currentRootNodePair + "\n" + "   Current path: " + currentPath));
        }
        Long currentNodeId = (Long)currentNodePair.getFirst();
        NodeRef currentNodeRef = (NodeRef)currentNodePair.getSecond();
        StoreRef currentStoreRef = currentNodeRef.getStoreRef();
        if (currentRootNodePair == null || !currentStoreRef.equals(currentRootNodePair.getFirst())) {
            Pair<Long, NodeRef> rootNodePair = this.getRootNode(currentStoreRef);
            currentRootNodePair = new Pair((Object)currentStoreRef, rootNodePair.getSecond());
        }
        boolean bl = hasParents = (parentAssocInfo = this.getParentAssocsCached(currentNodeId)).getParentAssocs().size() > 0;
        if (!(primaryOnly && hasParents || !parentAssocInfo.isRoot())) {
            ChildAssociationRef assocRef = new ChildAssociationRef(null, null, null, (NodeRef)currentRootNodePair.getSecond());
            Path pathToSave = new Path();
            Path.ChildAssocElement first = null;
            for (Path.Element element : currentPath) {
                if (first == null) {
                    first = (Path.ChildAssocElement)element;
                    continue;
                }
                pathToSave.append(element);
            }
            if (first != null) {
                ChildAssociationRef updateAssocRef = new ChildAssociationRef(parentAssocInfo.isStoreRoot() ? ContentModel.ASSOC_CHILDREN : first.getRef().getTypeQName(), (NodeRef)currentRootNodePair.getSecond(), first.getRef().getQName(), first.getRef().getChildRef());
                Path.ChildAssocElement newFirst = new Path.ChildAssocElement(updateAssocRef);
                pathToSave.prepend((Path.Element)newFirst);
            }
            Path.ChildAssocElement element = new Path.ChildAssocElement(assocRef);
            pathToSave.prepend((Path.Element)element);
            completedPaths.add(pathToSave);
        }
        if (!hasParents && !parentAssocInfo.isRoot()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Stale cache detected for Node #" + currentNodeId + ": removing from cache."));
            }
            this.invalidateNodeCaches(currentNodeId);
            NodeRef.Status currentNodeStatus = this.getNodeRefStatus(currentNodeRef);
            if (currentNodeStatus == null || currentNodeStatus.isDeleted()) {
                throw new DataIntegrityViolationException("Stale cache detected for Node #" + currentNodeId);
            }
            throw new RuntimeException("Node without parents does not have root aspect: " + currentNodeRef);
        }
        for (Map.Entry<Long, ChildAssocEntity> entry : parentAssocInfo.getParentAssocs().entrySet()) {
            Long assocId = entry.getKey();
            ChildAssocEntity assoc = entry.getValue();
            ChildAssociationRef assocRef = assoc.getRef(this.qnameDAO);
            if (primaryOnly && !assocRef.isPrimary()) continue;
            assocRef.setNthSibling(-1);
            Path.ChildAssocElement element = new Path.ChildAssocElement(assocRef);
            Path path = new Path();
            path.append(currentPath);
            path.prepend((Path.Element)element);
            Pair parentNodePair = new Pair((Object)assoc.getParentNode().getId(), (Object)assocRef.getParentRef());
            if (assocIdStack.contains(assocId)) {
                this.logger.error((Object)("Cyclic parent-child relationship detected: \n   current node: " + currentNodeId + "\n" + "   current path: " + currentPath + "\n" + "   next assoc: " + assocId));
                throw new CyclicChildRelationshipException("Node has been pasted into its own tree.", assocRef);
            }
            if (this.isDebugEnabled) {
                this.logger.debug((Object)("\n   Prepending path parent: \n      Parent node: " + parentNodePair));
            }
            assocIdStack.push(assocId);
            this.prependPaths((Pair<Long, NodeRef>)parentNodePair, (Pair<StoreRef, NodeRef>)currentRootNodePair, path, completedPaths, assocIdStack, primaryOnly);
            assocIdStack.pop();
        }
    }

    private ParentAssocsInfo getParentAssocsCached(Long nodeId) {
        NodeVersionKey nodeVersionKey = this.getNodeNotNull(nodeId).getNodeVersionKey();
        Pair<NodeVersionKey, ParentAssocsInfo> cacheEntry = this.parentAssocsCache.getByKey(nodeVersionKey);
        if (cacheEntry == null) {
            this.invalidateNodeCaches(nodeId);
            throw new DataIntegrityViolationException("Invalid node ID: " + nodeId);
        }
        return (ParentAssocsInfo)cacheEntry.getSecond();
    }

    private void setParentAssocsCached(Long nodeId, ParentAssocsInfo parentAssocs) {
        NodeVersionKey nodeVersionKey = this.getNodeNotNull(nodeId).getNodeVersionKey();
        this.parentAssocsCache.setValue(nodeVersionKey, parentAssocs);
    }

    private void copyParentAssocsCached(NodeVersionKey from, NodeVersionKey to) {
        ParentAssocsInfo cacheEntry = this.parentAssocsCache.getValue(from);
        if (cacheEntry != null) {
            this.parentAssocsCache.setValue(to, cacheEntry);
        }
    }

    @Override
    public void setCheckNodeConsistency() {
        if (this.nodesTransactionalCache != null) {
            this.nodesTransactionalCache.setDisableSharedCacheReadForTransaction(true);
        }
    }

    @Override
    public void cacheNodesById(List<Long> nodeIds) {
        if (nodeIds.size() < 10) {
            return;
        }
        int foundCacheEntryCount = 0;
        int missingCacheEntryCount = 0;
        boolean forceBatch = false;
        ArrayList<Long> batchLoadNodeIds = new ArrayList<Long>(nodeIds.size());
        for (Long nodeId : nodeIds) {
            if (!forceBatch) {
                if (this.nodesCache.getValue(nodeId) != null) {
                    ++foundCacheEntryCount;
                    continue;
                }
                if (foundCacheEntryCount + ++missingCacheEntryCount % 100 == 0) {
                    forceBatch = foundCacheEntryCount < missingCacheEntryCount;
                }
            }
            batchLoadNodeIds.add(nodeId);
        }
        int size = batchLoadNodeIds.size();
        this.cacheNodesBatch(batchLoadNodeIds);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Pre-loaded " + size + " nodes."));
        }
    }

    @Override
    public void cacheNodes(List<NodeRef> nodeRefs) {
        if (nodeRefs.size() < 10) {
            return;
        }
        int foundCacheEntryCount = 0;
        int missingCacheEntryCount = 0;
        boolean forceBatch = false;
        HashMap<StoreRef, ArrayList<String>> uuidsByStore = new HashMap<StoreRef, ArrayList<String>>(3);
        for (NodeRef nodeRef : nodeRefs) {
            StoreRef storeRef;
            ArrayList<String> uuids;
            if (!forceBatch) {
                if (this.nodesCache.getKey(nodeRef) != null) {
                    ++foundCacheEntryCount;
                    continue;
                }
                if (foundCacheEntryCount + ++missingCacheEntryCount % 100 == 0) {
                    boolean bl = forceBatch = foundCacheEntryCount < missingCacheEntryCount;
                }
            }
            if ((uuids = (ArrayList<String>)uuidsByStore.get(storeRef = nodeRef.getStoreRef())) == null) {
                uuids = new ArrayList<String>(nodeRefs.size());
                uuidsByStore.put(storeRef, uuids);
            }
            uuids.add(nodeRef.getId());
        }
        int size = nodeRefs.size();
        nodeRefs = null;
        for (Map.Entry entry : uuidsByStore.entrySet()) {
            StoreRef storeRef = (StoreRef)entry.getKey();
            List uuids = (List)entry.getValue();
            this.cacheNodes(storeRef, uuids);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Pre-loaded " + size + " nodes."));
        }
    }

    private void cacheNodes(StoreRef storeRef, List<String> uuids) {
        StoreEntity store = this.getStoreNotNull(storeRef);
        Long storeId = store.getId();
        int batchSize = 256;
        TreeSet<String> batch = new TreeSet<String>();
        for (String uuid : uuids) {
            batch.add(uuid);
            if (batch.size() < batchSize) continue;
            this.cacheNodesNoBatch(this.selectNodesByUuids(storeId, batch, Boolean.FALSE));
            batch.clear();
        }
        if (batch.size() > 0) {
            this.cacheNodesNoBatch(this.selectNodesByUuids(storeId, batch, Boolean.FALSE));
        }
    }

    private void cacheNodesBatch(List<Long> nodeIds) {
        int batchSize = 256;
        TreeSet<Long> batch = new TreeSet<Long>();
        for (Long nodeId : nodeIds) {
            batch.add(nodeId);
            if (batch.size() < batchSize) continue;
            this.cacheNodesNoBatch(this.selectNodesByIds(batch, Boolean.FALSE));
            batch.clear();
        }
        if (batch.size() > 0) {
            this.cacheNodesNoBatch(this.selectNodesByIds(batch, Boolean.FALSE));
        }
    }

    private void cacheNodesNoBatch(List<Node> nodes) {
        Long nodeId;
        TreeSet<Long> aspectNodeIds = new TreeSet<Long>();
        TreeSet<Long> propertiesNodeIds = new TreeSet<Long>();
        HashMap<Long, NodeVersionKey> nodeVersionKeysFromCache = new HashMap<Long, NodeVersionKey>(nodes.size() * 2);
        for (Node node : nodes) {
            Long nodeId2 = node.getId();
            NodeVersionKey nodeVersionKey = node.getNodeVersionKey();
            this.nodesCache.setValue(nodeId2, node);
            if (this.propertiesCache.getValue(nodeVersionKey) == null) {
                propertiesNodeIds.add(nodeId2);
            }
            if (this.aspectsCache.getValue(nodeVersionKey) == null) {
                aspectNodeIds.add(nodeId2);
            }
            nodeVersionKeysFromCache.put(nodeId2, nodeVersionKey);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Pre-loaded " + propertiesNodeIds.size() + " properties"));
            this.logger.debug((Object)("Pre-loaded " + propertiesNodeIds.size() + " aspects"));
        }
        Map<NodeVersionKey, Set<QName>> nodeAspects = this.selectNodeAspects(aspectNodeIds);
        for (Map.Entry<NodeVersionKey, Set<QName>> entry : nodeAspects.entrySet()) {
            NodeVersionKey nodeVersionKeyFromDb = entry.getKey();
            nodeId = nodeVersionKeyFromDb.getNodeId();
            Set<QName> qnames = entry.getValue();
            this.setNodeAspectsCached(nodeId, qnames);
            aspectNodeIds.remove(nodeId);
        }
        for (Long nodeId2 : aspectNodeIds) {
            this.setNodeAspectsCached(nodeId2, Collections.<QName>emptySet());
        }
        this.contentDataDAO.cacheContentDataForNodes(propertiesNodeIds);
        Map<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>> propsByNodeId = this.selectNodeProperties(propertiesNodeIds);
        for (Map.Entry<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>> entry : propsByNodeId.entrySet()) {
            nodeId = entry.getKey().getNodeId();
            Map<NodePropertyKey, NodePropertyValue> propertyValues = entry.getValue();
            Map<QName, Serializable> props = this.nodePropertyHelper.convertToPublicProperties(propertyValues);
            this.setNodePropertiesCached(nodeId, props);
        }
    }

    @Override
    public void clear() {
        this.clearCaches();
    }

    @Override
    public Long getMaxTxnIdByCommitTime(long maxCommitTime) {
        Transaction txn = this.selectLastTxnBeforeCommitTime(maxCommitTime);
        return txn == null ? null : txn.getId();
    }

    @Override
    public int getTransactionCount() {
        return this.selectTransactionCount();
    }

    @Override
    public Transaction getTxnById(Long txnId) {
        return this.selectTxnById(txnId);
    }

    @Override
    public List<NodeRef.Status> getTxnChanges(Long txnId) {
        return this.getTxnChangesForStore(null, txnId);
    }

    @Override
    public List<NodeRef.Status> getTxnChangesForStore(StoreRef storeRef, Long txnId) {
        Long storeId = storeRef == null ? null : this.getStoreNotNull(storeRef).getId();
        List<NodeEntity> nodes = this.selectTxnChanges(txnId, storeId);
        ArrayList<NodeRef.Status> nodeStatuses = new ArrayList<NodeRef.Status>(nodes.size());
        for (NodeEntity node : nodes) {
            nodeStatuses.add(node.getNodeStatus());
        }
        return nodeStatuses;
    }

    @Override
    public int getTxnUpdateCount(Long txnId) {
        return this.selectTxnNodeChangeCount(txnId, Boolean.TRUE);
    }

    @Override
    public int getTxnDeleteCount(Long txnId) {
        return this.selectTxnNodeChangeCount(txnId, Boolean.FALSE);
    }

    @Override
    public List<Transaction> getTxnsByCommitTimeAscending(Long fromTimeInclusive, Long toTimeExclusive, int count, List<Long> excludeTxnIds, boolean remoteOnly) {
        Long serverId;
        serverId = remoteOnly ? (serverId = this.getServerId()) : null;
        return this.selectTxns(fromTimeInclusive, toTimeExclusive, count, null, excludeTxnIds, serverId, Boolean.TRUE);
    }

    @Override
    public List<Transaction> getTxnsByCommitTimeDescending(Long fromTimeInclusive, Long toTimeExclusive, int count, List<Long> excludeTxnIds, boolean remoteOnly) {
        Long serverId;
        serverId = remoteOnly ? (serverId = this.getServerId()) : null;
        return this.selectTxns(fromTimeInclusive, toTimeExclusive, count, null, excludeTxnIds, serverId, Boolean.FALSE);
    }

    @Override
    public List<Transaction> getTxnsByCommitTimeAscending(List<Long> includeTxnIds) {
        return this.selectTxns(null, null, null, includeTxnIds, null, null, Boolean.TRUE);
    }

    @Override
    public List<Long> getTxnsUnused(Long minTxnId, long maxCommitTime, int count) {
        return this.selectTxnsUnused(minTxnId, maxCommitTime, count);
    }

    @Override
    public void purgeTxn(Long txnId) {
        this.deleteTransaction(txnId);
    }

    @Override
    public Long getMinTxnCommitTime() {
        Long time = this.selectMinTxnCommitTime();
        return time == null ? LONG_ZERO : time;
    }

    @Override
    public Long getMaxTxnCommitTime() {
        Long time = this.selectMaxTxnCommitTime();
        return time == null ? LONG_ZERO : time;
    }

    protected abstract ServerEntity selectServer(String var1);

    protected abstract Long insertServer(String var1);

    protected abstract Long insertTransaction(Long var1, String var2, Long var3);

    protected abstract int updateTransaction(Long var1, Long var2);

    protected abstract int deleteTransaction(Long var1);

    protected abstract List<StoreEntity> selectAllStores();

    protected abstract NodeEntity selectStoreRootNode(Long var1);

    protected abstract NodeEntity selectStoreRootNode(StoreRef var1);

    protected abstract Long insertStore(StoreEntity var1);

    protected abstract int updateStoreRoot(StoreEntity var1);

    protected abstract int updateStore(StoreEntity var1);

    protected abstract Long insertNode(NodeEntity var1);

    protected abstract int updateNode(NodeUpdateEntity var1);

    protected abstract int updateNodes(Long var1, List<Long> var2);

    protected abstract void updatePrimaryChildrenSharedAclId(Long var1, Long var2, Long var3, Long var4);

    protected abstract int deleteNodeById(Long var1, boolean var2);

    protected abstract int deleteNodesByCommitTime(boolean var1, long var2);

    protected abstract NodeEntity selectNodeById(Long var1, Boolean var2);

    protected abstract NodeEntity selectNodeByNodeRef(NodeRef var1, Boolean var2);

    protected abstract List<Node> selectNodesByUuids(Long var1, SortedSet<String> var2, Boolean var3);

    protected abstract List<Node> selectNodesByIds(SortedSet<Long> var1, Boolean var2);

    protected abstract Map<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>> selectNodeProperties(Set<Long> var1);

    protected abstract Map<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>> selectNodeProperties(Long var1);

    protected abstract Map<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>> selectNodeProperties(Long var1, Set<Long> var2);

    protected abstract int deleteNodeProperties(Long var1, Set<Long> var2);

    protected abstract int deleteNodeProperties(Long var1, List<NodePropertyKey> var2);

    protected abstract void insertNodeProperties(Long var1, Map<NodePropertyKey, NodePropertyValue> var2);

    protected abstract Map<NodeVersionKey, Set<QName>> selectNodeAspects(Set<Long> var1);

    protected abstract void insertNodeAspect(Long var1, Long var2);

    protected abstract int deleteNodeAspects(Long var1, Set<Long> var2);

    protected abstract void selectNodesWithAspects(List<Long> var1, Long var2, Long var3, NodeDAO.NodeRefQueryCallback var4);

    protected abstract Long insertNodeAssoc(Long var1, Long var2, Long var3, int var4);

    protected abstract int updateNodeAssoc(Long var1, int var2);

    protected abstract int deleteNodeAssoc(Long var1, Long var2, Long var3);

    protected abstract int deleteNodeAssocsToAndFrom(Long var1);

    protected abstract int deleteNodeAssocsToAndFrom(Long var1, Set<Long> var2);

    protected abstract int deleteNodeAssocs(List<Long> var1);

    protected abstract List<NodeAssocEntity> selectNodeAssocsBySource(Long var1, Long var2);

    protected abstract List<NodeAssocEntity> selectNodeAssocsByTarget(Long var1, Long var2);

    protected abstract NodeAssocEntity selectNodeAssocById(Long var1);

    protected abstract int selectNodeAssocMaxIndex(Long var1, Long var2);

    protected abstract Long insertChildAssoc(ChildAssocEntity var1);

    protected abstract int deleteChildAssocById(Long var1);

    protected abstract int updateChildAssocIndex(Long var1, Long var2, QName var3, QName var4, int var5);

    protected abstract int updateChildAssocsUniqueName(Long var1, String var2);

    protected abstract int deleteChildAssocsToAndFrom(Long var1);

    protected abstract ChildAssocEntity selectChildAssoc(Long var1);

    protected abstract List<ChildAssocEntity> selectChildNodeIds(Long var1, Boolean var2, Long var3, int var4);

    protected abstract List<NodeIdAndAclId> selectPrimaryChildAcls(Long var1);

    protected abstract List<ChildAssocEntity> selectChildAssoc(Long var1, Long var2, QName var3, QName var4);

    protected abstract void selectChildAssocs(Long var1, Long var2, QName var3, QName var4, Boolean var5, Boolean var6, NodeDAO.ChildAssocRefQueryCallback var7);

    protected abstract void selectChildAssocs(Long var1, QName var2, QName var3, int var4, NodeDAO.ChildAssocRefQueryCallback var5);

    protected abstract void selectChildAssocs(Long var1, Set<QName> var2, NodeDAO.ChildAssocRefQueryCallback var3);

    protected abstract ChildAssocEntity selectChildAssoc(Long var1, QName var2, String var3);

    protected abstract void selectChildAssocs(Long var1, QName var2, Collection<String> var3, NodeDAO.ChildAssocRefQueryCallback var4);

    protected abstract void selectChildAssocsByPropertyValue(Long var1, QName var2, NodePropertyValue var3, NodeDAO.ChildAssocRefQueryCallback var4);

    protected abstract void selectChildAssocsByChildTypes(Long var1, Set<QName> var2, NodeDAO.ChildAssocRefQueryCallback var3);

    protected abstract void selectChildAssocsWithoutParentAssocsOfType(Long var1, QName var2, NodeDAO.ChildAssocRefQueryCallback var3);

    protected abstract void selectParentAssocs(Long var1, QName var2, QName var3, Boolean var4, NodeDAO.ChildAssocRefQueryCallback var5);

    protected abstract List<ChildAssocEntity> selectParentAssocs(Long var1);

    protected abstract List<ChildAssocEntity> selectPrimaryParentAssocs(Long var1);

    protected abstract int updatePrimaryParentAssocs(Long var1, Long var2, QName var3, QName var4, String var5);

    protected abstract void moveNodeData(Long var1, Long var2);

    protected abstract void deleteSubscriptions(Long var1);

    protected abstract Transaction selectLastTxnBeforeCommitTime(Long var1);

    protected abstract int selectTransactionCount();

    protected abstract Transaction selectTxnById(Long var1);

    protected abstract List<NodeEntity> selectTxnChanges(Long var1, Long var2);

    protected abstract int selectTxnNodeChangeCount(Long var1, Boolean var2);

    protected abstract List<Transaction> selectTxns(Long var1, Long var2, Integer var3, List<Long> var4, List<Long> var5, Long var6, Boolean var7);

    protected abstract List<Long> selectTxnsUnused(Long var1, Long var2, Integer var3);

    protected abstract Long selectMinTxnCommitTime();

    protected abstract Long selectMaxTxnCommitTime();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParentAssocsCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<NodeVersionKey, ParentAssocsInfo, Serializable> {
        private ParentAssocsCallbackDAO() {
        }

        @Override
        public Pair<NodeVersionKey, ParentAssocsInfo> createValue(ParentAssocsInfo value) {
            throw new UnsupportedOperationException("Nodes are created independently.");
        }

        @Override
        public Pair<NodeVersionKey, ParentAssocsInfo> findByKey(NodeVersionKey nodeVersionKey) {
            ChildAssocEntity childAssoc;
            NodeVersionKey childNodeVersionKeyFromDb;
            Long nodeId = nodeVersionKey.getNodeId();
            boolean isRoot = AbstractNodeDAOImpl.this.hasNodeAspect(nodeId, ContentModel.ASPECT_ROOT);
            boolean isStoreRoot = AbstractNodeDAOImpl.this.getNodeType(nodeId).equals((Object)ContentModel.TYPE_STOREROOT);
            List<ChildAssocEntity> assocs = AbstractNodeDAOImpl.this.selectParentAssocs(nodeId);
            ParentAssocsInfo value = new ParentAssocsInfo(isRoot, isStoreRoot, assocs);
            if (!assocs.isEmpty() && !(childNodeVersionKeyFromDb = (childAssoc = assocs.get(0)).getChildNode().getNodeVersionKey()).equals(nodeVersionKey)) {
                AbstractNodeDAOImpl.this.invalidateNodeCaches(nodeId);
                throw new DataIntegrityViolationException("Detected stale node entry: " + nodeVersionKey + " (now " + childNodeVersionKeyFromDb + ")");
            }
            return new Pair((Object)nodeVersionKey, (Object)value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CycleCallBack
    implements NodeDAO.ChildAssocRefQueryCallback {
        final Set<Long> nodeIds = new HashSet<Long>(97);
        CyclicChildRelationshipException toThrow;

        private CycleCallBack() {
        }

        @Override
        public void done() {
        }

        @Override
        public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
            Long nodeId = (Long)childNodePair.getFirst();
            if (!this.nodeIds.add(nodeId)) {
                ChildAssociationRef childAssociationRef = (ChildAssociationRef)childAssocPair.getSecond();
                this.toThrow = new CyclicChildRelationshipException("Child Association Cycle detected hitting nodes: " + this.nodeIds, childAssociationRef);
                return false;
            }
            this.cycleCheck(nodeId);
            this.nodeIds.remove(nodeId);
            return this.toThrow == null;
        }

        @Override
        public boolean preLoadNodes() {
            return false;
        }

        @Override
        public boolean orderResults() {
            return false;
        }

        public void cycleCheck(Long nodeId) {
            AbstractNodeDAOImpl.this.getChildAssocs(nodeId, null, null, null, null, null, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChildAssocRefBatchingQueryCallback
    implements NodeDAO.ChildAssocRefQueryCallback {
        private final NodeDAO.ChildAssocRefQueryCallback callback;
        private final boolean preload;
        private final List<NodeRef> nodeRefs;

        private ChildAssocRefBatchingQueryCallback(NodeDAO.ChildAssocRefQueryCallback callback) {
            this.callback = callback;
            this.preload = callback.preLoadNodes();
            this.nodeRefs = this.preload ? new LinkedList<NodeRef>() : null;
        }

        @Override
        public boolean preLoadNodes() {
            throw new UnsupportedOperationException("Expected to be used internally only.");
        }

        @Override
        public boolean orderResults() {
            return this.callback.orderResults();
        }

        @Override
        public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
            if (this.preload) {
                this.nodeRefs.add((NodeRef)childNodePair.getSecond());
            }
            return this.callback.handle(childAssocPair, parentNodePair, childNodePair);
        }

        @Override
        public void done() {
            if (this.preload && this.nodeRefs.size() > 0) {
                AbstractNodeDAOImpl.this.cacheNodes(this.nodeRefs);
                this.nodeRefs.clear();
            }
            this.callback.done();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AspectsCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<NodeVersionKey, Set<QName>, Serializable> {
        private AspectsCallbackDAO() {
        }

        @Override
        public Pair<NodeVersionKey, Set<QName>> createValue(Set<QName> value) {
            throw new UnsupportedOperationException("A node always has a 'set' of aspects.");
        }

        @Override
        public Pair<NodeVersionKey, Set<QName>> findByKey(NodeVersionKey nodeVersionKey) {
            Long nodeId = nodeVersionKey.getNodeId();
            Set<Long> nodeIds = Collections.singleton(nodeId);
            Map<NodeVersionKey, Set<QName>> nodeAspectQNameIdsByVersionKey = AbstractNodeDAOImpl.this.selectNodeAspects(nodeIds);
            Set<Object> nodeAspectQNames = nodeAspectQNameIdsByVersionKey.get(nodeVersionKey);
            if (nodeAspectQNames == null) {
                if (nodeAspectQNameIdsByVersionKey.size() == 0) {
                    nodeAspectQNames = Collections.emptySet();
                } else {
                    AbstractNodeDAOImpl.this.invalidateNodeCaches(nodeId);
                    throw new DataIntegrityViolationException("Detected stale node entry: " + nodeVersionKey + " (now " + nodeAspectQNameIdsByVersionKey.keySet() + ")");
                }
            }
            return new Pair((Object)nodeVersionKey, Collections.unmodifiableSet(nodeAspectQNames));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertiesCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<NodeVersionKey, Map<QName, Serializable>, Serializable> {
        private PropertiesCallbackDAO() {
        }

        @Override
        public Pair<NodeVersionKey, Map<QName, Serializable>> createValue(Map<QName, Serializable> value) {
            throw new UnsupportedOperationException("A node always has a 'map' of properties.");
        }

        @Override
        public Pair<NodeVersionKey, Map<QName, Serializable>> findByKey(NodeVersionKey nodeVersionKey) {
            Long nodeId = nodeVersionKey.getNodeId();
            Map<NodeVersionKey, Map<NodePropertyKey, NodePropertyValue>> propsRawByNodeVersionKey = AbstractNodeDAOImpl.this.selectNodeProperties(nodeId);
            Map<NodePropertyKey, NodePropertyValue> propsRaw = propsRawByNodeVersionKey.get(nodeVersionKey);
            if (propsRaw == null) {
                if (propsRawByNodeVersionKey.size() == 0) {
                    propsRaw = Collections.emptyMap();
                } else {
                    AbstractNodeDAOImpl.this.invalidateNodeCaches(nodeId);
                    throw new DataIntegrityViolationException("Detected stale node entry: " + nodeVersionKey + " (now " + propsRawByNodeVersionKey.keySet() + ")");
                }
            }
            Map<QName, Serializable> props = AbstractNodeDAOImpl.this.nodePropertyHelper.convertToPublicProperties(propsRaw);
            return new Pair((Object)nodeVersionKey, Collections.unmodifiableMap(props));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodesCacheCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<Long, Node, NodeRef> {
        private NodesCacheCallbackDAO() {
        }

        @Override
        public Pair<Long, Node> createValue(Node value) {
            throw new UnsupportedOperationException("Node creation is done externally: " + value);
        }

        @Override
        public Pair<Long, Node> findByKey(Long nodeId) {
            NodeEntity node = AbstractNodeDAOImpl.this.selectNodeById(nodeId, null);
            if (node != null) {
                node.lock();
                return new Pair((Object)nodeId, (Object)node);
            }
            return null;
        }

        @Override
        public NodeRef getValueKey(Node value) {
            return value.getNodeRef();
        }

        @Override
        public Pair<Long, Node> findByValue(Node node) {
            NodeRef nodeRef = node.getNodeRef();
            if ((node = AbstractNodeDAOImpl.this.selectNodeByNodeRef(nodeRef, null)) != null) {
                node.lock();
                return new Pair((Object)node.getId(), (Object)node);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RootNodesCacheCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<StoreRef, Node, Serializable> {
        private RootNodesCacheCallbackDAO() {
        }

        @Override
        public Pair<StoreRef, Node> createValue(Node value) {
            throw new UnsupportedOperationException("Root node creation is done externally: " + value);
        }

        @Override
        public Pair<StoreRef, Node> findByKey(StoreRef storeRef) {
            NodeEntity node = AbstractNodeDAOImpl.this.selectStoreRootNode(storeRef);
            return node == null ? null : new Pair((Object)storeRef, (Object)node);
        }
    }

    private class UpdateTransactionListener
    extends TransactionListenerAdapter {
        private UpdateTransactionListener() {
        }

        public void beforeCommit(boolean readOnly) {
            if (readOnly) {
                return;
            }
            TransactionEntity txn = (TransactionEntity)AlfrescoTransactionSupport.getResource(AbstractNodeDAOImpl.KEY_TRANSACTION);
            Long txnId = txn.getId();
            Long now = System.currentTimeMillis();
            AbstractNodeDAOImpl.this.updateTransaction(txnId, now);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ServerIdCallback
    extends ReadWriteLockExecuter<Long> {
        private TransactionAwareSingleton<Long> serverIdStorage = new TransactionAwareSingleton();

        private ServerIdCallback() {
        }

        public Long getWithReadLock() throws Throwable {
            return this.serverIdStorage.get();
        }

        public Long getWithWriteLock() throws Throwable {
            if (this.serverIdStorage.get() != null) {
                return this.serverIdStorage.get();
            }
            if (AlfrescoTransactionSupport.getTransactionReadState() == AlfrescoTransactionSupport.TxnReadState.TXN_READ_ONLY) {
                return null;
            }
            String ipAddress = null;
            try {
                ipAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new AlfrescoRuntimeException("Failed to get server IP address", (Throwable)e);
            }
            ServerEntity serverEntity = AbstractNodeDAOImpl.this.selectServer(ipAddress);
            if (serverEntity != null) {
                this.serverIdStorage.put(serverEntity.getId());
                return serverEntity.getId();
            }
            Long serverId = AbstractNodeDAOImpl.this.insertServer(ipAddress);
            this.serverIdStorage.put(serverId);
            if (AbstractNodeDAOImpl.this.isDebugEnabled) {
                AbstractNodeDAOImpl.this.logger.debug((Object)("Created server entity: " + serverEntity));
            }
            return serverId;
        }
    }
}

