/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditablePropertiesEntity {
    private static Set<QName> auditablePropertyQNames = new HashSet<QName>(13);
    private boolean locked = false;
    private String auditCreator;
    private String auditCreated;
    private String auditModifier;
    private String auditModified;
    private String auditAccessed;
    private long auditModifiedTime = -1L;

    public static Set<QName> getAuditablePropertyQNames() {
        return auditablePropertyQNames;
    }

    public static boolean hasAuditableProperty(Set<QName> qnames) {
        for (QName qname : qnames) {
            if (!auditablePropertyQNames.contains(qname)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAuditableProperty(QName qname) {
        return auditablePropertyQNames.contains(qname);
    }

    public static boolean hasAuditableAspect(QName typeQName, DictionaryService dictionaryService) {
        TypeDefinition typeDef = dictionaryService.getType(typeQName);
        if (typeDef == null) {
            return false;
        }
        return typeDef.getDefaultAspectNames().contains(ContentModel.ASPECT_AUDITABLE);
    }

    public AuditablePropertiesEntity() {
    }

    public AuditablePropertiesEntity(AuditablePropertiesEntity that) {
        this.auditCreator = that.auditCreator;
        this.auditCreated = that.auditCreated;
        this.auditModifier = that.auditModifier;
        this.auditModified = that.auditModified;
        this.auditAccessed = that.auditAccessed;
        this.auditModifiedTime = that.auditModifiedTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("AuditablePropertiesEntity").append("[ auditCreator=").append(this.auditCreator).append(", auditCreated=").append(this.auditCreated).append(", auditModifier=").append(this.auditModifier).append(", auditModified=").append(this.auditModified).append("]");
        return sb.toString();
    }

    public synchronized void lock() {
        this.locked = true;
    }

    private final synchronized void checkLock() {
        if (this.locked) {
            throw new IllegalStateException("The entity is locked against updates: " + this);
        }
    }

    public Serializable getAuditableProperty(QName qname) {
        if (qname.equals((Object)ContentModel.PROP_CREATOR)) {
            return this.auditCreator;
        }
        if (qname.equals((Object)ContentModel.PROP_CREATED)) {
            return (Serializable)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.auditCreated);
        }
        if (qname.equals((Object)ContentModel.PROP_MODIFIER)) {
            return this.auditModifier == null ? this.auditCreator : this.auditModifier;
        }
        if (qname.equals((Object)ContentModel.PROP_MODIFIED)) {
            String dateStr = this.auditModified == null ? this.auditCreated : this.auditModified;
            return (Serializable)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)dateStr);
        }
        if (qname.equals((Object)ContentModel.PROP_ACCESSED)) {
            return (Serializable)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.auditAccessed);
        }
        return null;
    }

    public Map<QName, Serializable> getAuditableProperties() {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(7);
        properties.put(ContentModel.PROP_CREATOR, (Serializable)((Object)this.auditCreator));
        properties.put(ContentModel.PROP_CREATED, (Serializable)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.auditCreated));
        if (this.auditModifier != null) {
            properties.put(ContentModel.PROP_MODIFIER, (Serializable)((Object)this.auditModifier));
        } else {
            properties.put(ContentModel.PROP_MODIFIER, (Serializable)((Object)this.auditCreator));
        }
        if (this.auditModified != null) {
            properties.put(ContentModel.PROP_MODIFIED, (Serializable)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.auditModified));
        } else {
            properties.put(ContentModel.PROP_MODIFIED, (Serializable)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.auditCreated));
        }
        if (this.auditAccessed != null) {
            properties.put(ContentModel.PROP_ACCESSED, (Serializable)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.auditAccessed));
        }
        return properties;
    }

    public boolean setAuditValues(String user, Date date, boolean force, long modifiedDateToleranceMs) {
        long lastModTime;
        this.checkLock();
        if (user == null && (user = AuthenticationUtil.getFullyAuthenticatedUser()) == null) {
            user = "unknown";
        }
        if (date == null) {
            date = new Date();
        }
        String dateStr = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date);
        long dateTime = date.getTime();
        boolean changed = false;
        if (force || this.auditCreator == null) {
            this.auditCreator = user;
            changed = true;
        }
        if (force || this.auditCreated == null) {
            this.auditCreated = dateStr;
            changed = true;
        }
        if (this.auditModifier == null || !this.auditModifier.equals(user)) {
            this.auditModifier = user;
            changed = true;
        }
        if ((lastModTime = this.getAuditModifiedTime()) < 0L || lastModTime + modifiedDateToleranceMs < dateTime) {
            this.auditModifiedTime = dateTime;
            this.auditModified = dateStr;
            changed = true;
        }
        return changed;
    }

    public boolean setAuditValues(String user, Date date, Map<QName, Serializable> properties) {
        String auditAccessedNew;
        Date auditModifiedNew;
        String auditCreatedNew;
        String auditModifierNew;
        String auditCreatorNew;
        this.checkLock();
        boolean changed = false;
        if (properties.containsKey(ContentModel.PROP_CREATOR) && !EqualsHelper.nullSafeEquals((Object)this.auditCreator, (Object)(auditCreatorNew = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_CREATOR))))) {
            this.auditCreator = auditCreatorNew;
            changed = true;
        }
        if (properties.containsKey(ContentModel.PROP_MODIFIER) && !EqualsHelper.nullSafeEquals((Object)this.auditModifier, (Object)(auditModifierNew = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_MODIFIER))))) {
            this.auditModifier = auditModifierNew;
            changed = true;
        }
        if (properties.containsKey(ContentModel.PROP_CREATED) && !EqualsHelper.nullSafeEquals((Object)this.auditCreated, (Object)(auditCreatedNew = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_CREATED))))) {
            this.auditCreated = auditCreatedNew;
            changed = true;
        }
        if (properties.containsKey(ContentModel.PROP_MODIFIED) && !EqualsHelper.nullSafeEquals((Object)this.auditModified, (Object)(auditModifiedNew = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)properties.get(ContentModel.PROP_MODIFIED))))) {
            this.auditModifiedTime = auditModifiedNew.getTime();
            this.auditModified = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)auditModifiedNew);
            changed = true;
        }
        if (properties.containsKey(ContentModel.PROP_ACCESSED) && !EqualsHelper.nullSafeEquals((Object)this.auditAccessed, (Object)(auditAccessedNew = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_ACCESSED))))) {
            this.auditAccessed = auditAccessedNew;
            changed = true;
        }
        if (changed && (this.auditCreator == null || this.auditModifier == null || this.auditCreated == null || this.auditModified == null)) {
            if (user == null && (user = AuthenticationUtil.getFullyAuthenticatedUser()) == null) {
                user = "unknown";
            }
            if (date == null) {
                date = new Date();
            }
            String dateStr = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date);
            long dateTime = date.getTime();
            if (this.auditCreator == null) {
                this.auditCreator = user;
            }
            if (this.auditModifier == null) {
                this.auditModifier = user;
            }
            if (this.auditCreated == null) {
                this.auditCreated = dateStr;
            }
            if (this.auditModified == null) {
                this.auditModifiedTime = dateTime;
                this.auditModified = dateStr;
            }
        }
        return changed;
    }

    public String getAuditCreator() {
        return this.auditCreator;
    }

    public void setAuditCreator(String auditCreator) {
        this.checkLock();
        this.auditCreator = auditCreator;
    }

    public String getAuditCreated() {
        return this.auditCreated;
    }

    public void setAuditCreated(String auditCreated) {
        this.checkLock();
        this.auditCreated = auditCreated;
    }

    public String getAuditModifier() {
        return this.auditModifier;
    }

    public void setAuditModifier(String auditModifier) {
        this.checkLock();
        this.auditModifier = auditModifier;
    }

    public String getAuditModified() {
        return this.auditModified;
    }

    private long getAuditModifiedTime() {
        if (this.auditModifiedTime < 0L && this.auditModified != null) {
            this.auditModifiedTime = ((Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.auditModified)).getTime();
        }
        return this.auditModifiedTime;
    }

    public void setAuditModified(String auditModified) {
        this.checkLock();
        this.auditModified = auditModified;
    }

    public boolean setAuditModified(Date date, long modifiedDateToleranceMs) {
        this.checkLock();
        long dateTime = date.getTime();
        long lastModTime = this.getAuditModifiedTime();
        boolean changed = false;
        if (lastModTime < 0L || lastModTime + modifiedDateToleranceMs < dateTime) {
            this.auditModifiedTime = dateTime;
            this.auditModified = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date);
            changed = true;
        }
        return changed;
    }

    public String getAuditAccessed() {
        return this.auditAccessed;
    }

    public void setAuditAccessed(String auditAccessed) {
        this.checkLock();
        this.auditAccessed = auditAccessed;
    }

    static {
        auditablePropertyQNames.add(ContentModel.PROP_CREATOR);
        auditablePropertyQNames.add(ContentModel.PROP_CREATED);
        auditablePropertyQNames.add(ContentModel.PROP_MODIFIER);
        auditablePropertyQNames.add(ContentModel.PROP_MODIFIED);
        auditablePropertyQNames.add(ContentModel.PROP_ACCESSED);
    }
}

