/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.locale.LocaleDAO;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizedPropertiesEntity {
    private static final Set<QName> LOCALIZED_PROP_QNAMES = new HashSet<QName>(8);

    public static boolean isLocalizedProperty(QName qname) {
        return LOCALIZED_PROP_QNAMES.contains(qname);
    }

    public static void removeLocalizedProperties(Node node, Map<QName, Serializable> properties) {
        properties.keySet().removeAll(LOCALIZED_PROP_QNAMES);
    }

    public static void removeLocalizedProperties(Set<QName> propertyQNames) {
        propertyQNames.removeAll(LOCALIZED_PROP_QNAMES);
    }

    public static void addLocalizedProperties(LocaleDAO localeDAO, Node node, Map<QName, Serializable> properties) {
        Long localeId = node.getLocaleId();
        Locale locale = (Locale)localeDAO.getLocalePair(localeId).getSecond();
        properties.put(ContentModel.PROP_LOCALE, locale);
    }

    public static Serializable getLocalizedProperty(LocaleDAO localeDAO, Node node, QName qname) {
        if (qname.equals((Object)ContentModel.PROP_LOCALE)) {
            Long localeId = node.getLocaleId();
            return (Serializable)localeDAO.getLocalePair(localeId).getSecond();
        }
        throw new IllegalArgumentException("Not sys:localized property: " + qname);
    }

    static {
        LOCALIZED_PROP_QNAMES.add(ContentModel.PROP_LOCALE);
    }
}

