/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.node;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.crypto.SealedObject;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.node.ContentDataId;
import org.alfresco.repo.domain.node.ContentDataWithId;
import org.alfresco.repo.domain.schema.SchemaBootstrap;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.VersionNumber;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodePropertyValue
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -497902497351493075L;
    private static final String STRING_EMPTY = "";
    public static final Serializable EMPTY_COLLECTION_VALUE = (Serializable)((Object)Collections.emptyList());
    private static Log logger = LogFactory.getLog(NodePropertyValue.class);
    private static Log loggerOracle = LogFactory.getLog((String)(NodePropertyValue.class.getName() + ".oracle"));
    private static Map<QName, ValueType> valueTypesByPropertyType = new HashMap<QName, ValueType>(37);
    private static Map<Integer, ValueType> valueTypesByOrdinalNumber;
    private ValueType actualType;
    private ValueType persistedType;
    private Boolean booleanValue;
    private Long longValue;
    private Float floatValue;
    private Double doubleValue;
    private String stringValue;
    private Serializable serializableValue;

    private static ValueType getActualType(Serializable value) {
        if (value == null) {
            return ValueType.NULL;
        }
        if (value instanceof Boolean) {
            return ValueType.BOOLEAN;
        }
        if (value instanceof Integer) {
            return ValueType.INTEGER;
        }
        if (value instanceof Long) {
            return ValueType.LONG;
        }
        if (value instanceof Float) {
            return ValueType.FLOAT;
        }
        if (value instanceof Double) {
            return ValueType.DOUBLE;
        }
        if (value instanceof String) {
            return ValueType.STRING;
        }
        if (value instanceof Date) {
            return ValueType.DATE;
        }
        if (value instanceof NodeRef) {
            return ValueType.NODEREF;
        }
        if (value instanceof ChildAssociationRef) {
            return ValueType.CHILD_ASSOC_REF;
        }
        if (value instanceof AssociationRef) {
            return ValueType.ASSOC_REF;
        }
        if (value instanceof QName) {
            return ValueType.QNAME;
        }
        if (value instanceof Path) {
            return ValueType.PATH;
        }
        if (value instanceof Locale) {
            return ValueType.LOCALE;
        }
        if (value instanceof VersionNumber) {
            return ValueType.VERSION_NUMBER;
        }
        if (value instanceof Period) {
            return ValueType.PERIOD;
        }
        if (value instanceof ContentDataId) {
            return ValueType.CONTENT_DATA_ID;
        }
        if (value instanceof ContentDataWithId) {
            return ValueType.CONTENT_DATA_ID;
        }
        if (value instanceof ContentData) {
            return ValueType.CONTENT;
        }
        if (value instanceof SealedObject) {
            return ValueType.SEALED_OBJECT;
        }
        return ValueType.SERIALIZABLE;
    }

    private static ValueType makeValueType(QName typeQName) {
        ValueType valueType = valueTypesByPropertyType.get(typeQName);
        if (valueType == null) {
            throw new AlfrescoRuntimeException("Property type not recognised: \n   type: " + typeQName);
        }
        return valueType;
    }

    public static int convertToTypeOrdinal(QName typeQName) {
        ValueType valueType = NodePropertyValue.makeValueType(typeQName);
        return valueType.getOrdinalNumber();
    }

    public NodePropertyValue() {
    }

    public NodePropertyValue(QName typeQName, Serializable value) {
        ParameterCheck.mandatory((String)"typeQName", (Object)typeQName);
        if (value == null) {
            this.actualType = NodePropertyValue.getActualType(value);
            this.setPersistedValue(ValueType.NULL, null);
        } else {
            ValueType valueType = NodePropertyValue.makeValueType(typeQName);
            value = valueType.convert(value);
            this.actualType = NodePropertyValue.getActualType(value);
            ValueType persistedValueType = this.actualType.getPersistedType(value);
            value = persistedValueType.convert(value);
            this.setPersistedValue(persistedValueType, value);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof NodePropertyValue) {
            NodePropertyValue that = (NodePropertyValue)obj;
            return this.actualType.equals((Object)that.actualType) && EqualsHelper.nullSafeEquals((Object)this.getPersistedValue(), (Object)that.getPersistedValue());
        }
        return false;
    }

    public int hashCode() {
        Serializable persistedValue;
        int h = 0;
        if (this.actualType != null) {
            h = this.actualType.hashCode();
        }
        if ((persistedValue = this.getPersistedValue()) != null) {
            h += 17 * persistedValue.hashCode();
        }
        return h;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("PropertyValue").append("[actual-type=").append((Object)this.actualType).append(", value-type=").append((Object)this.persistedType).append(", value=").append(this.getPersistedValue()).append("]");
        return sb.toString();
    }

    public Integer getActualType() {
        return this.actualType == null ? null : this.actualType.getOrdinalNumber();
    }

    public String getActualTypeString() {
        return this.actualType == null ? null : this.actualType.toString();
    }

    public void setActualType(Integer actualType) {
        ValueType type = valueTypesByOrdinalNumber.get(actualType);
        if (type == null) {
            logger.error((Object)("Unknown property actual type ordinal number: " + actualType));
        }
        this.actualType = type;
    }

    public Integer getPersistedType() {
        return this.persistedType == null ? null : this.persistedType.getOrdinalNumber();
    }

    public void setPersistedType(Integer persistedType) {
        ValueType type = valueTypesByOrdinalNumber.get(persistedType);
        if (type == null) {
            logger.error((Object)("Unknown property persisted type ordinal number: " + persistedType));
        }
        this.persistedType = type;
    }

    public void setPersistedValue(ValueType persistedType, Serializable value) {
        switch (persistedType) {
            case NULL: {
                if (value == null) break;
                throw new AlfrescoRuntimeException("Value must be null for persisted type: " + (Object)((Object)persistedType));
            }
            case BOOLEAN: {
                this.booleanValue = (Boolean)value;
                break;
            }
            case LONG: {
                this.longValue = (Long)value;
                break;
            }
            case FLOAT: {
                this.floatValue = (Float)value;
                break;
            }
            case DOUBLE: {
                this.doubleValue = (Double)value;
                break;
            }
            case STRING: {
                this.stringValue = (String)((Object)value);
                break;
            }
            case SERIALIZABLE: {
                this.serializableValue = this.cloneSerializable(value);
                break;
            }
            default: {
                throw new AlfrescoRuntimeException("Unrecognised value type: " + (Object)((Object)persistedType));
            }
        }
        this.persistedType = persistedType;
    }

    private Serializable cloneSerializable(Serializable original) {
        ObjectOutputStream objectOut = null;
        ByteArrayOutputStream byteOut = null;
        ObjectInputStream objectIn = null;
        try {
            byteOut = new ByteArrayOutputStream();
            objectOut = new ObjectOutputStream(byteOut);
            objectOut.writeObject(original);
            objectOut.flush();
            objectIn = new ObjectInputStream(new ByteArrayInputStream(byteOut.toByteArray()));
            Object target = objectIn.readObject();
            Serializable serializable = (Serializable)target;
            return serializable;
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Failed to clone serializable object: " + original, e);
        }
        finally {
            if (objectOut != null) {
                try {
                    objectOut.close();
                }
                catch (Throwable e) {}
            }
            if (byteOut != null) {
                try {
                    byteOut.close();
                }
                catch (Throwable e) {}
            }
            if (objectIn != null) {
                try {
                    objectIn.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    private Serializable getPersistedValue() {
        switch (this.persistedType) {
            case NULL: {
                return null;
            }
            case BOOLEAN: {
                return this.booleanValue;
            }
            case LONG: {
                return this.longValue;
            }
            case FLOAT: {
                return this.floatValue;
            }
            case DOUBLE: {
                return this.doubleValue;
            }
            case STRING: {
                if (this.stringValue == null) {
                    if (loggerOracle.isDebugEnabled()) {
                        logger.debug((Object)"string_value is 'null'.  Forcing to empty String");
                    }
                    return STRING_EMPTY;
                }
                return this.stringValue;
            }
            case SERIALIZABLE: {
                return this.serializableValue;
            }
        }
        throw new AlfrescoRuntimeException("Unrecognised value type: " + (Object)((Object)this.persistedType));
    }

    public Serializable getValue(QName typeQName) {
        Serializable persistedValue;
        ValueType requiredType = NodePropertyValue.makeValueType(typeQName);
        if (requiredType == ValueType.SERIALIZABLE) {
            requiredType = this.actualType;
        }
        Serializable ret = null;
        ret = this.actualType == ValueType.COLLECTION && this.persistedType == ValueType.NULL ? (Serializable)((Object)Collections.emptyList()) : (this.persistedType == ValueType.NULL ? null : ((persistedValue = this.getPersistedValue()) instanceof Collection ? persistedValue : (persistedValue instanceof SealedObject ? persistedValue : requiredType.convert(persistedValue))));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Fetched value: \n   property value: " + this + "\n" + "   requested type: " + (Object)((Object)requiredType) + "\n" + "   result: " + ret));
        }
        return ret;
    }

    public Collection<Serializable> getCollection(QName typeQName) {
        Serializable value = this.getValue(typeQName);
        if (value instanceof Collection) {
            return (Collection)((Object)value);
        }
        return Collections.singletonList(value);
    }

    public boolean getBooleanValue() {
        if (this.booleanValue == null) {
            return false;
        }
        return this.booleanValue;
    }

    public void setBooleanValue(boolean value) {
        this.booleanValue = value;
    }

    public long getLongValue() {
        if (this.longValue == null) {
            return 0L;
        }
        return this.longValue;
    }

    public void setLongValue(long value) {
        this.longValue = value;
    }

    public float getFloatValue() {
        if (this.floatValue == null) {
            return 0.0f;
        }
        return this.floatValue.floatValue();
    }

    public void setFloatValue(float value) {
        this.floatValue = Float.valueOf(value);
    }

    public double getDoubleValue() {
        if (this.doubleValue == null) {
            return 0.0;
        }
        return this.doubleValue;
    }

    public void setDoubleValue(double value) {
        this.doubleValue = value;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String value) {
        this.stringValue = value;
    }

    public Serializable getSerializableValue() {
        return this.serializableValue;
    }

    public void setSerializableValue(Serializable value) {
        this.serializableValue = value;
    }

    static {
        valueTypesByPropertyType.put(DataTypeDefinition.ANY, ValueType.SERIALIZABLE);
        valueTypesByPropertyType.put(DataTypeDefinition.ENCRYPTED, ValueType.SEALED_OBJECT);
        valueTypesByPropertyType.put(DataTypeDefinition.BOOLEAN, ValueType.BOOLEAN);
        valueTypesByPropertyType.put(DataTypeDefinition.INT, ValueType.INTEGER);
        valueTypesByPropertyType.put(DataTypeDefinition.LONG, ValueType.LONG);
        valueTypesByPropertyType.put(DataTypeDefinition.DOUBLE, ValueType.DOUBLE);
        valueTypesByPropertyType.put(DataTypeDefinition.FLOAT, ValueType.FLOAT);
        valueTypesByPropertyType.put(DataTypeDefinition.DATE, ValueType.DATE);
        valueTypesByPropertyType.put(DataTypeDefinition.DATETIME, ValueType.DATE);
        valueTypesByPropertyType.put(DataTypeDefinition.CATEGORY, ValueType.NODEREF);
        valueTypesByPropertyType.put(DataTypeDefinition.CONTENT, ValueType.CONTENT_DATA_ID);
        valueTypesByPropertyType.put(DataTypeDefinition.TEXT, ValueType.STRING);
        valueTypesByPropertyType.put(DataTypeDefinition.MLTEXT, ValueType.MLTEXT);
        valueTypesByPropertyType.put(DataTypeDefinition.NODE_REF, ValueType.NODEREF);
        valueTypesByPropertyType.put(DataTypeDefinition.CHILD_ASSOC_REF, ValueType.CHILD_ASSOC_REF);
        valueTypesByPropertyType.put(DataTypeDefinition.ASSOC_REF, ValueType.ASSOC_REF);
        valueTypesByPropertyType.put(DataTypeDefinition.PATH, ValueType.PATH);
        valueTypesByPropertyType.put(DataTypeDefinition.QNAME, ValueType.QNAME);
        valueTypesByPropertyType.put(DataTypeDefinition.LOCALE, ValueType.LOCALE);
        valueTypesByPropertyType.put(DataTypeDefinition.PERIOD, ValueType.PERIOD);
        valueTypesByOrdinalNumber = new HashMap<Integer, ValueType>(37);
        for (ValueType valueType : ValueType.values()) {
            Integer ordinalNumber = valueType.getOrdinalNumber();
            if (valueTypesByOrdinalNumber.containsKey(ordinalNumber)) {
                throw new RuntimeException("ValueType has duplicate ordinal number: " + (Object)((Object)valueType));
            }
            if (ordinalNumber == -1) {
                throw new RuntimeException("ValueType doesn't have an ordinal number: " + (Object)((Object)valueType));
            }
            valueTypesByOrdinalNumber.put(ordinalNumber, valueType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ValueType {
        NULL{

            public Integer getOrdinalNumber() {
                return 0;
            }

            Serializable convert(Serializable value) {
                return null;
            }
        }
        ,
        BOOLEAN{

            public Integer getOrdinalNumber() {
                return 1;
            }

            Serializable convert(Serializable value) {
                return (Serializable)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)value);
            }
        }
        ,
        INTEGER{

            public Integer getOrdinalNumber() {
                return 2;
            }

            protected ValueType getPersistedType(Serializable value) {
                return LONG;
            }

            Serializable convert(Serializable value) {
                return (Serializable)DefaultTypeConverter.INSTANCE.convert(Integer.class, (Object)value);
            }
        }
        ,
        LONG{

            public Integer getOrdinalNumber() {
                return 3;
            }

            Serializable convert(Serializable value) {
                if (value == null) {
                    return null;
                }
                if (value instanceof ContentDataId) {
                    return ((ContentDataId)value).getId();
                }
                if (value instanceof ContentDataWithId) {
                    return ((ContentDataWithId)((Object)value)).getId();
                }
                return (Serializable)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)value);
            }
        }
        ,
        FLOAT{

            public Integer getOrdinalNumber() {
                return 4;
            }

            Serializable convert(Serializable value) {
                return (Serializable)DefaultTypeConverter.INSTANCE.convert(Float.class, (Object)value);
            }
        }
        ,
        DOUBLE{

            public Integer getOrdinalNumber() {
                return 5;
            }

            Serializable convert(Serializable value) {
                return (Serializable)DefaultTypeConverter.INSTANCE.convert(Double.class, (Object)value);
            }
        }
        ,
        STRING{

            public Integer getOrdinalNumber() {
                return 6;
            }

            protected ValueType getPersistedType(Serializable value) {
                String valueStr;
                if (value instanceof String && (valueStr = (String)((Object)value)).length() > SchemaBootstrap.getMaxStringLength()) {
                    return SERIALIZABLE;
                }
                return STRING;
            }

            Serializable convert(Serializable value) {
                return (Serializable)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
            }
        }
        ,
        DATE{

            public Integer getOrdinalNumber() {
                return 7;
            }

            protected ValueType getPersistedType(Serializable value) {
                return STRING;
            }

            Serializable convert(Serializable value) {
                return (Serializable)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)value);
            }
        }
        ,
        SERIALIZABLE{

            public Integer getOrdinalNumber() {
                return 9;
            }

            Serializable convert(Serializable value) {
                return value;
            }
        }
        ,
        MLTEXT{

            public Integer getOrdinalNumber() {
                return 10;
            }

            protected ValueType getPersistedType(Serializable value) {
                if (value instanceof MLText) {
                    throw new IllegalArgumentException("MLText must be split up before persistence.");
                }
                return STRING;
            }

            Serializable convert(Serializable value) {
                return (Serializable)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
            }
        }
        ,
        CONTENT{

            public Integer getOrdinalNumber() {
                return 11;
            }

            protected ValueType getPersistedType(Serializable value) {
                if (value instanceof ContentData) {
                    return SERIALIZABLE;
                }
                throw new RuntimeException("ContentData persistence must be by ContentDataId.");
            }

            Serializable convert(Serializable value) {
                if (value instanceof Long) {
                    return value;
                }
                if (value instanceof String) {
                    logger.warn((Object)("Content URL converter has not run to completion: " + value));
                    return (Serializable)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)value);
                }
                return (Serializable)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)value);
            }
        }
        ,
        NODEREF{

            public Integer getOrdinalNumber() {
                return 12;
            }

            protected ValueType getPersistedType(Serializable value) {
                return STRING;
            }

            Serializable convert(Serializable value) {
                return (Serializable)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)value);
            }
        }
        ,
        CHILD_ASSOC_REF{

            public Integer getOrdinalNumber() {
                return 13;
            }

            protected ValueType getPersistedType(Serializable value) {
                return STRING;
            }

            Serializable convert(Serializable value) {
                return (Serializable)DefaultTypeConverter.INSTANCE.convert(ChildAssociationRef.class, (Object)value);
            }
        }
        ,
        ASSOC_REF{

            public Integer getOrdinalNumber() {
                return 14;
            }

            protected ValueType getPersistedType(Serializable value) {
                return STRING;
            }

            Serializable convert(Serializable value) {
                return (Serializable)DefaultTypeConverter.INSTANCE.convert(AssociationRef.class, (Object)value);
            }
        }
        ,
        QNAME{

            public Integer getOrdinalNumber() {
                return 15;
            }

            protected ValueType getPersistedType(Serializable value) {
                return STRING;
            }

            Serializable convert(Serializable value) {
                return (Serializable)DefaultTypeConverter.INSTANCE.convert(QName.class, (Object)value);
            }
        }
        ,
        PATH{

            public Integer getOrdinalNumber() {
                return 16;
            }

            protected ValueType getPersistedType(Serializable value) {
                return SERIALIZABLE;
            }

            Serializable convert(Serializable value) {
                return (Serializable)DefaultTypeConverter.INSTANCE.convert(Path.class, (Object)value);
            }
        }
        ,
        LOCALE{

            public Integer getOrdinalNumber() {
                return 17;
            }

            protected ValueType getPersistedType(Serializable value) {
                return STRING;
            }

            Serializable convert(Serializable value) {
                return (Serializable)DefaultTypeConverter.INSTANCE.convert(Locale.class, (Object)value);
            }
        }
        ,
        VERSION_NUMBER{

            public Integer getOrdinalNumber() {
                return 18;
            }

            protected ValueType getPersistedType(Serializable value) {
                return STRING;
            }

            Serializable convert(Serializable value) {
                return (Serializable)DefaultTypeConverter.INSTANCE.convert(VersionNumber.class, (Object)value);
            }
        }
        ,
        COLLECTION{

            public Integer getOrdinalNumber() {
                return 19;
            }

            Serializable convert(Serializable value) {
                if (value == null) {
                    return (Serializable)((Object)Collections.emptyList());
                }
                return value;
            }
        }
        ,
        PERIOD{

            public Integer getOrdinalNumber() {
                return 20;
            }

            protected ValueType getPersistedType(Serializable value) {
                return STRING;
            }

            Serializable convert(Serializable value) {
                return (Serializable)DefaultTypeConverter.INSTANCE.convert(Period.class, (Object)value);
            }
        }
        ,
        CONTENT_DATA_ID{

            public Integer getOrdinalNumber() {
                return 21;
            }

            protected ValueType getPersistedType(Serializable value) {
                return LONG;
            }

            Serializable convert(Serializable value) {
                if (value == null) {
                    return null;
                }
                if (value instanceof Long) {
                    return value;
                }
                if (value instanceof ContentDataId) {
                    return ((ContentDataId)value).getId();
                }
                return (Serializable)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)value);
            }
        }
        ,
        SEALED_OBJECT{

            public Integer getOrdinalNumber() {
                return 22;
            }

            protected ValueType getPersistedType(Serializable value) {
                return SERIALIZABLE;
            }

            Serializable convert(Serializable value) {
                if (value == null) {
                    return null;
                }
                if (value instanceof SealedObject) {
                    return value;
                }
                throw new IllegalArgumentException("Encrypted properties must be encrypted by the client.");
            }
        };


        public abstract Integer getOrdinalNumber();

        protected ValueType getPersistedType(Serializable value) {
            return this;
        }

        abstract Serializable convert(Serializable var1);
    }
}

