/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.patch;

import java.util.List;
import java.util.Map;
import org.alfresco.ibatis.BatchingDAO;
import org.alfresco.repo.domain.avm.AVMNodeEntity;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.service.cmr.repository.ContentData;
import org.apache.ibatis.session.ResultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPatchDAOImpl
implements PatchDAO,
BatchingDAO {
    private ContentDataDAO contentDataDAO;

    protected AbstractPatchDAOImpl() {
    }

    public void setContentDataDAO(ContentDataDAO contentDataDAO) {
        this.contentDataDAO = contentDataDAO;
    }

    @Override
    public long getAVMNodesCountWhereNewInStore() {
        return this.getAVMNodeEntitiesCountWhereNewInStore();
    }

    @Override
    public List<AVMNodeEntity> getEmptyGUIDS(int count) {
        return this.getAVMNodeEntitiesWithEmptyGUID(count);
    }

    @Override
    public List<AVMNodeEntity> getNullVersionLayeredDirectories(int count) {
        return this.getNullVersionLayeredDirectoryNodeEntities(count);
    }

    @Override
    public List<AVMNodeEntity> getNullVersionLayeredFiles(int count) {
        return this.getNullVersionLayeredFileNodeEntities(count);
    }

    @Override
    public int updateAVMNodesNullifyAcl(List<Long> nodeIds) {
        return this.updateAVMNodeEntitiesNullifyAcl(nodeIds);
    }

    @Override
    public int updateAVMNodesSetAcl(long aclId, List<Long> nodeIds) {
        return this.updateAVMNodeEntitiesSetAcl(aclId, nodeIds);
    }

    protected abstract long getAVMNodeEntitiesCountWhereNewInStore();

    protected abstract List<AVMNodeEntity> getAVMNodeEntitiesWithEmptyGUID(int var1);

    protected abstract List<AVMNodeEntity> getNullVersionLayeredDirectoryNodeEntities(int var1);

    protected abstract List<AVMNodeEntity> getNullVersionLayeredFileNodeEntities(int var1);

    protected abstract int updateAVMNodeEntitiesNullifyAcl(List<Long> var1);

    protected abstract int updateAVMNodeEntitiesSetAcl(long var1, List<Long> var3);

    @Override
    public long getMaxAclId() {
        return this.getMaxAclEntityId();
    }

    @Override
    public long getDmNodeCount() {
        return this.getDmNodeEntitiesCount();
    }

    @Override
    public long getDmNodeCountWithNewACLs(Long above) {
        return this.getDmNodeEntitiesCountWithNewACLs(above);
    }

    @Override
    public List<Long> selectAllAclIds() {
        return this.selectAllAclEntityIds();
    }

    @Override
    public List<Long> selectNonDanglingAclIds() {
        return this.selectNonDanglingAclEntityIds();
    }

    @Override
    public int deleteDanglingAces() {
        return this.deleteDanglingAceEntities();
    }

    @Override
    public int deleteAcls(List<Long> aclIds) {
        return this.deleteAclEntities(aclIds);
    }

    @Override
    public int deleteAclMembersForAcls(List<Long> aclIds) {
        return this.deleteAclMemberEntitiesForAcls(aclIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAdmV31ContentProperties(Long minNodeId, Long maxNodeId) {
        List<Map<String, Object>> props = this.getAdmOldContentProperties(minNodeId, maxNodeId);
        for (Map<String, Object> prop : props) {
            String stringValue = (String)prop.get("stringValue");
            ContentData contentData = ContentData.createContentProperty((String)stringValue);
            Long contentDataId = (Long)this.contentDataDAO.createContentData(contentData).getFirst();
            prop.put("contentDataId", contentDataId);
        }
        try {
            this.startBatch();
            for (Map<String, Object> prop : props) {
                Long nodeId = (Long)prop.get("nodeId");
                Long qnameId = (Long)prop.get("qnameId");
                Integer listIndex = (Integer)prop.get("listIndex");
                Long localeId = (Long)prop.get("localeId");
                Long contentDataId = (Long)prop.get("contentDataId");
                this.updateAdmOldContentProperty(nodeId, qnameId, listIndex, localeId, contentDataId);
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.executeBatch();
            throw throwable;
        }
        this.executeBatch();
    }

    protected abstract List<Map<String, Object>> getAdmOldContentProperties(Long var1, Long var2);

    protected abstract void updateAdmOldContentProperty(Long var1, Long var2, Integer var3, Long var4, Long var5);

    protected abstract long getMaxAclEntityId();

    protected abstract long getDmNodeEntitiesCount();

    protected abstract long getDmNodeEntitiesCountWithNewACLs(Long var1);

    protected abstract List<Long> selectAllAclEntityIds();

    protected abstract List<Long> selectNonDanglingAclEntityIds();

    protected abstract int deleteDanglingAceEntities();

    protected abstract int deleteAclEntities(List<Long> var1);

    protected abstract int deleteAclMemberEntitiesForAcls(List<Long> var1);

    @Override
    public void migrateOldAttrTenants(ResultHandler resultHandler) {
        this.getOldAttrTenantsImpl(resultHandler);
    }

    protected abstract void getOldAttrTenantsImpl(ResultHandler var1);

    @Override
    public void migrateOldAttrAVMLocks(ResultHandler resultHandler) {
        this.getOldAttrAVMLocksImpl(resultHandler);
    }

    protected abstract void getOldAttrAVMLocksImpl(ResultHandler var1);

    @Override
    public void migrateOldAttrPropertyBackedBeans(ResultHandler resultHandler) {
        this.getOldAttrPropertyBackedBeansImpl(resultHandler);
    }

    protected abstract void getOldAttrPropertyBackedBeansImpl(ResultHandler var1);

    @Override
    public void migrateOldAttrChainingURS(ResultHandler resultHandler) {
        this.getOldAttrChainingURSImpl(resultHandler);
    }

    protected abstract void getOldAttrChainingURSImpl(ResultHandler var1);

    @Override
    public List<String> getOldAttrCustomNames() {
        return this.getOldAttrCustomNamesImpl();
    }

    protected abstract List<String> getOldAttrCustomNamesImpl();
}

