/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.patch.ibatis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.ibatis.IdsEntity;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.CrcHelper;
import org.alfresco.repo.domain.avm.AVMNodeEntity;
import org.alfresco.repo.domain.locale.LocaleDAO;
import org.alfresco.repo.domain.patch.AbstractPatchDAOImpl;
import org.alfresco.repo.domain.patch.ibatis.IdListOfIdsParam;
import org.alfresco.repo.domain.patch.ibatis.SizeCurrentParams;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.mybatis.spring.SqlSessionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchDAOImpl
extends AbstractPatchDAOImpl {
    private static Log logger = LogFactory.getLog(PatchDAOImpl.class);
    private static final String SELECT_AVM_NODE_ENTITIES_COUNT_WHERE_NEW_IN_STORE = "alfresco.avm.select_AVMNodeEntitiesCountWhereNewInStore";
    private static final String SELECT_AVM_NODE_ENTITIES_WITH_EMPTY_GUID = "alfresco.avm.select_AVMNodesWithEmptyGUID";
    private static final String SELECT_AVM_LD_NODE_ENTITIES_NULL_VERSION = "alfresco.avm.select_AVMNodes_nullVersionLayeredDirectories";
    private static final String SELECT_AVM_LF_NODE_ENTITIES_NULL_VERSION = "alfresco.avm.select_AVMNodes_nullVersionLayeredFiles";
    private static final String SELECT_AVM_MAX_NODE_ID = "alfresco.patch.select_avmMaxNodeId";
    private static final String SELECT_ADM_MAX_NODE_ID = "alfresco.patch.select_admMaxNodeId";
    private static final String SELECT_AVM_NODES_WITH_OLD_CONTENT_PROPERTIES = "alfresco.patch.select_avmNodesWithOldContentProperties";
    private static final String SELECT_ADM_OLD_CONTENT_PROPERTIES = "alfresco.patch.select_admOldContentProperties";
    private static final String SELECT_AUTHORITIES_AND_CRC = "alfresco.patch.select_authoritiesAndCrc";
    private static final String SELECT_PERMISSIONS_ALL_ACL_IDS = "alfresco.patch.select_AllAclIds";
    private static final String SELECT_PERMISSIONS_USED_ACL_IDS = "alfresco.patch.select_UsedAclIds";
    private static final String SELECT_PERMISSIONS_MAX_ACL_ID = "alfresco.patch.select_MaxAclId";
    private static final String SELECT_PERMISSIONS_DM_NODE_COUNT = "alfresco.patch.select_DmNodeCount";
    private static final String SELECT_PERMISSIONS_DM_NODE_COUNT_WITH_NEW_ACLS = "alfresco.patch.select_DmNodeCountWherePermissionsHaveChanged";
    private static final String SELECT_CHILD_ASSOCS_COUNT = "alfresco.patch.select_allChildAssocsCount";
    private static final String SELECT_CHILD_ASSOCS_MAX_ID = "alfresco.patch.select_maxChildAssocId";
    private static final String SELECT_CHILD_ASSOCS_FOR_CRCS = "alfresco.patch.select_allChildAssocsForCrcs";
    private static final String SELECT_NODES_BY_TYPE_AND_NAME_PATTERN = "alfresco.patch.select_nodesByTypeAndNamePattern";
    private static final String UPDATE_ADM_OLD_CONTENT_PROPERTY = "alfresco.patch.update_admOldContentProperty";
    private static final String UPDATE_CONTENT_MIMETYPE_ID = "alfresco.patch.update_contentMimetypeId";
    private static final String UPDATE_AVM_NODE_LIST_NULLIFY_ACL = "alfresco.avm.update_AVMNodeList_nullifyAcl";
    private static final String UPDATE_AVM_NODE_LIST_SET_ACL = "alfresco.avm.update_AVMNodeList_setAcl";
    private static final String UPDATE_CHILD_ASSOC_CRC = "alfresco.patch.update_childAssocCrc";
    private static final String UPDATE_CREATE_SIZE_CURRENT_PROPERTY = "alfresco.patch.update_CreateSizeCurrentProperty";
    private static final String DELETE_PERMISSIONS_UNUSED_ACES = "alfresco.permissions.delete_UnusedAces";
    private static final String DELETE_PERMISSIONS_ACL_LIST = "alfresco.permissions.delete_AclList";
    private static final String DELETE_PERMISSIONS_ACL_MEMBERS_FOR_ACL_LIST = "alfresco.permissions.delete_AclMembersForAclList";
    private static final String SELECT_OLD_ATTR_TENANTS = "alfresco.patch.select_oldAttrTenants";
    private static final String SELECT_OLD_ATTR_AVM_LOCKS = "alfresco.patch.select_oldAttrAVMLocks";
    private static final String SELECT_OLD_ATTR_PBBS = "alfresco.patch.select_oldAttrPropertyBackedBeans";
    private static final String SELECT_OLD_ATTR_CHAINING_URS = "alfresco.patch.select_oldAttrChainingURS";
    private static final String SELECT_OLD_ATTR_CUSTOM_NAMES = "alfresco.patch.select_oldAttrCustomNames";
    private static final String DROP_OLD_ATTR_LIST = "alfresco.patch.drop_oldAttrAlfListAttributeEntries";
    private static final String DROP_OLD_ATTR_MAP = "alfresco.patch.drop_oldAttrAlfMapAttributeEntries";
    private static final String DROP_OLD_ATTR_GLOBAL = "alfresco.patch.drop_oldAttrAlfGlobalAttributes";
    private static final String DROP_OLD_ATTR = "alfresco.patch.drop_oldAttrAlfAttributes";
    private static final String DROP_OLD_ATTR_SEQ = "alfresco.patch.drop_oldAttrAlfAttributes_seq";
    private static final String SELECT_ACLS_THAT_INHERIT_FROM_NON_PRIMARY_PARENT = "alfresco.patch.select_aclsThatInheritFromNonPrimaryParent";
    private static final String SELECT_ACLS_THAT_INHERIT_WITH_INHERITANCE_UNSET = "alfresco.patch.select_aclsThatInheritWithInheritanceUnset";
    private static final String SELECT_DEFINING_ACLS_THAT_DO_NOT_INHERIT_CORRECTLY_FROM_THE_PRIMARY_PARENT = "alfresco.patch.select_definingAclsThatDoNotInheritCorrectlyFromThePrimaryParent";
    private static final String SELECT_SHARED_ACLS_THAT_DO_NOT_INHERIT_CORRECTLY_FROM_THE_PRIMARY_PARENT = "alfresco.patch.select_sharedAclsThatDoNotInheritCorrectlyFromThePrimaryParent";
    private static final String SELECT_SHARED_ACLS_THAT_DO_NOT_INHERIT_CORRECTLY_FROM_THEIR_DEFINING_ACL = "alfresco.patch.select_sharedAclsThatDoNotInheritCorrectlyFromTheirDefiningAcl";
    private static final String SELECT_COUNT_NODES_WITH_ASPECTS = "alfresco.patch.select_CountNodesWithAspectIds";
    private LocaleDAO localeDAO;
    protected SqlSessionTemplate template;
    private QNameDAO qnameDAO;

    public final void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.template = sqlSessionTemplate;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setLocaleDAO(LocaleDAO localeDAO) {
        this.localeDAO = localeDAO;
    }

    public void startBatch() {
    }

    public void executeBatch() {
    }

    @Override
    protected long getAVMNodeEntitiesCountWhereNewInStore() {
        Long count = (Long)this.template.selectOne(SELECT_AVM_NODE_ENTITIES_COUNT_WHERE_NEW_IN_STORE);
        return count == null ? 0L : count;
    }

    @Override
    protected List<AVMNodeEntity> getAVMNodeEntitiesWithEmptyGUID(int maxResults) {
        if (maxResults < 0) {
            maxResults = Integer.MAX_VALUE;
        }
        return this.template.selectList(SELECT_AVM_NODE_ENTITIES_WITH_EMPTY_GUID, (Object)new RowBounds(0, maxResults));
    }

    @Override
    protected List<AVMNodeEntity> getNullVersionLayeredDirectoryNodeEntities(int maxResults) {
        if (maxResults < 0) {
            maxResults = Integer.MAX_VALUE;
        }
        return this.template.selectList(SELECT_AVM_LD_NODE_ENTITIES_NULL_VERSION, (Object)new RowBounds(0, maxResults));
    }

    @Override
    protected List<AVMNodeEntity> getNullVersionLayeredFileNodeEntities(int maxResults) {
        if (maxResults < 0) {
            maxResults = Integer.MAX_VALUE;
        }
        return this.template.selectList(SELECT_AVM_LF_NODE_ENTITIES_NULL_VERSION, (Object)new RowBounds(0, maxResults));
    }

    @Override
    public long getMaxAvmNodeID() {
        Long count = (Long)this.template.selectOne(SELECT_AVM_MAX_NODE_ID);
        return count == null ? 0L : count;
    }

    @Override
    public List<Long> getAvmNodesWithOldContentProperties(Long minNodeId, Long maxNodeId) {
        IdsEntity ids = new IdsEntity();
        ids.setIdOne(minNodeId);
        ids.setIdTwo(maxNodeId);
        return this.template.selectList(SELECT_AVM_NODES_WITH_OLD_CONTENT_PROPERTIES, (Object)ids);
    }

    @Override
    public long getMaxAdmNodeID() {
        Long count = (Long)this.template.selectOne(SELECT_ADM_MAX_NODE_ID);
        return count == null ? 0L : count;
    }

    @Override
    protected List<Map<String, Object>> getAdmOldContentProperties(Long minNodeId, Long maxNodeId) {
        IdsEntity ids = new IdsEntity();
        ids.setIdOne(minNodeId);
        ids.setIdTwo(maxNodeId);
        return this.template.selectList(SELECT_ADM_OLD_CONTENT_PROPERTIES, (Object)ids);
    }

    @Override
    protected void updateAdmOldContentProperty(Long nodeId, Long qnameId, Integer listIndex, Long localeId, Long longValue) {
        HashMap<String, Number> params = new HashMap<String, Number>(11);
        params.put("nodeId", nodeId);
        params.put("qnameId", qnameId);
        params.put("listIndex", listIndex);
        params.put("localeId", localeId);
        params.put("longValue", longValue);
        this.template.update(UPDATE_ADM_OLD_CONTENT_PROPERTY, params);
    }

    @Override
    public int updateContentMimetypeIds(Long oldMimetypeId, Long newMimetypeId) {
        HashMap<String, Long> params = new HashMap<String, Long>(11);
        params.put("newMimetypeId", newMimetypeId);
        params.put("oldMimetypeId", oldMimetypeId);
        return this.template.update(UPDATE_CONTENT_MIMETYPE_ID, params);
    }

    @Override
    public int addSizeCurrentProp() {
        Long sizeCurrentPropQNameId = (Long)this.qnameDAO.getOrCreateQName(ContentModel.PROP_SIZE_CURRENT).getFirst();
        Long defaultLocaleId = (Long)this.localeDAO.getOrCreateDefaultLocalePair().getFirst();
        Long personTypeQNameId = (Long)this.qnameDAO.getOrCreateQName(ContentModel.TYPE_PERSON).getFirst();
        SizeCurrentParams params = new SizeCurrentParams();
        params.setSizeCurrentQNameId(sizeCurrentPropQNameId);
        params.setDefaultLocaleId(defaultLocaleId);
        params.setPersonTypeQNameId(personTypeQNameId);
        int rowsAffected = this.template.update(UPDATE_CREATE_SIZE_CURRENT_PROPERTY, (Object)params);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added " + rowsAffected + " cm:sizeCurrent properties."));
        }
        return rowsAffected;
    }

    @Override
    protected int updateAVMNodeEntitiesNullifyAcl(List<Long> nodeIds) {
        return this.template.update(UPDATE_AVM_NODE_LIST_NULLIFY_ACL, nodeIds);
    }

    @Override
    protected int updateAVMNodeEntitiesSetAcl(long aclId, List<Long> nodeIds) {
        IdListOfIdsParam params = new IdListOfIdsParam();
        params.setId(aclId);
        params.setListOfIds(nodeIds);
        return this.template.update(UPDATE_AVM_NODE_LIST_SET_ACL, (Object)params);
    }

    @Override
    protected long getMaxAclEntityId() {
        Long count = (Long)this.template.selectOne(SELECT_PERMISSIONS_MAX_ACL_ID, null);
        return count == null ? 0L : count;
    }

    @Override
    protected long getDmNodeEntitiesCount() {
        Long count = (Long)this.template.selectOne(SELECT_PERMISSIONS_DM_NODE_COUNT, null);
        return count == null ? 0L : count;
    }

    @Override
    protected long getDmNodeEntitiesCountWithNewACLs(Long above) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", above);
        Long count = (Long)this.template.selectOne(SELECT_PERMISSIONS_DM_NODE_COUNT_WITH_NEW_ACLS, params);
        return count == null ? 0L : count;
    }

    @Override
    protected List<Long> selectAllAclEntityIds() {
        return this.template.selectList(SELECT_PERMISSIONS_ALL_ACL_IDS);
    }

    @Override
    protected List<Long> selectNonDanglingAclEntityIds() {
        return this.template.selectList(SELECT_PERMISSIONS_USED_ACL_IDS);
    }

    @Override
    protected int deleteDanglingAceEntities() {
        return this.template.delete(DELETE_PERMISSIONS_UNUSED_ACES);
    }

    @Override
    protected int deleteAclEntities(List<Long> aclIds) {
        return this.template.delete(DELETE_PERMISSIONS_ACL_LIST, aclIds);
    }

    @Override
    protected int deleteAclMemberEntitiesForAcls(List<Long> aclIds) {
        return this.template.delete(DELETE_PERMISSIONS_ACL_MEMBERS_FOR_ACL_LIST, aclIds);
    }

    @Override
    public List<String> getAuthoritiesWithNonUtf8Crcs() {
        final ArrayList<String> results = new ArrayList<String>(1000);
        ResultHandler resultHandler = new ResultHandler(){

            public void handleResult(ResultContext context) {
                Map result = (Map)context.getResultObject();
                String authority = (String)result.get("authority");
                Long crc = (Long)result.get("crc");
                Long crcShouldBe = (Long)CrcHelper.getStringCrcPair(authority, 32, true, true).getSecond();
                if (!crcShouldBe.equals(crc)) {
                    results.add(authority);
                }
            }
        };
        this.template.select(SELECT_AUTHORITIES_AND_CRC, resultHandler);
        return results;
    }

    @Override
    public int getChildAssocCount() {
        return (Integer)this.template.selectOne(SELECT_CHILD_ASSOCS_COUNT);
    }

    @Override
    public Long getMaxChildAssocId() {
        Long maxAssocId = (Long)this.template.selectOne(SELECT_CHILD_ASSOCS_MAX_ID);
        return maxAssocId == null ? 0L : maxAssocId;
    }

    @Override
    public List<Map<String, Object>> getChildAssocsForCrcFix(Long minAssocId, Long stopAtAssocId, long rangeMultiplier, long maxIdRange, int maxResults) {
        ParameterCheck.mandatory((String)"minAssocId", (Object)minAssocId);
        ParameterCheck.mandatory((String)"stopAtAssocId", (Object)stopAtAssocId);
        Long qnameId = (Long)this.qnameDAO.getOrCreateQName(ContentModel.PROP_NAME).getFirst();
        int queryMaxResults = maxResults;
        List<Map<String, Object>> results = new ArrayList<Map<String, Object>>(maxResults);
        while (results.size() < maxResults && minAssocId <= stopAtAssocId) {
            Long maxAssocId = minAssocId + Math.min((long)maxResults * rangeMultiplier, maxIdRange);
            IdsEntity entity = new IdsEntity();
            entity.setIdOne(qnameId);
            entity.setIdTwo(minAssocId);
            entity.setIdThree(maxAssocId);
            try {
                long newRangeMultiplier;
                long newIdRange;
                List rows = this.template.selectList(SELECT_CHILD_ASSOCS_FOR_CRCS, (Object)entity, new RowBounds(0, queryMaxResults));
                if (results.size() == 0 && rows.size() >= maxResults) {
                    results = rows;
                    break;
                }
                results.addAll(rows);
                queryMaxResults = maxResults - results.size();
                minAssocId = maxAssocId;
                if (rows.size() >= queryMaxResults / 2 || (newIdRange = (long)maxResults * (newRangeMultiplier = rangeMultiplier * 2L)) <= 0L || newIdRange >= maxIdRange) continue;
                rangeMultiplier = newRangeMultiplier;
            }
            catch (Throwable e) {
                String msg = "Failed to query for batch of alf_child_assoc rows; use a lower 'maxIdRange': \n   minAssocId:      " + minAssocId + "\n" + "   maxAssocId:      " + maxAssocId + "\n" + "   maxIdRange:      " + maxIdRange + "\n" + "   stopAtAssocId:   " + stopAtAssocId + "\n" + "   rangeMultiplier: " + rangeMultiplier + "\n" + "   queryMaxResults: " + queryMaxResults;
                logger.error((Object)msg);
                throw new RuntimeException(msg, e);
            }
        }
        return results;
    }

    @Override
    public int updateChildAssocCrc(Long assocId, Long childNodeNameCrc, Long qnameCrc) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("id", assocId);
        params.put("childNodeNameCrc", childNodeNameCrc);
        params.put("qnameCrc", qnameCrc);
        return this.template.update(UPDATE_CHILD_ASSOC_CRC, params);
    }

    @Override
    public List<Pair<NodeRef, String>> getNodesOfTypeWithNamePattern(QName typeQName, String namePattern) {
        Pair<Long, QName> typeQNamePair = this.qnameDAO.getQName(typeQName);
        if (typeQNamePair == null) {
            return Collections.emptyList();
        }
        Long typeQNameId = (Long)typeQNamePair.getFirst();
        Pair<Long, QName> propQNamePair = this.qnameDAO.getQName(ContentModel.PROP_NAME);
        if (propQNamePair == null) {
            return Collections.emptyList();
        }
        Long propQNameId = (Long)propQNamePair.getFirst();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("typeQNameId", typeQNameId);
        params.put("propQNameId", propQNameId);
        params.put("namePattern", namePattern);
        final ArrayList<Pair<NodeRef, String>> results = new ArrayList<Pair<NodeRef, String>>(500);
        ResultHandler resultHandler = new ResultHandler(){

            public void handleResult(ResultContext context) {
                Map row = (Map)context.getResultObject();
                String protocol = (String)row.get("protocol");
                String identifier = (String)row.get("identifier");
                String uuid = (String)row.get("uuid");
                NodeRef nodeRef = new NodeRef(new StoreRef(protocol, identifier), uuid);
                String name = (String)row.get("name");
                Pair pair = new Pair((Object)nodeRef, (Object)name);
                results.add(pair);
            }
        };
        this.template.select(SELECT_NODES_BY_TYPE_AND_NAME_PATTERN, params, resultHandler);
        return results;
    }

    @Override
    protected void getOldAttrTenantsImpl(ResultHandler resultHandler) {
        this.template.select(SELECT_OLD_ATTR_TENANTS, resultHandler);
    }

    @Override
    protected void getOldAttrAVMLocksImpl(ResultHandler resultHandler) {
        this.template.select(SELECT_OLD_ATTR_AVM_LOCKS, resultHandler);
    }

    @Override
    protected void getOldAttrPropertyBackedBeansImpl(ResultHandler resultHandler) {
        this.template.select(SELECT_OLD_ATTR_PBBS, resultHandler);
    }

    @Override
    protected void getOldAttrChainingURSImpl(ResultHandler resultHandler) {
        this.template.select(SELECT_OLD_ATTR_CHAINING_URS, resultHandler);
    }

    @Override
    protected List<String> getOldAttrCustomNamesImpl() {
        return this.template.selectList(SELECT_OLD_ATTR_CUSTOM_NAMES);
    }

    @Override
    public void migrateOldAttrDropTables() {
        this.template.update(DROP_OLD_ATTR_LIST);
        this.template.update(DROP_OLD_ATTR_MAP);
        this.template.update(DROP_OLD_ATTR_GLOBAL);
        this.template.update(DROP_OLD_ATTR);
    }

    @Override
    public List<Map<String, Object>> getAclsThatInheritFromNonPrimaryParent() {
        List rows = this.template.selectList(SELECT_ACLS_THAT_INHERIT_FROM_NON_PRIMARY_PARENT, (Object)Boolean.TRUE);
        return rows;
    }

    @Override
    public List<Map<String, Object>> getAclsThatInheritWithInheritanceUnset() {
        List rows = this.template.selectList(SELECT_ACLS_THAT_INHERIT_WITH_INHERITANCE_UNSET, (Object)Boolean.TRUE);
        return rows;
    }

    @Override
    public List<Map<String, Object>> getDefiningAclsThatDoNotInheritCorrectlyFromThePrimaryParent() {
        List rows = this.template.selectList(SELECT_DEFINING_ACLS_THAT_DO_NOT_INHERIT_CORRECTLY_FROM_THE_PRIMARY_PARENT, (Object)Boolean.TRUE);
        return rows;
    }

    @Override
    public List<Map<String, Object>> getSharedAclsThatDoNotInheritCorrectlyFromThePrimaryParent() {
        List rows = this.template.selectList(SELECT_SHARED_ACLS_THAT_DO_NOT_INHERIT_CORRECTLY_FROM_THE_PRIMARY_PARENT, (Object)Boolean.TRUE);
        return rows;
    }

    @Override
    public List<Map<String, Object>> getSharedAclsThatDoNotInheritCorrectlyFromTheirDefiningAcl() {
        List rows = this.template.selectList(SELECT_SHARED_ACLS_THAT_DO_NOT_INHERIT_CORRECTLY_FROM_THEIR_DEFINING_ACL, (Object)Boolean.TRUE);
        return rows;
    }

    @Override
    public long getCountNodesWithAspects(Set<QName> qnames) {
        Set<Long> qnameIds = this.qnameDAO.convertQNamesToIds(qnames, false);
        if (qnameIds.size() == 0) {
            return 0L;
        }
        IdsEntity params = new IdsEntity();
        params.setIds(new ArrayList<Long>(qnameIds));
        Long count = (Long)this.template.selectOne(SELECT_COUNT_NODES_WITH_ASPECTS, (Object)params);
        if (count == null) {
            return 0L;
        }
        return count;
    }

    public static class Oracle
    extends PatchDAOImpl {
        public void migrateOldAttrDropTables() {
            super.migrateOldAttrDropTables();
            this.template.update(PatchDAOImpl.DROP_OLD_ATTR_SEQ);
        }
    }

    public static class PostgreSQL
    extends PatchDAOImpl {
        public void migrateOldAttrDropTables() {
            super.migrateOldAttrDropTables();
            this.template.update(PatchDAOImpl.DROP_OLD_ATTR_SEQ);
        }
    }
}

