/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.permissions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.AVMRepository;
import org.alfresco.repo.avm.util.AVMUtil;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.domain.avm.AVMNodeDAO;
import org.alfresco.repo.domain.avm.AVMNodeEntity;
import org.alfresco.repo.domain.permissions.AccessControlListDAO;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.search.AVMSnapShotTriggeredIndexingMethodInterceptorImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.ACLType;
import org.alfresco.repo.security.permissions.AccessControlEntry;
import org.alfresco.repo.security.permissions.AccessControlList;
import org.alfresco.repo.security.permissions.SimpleAccessControlListProperties;
import org.alfresco.repo.security.permissions.impl.AclChange;
import org.alfresco.service.cmr.avm.AVMException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.InvalidStoreRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;
import org.alfresco.wcm.util.WCMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMAccessControlListDAO
implements AccessControlListDAO {
    private static Log s_logger = LogFactory.getLog(AVMAccessControlListDAO.class);
    private AVMRepository fAVMRepository;
    private AVMService fAVMService;
    private AclDAO aclDaoComponent;
    private AVMNodeDAO avmNodeDAO;

    public void setAvmRepository(AVMRepository repository) {
        this.fAVMRepository = repository;
    }

    public void setAvmService(AVMService avmService) {
        this.fAVMService = avmService;
    }

    public void setAclDAO(AclDAO aclDaoComponent) {
        this.aclDaoComponent = aclDaoComponent;
    }

    public void setAvmNodeDAO(AVMNodeDAO avmNodeDAO) {
        this.avmNodeDAO = avmNodeDAO;
    }

    @Override
    public Long getIndirectAcl(NodeRef nodeRef) {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        int version = (Integer)avmVersionPath.getFirst();
        if (version >= 0) {
            throw new InvalidNodeRefException("Read Only Node.", nodeRef);
        }
        String path = (String)avmVersionPath.getSecond();
        try {
            AVMNodeDescriptor descriptor = this.fAVMService.lookup(version, path);
            if (descriptor == null) {
                return null;
            }
            if (descriptor.isPrimary()) {
                Acl acl = this.getAclAsSystem(descriptor.getIndirectionVersion(), descriptor.getIndirection());
                if (acl == null) {
                    return null;
                }
                return acl.getId();
            }
            Acl acl = this.getAclAsSystem(version, path);
            if (acl == null) {
                return null;
            }
            return acl.getId();
        }
        catch (AVMException e) {
            throw new InvalidNodeRefException(nodeRef);
        }
    }

    @Override
    public Long getInheritedAcl(NodeRef nodeRef) {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        String path = (String)avmVersionPath.getSecond();
        ArrayList result = new ArrayList();
        String[] splitPath = AVMNodeConverter.SplitBase(path);
        if (splitPath[0] == null) {
            return null;
        }
        Acl acl = this.getAclAsSystem((Integer)avmVersionPath.getFirst(), splitPath[0]);
        if (acl == null) {
            return null;
        }
        return acl.getId();
    }

    @Override
    public Acl getAccessControlList(NodeRef nodeRef) {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        int version = (Integer)avmVersionPath.getFirst();
        String path = (String)avmVersionPath.getSecond();
        try {
            return this.getAclAsSystem(version, path);
        }
        catch (AVMException e) {
            throw new InvalidNodeRefException(nodeRef);
        }
    }

    @Override
    public void setAccessControlList(NodeRef nodeRef, Acl acl) {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        int version = (Integer)avmVersionPath.getFirst();
        if (version >= 0) {
            throw new InvalidNodeRefException("Read Only Node.", nodeRef);
        }
        String path = (String)avmVersionPath.getSecond();
        try {
            this.setAclAsSystem(path, acl);
        }
        catch (AVMException e) {
            throw new InvalidNodeRefException(nodeRef);
        }
    }

    @Override
    public void setAccessControlList(NodeRef nodeRef, Long aclId) {
        throw new UnsupportedOperationException("Not implemented for AVM: setAccessControlList(NodeRef nodeRef, Long aclId)");
    }

    @Override
    public void updateChangedAcls(NodeRef startingPoint, List<AclChange> changes) {
        boolean hasChanges = false;
        Long after = null;
        for (AclChange change : changes) {
            if (change.getBefore() == null) {
                after = change.getAfter();
            } else if (change.getTypeBefore() != change.getTypeAfter()) {
                after = change.getAfter();
            }
            if (!EqualsHelper.nullSafeEquals((Object)((Object)change.getTypeBefore()), (Object)((Object)change.getTypeAfter()))) {
                hasChanges = true;
            }
            if (EqualsHelper.nullSafeEquals((Object)change.getBefore(), (Object)change.getAfter())) continue;
            hasChanges = true;
        }
        if (!hasChanges) {
            return;
        }
        Long inherited = null;
        if (after != null) {
            inherited = this.aclDaoComponent.getInheritedAccessControlList(after);
        }
        AVMNodeDescriptor descriptor = this.getDesc(startingPoint);
        Map<Long, Set<Long>> indirections = this.buildIndirections(descriptor);
        this.updateChangedAclsImpl(startingPoint, changes, SetMode.ALL, inherited, after, indirections);
    }

    private void updateChangedAclsImpl(NodeRef startingPoint, List<AclChange> changes, SetMode mode, Long inherited, Long setAcl, Map<Long, Set<Long>> indirections) {
        HashMap<Long, Long> changeMap = new HashMap<Long, Long>();
        HashSet<Long> unchangedSet = new HashSet<Long>();
        for (AclChange change : changes) {
            if (change.getBefore() == null) continue;
            if (!change.getBefore().equals(change.getAfter())) {
                changeMap.put(change.getBefore(), change.getAfter());
                continue;
            }
            unchangedSet.add(change.getBefore());
        }
        unchangedSet.add(inherited);
        unchangedSet.add(setAcl);
        if (inherited != null) {
            this.updateReferencingLayeredAcls(startingPoint, inherited, indirections);
        }
        this.updateInheritedChangedAcls(startingPoint, changeMap, unchangedSet, inherited, mode, indirections);
        this.updateLayeredAclsChangedByInheritance(changes, changeMap, unchangedSet, indirections);
    }

    @Override
    public void forceCopy(NodeRef nodeRef) {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
        int version = (Integer)avmVersionPath.getFirst();
        if (version >= 0) {
            throw new InvalidNodeRefException("Read Only Node.", nodeRef);
        }
        String path = (String)avmVersionPath.getSecond();
        try {
            this.fAVMRepository.forceCopy(path);
        }
        catch (AVMException e) {
            throw new InvalidNodeRefException(nodeRef);
        }
    }

    private AVMNodeDescriptor getDesc(NodeRef node) {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(node);
        int version = (Integer)avmVersionPath.getFirst();
        if (version >= 0) {
            throw new InvalidNodeRefException("Read Only Node.", node);
        }
        String path = (String)avmVersionPath.getSecond();
        try {
            AVMNodeDescriptor descriptor = this.fAVMService.lookup(version, path);
            return descriptor;
        }
        catch (AVMException e) {
            throw new InvalidNodeRefException(node);
        }
    }

    private List<Indirection> getLayeredDirectories() {
        List<AVMNodeEntity> ldNodeEntities = this.avmNodeDAO.getAllLayeredDirectories();
        ArrayList<Indirection> indirections = new ArrayList<Indirection>(ldNodeEntities.size());
        for (AVMNodeEntity ldNodeEntity : ldNodeEntities) {
            Long from = ldNodeEntity.getId();
            String to = ldNodeEntity.getIndirection();
            Integer version = ldNodeEntity.getIndirectionVersion();
            indirections.add(new Indirection(from, to, version));
        }
        return indirections;
    }

    private List<Indirection> getLayeredFiles() {
        List<AVMNodeEntity> lfNodeEntities = this.avmNodeDAO.getAllLayeredFiles();
        ArrayList<Indirection> indirections = new ArrayList<Indirection>(lfNodeEntities.size());
        for (AVMNodeEntity lfNodeEntity : lfNodeEntities) {
            Long from = lfNodeEntity.getId();
            String to = lfNodeEntity.getIndirection();
            Integer version = lfNodeEntity.getIndirectionVersion();
            indirections.add(new Indirection(from, to, version));
        }
        return indirections;
    }

    private List<Indirection> getAvmIndirections() {
        List<Indirection> dirList = this.getLayeredDirectories();
        List<Indirection> fileList = this.getLayeredFiles();
        ArrayList<Indirection> answer = new ArrayList<Indirection>(dirList.size() + fileList.size());
        answer.addAll(dirList);
        answer.addAll(fileList);
        return answer;
    }

    private Map<Long, Set<Long>> buildIndirections(AVMNodeDescriptor desc) {
        String[] pathParts;
        if (desc != null && desc.getVersionID() == 1 && (pathParts = AVMUtil.splitPath(desc.getPath()))[1].equals("/www") && WCMUtil.isStagingStore(pathParts[0])) {
            return null;
        }
        return this.buildIndirections();
    }

    private Map<Long, Set<Long>> buildIndirections() {
        long start = System.currentTimeMillis();
        HashMap<Long, Set<Long>> answer = new HashMap<Long, Set<Long>>();
        List<Indirection> indirections = this.getAvmIndirections();
        for (Indirection indirection : indirections) {
            AVMNodeDescriptor toDesc = this.fAVMService.lookup(indirection.getToVersion(), indirection.getTo(), true);
            if (toDesc == null) continue;
            Long toId = toDesc.getId();
            HashSet<Long> referees = (HashSet<Long>)answer.get(toId);
            if (referees == null) {
                referees = new HashSet<Long>();
                answer.put(toId, referees);
            }
            referees.add(indirection.getFrom());
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("buildIndirections: (" + indirections.size() + ", " + answer.size() + ") in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        return answer;
    }

    private void updateReferencingLayeredAcls(NodeRef node, Long inherited, Map<Long, Set<Long>> indirections) {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(node);
        int version = (Integer)avmVersionPath.getFirst();
        if (version >= 0) {
            throw new InvalidNodeRefException("Read Only Node.", node);
        }
        String path = (String)avmVersionPath.getSecond();
        try {
            AVMNodeDescriptor descriptor = this.fAVMService.lookup(version, path);
            if (descriptor == null || indirections == null) {
                return;
            }
            Set<Long> avmNodeIds = indirections.get(descriptor.getId());
            if (avmNodeIds != null) {
                for (Long id : avmNodeIds) {
                    AVMNodeDescriptor layerDesc = new AVMNodeDescriptor(null, null, 0, null, null, null, 0L, 0L, 0L, id, null, 0, null, 0, false, 0L, false, 0L, 0);
                    List<Pair<Integer, String>> layerPaths = this.fAVMRepository.getHeadPaths(layerDesc);
                    block3: for (Pair<Integer, String> layerPath : layerPaths) {
                        Acl target = this.getAclAsSystem(-1, (String)layerPath.getSecond());
                        if (target == null || target.getAclType() != ACLType.LAYERED) continue;
                        this.fAVMService.forceCopy((String)layerPath.getSecond());
                        List<AclChange> layeredChanges = this.aclDaoComponent.mergeInheritedAccessControlList(inherited, target.getId());
                        NodeRef layeredNode = AVMNodeConverter.ToNodeRef(-1, (String)layerPath.getSecond());
                        for (AclChange change : layeredChanges) {
                            if (!change.getBefore().equals(target.getId())) continue;
                            Long newInherited = null;
                            if (change.getAfter() != null) {
                                newInherited = this.aclDaoComponent.getInheritedAccessControlList(change.getAfter());
                            }
                            this.updateChangedAclsImpl(layeredNode, layeredChanges, SetMode.DIRECT_ONLY, newInherited, change.getAfter(), indirections);
                            continue block3;
                        }
                    }
                }
            }
        }
        catch (AVMException e) {
            throw new InvalidNodeRefException(node);
        }
    }

    private void updateLayeredAclsChangedByInheritance(List<AclChange> changes, HashMap<Long, Long> changeMap, Set<Long> unchanged, Map<Long, Set<Long>> indirections) {
        for (AclChange change : changes) {
            if (change.getTypeBefore() != ACLType.LAYERED || change.getTypeAfter() != ACLType.LAYERED) continue;
            List<Long> avmNodeIds = this.aclDaoComponent.getAVMNodesByAcl(change.getBefore(), -1);
            for (Long id : avmNodeIds) {
                AVMNodeDescriptor desc = new AVMNodeDescriptor(null, null, 0, null, null, null, 0L, 0L, 0L, id, null, 0, null, 0, false, 0L, false, 0L, 0);
                List<Pair<Integer, String>> paths = this.fAVMRepository.getHeadPaths(desc);
                for (Pair<Integer, String> path : paths) {
                    this.setAclAsSystem((String)path.getSecond(), this.aclDaoComponent.getAcl(change.getAfter()));
                    NodeRef layeredNode = AVMNodeConverter.ToNodeRef(-1, (String)path.getSecond());
                    this.updateInheritedChangedAcls(layeredNode, changeMap, unchanged, this.aclDaoComponent.getInheritedAccessControlList(change.getAfter()), SetMode.DIRECT_ONLY, indirections);
                }
            }
        }
    }

    private void updateInheritedChangedAcls(NodeRef startingPoint, HashMap<Long, Long> changeMap, Set<Long> unchanged, Long unsetAcl, SetMode mode, Map<Long, Set<Long>> indirections) {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(startingPoint);
        int version = (Integer)avmVersionPath.getFirst();
        if (version >= 0) {
            throw new InvalidNodeRefException("Read Only Node.", startingPoint);
        }
        String path = (String)avmVersionPath.getSecond();
        try {
            AVMNodeDescriptor descriptor = this.fAVMService.lookup(version, path);
            if (descriptor == null) {
                return;
            }
            if (descriptor.isLayeredDirectory()) {
                this.setInheritanceForDirectChildren(descriptor, changeMap, this.getAclAsSystem(-1, descriptor.getPath()).getId(), indirections);
            }
            this.fixUpAcls(descriptor, changeMap, unchanged, unsetAcl, mode, indirections);
        }
        catch (AVMException e) {
            throw new InvalidNodeRefException(startingPoint);
        }
    }

    private void fixUpAcls(AVMNodeDescriptor descriptor, Map<Long, Long> changes, Set<Long> unchanged, Long unsetAcl, SetMode mode, Map<Long, Set<Long>> indirections) {
        Acl acl = this.getAclAsSystem(-1, descriptor.getPath());
        Long id = null;
        if (acl != null) {
            id = acl.getId();
        }
        if (id == null) {
            this.setAclAsSystem(descriptor.getPath(), this.aclDaoComponent.getAcl(unsetAcl));
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, descriptor.getPath());
            this.updateReferencingLayeredAcls(nodeRef, unsetAcl, indirections);
        } else if (changes.containsKey(id)) {
            Long updateId = changes.get(id);
            if (updateId != id) {
                Acl newAcl = this.aclDaoComponent.getAcl(updateId);
                this.setAclAsSystem(descriptor.getPath(), newAcl);
            }
        } else if (!unchanged.contains(id)) {
            return;
        }
        if (descriptor.isDirectory()) {
            SortedMap<String, AVMNodeDescriptor> children;
            switch (mode) {
                case ALL: {
                    children = this.fAVMService.getDirectoryListing(descriptor, false);
                    break;
                }
                case DIRECT_ONLY: {
                    children = this.fAVMService.getDirectoryListingDirect(descriptor, false);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            for (AVMNodeDescriptor child : children.values()) {
                this.fixUpAcls(child, changes, unchanged, unsetAcl, mode, indirections);
            }
        }
    }

    private void setInheritanceForDirectChildren(AVMNodeDescriptor descriptor, Map<Long, Long> changeMap, Long inheritFrom, Map<Long, Set<Long>> indirections) {
        ArrayList<AclChange> changes = new ArrayList<AclChange>();
        this.setFixedAcls(descriptor, inheritFrom, null, changes, SetMode.DIRECT_ONLY, false, indirections);
        for (AclChange change : changes) {
            if (change.getBefore().equals(change.getAfter())) continue;
            changeMap.put(change.getBefore(), change.getAfter());
        }
    }

    @Override
    public List<AclChange> setInheritanceForChildren(NodeRef parent, Long inheritFrom, Long sharedAclToReplace) {
        Pair<Integer, String> avmVersionPath = AVMNodeConverter.ToAVMVersionPath(parent);
        int version = (Integer)avmVersionPath.getFirst();
        if (version >= 0) {
            throw new InvalidNodeRefException("Read Only Node.", parent);
        }
        String path = (String)avmVersionPath.getSecond();
        try {
            ArrayList<AclChange> changes = new ArrayList<AclChange>();
            AVMNodeDescriptor descriptor = this.fAVMService.lookup(version, path);
            Map<Long, Set<Long>> indirections = this.buildIndirections(descriptor);
            this.setFixedAcls(descriptor, inheritFrom, null, changes, SetMode.ALL, false, indirections);
            return changes;
        }
        catch (AVMException e) {
            throw new InvalidNodeRefException(parent);
        }
    }

    public void setFixedAcls(AVMNodeDescriptor descriptor, Long inheritFrom, Long mergeFrom, List<AclChange> changes, SetMode mode, boolean set, Map<Long, Set<Long>> indirections) {
        if (descriptor == null) {
            return;
        }
        if (set) {
            if (mergeFrom == null) {
                mergeFrom = this.aclDaoComponent.getInheritedAccessControlList(inheritFrom);
            }
            Acl previous = this.getAclAsSystem(-1, descriptor.getPath());
            this.setAclAsSystem(descriptor.getPath(), this.aclDaoComponent.getAcl(mergeFrom));
            if (previous == null) {
                NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, descriptor.getPath());
                this.updateReferencingLayeredAcls(nodeRef, mergeFrom, indirections);
            }
        }
        if (descriptor.isDirectory()) {
            SortedMap<String, AVMNodeDescriptor> children;
            switch (mode) {
                case ALL: {
                    children = this.fAVMService.getDirectoryListing(descriptor, false);
                    break;
                }
                case DIRECT_ONLY: {
                    children = this.fAVMService.getDirectoryListingDirect(descriptor, false);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            block4: for (String key : children.keySet()) {
                AVMNodeDescriptor child;
                Acl acl;
                if (mergeFrom == null) {
                    mergeFrom = this.aclDaoComponent.getInheritedAccessControlList(inheritFrom);
                }
                if ((acl = this.getAclAsSystem(-1, (child = (AVMNodeDescriptor)children.get(key)).getPath())) == null) {
                    this.setFixedAcls(child, inheritFrom, mergeFrom, changes, mode, true, indirections);
                    continue;
                }
                if (acl.getAclType() == ACLType.LAYERED) continue;
                if (acl.getAclType() == ACLType.DEFINING) {
                    this.fAVMService.forceCopy(child.getPath());
                    List<AclChange> newChanges = this.aclDaoComponent.mergeInheritedAccessControlList(mergeFrom, acl.getId());
                    for (AclChange change : newChanges) {
                        if (!change.getBefore().equals(acl.getId())) continue;
                        this.setAclAsSystem(child.getPath(), this.aclDaoComponent.getAcl(change.getAfter()));
                        this.setFixedAcls(child, change.getAfter(), null, newChanges, SetMode.DIRECT_ONLY, false, indirections);
                        changes.addAll(newChanges);
                        continue block4;
                    }
                    continue;
                }
                this.setFixedAcls(child, inheritFrom, mergeFrom, changes, mode, true, indirections);
            }
        }
    }

    @Override
    public Map<ACLType, Integer> patchAcls() {
        CounterSet result = new CounterSet();
        List<AVMStoreDescriptor> stores = this.fAVMService.getStores();
        Map<Long, Set<Long>> indirections = this.buildIndirections();
        block3: for (AVMStoreDescriptor store : stores) {
            CounterSet update;
            AVMNodeDescriptor root = this.fAVMService.getStoreRoot(-1, store.getName());
            Map<QName, PropertyValue> storeProperties = this.fAVMService.getStoreProperties(store.getName());
            switch (AVMSnapShotTriggeredIndexingMethodInterceptorImpl.StoreType.getStoreType(store.getName(), store, storeProperties)) {
                case AUTHOR: 
                case AUTHOR_PREVIEW: 
                case AUTHOR_WORKFLOW: 
                case AUTHOR_WORKFLOW_PREVIEW: 
                case STAGING: 
                case STAGING_PREVIEW: 
                case WORKFLOW: 
                case WORKFLOW_PREVIEW: {
                    AVMNodeDescriptor www = this.fAVMService.lookup(-1, store.getName() + ":/www");
                    if (www != null) {
                        update = this.fixOldAvmAcls(www, false, indirections);
                        result.add(update);
                        continue block3;
                    }
                    update = this.fixOldAvmAcls(root, true, indirections);
                    result.add(update);
                    continue block3;
                }
            }
            update = this.fixOldAvmAcls(root, true, indirections);
            result.add(update);
        }
        HashMap<ACLType, Integer> toReturn = new HashMap<ACLType, Integer>();
        toReturn.put(ACLType.DEFINING, ((Counter)result.get((Object)ACLType.DEFINING)).getCounter());
        toReturn.put(ACLType.FIXED, ((Counter)result.get((Object)ACLType.FIXED)).getCounter());
        toReturn.put(ACLType.GLOBAL, ((Counter)result.get((Object)ACLType.GLOBAL)).getCounter());
        toReturn.put(ACLType.LAYERED, ((Counter)result.get((Object)ACLType.LAYERED)).getCounter());
        toReturn.put(ACLType.OLD, ((Counter)result.get((Object)ACLType.OLD)).getCounter());
        toReturn.put(ACLType.SHARED, ((Counter)result.get((Object)ACLType.SHARED)).getCounter());
        return toReturn;
    }

    private CounterSet fixOldAvmAcls(AVMNodeDescriptor node, boolean searchDirectories, Map<Long, Set<Long>> indirections) {
        return this.fixOldAvmAclsImpl(node, searchDirectories, indirections);
    }

    private CounterSet fixOldAvmAclsImpl(AVMNodeDescriptor node, boolean searchDirectories, Map<Long, Set<Long>> indirections) {
        CounterSet result;
        block21: {
            ArrayList<AclChange> changes;
            Acl acl;
            AVMNodeDescriptor referencedNode;
            block22: {
                block20: {
                    Acl existingAcl;
                    result = new CounterSet();
                    if (searchDirectories && node.isDirectory()) {
                        SortedMap<String, AVMNodeDescriptor> children = this.fAVMRepository.getListingDirect(node, true);
                        for (AVMNodeDescriptor child : children.values()) {
                            CounterSet update = this.fixOldAvmAcls(child, searchDirectories, indirections);
                            result.add(update);
                        }
                    }
                    if ((existingAcl = this.getAclAsSystem(-1, node.getPath())) == null) break block20;
                    if (existingAcl.getAclType() == ACLType.OLD) {
                        result.increment(ACLType.DEFINING);
                        SimpleAccessControlListProperties properties = new SimpleAccessControlListProperties();
                        properties.setAclType(ACLType.DEFINING);
                        properties.setVersioned(true);
                        Acl newAcl = this.aclDaoComponent.createAccessControlList(properties);
                        long id = newAcl.getId();
                        AccessControlList existing = this.aclDaoComponent.getAccessControlList(existingAcl.getId());
                        for (AccessControlEntry entry : existing.getEntries()) {
                            if (entry.getPosition() != 0) continue;
                            this.aclDaoComponent.setAccessControlEntry(id, entry);
                        }
                        this.setAclAsSystem(node.getPath(), newAcl);
                        ArrayList<AclChange> changes2 = new ArrayList<AclChange>();
                        this.setFixedAcls(node, id, null, changes2, SetMode.DIRECT_ONLY, false, indirections);
                        for (AclChange change : changes2) {
                            if (change.getBefore().equals(change.getAfter())) continue;
                            s_logger.warn((Object)"ACL fix should not change the acl ids - unexpected COW!");
                        }
                    } else {
                        s_logger.warn((Object)"Skipping new style ACLs");
                    }
                    break block21;
                }
                if (!node.isLayeredDirectory()) break block22;
                result.increment(ACLType.LAYERED);
                if (node.getIndirection() != null) {
                    referencedNode = this.fAVMService.lookup(-1, node.getIndirection(), false);
                    if (referencedNode != null && referencedNode.isDirectory()) {
                        acl = this.getAclAsSystem(-1, referencedNode.getPath());
                        if (acl != null) {
                            this.setAclAsSystem(node.getPath(), this.aclDaoComponent.createLayeredAcl(acl.getId()));
                        } else {
                            this.setAclAsSystem(node.getPath(), this.aclDaoComponent.createLayeredAcl(null));
                        }
                    } else {
                        this.setAclAsSystem(node.getPath(), this.aclDaoComponent.createLayeredAcl(null));
                    }
                } else {
                    this.setAclAsSystem(node.getPath(), this.aclDaoComponent.createLayeredAcl(null));
                }
                changes = new ArrayList<AclChange>();
                this.setFixedAcls(node, this.getAclAsSystem(-1, node.getPath()).getId(), null, changes, SetMode.DIRECT_ONLY, false, indirections);
                for (AclChange change : changes) {
                    if (change.getBefore().equals(change.getAfter())) continue;
                    s_logger.warn((Object)"ACL fix should not change the acl ids - unexpected COW!");
                }
                break block21;
            }
            if (!node.isLayeredFile()) break block21;
            result.increment(ACLType.LAYERED);
            if (node.getIndirection() != null) {
                referencedNode = this.fAVMService.lookup(-1, node.getIndirection(), false);
                if (referencedNode != null) {
                    acl = this.getAclAsSystem(-1, referencedNode.getPath());
                    if (acl != null) {
                        this.setAclAsSystem(node.getPath(), this.aclDaoComponent.createLayeredAcl(acl.getId()));
                    } else {
                        this.setAclAsSystem(node.getPath(), this.aclDaoComponent.createLayeredAcl(null));
                    }
                } else {
                    this.setAclAsSystem(node.getPath(), this.aclDaoComponent.createLayeredAcl(null));
                }
            } else {
                this.setAclAsSystem(node.getPath(), this.aclDaoComponent.createLayeredAcl(null));
            }
            changes = new ArrayList();
            this.setFixedAcls(node, this.getAclAsSystem(-1, node.getPath()).getId(), null, changes, SetMode.DIRECT_ONLY, false, indirections);
            for (AclChange change : changes) {
                if (change.getBefore().equals(change.getAfter())) continue;
                throw new IllegalStateException("ACL fix should not change the acl ids - unexpected COW!");
            }
        }
        return result;
    }

    private Acl getStoreAclAsSystem(final String storeName) {
        return (Acl)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Acl>(){

            public Acl doWork() throws Exception {
                return AVMAccessControlListDAO.this.fAVMRepository.getStoreAcl(storeName);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private void setStoreAclAsSystem(final String storeName, final Acl acl) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                AVMAccessControlListDAO.this.fAVMRepository.setStoreAcl(storeName, acl);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private Acl getAclAsSystem(final int version, final String path) {
        return (Acl)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Acl>(){

            public Acl doWork() throws Exception {
                return AVMAccessControlListDAO.this.fAVMRepository.getACL(version, path);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private void setAclAsSystem(final String path, final Acl acl) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                AVMAccessControlListDAO.this.fAVMRepository.setACL(path, acl);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    public Acl getAccessControlList(StoreRef storeRef) {
        try {
            return this.getStoreAclAsSystem(storeRef.getIdentifier());
        }
        catch (AVMException e) {
            throw new InvalidStoreRefException(storeRef);
        }
    }

    @Override
    public void setAccessControlList(StoreRef storeRef, Acl acl) {
        try {
            this.setStoreAclAsSystem(storeRef.getIdentifier(), acl);
        }
        catch (AVMException e) {
            throw new InvalidStoreRefException(storeRef);
        }
    }

    @Override
    public void updateInheritance(Long childNodeId, Long oldParentNodeId, Long newParentNodeId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFixedAcls(Long nodeId, Long inheritFrom, Long mergeFrom, Long sharedAclToReplace, List<AclChange> changes, boolean set) {
        throw new UnsupportedOperationException();
    }

    public static class Counter {
        int counter;

        void increment() {
            ++this.counter;
        }

        int getCounter() {
            return this.counter;
        }

        void add(int i) {
            this.counter += i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CounterSet
    extends HashMap<ACLType, Counter> {
        private static final long serialVersionUID = -3682278258679211481L;

        CounterSet() {
            this.put(ACLType.DEFINING, new Counter());
            this.put(ACLType.FIXED, new Counter());
            this.put(ACLType.GLOBAL, new Counter());
            this.put(ACLType.LAYERED, new Counter());
            this.put(ACLType.OLD, new Counter());
            this.put(ACLType.SHARED, new Counter());
        }

        void add(ACLType type, Counter c) {
            Counter counter = (Counter)this.get((Object)type);
            counter.add(c.getCounter());
        }

        void increment(ACLType type) {
            Counter counter = (Counter)this.get((Object)type);
            counter.increment();
        }

        void add(CounterSet other) {
            this.add(ACLType.DEFINING, (Counter)other.get((Object)ACLType.DEFINING));
            this.add(ACLType.FIXED, (Counter)other.get((Object)ACLType.FIXED));
            this.add(ACLType.GLOBAL, (Counter)other.get((Object)ACLType.GLOBAL));
            this.add(ACLType.LAYERED, (Counter)other.get((Object)ACLType.LAYERED));
            this.add(ACLType.OLD, (Counter)other.get((Object)ACLType.OLD));
            this.add(ACLType.SHARED, (Counter)other.get((Object)ACLType.SHARED));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SetMode {
        ALL,
        DIRECT_ONLY;

    }

    public static class Indirection {
        Long from;
        String to;
        Integer toVersion;

        Indirection(Long from, String to, Integer toVersion) {
            this.from = from;
            this.to = to;
            this.toVersion = toVersion;
        }

        public Long getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public Integer getToVersion() {
            return this.toVersion;
        }
    }
}

