/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.propval;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.alfresco.util.Pair;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDateValueEntity {
    private long dateValue;
    private short fullYear;
    private short halfOfYear;
    private short quarterOfYear;
    private short monthOfYear;
    private short weekOfYear;
    private short weekOfMonth;
    private short dayOfYear;
    private short dayOfMonth;
    private short dayOfWeek;

    public static Date truncateDate(Date value) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(value.getTime());
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        Date dayOnlyDate = cal.getTime();
        return dayOnlyDate;
    }

    public int hashCode() {
        return (int)this.dateValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof PropertyDateValueEntity) {
            PropertyDateValueEntity that = (PropertyDateValueEntity)obj;
            return this.dateValue == that.dateValue;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("PropertyDateValueEntity").append("[ value=").append(this.dateValue).append(" (").append(ISO8601DateFormat.format((Date)new Date(this.dateValue))).append(")").append("]");
        return sb.toString();
    }

    public Pair<Long, Date> getEntityPair() {
        return new Pair((Object)this.dateValue, (Object)new Date(this.dateValue));
    }

    public void setValue(Date value) {
        long valueInMs;
        this.dateValue = valueInMs = value.getTime();
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(valueInMs);
        this.monthOfYear = (short)cal.get(2);
        this.fullYear = (short)cal.get(1);
        this.halfOfYear = this.monthOfYear < 5 ? (short)0 : 1;
        this.quarterOfYear = (short)(this.monthOfYear / 3);
        this.weekOfYear = (short)cal.get(3);
        this.weekOfMonth = (short)cal.get(4);
        this.dayOfYear = (short)cal.get(6);
        this.dayOfMonth = (short)cal.get(5);
        this.dayOfWeek = (short)cal.get(5);
    }

    public long getDateValue() {
        return this.dateValue;
    }

    public void setDateValue(long dateValue) {
        this.dateValue = dateValue;
    }

    public short getFullYear() {
        return this.fullYear;
    }

    public void setFullYear(short fullYear) {
        this.fullYear = fullYear;
    }

    public short getHalfOfYear() {
        return this.halfOfYear;
    }

    public void setHalfOfYear(short halfOfYear) {
        this.halfOfYear = halfOfYear;
    }

    public short getQuarterOfYear() {
        return this.quarterOfYear;
    }

    public void setQuarterOfYear(short quarterOfYear) {
        this.quarterOfYear = quarterOfYear;
    }

    public short getMonthOfYear() {
        return this.monthOfYear;
    }

    public void setMonthOfYear(short monthOfYear) {
        this.monthOfYear = monthOfYear;
    }

    public short getWeekOfYear() {
        return this.weekOfYear;
    }

    public void setWeekOfYear(short weekOfYear) {
        this.weekOfYear = weekOfYear;
    }

    public short getWeekOfMonth() {
        return this.weekOfMonth;
    }

    public void setWeekOfMonth(short weekOfMonth) {
        this.weekOfMonth = weekOfMonth;
    }

    public short getDayOfYear() {
        return this.dayOfYear;
    }

    public void setDayOfYear(short dayOfYear) {
        this.dayOfYear = dayOfYear;
    }

    public short getDayOfMonth() {
        return this.dayOfMonth;
    }

    public void setDayOfMonth(short dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public short getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(short dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }
}

