/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.query;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.error.ExceptionStackUtil;
import org.alfresco.repo.domain.mimetype.MimetypeDAO;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.springframework.context.ApplicationContext;

public class CannedQueryDAOTest
extends TestCase {
    private static final String QUERY_NS = "alfresco.query.test";
    private static final String QUERY_SELECT_MIMETYPE_COUNT = "select_CountMimetypes";
    private static final String QUERY_SELECT_MIMETYPES = "select_Mimetypes";
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private CannedQueryDAO cannedQueryDAO;
    private MimetypeDAO mimetypeDAO;
    private String mimetypePrefix;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.cannedQueryDAO = (CannedQueryDAO)this.ctx.getBean("cannedQueryDAO");
        this.mimetypeDAO = (MimetypeDAO)this.ctx.getBean("mimetypeDAO");
        RetryingTransactionHelper.RetryingTransactionCallback<String> createMimetypeCallback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            @Override
            public String execute() throws Throwable {
                String mimetypePrefix = GUID.generate();
                CannedQueryDAOTest.this.mimetypeDAO.getOrCreateMimetype(mimetypePrefix + "-aaa");
                CannedQueryDAOTest.this.mimetypeDAO.getOrCreateMimetype(mimetypePrefix + "-bbb");
                return mimetypePrefix;
            }
        };
        this.mimetypePrefix = this.txnHelper.doInTransaction(createMimetypeCallback);
    }

    public void testExecute_FailureRecovery() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> failCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TestOneParams params = new TestOneParams(null, true);
                params.setForceFail(true);
                try {
                    CannedQueryDAOTest.this.cannedQueryDAO.executeCountQuery(CannedQueryDAOTest.QUERY_NS, CannedQueryDAOTest.QUERY_SELECT_MIMETYPE_COUNT, params);
                    Assert.fail((String)"Expected bad SQL");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                CannedQueryDAOTest.this.mimetypeDAO.getOrCreateMimetype(CannedQueryDAOTest.this.mimetypePrefix + "-postfail");
                return null;
            }
        };
        this.txnHelper.doInTransaction(failCallback, false);
    }

    public void testExecute_CountAllMimetypes() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Long> selectCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                TestOneParams params = new TestOneParams(null, true);
                return CannedQueryDAOTest.this.cannedQueryDAO.executeCountQuery(CannedQueryDAOTest.QUERY_NS, CannedQueryDAOTest.QUERY_SELECT_MIMETYPE_COUNT, params);
            }
        };
        Long count = this.txnHelper.doInTransaction(selectCallback, true);
        CannedQueryDAOTest.assertNotNull((Object)count);
        CannedQueryDAOTest.assertTrue((count > 0L ? 1 : 0) != 0);
    }

    public void testExecute_CountNoResults() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Long> selectCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                TestOneParams params = new TestOneParams(GUID.generate(), true);
                return CannedQueryDAOTest.this.cannedQueryDAO.executeCountQuery(CannedQueryDAOTest.QUERY_NS, CannedQueryDAOTest.QUERY_SELECT_MIMETYPE_COUNT, params);
            }
        };
        Long count = this.txnHelper.doInTransaction(selectCallback, true);
        CannedQueryDAOTest.assertNotNull((Object)count);
        CannedQueryDAOTest.assertEquals((String)"Incorrect result count.", (long)0L, (long)count);
    }

    public void testExecute_CountMimetypeExact() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Long> selectCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                TestOneParams params = new TestOneParams(CannedQueryDAOTest.this.mimetypePrefix + "-aaa", true);
                return CannedQueryDAOTest.this.cannedQueryDAO.executeCountQuery(CannedQueryDAOTest.QUERY_NS, CannedQueryDAOTest.QUERY_SELECT_MIMETYPE_COUNT, params);
            }
        };
        Long count = this.txnHelper.doInTransaction(selectCallback, true);
        CannedQueryDAOTest.assertNotNull((Object)count);
        CannedQueryDAOTest.assertEquals((String)"Incorrect result count.", (long)1L, (long)count);
    }

    public void testExecute_CountMimetypeWildcard() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<Long> selectCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Throwable {
                TestOneParams params = new TestOneParams(CannedQueryDAOTest.this.mimetypePrefix + "%", false);
                return CannedQueryDAOTest.this.cannedQueryDAO.executeCountQuery(CannedQueryDAOTest.QUERY_NS, CannedQueryDAOTest.QUERY_SELECT_MIMETYPE_COUNT, params);
            }
        };
        Long count = this.txnHelper.doInTransaction(selectCallback, true);
        CannedQueryDAOTest.assertNotNull((Object)count);
        CannedQueryDAOTest.assertEquals((String)"Incorrect result count.", (long)2L, (long)count);
    }

    public void testExecute_BadBounds() throws Throwable {
        try {
            this.cannedQueryDAO.executeQuery(QUERY_NS, QUERY_SELECT_MIMETYPES, null, -1, 10);
            CannedQueryDAOTest.fail((String)"Illegal parameter not detected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.cannedQueryDAO.executeQuery(QUERY_NS, QUERY_SELECT_MIMETYPES, null, 0, -1);
            CannedQueryDAOTest.fail((String)"Illegal parameter not detected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExecute_ListMimetypes() throws Throwable {
        RetryingTransactionHelper.RetryingTransactionCallback<List<String>> selectCallback = new RetryingTransactionHelper.RetryingTransactionCallback<List<String>>(){

            @Override
            public List<String> execute() throws Throwable {
                TestOneParams params = new TestOneParams(null, false);
                return CannedQueryDAOTest.this.cannedQueryDAO.executeQuery(CannedQueryDAOTest.QUERY_NS, CannedQueryDAOTest.QUERY_SELECT_MIMETYPES, params, 0, 2);
            }
        };
        List<String> mimetypes = this.txnHelper.doInTransaction(selectCallback, true);
        CannedQueryDAOTest.assertNotNull(mimetypes);
        CannedQueryDAOTest.assertTrue((String)"Too many results", (mimetypes.size() <= 2 ? 1 : 0) != 0);
    }

    public void testExecute_ResultHandlerWithError() throws Throwable {
        final CannedQueryDAO.ResultHandler<String> resultHandler = new CannedQueryDAO.ResultHandler<String>(){

            @Override
            public boolean handleResult(String result) {
                throw new UnsupportedOperationException();
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<List<String>> selectCallback = new RetryingTransactionHelper.RetryingTransactionCallback<List<String>>(){

            @Override
            public List<String> execute() throws Throwable {
                TestOneParams params;
                block2: {
                    params = new TestOneParams(null, false);
                    try {
                        CannedQueryDAOTest.this.cannedQueryDAO.executeQuery(CannedQueryDAOTest.QUERY_NS, CannedQueryDAOTest.QUERY_SELECT_MIMETYPES, params, 0, 2, resultHandler);
                        Assert.fail((String)"Expected UnsupportedOperationException");
                    }
                    catch (Exception e) {
                        Throwable ee = ExceptionStackUtil.getCause((Throwable)e, (Class[])new Class[]{UnsupportedOperationException.class});
                        if (ee != null) break block2;
                        throw e;
                    }
                }
                return CannedQueryDAOTest.this.cannedQueryDAO.executeQuery(CannedQueryDAOTest.QUERY_NS, CannedQueryDAOTest.QUERY_SELECT_MIMETYPES, params, 0, 2);
            }
        };
        List<String> mimetypes = this.txnHelper.doInTransaction(selectCallback, true);
        CannedQueryDAOTest.assertNotNull(mimetypes);
        CannedQueryDAOTest.assertTrue((String)"Too many results", (mimetypes.size() <= 2 ? 1 : 0) != 0);
    }

    public void testExecute_ResultHandlerWithEarlyTermination() throws Throwable {
        final ArrayList results = new ArrayList();
        final CannedQueryDAO.ResultHandler<String> resultHandler = new CannedQueryDAO.ResultHandler<String>(){

            @Override
            public boolean handleResult(String result) {
                results.add(result);
                return false;
            }
        };
        RetryingTransactionHelper.RetryingTransactionCallback<Void> selectCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TestOneParams params = new TestOneParams(null, false);
                CannedQueryDAOTest.this.cannedQueryDAO.executeQuery(CannedQueryDAOTest.QUERY_NS, CannedQueryDAOTest.QUERY_SELECT_MIMETYPES, params, 0, 2, resultHandler);
                return null;
            }
        };
        this.txnHelper.doInTransaction(selectCallback, true);
        CannedQueryDAOTest.assertEquals((String)"ResultHandler did not terminate early", (int)1, (int)results.size());
    }

    public static class TestOneParams {
        private final String mimetypeMatch;
        private final boolean exact;
        private boolean forceFail;

        public TestOneParams(String mimetypeMatch, boolean exact) {
            this.mimetypeMatch = mimetypeMatch;
            this.exact = exact;
            this.forceFail = false;
        }

        public String toString() {
            return "TestOneParams [mimetypeMatch=" + this.mimetypeMatch + ", exact=" + this.exact + "]";
        }

        public String getMimetypeMatch() {
            return this.mimetypeMatch;
        }

        public boolean isExact() {
            return this.exact;
        }

        public boolean isForceFail() {
            return this.forceFail;
        }

        public void setForceFail(boolean forceFail) {
            this.forceFail = forceFail;
        }
    }
}

