/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.solr.ibatis;

import java.util.List;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.solr.NodeParametersEntity;
import org.alfresco.repo.domain.solr.SOLRDAO;
import org.alfresco.repo.domain.solr.SOLRTrackingParameters;
import org.alfresco.repo.solr.Acl;
import org.alfresco.repo.solr.AclChangeSet;
import org.alfresco.repo.solr.NodeParameters;
import org.alfresco.repo.solr.Transaction;
import org.alfresco.util.PropertyCheck;
import org.apache.ibatis.session.RowBounds;
import org.mybatis.spring.SqlSessionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOLRDAOImpl
implements SOLRDAO {
    private static final String SELECT_CHANGESETS_SUMMARY = "alfresco.solr.select_ChangeSets_Summary";
    private static final String SELECT_ACLS_BY_CHANGESET_IDS = "alfresco.solr.select_AclsByChangeSetIds";
    private static final String SELECT_TRANSACTIONS = "alfresco.solr.select_Txns";
    private static final String SELECT_NODES = "alfresco.solr.select_Txn_Nodes";
    private SqlSessionTemplate template;
    private QNameDAO qnameDAO;

    public final void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.template = sqlSessionTemplate;
    }

    public void setQNameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"template", (Object)this.template);
        PropertyCheck.mandatory((Object)this, (String)"qnameDAO", (Object)this.qnameDAO);
    }

    @Override
    public List<AclChangeSet> getAclChangeSets(Long minAclChangeSetId, Long fromCommitTime, Long maxAclChangeSetId, Long toCommitTime, int maxResults) {
        if (maxResults <= 0 || maxResults == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Maximum results must be a reasonable number.");
        }
        SOLRTrackingParameters params = new SOLRTrackingParameters();
        params.setFromIdInclusive(minAclChangeSetId);
        params.setFromCommitTimeInclusive(fromCommitTime);
        params.setToIdExclusive(maxAclChangeSetId);
        params.setToCommitTimeExclusive(toCommitTime);
        return this.template.selectList(SELECT_CHANGESETS_SUMMARY, (Object)params, new RowBounds(0, maxResults));
    }

    @Override
    public List<Acl> getAcls(List<Long> aclChangeSetIds, Long minAclId, int maxResults) {
        if (maxResults <= 0 || maxResults == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Maximum results must be a reasonable number.");
        }
        if (aclChangeSetIds == null || aclChangeSetIds.size() == 0) {
            throw new IllegalArgumentException("'aclChangeSetIds' must contain IDs.");
        }
        if (aclChangeSetIds.size() > 512) {
            throw new IllegalArgumentException("'aclChangeSetIds' cannot have more than 512 entries.");
        }
        SOLRTrackingParameters params = new SOLRTrackingParameters();
        params.setIds(aclChangeSetIds);
        params.setFromIdInclusive(minAclId);
        return this.template.selectList(SELECT_ACLS_BY_CHANGESET_IDS, (Object)params, new RowBounds(0, maxResults));
    }

    @Override
    public List<Transaction> getTransactions(Long minTxnId, Long fromCommitTime, Long maxTxnId, Long toCommitTime, int maxResults) {
        if (maxResults <= 0 || maxResults == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Maximum results must be a reasonable number.");
        }
        SOLRTrackingParameters params = new SOLRTrackingParameters();
        params.setFromIdInclusive(minTxnId);
        params.setFromCommitTimeInclusive(fromCommitTime);
        params.setToIdExclusive(maxTxnId);
        params.setToCommitTimeExclusive(toCommitTime);
        return this.template.selectList(SELECT_TRANSACTIONS, (Object)params, new RowBounds(0, maxResults));
    }

    @Override
    public List<Node> getNodes(NodeParameters nodeParameters) {
        NodeParametersEntity params = new NodeParametersEntity(nodeParameters, this.qnameDAO);
        if (nodeParameters.getMaxResults() != 0 && nodeParameters.getMaxResults() != Integer.MAX_VALUE) {
            return this.template.selectList(SELECT_NODES, (Object)params, new RowBounds(0, nodeParameters.getMaxResults()));
        }
        return this.template.selectList(SELECT_NODES, (Object)params);
    }
}

