/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.forms.AssociationFieldDefinition;
import org.alfresco.repo.forms.FieldDefinition;
import org.alfresco.repo.forms.Form;
import org.alfresco.repo.forms.FormNotFoundException;
import org.alfresco.repo.forms.FormService;
import org.alfresco.repo.forms.Item;
import org.alfresco.repo.forms.PropertyFieldDefinition;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ApplicationContextHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionFormProcessorTest {
    private static final ApplicationContext testContext = ApplicationContextHelper.getApplicationContext();
    private static ContentService CONTENT_SERVICE;
    private static FormService FORM_SERVICE;
    private static NamespaceService NAMESPACE_SERVICE;
    private static NodeService NODE_SERVICE;
    private static Repository REPOSITORY_HELPER;
    private static RetryingTransactionHelper TRANSACTION_HELPER;
    private NodeRef testNode;
    private List<NodeRef> testNodesToBeTidiedUp;

    @BeforeClass
    public static void initTestsContext() throws Exception {
        CONTENT_SERVICE = (ContentService)testContext.getBean("ContentService");
        FORM_SERVICE = (FormService)testContext.getBean("FormService");
        NAMESPACE_SERVICE = (NamespaceService)testContext.getBean("NamespaceService");
        NODE_SERVICE = (NodeService)testContext.getBean("NodeService");
        REPOSITORY_HELPER = (Repository)testContext.getBean("repositoryHelper");
        TRANSACTION_HELPER = (RetryingTransactionHelper)testContext.getBean("retryingTransactionHelper");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
    }

    @Before
    public void createTestObjects() throws Exception {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef companyHome = REPOSITORY_HELPER.getCompanyHome();
                ActionFormProcessorTest.this.testNode = ActionFormProcessorTest.this.createNode(companyHome, "testDoc" + ActionFormProcessorTest.class.getSimpleName() + ".txt", ContentModel.TYPE_CONTENT);
                ContentWriter writer = CONTENT_SERVICE.getWriter(ActionFormProcessorTest.this.testNode, ContentModel.PROP_CONTENT, true);
                writer.setMimetype("text/plain");
                writer.setEncoding("UTF-8");
                writer.putContent("Irrelevant content");
                return null;
            }
        });
        this.testNodesToBeTidiedUp = new ArrayList<NodeRef>();
        this.testNodesToBeTidiedUp.add(this.testNode);
    }

    private NodeRef createNode(NodeRef parentNode, String name, QName type) {
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, name);
        QName docContentQName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)name);
        NodeRef node = NODE_SERVICE.createNode(parentNode, ContentModel.ASSOC_CONTAINS, docContentQName, type, props).getChildRef();
        return node;
    }

    @After
    public void tidyUpTestNodes() throws Exception {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                for (NodeRef node : ActionFormProcessorTest.this.testNodesToBeTidiedUp) {
                    if (!NODE_SERVICE.exists(node)) continue;
                    NODE_SERVICE.deleteNode(node);
                }
                return null;
            }
        });
    }

    @Test(expected=FormNotFoundException.class)
    public void requestFormForNonExistentAction() throws Exception {
        FORM_SERVICE.getForm(new Item("action", "noSuchActionBean"));
    }

    @Test
    public void generateDefaultFormForParameterlessAction() throws Exception {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Form form = FORM_SERVICE.getForm(new Item("action", "extract-metadata"));
                Assert.assertNotNull((String)"Expecting form to be present", (Object)form);
                List<FieldDefinition> fieldDefs = form.getFieldDefinitions();
                Assert.assertEquals((String)"Wrong number of fieldDefs", (long)1L, (long)fieldDefs.size());
                HashMap<String, FieldDefinition> fieldDefMap = new HashMap<String, FieldDefinition>(fieldDefs.size());
                for (FieldDefinition fieldDef : fieldDefs) {
                    fieldDefMap.put(fieldDef.getName(), fieldDef);
                }
                ActionFormProcessorTest.this.validateExecuteAsynchronouslyField(fieldDefMap);
                return null;
            }
        });
    }

    @Test
    public void generateDefaultFormForActionWithNodeRefParam() throws Exception {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Form form = FORM_SERVICE.getForm(new Item("action", "script"));
                Assert.assertNotNull((String)"Expecting form to be present", (Object)form);
                List<FieldDefinition> fieldDefs = form.getFieldDefinitions();
                Assert.assertEquals((String)"Wrong number of fieldDefs", (long)2L, (long)fieldDefs.size());
                HashMap<String, FieldDefinition> fieldDefMap = new HashMap<String, FieldDefinition>(fieldDefs.size());
                for (FieldDefinition fieldDef : fieldDefs) {
                    fieldDefMap.put(fieldDef.getName(), fieldDef);
                }
                ActionFormProcessorTest.this.validateExecuteAsynchronouslyField(fieldDefMap);
                PropertyFieldDefinition scriptRef = (PropertyFieldDefinition)fieldDefMap.get("script-ref");
                Assert.assertNotNull((String)"'script-ref' field defn was missing.", (Object)scriptRef);
                Assert.assertEquals((Object)"script-ref", (Object)scriptRef.getName());
                Assert.assertEquals((Object)"Script", (Object)scriptRef.getLabel());
                Assert.assertEquals((Object)"script-ref", (Object)scriptRef.getDescription());
                Assert.assertEquals((Object)"text", (Object)scriptRef.getDataType());
                Assert.assertTrue((boolean)scriptRef.isMandatory());
                List<PropertyFieldDefinition.FieldConstraint> constraints = scriptRef.getConstraints();
                Assert.assertEquals((long)1L, (long)constraints.size());
                Assert.assertEquals((Object)"LIST", (Object)constraints.get(0).getType());
                return null;
            }
        });
    }

    private void validateExecuteAsynchronouslyField(Map<String, FieldDefinition> fieldDefMap) {
        PropertyFieldDefinition execAsync = (PropertyFieldDefinition)fieldDefMap.get("executeAsynchronously");
        Assert.assertNotNull((String)"'executeAsynchronously' field defn was missing.", (Object)execAsync);
        Assert.assertEquals((String)"'executeAsynchronously' name was wrong", (Object)"executeAsynchronously", (Object)execAsync.getName());
        Assert.assertEquals((String)"'executeAsynchronously' label was wrong", (Object)"executeAsynchronously", (Object)execAsync.getLabel());
        Assert.assertNull((String)"'executeAsynchronously' description was wrong", (Object)execAsync.getDescription());
        Assert.assertEquals((String)"'executeAsynchronously' datatype was wrong", (Object)"boolean", (Object)execAsync.getDataType());
    }

    @Test
    public void generateFormWithSelectedFields() throws Exception {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ArrayList<String> fields = new ArrayList<String>();
                fields.add("destination-folder");
                fields.add("executeAsynchronously");
                Form form = FORM_SERVICE.getForm(new Item("action", "move"), fields);
                Assert.assertNotNull((String)"Expecting form to be present", (Object)form);
                List<FieldDefinition> fieldDefs = form.getFieldDefinitions();
                HashMap<String, FieldDefinition> fieldDefMap = new HashMap<String, FieldDefinition>(fieldDefs.size());
                for (FieldDefinition fieldDef : fieldDefs) {
                    fieldDefMap.put(fieldDef.getName(), fieldDef);
                }
                Assert.assertEquals((long)2L, (long)fieldDefMap.size());
                AssociationFieldDefinition destFolderField = (AssociationFieldDefinition)fieldDefMap.get("destination-folder");
                Assert.assertNotNull((Object)destFolderField);
                PropertyFieldDefinition execAsyncField = (PropertyFieldDefinition)fieldDefMap.get("executeAsynchronously");
                Assert.assertNotNull((Object)execAsyncField);
                return null;
            }
        });
    }

    @Test
    public void persistForm_executeTransformAction() throws Exception {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Form form = FORM_SERVICE.getForm(new Item("action", "transform"));
                form.addData("alf_destination", ActionFormProcessorTest.this.testNode.toString());
                form.addData("prop_mime-type", "application/pdf");
                form.addData("prop_destination-folder", REPOSITORY_HELPER.getCompanyHome().toString());
                form.addData("prop_assoc-type", ContentModel.ASSOC_CONTAINS.toPrefixString((NamespacePrefixResolver)NAMESPACE_SERVICE));
                form.addData("prop_assoc-name", ContentModel.ASSOC_CONTAINS.toPrefixString((NamespacePrefixResolver)NAMESPACE_SERVICE));
                FORM_SERVICE.saveForm(form.getItem(), form.getFormData());
                for (ChildAssociationRef chAssRef : NODE_SERVICE.getChildAssocs(REPOSITORY_HELPER.getCompanyHome())) {
                    System.err.println(NODE_SERVICE.getProperty(chAssRef.getChildRef(), ContentModel.PROP_NAME));
                }
                Serializable cmName = NODE_SERVICE.getProperty(ActionFormProcessorTest.this.testNode, ContentModel.PROP_NAME);
                String transformedNodeName = ((String)((Object)cmName)).replace(".txt", ".pdf");
                NodeRef expectedTransformedNode = NODE_SERVICE.getChildByName(REPOSITORY_HELPER.getCompanyHome(), ContentModel.ASSOC_CONTAINS, transformedNodeName);
                Assert.assertNotNull((String)"transformed node was missing", (Object)expectedTransformedNode);
                ActionFormProcessorTest.this.testNodesToBeTidiedUp.add(expectedTransformedNode);
                return null;
            }
        });
    }
}

