/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMultipart;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteLoadTester
extends TestCase {
    private Log logger = LogFactory.getLog(RemoteLoadTester.class);
    private static final String USER_NAME = "test_imap_user";
    private static final String USER_PASSWORD = "test_imap_user";
    private static final String TEST_FOLDER_NAME = "test_imap1000";
    private static final String ADMIN_USER_NAME = "admin";
    private static String REMOTE_HOST = "127.0.0.1";

    public static void main(String[] args) {
        if (args.length > 0) {
            REMOTE_HOST = args[0];
        }
        new RemoteLoadTester().testListSequence();
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void testListSequence() {
        block11: {
            System.out.println(String.format("Connecting to remote server '%s'", REMOTE_HOST));
            Properties props = System.getProperties();
            props.setProperty("mail.imap.partialfetch", "false");
            Session session = Session.getDefaultInstance((Properties)props, null);
            Store store = null;
            long startTime = 0L;
            long endTime = 0L;
            store = session.getStore("imap");
            store.connect(REMOTE_HOST, ADMIN_USER_NAME, ADMIN_USER_NAME);
            Folder[] folders = null;
            startTime = System.currentTimeMillis();
            folders = store.getDefaultFolder().list("");
            endTime = System.currentTimeMillis();
            System.out.println(String.format("LIST '', folders.length = %d, execTime = %d sec", folders.length, (endTime - startTime) / 1000L));
            startTime = System.currentTimeMillis();
            folders = store.getDefaultFolder().list("*");
            endTime = System.currentTimeMillis();
            System.out.println(String.format("LIST *, folders.length = %d, execTime = %d sec", folders.length, (endTime - startTime) / 1000L));
            startTime = System.currentTimeMillis();
            folders = store.getDefaultFolder().listSubscribed("*");
            endTime = System.currentTimeMillis();
            System.out.println(String.format("LSUB *, folders.length = %d, execTime = %d sec", folders.length, (endTime - startTime) / 1000L));
            startTime = System.currentTimeMillis();
            for (Folder folder : folders) {
                folder.getMessageCount();
            }
            endTime = System.currentTimeMillis();
            System.out.println(String.format("Folders Loop, folders.length = %d, execTime = %d sec", folders.length, (endTime - startTime) / 1000L));
            Object var14_13 = null;
            try {
                store.close();
            }
            catch (MessagingException e2) {
                System.err.println(e2.getMessage());
            }
            break block11;
            {
                catch (NoSuchProviderException e) {
                    e.printStackTrace();
                    Object var14_14 = null;
                    try {
                        store.close();
                    }
                    catch (MessagingException e2) {
                        System.err.println(e2.getMessage());
                    }
                    break block11;
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                    Object var14_15 = null;
                    try {
                        store.close();
                    }
                    catch (MessagingException e2) {
                        System.err.println(e2.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                try {
                    store.close();
                }
                catch (MessagingException e2) {
                    System.err.println(e2.getMessage());
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void testMailbox() {
        block25: {
            this.logger.info((Object)"Getting folder...");
            long t = System.currentTimeMillis();
            Properties props = new Properties();
            props.setProperty("mail.imap.partialfetch", "false");
            Session session = Session.getDefaultInstance((Properties)props, null);
            Store store = null;
            Folder folder = null;
            store = session.getStore("imap");
            store.connect(REMOTE_HOST, "test_imap_user", "test_imap_user");
            folder = store.getFolder(TEST_FOLDER_NAME);
            folder.open(1);
            Message[] message = folder.getMessages();
            int n = message.length;
            for (int i = 0; i < n; ++i) {
                message[i].getAllHeaders();
                Address[] from = message[i].getFrom();
                System.out.print(i + ": ");
                if (from != null) {
                    System.out.print(message[i].getFrom()[0] + "\t");
                }
                System.out.println(message[i].getSubject());
                Object content = message[i].getContent();
                if (content instanceof MimeMultipart) {
                    int m = ((MimeMultipart)content).getCount();
                    for (int j = 0; j < m; ++j) {
                        BodyPart part = ((MimeMultipart)content).getBodyPart(j);
                        Object partContent = part.getContent();
                        if (partContent instanceof String) {
                            String body = (String)partContent;
                            continue;
                        }
                        if (!(partContent instanceof FilterInputStream)) continue;
                        FilterInputStream fis = (FilterInputStream)partContent;
                        BufferedInputStream bis = new BufferedInputStream(fis);
                        byte[] bytes = new byte[524288];
                        while (bis.read(bytes) != -1) {
                        }
                        bis.close();
                        fis.close();
                    }
                }
                boolean nn = false;
            }
            t = System.currentTimeMillis() - t;
            this.logger.info((Object)("Time: " + t + " ms (" + t / 1000L + " s)"));
            this.logger.info((Object)("Length: " + message.length));
            Object var20_19 = null;
            try {
                if (folder != null) {
                    folder.close(false);
                }
            }
            catch (MessagingException e2) {
                this.logger.error((Object)e2.getMessage(), (Throwable)e2);
                RemoteLoadTester.fail((String)e2.getMessage());
            }
            try {
                if (store != null) {
                    store.close();
                }
                break block25;
            }
            catch (MessagingException e2) {
                this.logger.error((Object)e2.getMessage(), (Throwable)e2);
                RemoteLoadTester.fail((String)e2.getMessage());
            }
            break block25;
            {
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                    RemoteLoadTester.fail((String)e.getMessage());
                    Object var20_20 = null;
                    try {
                        if (folder != null) {
                            folder.close(false);
                        }
                    }
                    catch (MessagingException e2) {
                        this.logger.error((Object)e2.getMessage(), (Throwable)e2);
                        RemoteLoadTester.fail((String)e2.getMessage());
                    }
                    try {
                        if (store != null) {
                            store.close();
                        }
                        break block25;
                    }
                    catch (MessagingException e2) {
                        this.logger.error((Object)e2.getMessage(), (Throwable)e2);
                        RemoteLoadTester.fail((String)e2.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var20_21 = null;
                try {
                    if (folder != null) {
                        folder.close(false);
                    }
                }
                catch (MessagingException e2) {
                    this.logger.error((Object)e2.getMessage(), (Throwable)e2);
                    RemoteLoadTester.fail((String)e2.getMessage());
                }
                try {
                    if (store != null) {
                        store.close();
                    }
                }
                catch (MessagingException e2) {
                    this.logger.error((Object)e2.getMessage(), (Throwable)e2);
                    RemoteLoadTester.fail((String)e2.getMessage());
                }
                throw throwable;
            }
        }
    }
}

