/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.invitation.AbstractInvitationServiceImplTest;
import org.alfresco.repo.invitation.WorkflowModelNominatedInvitation;
import org.alfresco.service.cmr.invitation.Invitation;
import org.alfresco.service.cmr.invitation.NominatedInvitation;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.namespace.QName;

public class ActivitiInvitationServiceImplTests
extends AbstractInvitationServiceImplTest {
    private WorkflowService workflowService;

    public void testWorkflowTaskContainsProps() {
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = "InvitationTest";
        String inviteeRole = "SiteCollaborator";
        String serverPath = "wibble";
        String acceptUrl = "froob";
        String rejectUrl = "marshmallow";
        NominatedInvitation nomInvite = this.invitationService.inviteNominated("InvitationServiceAlice", resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        WorkflowTask task = this.getTaskForInvitation(nomInvite);
        Map<QName, Serializable> props = task.getProperties();
        ActivitiInvitationServiceImplTests.assertEquals((Object)inviteeRole, (Object)props.get(WorkflowModelNominatedInvitation.WF_PROP_INVITEE_ROLE));
        ActivitiInvitationServiceImplTests.assertEquals((Object)nomInvite.getResourceDescription(), (Object)props.get(WorkflowModelNominatedInvitation.WF_PROP_RESOURCE_DESCRIPTION));
        ActivitiInvitationServiceImplTests.assertEquals((Object)nomInvite.getResourceTitle(), (Object)props.get(WorkflowModelNominatedInvitation.WF_PROP_RESOURCE_TITLE));
        this.invitationService.accept(nomInvite.getInviteId(), nomInvite.getTicket());
        task = this.workflowService.getTaskById(task.getId());
        props = task.getProperties();
        ActivitiInvitationServiceImplTests.assertEquals((Object)inviteeRole, (Object)props.get(WorkflowModelNominatedInvitation.WF_PROP_INVITEE_ROLE));
        ActivitiInvitationServiceImplTests.assertEquals((Object)nomInvite.getResourceDescription(), (Object)props.get(WorkflowModelNominatedInvitation.WF_PROP_RESOURCE_DESCRIPTION));
        ActivitiInvitationServiceImplTests.assertEquals((Object)nomInvite.getResourceTitle(), (Object)props.get(WorkflowModelNominatedInvitation.WF_PROP_RESOURCE_TITLE));
    }

    private WorkflowTask getTaskForInvitation(Invitation invite) {
        String instanceId = invite.getInviteId();
        List<WorkflowPath> paths = this.workflowService.getWorkflowPaths(instanceId);
        ActivitiInvitationServiceImplTests.assertEquals((int)1, (int)paths.size());
        WorkflowPath path = paths.get(0);
        List<WorkflowTask> tasks = this.workflowService.getTasksForWorkflowPath(path.getId());
        ActivitiInvitationServiceImplTests.assertEquals((int)1, (int)tasks.size());
        WorkflowTask task = tasks.get(0);
        return task;
    }

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.workflowService = (WorkflowService)this.applicationContext.getBean("WorkflowService");
        this.workflowAdminService.setEnabledEngines(Arrays.asList("jbpm"));
        String invitee = "InvitationServiceAlice";
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = "InvitationTest";
        String inviteeRole = "SiteCollaborator";
        String serverPath = "wibble";
        String acceptUrl = "froob";
        String rejectUrl = "marshmallow";
        this.authenticationComponent.setCurrentUser("InvitationServiceManagerOne");
        this.invitationService.inviteNominated(invitee, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        this.invitationService.inviteModerated("", invitee, resourceType, resourceName, inviteeRole);
        this.workflowAdminService.setEnabledEngines(Arrays.asList("activiti"));
    }
}

