/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation;

import java.util.Map;
import org.alfresco.service.cmr.invitation.Invitation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class InvitationImpl {
    public static final String ID_KEY = "id";
    public static final String INVITEE_KEY = "invitee";
    public static final String RESOURCE_NAME_KEY = "resourceName";
    public static final String RESOURCE_TYPE_KEY = "resourceType";
    public static final String ROLE_KEY = "role";
    private final String inviteId;
    private final String resourceName;
    private final Invitation.ResourceType resourceType;
    private final String roleName;
    private final String inviteeUserName;

    public InvitationImpl(Map<String, String> props) {
        this.inviteId = props.get(ID_KEY);
        this.inviteeUserName = props.get(INVITEE_KEY);
        this.resourceName = props.get(RESOURCE_NAME_KEY);
        this.roleName = props.get(ROLE_KEY);
        String type = props.get(RESOURCE_TYPE_KEY);
        this.resourceType = type == null ? Invitation.ResourceType.WEB_SITE : Invitation.ResourceType.valueOf(type);
    }

    public Invitation.ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getInviteId() {
        return this.inviteId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getInviteeUserName() {
        return this.inviteeUserName;
    }

    public abstract Invitation.InvitationType getInvitationType();
}

