/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.invitation.ModeratedActionReject;
import org.alfresco.repo.invitation.WorkflowModelNominatedInvitation;
import org.alfresco.repo.invitation.site.InviteInfo;
import org.alfresco.repo.invitation.site.InviteSender;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.invitation.Invitation;
import org.alfresco.service.cmr.invitation.InvitationExceptionForbidden;
import org.alfresco.service.cmr.invitation.InvitationService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TemplateService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.collections.CollectionUtils;
import org.alfresco.util.collections.Filter;
import org.alfresco.util.collections.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InviteHelper
implements InitializingBean {
    public static final String NAME = "InviteHelper";
    private static final String MSG_NOT_SITE_MANAGER = "invitation.cancel.not_site_manager";
    private static final String REJECT_TEMPLATE = "/alfresco/bootstrap/invite/moderated-reject-email.ftl";
    private static final Log logger = LogFactory.getLog(ModeratedActionReject.class);
    private static final Collection<String> sendInvitePropertyNames = Arrays.asList("inwf_inviteeUserName", "inwf_resourceName", "inwf_inviterUserName", "inwf_inviteeUserName", "inwf_inviteeRole", "inwf_inviteeGenPassword", "inwf_resourceName", "inwf_inviteTicket", "inwf_serverPath", "inwf_acceptUrl", "inwf_rejectUrl", "wf_instanceId");
    private Repository repositoryHelper;
    private ServiceRegistry serviceRegistry;
    private ActionService actionService;
    private InvitationService invitationService;
    private MutableAuthenticationService authenticationService;
    private MessageService messageService;
    private NamespaceService namespaceService;
    private PersonService personService;
    private SiteService siteService;
    private TemplateService templateService;
    private WorkflowService workflowService;
    private InviteSender inviteSender;

    public void afterPropertiesSet() {
        this.actionService = this.serviceRegistry.getActionService();
        this.authenticationService = this.serviceRegistry.getAuthenticationService();
        this.invitationService = this.serviceRegistry.getInvitationService();
        this.namespaceService = this.serviceRegistry.getNamespaceService();
        this.personService = this.serviceRegistry.getPersonService();
        this.siteService = this.serviceRegistry.getSiteService();
        this.templateService = this.serviceRegistry.getTemplateService();
        this.workflowService = this.serviceRegistry.getWorkflowService();
        this.inviteSender = new InviteSender(this.serviceRegistry, this.repositoryHelper, this.messageService);
    }

    public void acceptNominatedInvitation(Map<String, Object> executionVariables) {
        final String invitee = (String)executionVariables.get("inwf_inviteeUserName");
        String siteShortName = (String)executionVariables.get("inwf_resourceName");
        String inviter = (String)executionVariables.get("inwf_inviterUserName");
        String role = (String)executionVariables.get("inwf_inviteeRole");
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                if (!InviteHelper.this.authenticationService.getAuthenticationEnabled(invitee)) {
                    InviteHelper.this.authenticationService.setAuthenticationEnabled(invitee, true);
                }
                return null;
            }
        });
        this.addSiteMembership(invitee, siteShortName, role, inviter, false);
    }

    public WorkflowTask findInviteStartTask(String inviteId) {
        return this.workflowService.getStartTask(inviteId);
    }

    public List<WorkflowTask> findInvitePendingTasks(String inviteeUserName) {
        List<WorkflowTask> tasks = this.workflowService.getAssignedTasks(inviteeUserName, WorkflowTaskState.IN_PROGRESS);
        return CollectionUtils.filter(tasks, (Function)new Filter<WorkflowTask>(){

            public Boolean apply(WorkflowTask value) {
                QName taskDefName = value.getDefinition().getMetadata().getName();
                return WorkflowModelNominatedInvitation.WF_TASK_INVITE_PENDING.equals((Object)taskDefName) || WorkflowModelNominatedInvitation.WF_TASK_ACTIVIT_INVITE_PENDING.equals((Object)taskDefName);
            }
        });
    }

    public InviteInfo getPendingInviteInfo(WorkflowTask startInviteTask) {
        Map<QName, Serializable> taskProps = startInviteTask.getProperties();
        String inviterUserName = (String)((Object)taskProps.get(WorkflowModelNominatedInvitation.WF_PROP_INVITER_USER_NAME));
        String inviteeUserName = (String)((Object)taskProps.get(WorkflowModelNominatedInvitation.WF_PROP_INVITEE_USER_NAME));
        String role = (String)((Object)taskProps.get(WorkflowModelNominatedInvitation.WF_PROP_INVITEE_ROLE));
        String siteShortName = (String)((Object)taskProps.get(WorkflowModelNominatedInvitation.WF_PROP_RESOURCE_NAME));
        SiteInfo siteInfo = this.siteService.getSite(siteShortName);
        String workflowId = startInviteTask.getPath().getInstance().getId();
        Date sentInviteDate = startInviteTask.getPath().getInstance().getStartDate();
        String invitationStatus = "pending";
        NodeRef inviterRef = this.personService.getPerson(inviterUserName);
        TemplateNode inviterPerson = inviterRef == null ? null : new TemplateNode(inviterRef, this.serviceRegistry, null);
        NodeRef inviteeRef = this.personService.getPerson(inviteeUserName);
        TemplateNode inviteePerson = inviteeRef == null ? null : new TemplateNode(inviteeRef, this.serviceRegistry, null);
        return new InviteInfo(invitationStatus, inviterUserName, inviterPerson, inviteeUserName, inviteePerson, role, siteShortName, siteInfo, sentInviteDate, workflowId);
    }

    public void addSiteMembership(final String invitee, final String siteName, final String role, String runAsUser, final boolean overrideExisting) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                if (overrideExisting || !InviteHelper.this.siteService.isMember(siteName, invitee)) {
                    InviteHelper.this.siteService.setMembership(siteName, invitee, role);
                }
                return null;
            }
        }, (String)runAsUser);
    }

    public void deleteAuthenticationIfUnused(final String inviteeUserName, final String currentInviteId) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                Invitation pendingInvite;
                boolean invitesPending;
                List<Invitation> pendingInvites = InviteHelper.this.invitationService.listPendingInvitationsForInvitee(inviteeUserName);
                boolean bl = invitesPending = !CollectionUtils.isEmpty(pendingInvites);
                if (invitesPending && pendingInvites.size() == 1 && (pendingInvite = pendingInvites.get(0)).getInviteId().equals(currentInviteId)) {
                    invitesPending = false;
                }
                if (InviteHelper.this.authenticationService.authenticationExists(inviteeUserName) && !InviteHelper.this.authenticationService.getAuthenticationEnabled(inviteeUserName) && !invitesPending) {
                    InviteHelper.this.authenticationService.deleteAuthentication(inviteeUserName);
                    if (InviteHelper.this.personService.personExists(inviteeUserName)) {
                        InviteHelper.this.personService.deletePerson(inviteeUserName);
                    }
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public void cancelInvitation(Map<String, Object> executionVariables, String currentInviteId) {
        String currentUserName;
        String inviteeUserName = (String)executionVariables.get("inwf_inviteeUserName");
        String siteShortName = (String)executionVariables.get("inwf_resourceName");
        String currentUserSiteRole = this.siteService.getMembersRole(siteShortName, currentUserName = this.authenticationService.getCurrentUserName());
        if (!"SiteManager".equals(currentUserSiteRole)) {
            String inviteId = (String)executionVariables.get("workflowinstanceid");
            Object[] args = new Object[]{currentUserName, inviteId, siteShortName};
            throw new InvitationExceptionForbidden(MSG_NOT_SITE_MANAGER, args);
        }
        this.deleteAuthenticationIfUnused(inviteeUserName, currentInviteId);
    }

    public void sendNominatedInvitation(String inviteId, Map<String, Object> executionVariables) {
        if (this.invitationService.isSendEmails()) {
            Map<String, String> properties = this.makePropertiesFromContextVariables(executionVariables, sendInvitePropertyNames);
            String packageName = WorkflowModel.ASSOC_PACKAGE.toPrefixString((NamespacePrefixResolver)this.namespaceService).replace(":", "_");
            ScriptNode packageNode = (ScriptNode)executionVariables.get(packageName);
            String packageRef = packageNode.getNodeRef().toString();
            properties.put("wf_package", packageRef);
            properties.put("wf_instanceId", inviteId);
            this.inviteSender.sendMail(properties);
        }
    }

    public void approveModeratedInvitation(Map<String, Object> executionVariables) {
        String siteName = (String)executionVariables.get("imwf_resourceName");
        String invitee = (String)executionVariables.get("imwf_inviteeUserName");
        String role = (String)executionVariables.get("imwf_inviteeRole");
        String reviewer = (String)executionVariables.get("imwf_reviewer");
        this.addSiteMembership(invitee, siteName, role, reviewer, true);
    }

    private Map<String, String> makePropertiesFromContextVariables(Map<?, ?> executionVariables, Collection<String> propertyNames) {
        return CollectionUtils.filterKeys(executionVariables, (Function)CollectionUtils.containsFilter(propertyNames));
    }

    public void rejectModeratedInvitation(Map<String, Object> vars) {
        if (!this.invitationService.isSendEmails()) {
            return;
        }
        String resourceType = (String)vars.get("imwf_resourceType");
        String resourceName = (String)vars.get("imwf_resourceName");
        String inviteeUserName = (String)vars.get("imwf_inviteeUserName");
        String inviteeRole = (String)vars.get("imwf_inviteeRole");
        String reviewer = (String)vars.get("imwf_reviewer");
        String reviewComments = (String)vars.get("imwf_reviewComments");
        try {
            HashMap<String, String> model = new HashMap<String, String>(8, 1.0f);
            model.put("resourceName", resourceName);
            model.put("resourceType", resourceType);
            model.put("inviteeRole", inviteeRole);
            model.put("reviewComments", reviewComments);
            model.put("reviewer", reviewer);
            model.put("inviteeUserName", inviteeUserName);
            String emailMsg = this.templateService.processTemplate("freemarker", REJECT_TEMPLATE, model);
            Action emailAction = this.actionService.createAction("mail");
            emailAction.setParameterValue("to", (Serializable)((Object)inviteeUserName));
            emailAction.setParameterValue("from", (Serializable)((Object)reviewer));
            emailAction.setParameterValue("subject", (Serializable)((Object)("Rejected invitation to web site:" + resourceName)));
            emailAction.setParameterValue("text", (Serializable)((Object)emailMsg));
            emailAction.setExecuteAsynchronously(true);
            this.actionService.executeAction(emailAction, null);
        }
        catch (Exception e) {
            logger.error((Object)"unable to send reject email", (Throwable)e);
        }
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setRepositoryHelper(Repository repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }
}

