/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation.site;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.SysAdminParamsImpl;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.repo.invitation.site.InviteSender;
import org.alfresco.repo.model.Repository;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.admin.RepoUsage;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.springframework.extensions.surf.util.URLEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InviteSenderTest
extends TestCase {
    private static final StoreRef testStore = new StoreRef("test", "test");
    private static final Person inviter = new Person("inviter");
    private static final Person invitee = new Person("invitee");
    private static final Person whitespaceInvitee = new Person("First Second\tthird\nFourth\r\nFifth");
    private static final Person specialCharInvitee = new Person("\u00e0\u00e2\u00e6\u00e7\u00e9\u00e8\u00ea\u00eb\u00ee\u00ef\u00f4\u0153\u00f9\u00fb\u00fc\u00ff\u00f1");
    private static final NodeRef template = new NodeRef(testStore, "template");
    private static final String siteName = "Full Site Name";
    private static final String siteShortName = "Site Name";
    private static final String mailText = "Mail Text";
    private static final String acceptUrl = "/accpet";
    private static final String rejectUrl = "/reject";
    private static final String role = "Role";
    private static final String password = "password";
    private static final String ticket = "Ticket";
    private static final String path = testStore + "/path";
    private static final String packageId = testStore + "/Package";
    private static final String instanceId = "InstanceId";
    private final MessageService messageService = (MessageService)Mockito.mock(MessageService.class);
    private Action mailAction;
    private SiteInfo siteInfo = (SiteInfo)Mockito.mock(SiteInfo.class);
    private InviteSender sender;
    private Map<String, Serializable> lastSetMailModel;

    public void testSendMailWorkingPath() throws Exception {
        String rolePropertyName = "invitation.invitesender.email.role.Role";
        String subjectPropertyName = "invitation.invitesender.email.subject";
        String subjectMsg = "Subject message";
        Mockito.when((Object)this.messageService.getMessage((String)Matchers.eq((Object)subjectPropertyName), Matchers.eq((Object)"Share"), Matchers.eq((Object)siteShortName))).thenReturn((Object)subjectMsg);
        Map<String, String> properties = this.buildDefaultProperties();
        this.sender.sendMail(properties);
        ((MessageService)Mockito.verify((Object)this.messageService)).getMessage((String)Matchers.eq((Object)subjectPropertyName), Matchers.eq((Object)"Share"), Matchers.eq((Object)siteShortName));
        ((MessageService)Mockito.verify((Object)this.messageService)).getMessage((String)Matchers.eq((Object)rolePropertyName));
        ((Action)Mockito.verify((Object)this.mailAction)).setParameterValue((String)Matchers.eq((Object)"from"), (Serializable)Matchers.eq((Object)InviteSenderTest.inviter.email));
        ((Action)Mockito.verify((Object)this.mailAction)).setParameterValue((String)Matchers.eq((Object)"to"), (Serializable)Matchers.eq((Object)InviteSenderTest.invitee.email));
        ((Action)Mockito.verify((Object)this.mailAction)).setParameterValue((String)Matchers.eq((Object)"subject"), (Serializable)Matchers.eq((Object)subjectMsg));
        ((Action)Mockito.verify((Object)this.mailAction)).setParameterValue((String)Matchers.eq((Object)"template"), (Serializable)Matchers.any());
        ArgumentCaptor modelC = ArgumentCaptor.forClass(Map.class);
        ((Action)Mockito.verify((Object)this.mailAction)).setParameterValue((String)Matchers.eq((Object)"template_model"), (Serializable)modelC.capture());
        Map model = (Map)modelC.getValue();
        InviteSenderTest.assertNotNull((Object)model);
        InviteSenderTest.assertEquals((boolean)false, (boolean)model.isEmpty());
        InviteSenderTest.assertEquals(null, model.get("userhome"));
        InviteSenderTest.assertNotNull(model.get("productName"));
        Map argsMap = (Map)model.get("args");
        InviteSenderTest.assertNotNull((Object)argsMap);
        InviteSenderTest.assertEquals((String)siteShortName, (String)((String)argsMap.get("siteName")));
        InviteSenderTest.assertEquals((String)InviteSenderTest.invitee.node.toString(), (String)((String)argsMap.get("inviteePersonRef")));
        InviteSenderTest.assertEquals((String)InviteSenderTest.inviter.node.toString(), (String)((String)argsMap.get("inviterPersonRef")));
        InviteSenderTest.assertEquals((String)siteShortName, (String)((String)argsMap.get("siteName")));
        InviteSenderTest.assertEquals((String)InviteSenderTest.invitee.name, (String)((String)argsMap.get("inviteeUserName")));
        InviteSenderTest.assertEquals((String)password, (String)((String)argsMap.get("inviteeGenPassword")));
        InviteSenderTest.assertEquals((String)"test://test/path/accpet?inviteId=InstanceId&inviteeUserName=invitee&siteShortName=Full Site Name&inviteTicket=Ticket", (String)((String)argsMap.get("acceptLink")));
        InviteSenderTest.assertEquals((String)"test://test/path/reject?inviteId=InstanceId&inviteeUserName=invitee&siteShortName=Full Site Name&inviteTicket=Ticket", (String)((String)argsMap.get("rejectLink")));
        InviteSenderTest.assertEquals((String)role, (String)((String)argsMap.get("inviteeSiteRole")));
        Mockito.reset((Object[])new Object[]{this.mailAction, this.messageService});
        String roleMsg = "role message";
        Mockito.when((Object)this.messageService.getMessage(rolePropertyName)).thenReturn((Object)roleMsg);
        this.sender.sendMail(properties);
        modelC = ArgumentCaptor.forClass(Map.class);
        ((Action)Mockito.verify((Object)this.mailAction)).setParameterValue((String)Matchers.eq((Object)"template_model"), (Serializable)modelC.capture());
        model = (Map)modelC.getValue();
        InviteSenderTest.assertNotNull((Object)model);
        argsMap = (Map)model.get("args");
        InviteSenderTest.assertNotNull((Object)argsMap);
        InviteSenderTest.assertEquals((String)roleMsg, (String)((String)argsMap.get("inviteeSiteRole")));
    }

    public void testSendMailWithWhitespaceUserName() throws Exception {
        Map<String, String> properties = this.buildDefaultProperties();
        properties.put("inwf_inviteeUserName", InviteSenderTest.whitespaceInvitee.name);
        this.sender.sendMail(properties);
        ArgumentCaptor modelC = ArgumentCaptor.forClass(Map.class);
        ((Action)Mockito.verify((Object)this.mailAction)).setParameterValue((String)Matchers.eq((Object)"template_model"), (Serializable)modelC.capture());
        Map model = (Map)modelC.getValue();
        InviteSenderTest.assertNotNull((Object)model);
        InviteSenderTest.assertEquals((boolean)false, (boolean)model.isEmpty());
        InviteSenderTest.assertEquals(null, model.get("userhome"));
        InviteSenderTest.assertNotNull(model.get("productName"));
        Map argsMap = (Map)model.get("args");
        String acceptLink = (String)argsMap.get("acceptLink");
        InviteSenderTest.assertEquals((String)"test://test/path/accpet?inviteId=InstanceId&inviteeUserName=First%20Second%09third%0aFourth%0d%0aFifth&siteShortName=Full Site Name&inviteTicket=Ticket", (String)acceptLink);
        String rejectLink = (String)argsMap.get("rejectLink");
        InviteSenderTest.assertEquals((String)"test://test/path/reject?inviteId=InstanceId&inviteeUserName=First%20Second%09third%0aFourth%0d%0aFifth&siteShortName=Full Site Name&inviteTicket=Ticket", (String)rejectLink);
    }

    public void testSendMailWithSpecialCharUserName() throws Exception {
        Map<String, String> properties = this.buildDefaultProperties();
        properties.put("inwf_inviteeUserName", InviteSenderTest.specialCharInvitee.name);
        this.sender.sendMail(properties);
        ArgumentCaptor modelC = ArgumentCaptor.forClass(Map.class);
        ((Action)Mockito.verify((Object)this.mailAction)).setParameterValue((String)Matchers.eq((Object)"template_model"), (Serializable)modelC.capture());
        Map model = (Map)modelC.getValue();
        InviteSenderTest.assertNotNull((Object)model);
        InviteSenderTest.assertEquals((boolean)false, (boolean)model.isEmpty());
        InviteSenderTest.assertEquals(null, model.get("userhome"));
        InviteSenderTest.assertNotNull(model.get("productName"));
        Map argsMap = (Map)model.get("args");
        String acceptLink = (String)argsMap.get("acceptLink");
        InviteSenderTest.assertEquals((String)"test://test/path/accpet?inviteId=InstanceId&inviteeUserName=%c3%a0%c3%a2%c3%a6%c3%a7%c3%a9%c3%a8%c3%aa%c3%ab%c3%ae%c3%af%c3%b4%c5%93%c3%b9%c3%bb%c3%bc%c3%bf%c3%b1&siteShortName=Full Site Name&inviteTicket=Ticket", (String)acceptLink);
        String rejectLink = (String)argsMap.get("rejectLink");
        InviteSenderTest.assertEquals((String)"test://test/path/reject?inviteId=InstanceId&inviteeUserName=%c3%a0%c3%a2%c3%a6%c3%a7%c3%a9%c3%a8%c3%aa%c3%ab%c3%ae%c3%af%c3%b4%c5%93%c3%b9%c3%bb%c3%bc%c3%bf%c3%b1&siteShortName=Full Site Name&inviteTicket=Ticket", (String)rejectLink);
    }

    public void testValidServerPath() throws Exception {
        String validPath = "test://test/path/accept?hello";
        String link = this.sender.makeLink("test://test/path", "accept", "hello");
        InviteSenderTest.assertEquals((String)validPath, (String)link);
        link = this.sender.makeLink("test://test/path/", "accept", "hello");
        InviteSenderTest.assertEquals((String)validPath, (String)link);
        link = this.sender.makeLink("test://test/path", "/accept", "hello");
        InviteSenderTest.assertEquals((String)validPath, (String)link);
        link = this.sender.makeLink("test://test/path/", "/accept", "hello");
        InviteSenderTest.assertEquals((String)validPath, (String)link);
        link = this.sender.makeLink("test://test/path", "/accept", "?hello");
        InviteSenderTest.assertEquals((String)validPath, (String)link);
    }

    protected static String ensureEndsWithSlash(String thePath) {
        return thePath.endsWith("/") ? thePath : thePath + "/";
    }

    private Map<String, String> buildDefaultProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("inwf_resourceName", siteName);
        properties.put("inwf_inviteeUserName", InviteSenderTest.invitee.name);
        properties.put("inwf_inviterUserName", InviteSenderTest.inviter.name);
        properties.put("inwf_acceptUrl", acceptUrl);
        properties.put("inwf_rejectUrl", rejectUrl);
        properties.put("inwf_inviteeRole", role);
        properties.put("inwf_inviteeGenPassword", password);
        properties.put("inwf_inviteTicket", ticket);
        properties.put("inwf_serverPath", path);
        properties.put("wf_package", packageId);
        properties.put("wf_instanceId", instanceId);
        return properties;
    }

    protected void setUp() throws Exception {
        super.setUp();
        ServiceRegistry services = this.mockServices();
        Repository repository = this.mockRepository();
        this.sender = new InviteSender(services, repository, this.messageService);
        this.lastSetMailModel = null;
    }

    private Repository mockRepository() {
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)repository.getPerson()).thenReturn((Object)InviteSenderTest.inviter.node);
        return repository;
    }

    private ServiceRegistry mockServices() {
        ActionService mockActionService = this.mockActionService();
        NodeService mockNodeService = this.mockNodeService();
        PersonService mockPersonService = this.mockPersonService();
        SearchService mockSearchService = this.mockSearchService();
        SiteService mockSiteService = this.mockSiteService();
        FileFolderService mockFileFolderService = this.mockFileFolderService();
        RepoAdminService mockRepoAdminService = this.mockRepoAdminService();
        SysAdminParamsImpl sysAdminParams = new SysAdminParamsImpl();
        ServiceRegistry services = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
        Mockito.when((Object)services.getActionService()).thenReturn((Object)mockActionService);
        Mockito.when((Object)services.getNodeService()).thenReturn((Object)mockNodeService);
        Mockito.when((Object)services.getPersonService()).thenReturn((Object)mockPersonService);
        Mockito.when((Object)services.getSearchService()).thenReturn((Object)mockSearchService);
        Mockito.when((Object)services.getSiteService()).thenReturn((Object)mockSiteService);
        Mockito.when((Object)services.getFileFolderService()).thenReturn((Object)mockFileFolderService);
        Mockito.when((Object)services.getSysAdminParams()).thenReturn((Object)sysAdminParams);
        Mockito.when((Object)services.getRepoAdminService()).thenReturn((Object)mockRepoAdminService);
        return services;
    }

    private FileFolderService mockFileFolderService() {
        FileFolderService fileFolderService = (FileFolderService)Mockito.mock(FileFolderService.class);
        Mockito.when((Object)fileFolderService.getLocalizedSibling(null)).thenAnswer((Answer)new Answer<NodeRef>(){

            public NodeRef answer(InvocationOnMock invocation) throws Throwable {
                Object[] o = invocation.getArguments();
                if (o == null || o.length == 0) {
                    return null;
                }
                return (NodeRef)o[0];
            }
        });
        return fileFolderService;
    }

    private RepoAdminService mockRepoAdminService() {
        RepoUsage usage = new RepoUsage(System.currentTimeMillis(), 10L, 100L, RepoUsage.LicenseMode.ENTERPRISE, System.currentTimeMillis(), false);
        RepoAdminService repoAdminService = (RepoAdminService)Mockito.mock(RepoAdminService.class);
        Mockito.when((Object)repoAdminService.getRestrictions()).thenReturn((Object)usage);
        return repoAdminService;
    }

    private SiteService mockSiteService() {
        SiteService siteService = (SiteService)Mockito.mock(SiteService.class);
        Mockito.when((Object)this.siteInfo.getShortName()).thenReturn((Object)siteShortName);
        Mockito.when((Object)siteService.getSite(siteName)).thenReturn((Object)this.siteInfo);
        return siteService;
    }

    private SearchService mockSearchService() {
        SearchService searchService = (SearchService)Mockito.mock(SearchService.class);
        ResultSet results = (ResultSet)Mockito.mock(ResultSet.class);
        List<NodeRef> nodeRefs = Arrays.asList(template);
        Mockito.when((Object)results.getNodeRefs()).thenReturn(nodeRefs);
        Mockito.when((Object)searchService.query((SearchParameters)Matchers.any())).thenReturn((Object)results);
        Mockito.when((Object)searchService.selectNodes((NodeRef)Matchers.any(NodeRef.class), (String)Matchers.any(String.class), (QueryParameterDefinition[])Matchers.any(QueryParameterDefinition[].class), (NamespacePrefixResolver)Matchers.any(NamespacePrefixResolver.class), Matchers.eq((boolean)false))).thenReturn(nodeRefs);
        return searchService;
    }

    private PersonService mockPersonService() {
        PersonService personService = (PersonService)Mockito.mock(PersonService.class);
        Mockito.when((Object)personService.getPerson(InviteSenderTest.inviter.name)).thenReturn((Object)InviteSenderTest.inviter.node);
        Mockito.when((Object)personService.getPerson(InviteSenderTest.invitee.name)).thenReturn((Object)InviteSenderTest.invitee.node);
        Mockito.when((Object)personService.getPerson(InviteSenderTest.whitespaceInvitee.name)).thenReturn((Object)InviteSenderTest.whitespaceInvitee.node);
        Mockito.when((Object)personService.getPerson(InviteSenderTest.specialCharInvitee.name)).thenReturn((Object)InviteSenderTest.specialCharInvitee.node);
        return personService;
    }

    private NodeService mockNodeService() {
        NodeService nodeService = (NodeService)Mockito.mock(NodeService.class);
        Mockito.when((Object)nodeService.getProperty(InviteSenderTest.inviter.node, ContentModel.PROP_EMAIL)).thenReturn((Object)InviteSenderTest.inviter.email);
        Mockito.when((Object)nodeService.getProperty(InviteSenderTest.invitee.node, ContentModel.PROP_EMAIL)).thenReturn((Object)InviteSenderTest.invitee.email);
        Mockito.when((Object)nodeService.getProperty(InviteSenderTest.whitespaceInvitee.node, ContentModel.PROP_EMAIL)).thenReturn((Object)InviteSenderTest.whitespaceInvitee.email);
        Mockito.when((Object)nodeService.getProperty(InviteSenderTest.specialCharInvitee.node, ContentModel.PROP_EMAIL)).thenReturn((Object)InviteSenderTest.specialCharInvitee.email);
        return nodeService;
    }

    private ActionService mockActionService() {
        this.mailAction = (Action)Mockito.mock(Action.class);
        ActionService actionService = (ActionService)Mockito.mock(ActionService.class);
        Mockito.when((Object)actionService.createAction("mail")).thenReturn((Object)this.mailAction);
        return actionService;
    }

    private static class Person {
        public final String name;
        public final String email;
        public final NodeRef node;

        public Person(String name) {
            this.name = name;
            String encName = URLEncoder.encode((String)name);
            this.email = encName + "@test.com";
            this.node = new NodeRef(testStore, encName);
        }
    }
}

