/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.app.PropertyDecorator;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO8601DateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.URLEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApplicationScriptUtils
extends BaseScopableProcessorExtension {
    private static Log logger = LogFactory.getLog(ApplicationScriptUtils.class);
    private ServiceRegistry services;
    private NodeService nodeService = null;
    private Map<String, Object> decoratedProperties;
    private String[] userPermissions;
    private static final String CONTENT_DOWNLOAD_API_URL = "/api/node/content/{0}/{1}/{2}/{3}";

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.services = serviceRegistry;
        this.nodeService = this.services.getNodeService();
    }

    public void setDecoratedProperties(Map<String, Object> decoratedProperties) {
        this.decoratedProperties = decoratedProperties;
    }

    public void setUserPermissions(String[] userPermissions) {
        this.userPermissions = userPermissions;
    }

    public String toJSON(ScriptNode node) {
        return this.toJSON(node, false);
    }

    public String toJSON(ScriptNode node, boolean useShortQNames) {
        return this.toJSONObj(node, useShortQNames).toString();
    }

    protected Object toJSONObj(ScriptNode node, boolean useShortQNames) {
        NodeRef nodeRef = node.getNodeRef();
        JSONObject json = new JSONObject();
        if (this.nodeService.exists(nodeRef) && this.services.getPublicServiceAccessService().hasAccess(ServiceRegistry.NODE_SERVICE.getLocalName(), "getProperties", nodeRef) == AccessStatus.ALLOWED) {
            try {
                NodeRef targetNodeRef;
                String typeString = useShortQNames ? this.getShortQName(node.getQNameType()) : node.getType();
                boolean isLink = node.getIsLinkToContainer() || node.getIsLinkToDocument();
                json.put("nodeRef", (Object)nodeRef.toString());
                json.put("type", (Object)typeString);
                json.put("isContainer", node.getIsContainer() || node.getIsLinkToContainer());
                json.put("isLink", isLink);
                json.put("isLocked", node.getIsLocked());
                if (node.getIsDocument()) {
                    json.put("contentURL", (Object)this.getDownloadAPIUrl(node));
                    json.put("mimetype", (Object)node.getMimetype());
                    json.put("size", node.getSize());
                }
                LinkedHashMap<String, Object> permissionsJSON = new LinkedHashMap<String, Object>(3);
                if (node.hasPermission("ReadPermissions")) {
                    permissionsJSON.put("roles", node.retrieveAllSetPermissions(false, true));
                }
                permissionsJSON.put("inherited", node.inheritsPermissions());
                LinkedHashMap<String, Boolean> userPermissionJSON = new LinkedHashMap<String, Boolean>(this.userPermissions.length);
                for (String userPermission : this.userPermissions) {
                    userPermissionJSON.put(userPermission, node.hasPermission(userPermission));
                }
                permissionsJSON.put("user", userPermissionJSON);
                json.put("permissions", permissionsJSON);
                Map nodeProperties = this.nodeService.getProperties(nodeRef);
                json.put("properties", this.parseToJSON(nodeRef, nodeProperties, useShortQNames));
                Set nodeAspects = this.nodeService.getAspects(nodeRef);
                if (useShortQNames) {
                    LinkedHashSet<String> nodeAspectsShortQNames = new LinkedHashSet<String>(nodeAspects.size());
                    for (QName nextLongQName : nodeAspects) {
                        String nextShortQName = this.getShortQName(nextLongQName);
                        nodeAspectsShortQNames.add(nextShortQName);
                    }
                    json.put("aspects", nodeAspectsShortQNames);
                } else {
                    json.put("aspects", (Collection)nodeAspects);
                }
                if (isLink && (targetNodeRef = (NodeRef)nodeProperties.get(ContentModel.PROP_LINK_DESTINATION)) != null) {
                    json.put("linkedNode", this.toJSONObj(new ScriptNode(targetNodeRef, this.services, node.scope), useShortQNames));
                }
            }
            catch (JSONException error) {
                error.printStackTrace();
            }
        }
        return json;
    }

    protected String getShortQName(QName longQName) {
        return longQName.toPrefixString((NamespacePrefixResolver)this.services.getNamespaceService());
    }

    protected Map<String, Serializable> parseToJSON(NodeRef nodeRef, Map<QName, Serializable> properties, boolean useShortQNames) {
        LinkedHashMap<String, Serializable> json = new LinkedHashMap<String, Serializable>(properties.size());
        for (QName nextLongQName : properties.keySet()) {
            try {
                String shortQName = this.getShortQName(nextLongQName);
                String key = useShortQNames ? shortQName : nextLongQName.toString();
                Serializable value = properties.get(nextLongQName);
                if (value != null) {
                    if (this.decoratedProperties.containsKey(shortQName)) {
                        json.put(key, ((PropertyDecorator)this.decoratedProperties.get(shortQName)).decorate(nodeRef, shortQName, value));
                        continue;
                    }
                    if (value instanceof Date) {
                        LinkedHashMap<String, Object> dateObj = new LinkedHashMap<String, Object>(1);
                        dateObj.put("value", value);
                        dateObj.put("iso8601", ISO8601DateFormat.format((Date)((Date)value)));
                        json.put(key, dateObj);
                        continue;
                    }
                    json.put(key, value);
                    continue;
                }
                json.put(key, null);
            }
            catch (NamespaceException ne) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Ignoring property '" + nextLongQName + "' as its namespace is not registered"));
            }
        }
        return json;
    }

    public String getDownloadAPIUrl(ScriptNode node) {
        if (node.getIsDocument()) {
            return MessageFormat.format(CONTENT_DOWNLOAD_API_URL, node.nodeRef.getStoreRef().getProtocol(), node.nodeRef.getStoreRef().getIdentifier(), node.nodeRef.getId(), URLEncoder.encode((String)node.getName()));
        }
        return "";
    }
}

