/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript.app;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.app.PropertyDecorator;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;

public class UsernamePropertyDecorator
implements PropertyDecorator {
    private ServiceRegistry services;
    private NodeService nodeService = null;
    private PersonService personService = null;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.services = serviceRegistry;
        this.nodeService = serviceRegistry.getNodeService();
        this.personService = serviceRegistry.getPersonService();
    }

    public Serializable decorate(NodeRef nodeRef, String propertyName, Serializable value) {
        String username = value.toString();
        String firstName = null;
        String lastName = null;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(4);
        map.put("userName", username);
        if (this.personService.personExists(username)) {
            NodeRef personRef = this.personService.getPerson(username);
            Map properties = this.nodeService.getProperties(personRef);
            firstName = (String)properties.get(ContentModel.PROP_FIRSTNAME);
            lastName = (String)properties.get(ContentModel.PROP_LASTNAME);
        } else if (username.equals("System") || username.startsWith("System@")) {
            firstName = "System";
            lastName = "User";
        } else {
            map.put("isDeleted", true);
            return map;
        }
        map.put("firstName", firstName);
        map.put("lastName", lastName);
        map.put("displayName", (firstName != null ? firstName + " " : ("" + lastName != null ? lastName : "")).replaceAll("^\\s+|\\s+$", ""));
        return map;
    }
}

