/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.GenericApplicationListenerAdapter;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.OrderComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafeApplicationEventMulticaster
implements ApplicationEventMulticaster,
ApplicationContextAware {
    private final Log log = LogFactory.getLog(SafeApplicationEventMulticaster.class);
    private final ListenerRetriever defaultRetriever = new ListenerRetriever(false);
    private final Map<ListenerCacheKey, ListenerRetriever> retrieverCache = new ConcurrentHashMap<ListenerCacheKey, ListenerRetriever>();
    private ApplicationContext appContext;
    private Executor taskExecutor;
    private boolean isApplicationStarted;
    private List<ApplicationEvent> queuedEvents = new LinkedList<ApplicationEvent>();

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    protected Executor getTaskExecutor() {
        return this.taskExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationListener(ApplicationListener listener) {
        ListenerRetriever listenerRetriever = this.defaultRetriever;
        synchronized (listenerRetriever) {
            this.defaultRetriever.applicationListeners.add(listener);
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationListenerBean(String listenerBeanName) {
        ListenerRetriever listenerRetriever = this.defaultRetriever;
        synchronized (listenerRetriever) {
            this.defaultRetriever.applicationListenerBeans.add(listenerBeanName);
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationListener(ApplicationListener listener) {
        ListenerRetriever listenerRetriever = this.defaultRetriever;
        synchronized (listenerRetriever) {
            this.defaultRetriever.applicationListeners.remove(listener);
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationListenerBean(String listenerBeanName) {
        ListenerRetriever listenerRetriever = this.defaultRetriever;
        synchronized (listenerRetriever) {
            this.defaultRetriever.applicationListenerBeans.remove(listenerBeanName);
            this.retrieverCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        ListenerRetriever listenerRetriever = this.defaultRetriever;
        synchronized (listenerRetriever) {
            this.defaultRetriever.applicationListeners.clear();
            this.defaultRetriever.applicationListenerBeans.clear();
            this.retrieverCache.clear();
        }
    }

    private BeanFactory getBeanFactory() {
        if (this.appContext == null) {
            throw new IllegalStateException("ApplicationEventMulticaster cannot retrieve listener beans because it is not associated with a BeanFactory");
        }
        return this.appContext;
    }

    public void multicastEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent && event.getSource() == this.appContext) {
            this.isApplicationStarted = true;
            for (ApplicationEvent queuedEvent : this.queuedEvents) {
                this.multicastEventInternal(queuedEvent);
            }
            this.queuedEvents.clear();
            this.multicastEventInternal(event);
        } else if (event instanceof ContextClosedEvent && event.getSource() == this.appContext) {
            this.isApplicationStarted = false;
            this.multicastEventInternal(event);
        } else if (this.isApplicationStarted) {
            this.multicastEventInternal(event);
        } else {
            this.queuedEvents.add(event);
        }
    }

    protected void multicastEventInternal(final ApplicationEvent event) {
        for (final ApplicationListener listener : this.getApplicationListeners(event)) {
            Executor executor = this.getTaskExecutor();
            if (executor != null) {
                executor.execute(new Runnable(){

                    public void run() {
                        listener.onApplicationEvent(event);
                    }
                });
                continue;
            }
            listener.onApplicationEvent(event);
        }
    }

    protected Collection<ApplicationListener> getApplicationListeners() {
        return this.defaultRetriever.getApplicationListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<ApplicationListener> getApplicationListeners(ApplicationEvent event) {
        Class<?> sourceType;
        Class<?> eventType = event.getClass();
        ListenerCacheKey cacheKey = new ListenerCacheKey(eventType, sourceType = event.getSource().getClass());
        ListenerRetriever retriever = this.retrieverCache.get(cacheKey);
        if (retriever != null) {
            return retriever.getApplicationListeners();
        }
        retriever = new ListenerRetriever(true);
        LinkedList<ApplicationListener> allListeners = new LinkedList<ApplicationListener>();
        ListenerRetriever listenerRetriever = this.defaultRetriever;
        synchronized (listenerRetriever) {
            if (!this.defaultRetriever.applicationListenerBeans.isEmpty()) {
                BeanFactory beanFactory = this.getBeanFactory();
                for (String listenerBeanName : this.defaultRetriever.applicationListenerBeans) {
                    ApplicationListener listener = (ApplicationListener)beanFactory.getBean(listenerBeanName, ApplicationListener.class);
                    if (!this.supportsEvent(listener, eventType, sourceType)) continue;
                    retriever.applicationListenerBeans.add(listenerBeanName);
                    allListeners.add(listener);
                }
            }
            for (ApplicationListener listener : this.defaultRetriever.applicationListeners) {
                if (allListeners.contains(listener) || !this.supportsEvent(listener, eventType, sourceType)) continue;
                retriever.applicationListeners.add(listener);
                allListeners.add(listener);
            }
            OrderComparator.sort(allListeners);
            this.retrieverCache.put(cacheKey, retriever);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)allListeners.toString());
        }
        return allListeners;
    }

    protected boolean supportsEvent(ApplicationListener listener, Class<? extends ApplicationEvent> eventType, Class sourceType) {
        SmartApplicationListener smartListener = listener instanceof SmartApplicationListener ? (SmartApplicationListener)listener : new GenericApplicationListenerAdapter(listener);
        return smartListener.supportsEventType(eventType) && smartListener.supportsSourceType(sourceType);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListenerRetriever {
        public final Set<ApplicationListener> applicationListeners = new LinkedHashSet<ApplicationListener>();
        public final Set<String> applicationListenerBeans = new LinkedHashSet<String>();
        private final boolean preFiltered;

        public ListenerRetriever(boolean preFiltered) {
            this.preFiltered = preFiltered;
        }

        public Collection<ApplicationListener> getApplicationListeners() {
            LinkedList<ApplicationListener> allListeners = new LinkedList<ApplicationListener>();
            if (!this.applicationListenerBeans.isEmpty()) {
                BeanFactory beanFactory = SafeApplicationEventMulticaster.this.getBeanFactory();
                for (String listenerBeanName : this.applicationListenerBeans) {
                    ApplicationListener listener = (ApplicationListener)beanFactory.getBean(listenerBeanName, ApplicationListener.class);
                    allListeners.add(listener);
                }
            }
            for (ApplicationListener listener : this.applicationListeners) {
                if (!this.preFiltered && allListeners.contains(listener)) continue;
                allListeners.add(listener);
            }
            OrderComparator.sort(allListeners);
            if (SafeApplicationEventMulticaster.this.log.isDebugEnabled()) {
                SafeApplicationEventMulticaster.this.log.debug((Object)allListeners.toString());
            }
            return allListeners;
        }
    }

    private static class ListenerCacheKey {
        private final Class eventType;
        private final Class sourceType;

        public ListenerCacheKey(Class eventType, Class sourceType) {
            this.eventType = eventType;
            this.sourceType = sourceType;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            ListenerCacheKey otherKey = (ListenerCacheKey)other;
            return this.eventType.equals(otherKey.eventType) && this.sourceType.equals(otherKey.sourceType);
        }

        public int hashCode() {
            return this.eventType.hashCode() * 29 + this.sourceType.hashCode();
        }
    }
}

