/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantDeployer;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class Repository
implements ApplicationContextAware,
ApplicationListener,
TenantDeployer {
    private ProcessorLifecycle lifecycle = new ProcessorLifecycle();
    private RetryingTransactionHelper retryingTransactionHelper;
    private NamespaceService namespaceService;
    private SearchService searchService;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private PersonService personService;
    private AVMService avmService;
    private TenantAdminService tenantAdminService;
    private StoreRef companyHomeStore;
    private String companyHomePath;
    private Map<String, NodeRef> companyHomeRefs;
    private NodeRef rootRef;

    public void setCompanyHomeStore(String companyHomeStore) {
        this.companyHomeStore = new StoreRef(companyHomeStore);
    }

    public void setCompanyHomePath(String companyHomePath) {
        this.companyHomePath = companyHomePath;
    }

    public void setTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setTenantAdminService(TenantAdminService tenantAdminService) {
        this.tenantAdminService = tenantAdminService;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.lifecycle.setApplicationContext(applicationContext);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        this.lifecycle.onApplicationEvent(event);
    }

    protected void initContext() {
        this.tenantAdminService.register(this);
        if (this.companyHomeRefs == null) {
            this.companyHomeRefs = new ConcurrentHashMap<String, NodeRef>(4);
        }
        this.getCompanyHome();
    }

    public NodeRef getRootHome() {
        if (this.rootRef == null) {
            this.rootRef = this.nodeService.getRootNode(this.companyHomeStore);
        }
        return this.rootRef;
    }

    public NodeRef getCompanyHome() {
        String tenantDomain = this.tenantAdminService.getCurrentUserDomain();
        NodeRef companyHomeRef = this.companyHomeRefs.get(tenantDomain);
        if (companyHomeRef == null) {
            companyHomeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    return Repository.this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                        @Override
                        public NodeRef execute() throws Exception {
                            List refs = Repository.this.searchService.selectNodes(Repository.this.nodeService.getRootNode(Repository.this.companyHomeStore), Repository.this.companyHomePath, null, (NamespacePrefixResolver)Repository.this.namespaceService, false);
                            if (refs.size() != 1) {
                                throw new IllegalStateException("Invalid company home path: " + Repository.this.companyHomePath + " - found: " + refs.size());
                            }
                            return (NodeRef)refs.get(0);
                        }
                    }, true);
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            this.companyHomeRefs.put(tenantDomain, companyHomeRef);
        }
        return companyHomeRef;
    }

    public NodeRef getPerson() {
        NodeRef person = null;
        String currentUserName = AuthenticationUtil.getRunAsUser();
        if (this.personService.personExists(currentUserName)) {
            person = this.personService.getPerson(currentUserName);
        }
        return person;
    }

    public NodeRef getUserHome(NodeRef person) {
        NodeRef homeFolderRef = (NodeRef)this.nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER);
        if (homeFolderRef != null && this.nodeService.exists(homeFolderRef)) {
            return homeFolderRef;
        }
        return null;
    }

    public NodeRef findNodeRef(String referenceType, String[] reference) {
        NodeRef nodeRef = null;
        if (referenceType.equals("avmpath")) {
            AVMNodeDescriptor nodeDesc;
            if (reference.length == 0) {
                throw new AlfrescoRuntimeException("Reference " + Arrays.toString(reference) + " is not properly formed");
            }
            String path = reference[0] + ":/";
            if (reference.length > 1) {
                Object[] pathElements = ArrayUtils.subarray((Object[])reference, (int)1, (int)reference.length);
                path = path + StringUtils.join((Object[])pathElements, (String)"/");
            }
            if ((nodeDesc = this.avmService.lookup(-1, path)) != null) {
                nodeRef = AVMNodeConverter.ToNodeRef(-1, path);
            }
        } else {
            if (reference.length < 3) {
                throw new AlfrescoRuntimeException("Reference " + Arrays.toString(reference) + " is not properly formed");
            }
            StoreRef storeRef = new StoreRef(reference[0], reference[1]);
            if (this.nodeService.exists(storeRef)) {
                if (referenceType.equals("node")) {
                    NodeRef relRef = new NodeRef(storeRef, reference[2]);
                    if (this.nodeService.exists(relRef)) {
                        if (reference.length == 3 || reference.length == 4) {
                            nodeRef = relRef;
                        } else {
                            ArrayList<String> paths = new ArrayList<String>(reference.length - 3);
                            for (int i = 3; i < reference.length; ++i) {
                                paths.add(reference[i]);
                            }
                            try {
                                NodeRef parentRef = this.nodeService.getPrimaryParent(relRef).getParentRef();
                                FileInfo fileInfo = this.fileFolderService.resolveNamePath(parentRef, paths);
                                nodeRef = fileInfo.getNodeRef();
                            }
                            catch (FileNotFoundException e) {}
                        }
                    }
                } else if (referenceType.equals("path")) {
                    if (reference[0].equals("avm")) {
                        AVMNodeDescriptor nodeDesc;
                        String path = reference[1] + ":/";
                        if (reference.length > 2) {
                            Object[] pathElements = ArrayUtils.subarray((Object[])reference, (int)2, (int)reference.length);
                            path = path + StringUtils.join((Object[])pathElements, (String)"/");
                        }
                        if ((nodeDesc = this.avmService.lookup(-1, path)) != null) {
                            nodeRef = AVMNodeConverter.ToNodeRef(-1, path);
                        }
                    } else {
                        NodeRef rootNodeRef = this.getCompanyHome();
                        if (reference.length == 3) {
                            if (reference[2].equals(this.nodeService.getPrimaryParent(rootNodeRef).getQName().toPrefixString((NamespacePrefixResolver)this.namespaceService))) {
                                nodeRef = rootNodeRef;
                            }
                        } else {
                            String[] path = new String[reference.length - 3];
                            System.arraycopy(reference, 3, path, 0, path.length);
                            try {
                                FileInfo fileInfo = this.fileFolderService.resolveNamePath(rootNodeRef, Arrays.asList(path));
                                nodeRef = fileInfo.getNodeRef();
                            }
                            catch (FileNotFoundException e) {}
                        }
                    }
                } else {
                    throw new AlfrescoRuntimeException("Web Script Node URL specified an invalid reference style of '" + referenceType + "'");
                }
            }
        }
        return nodeRef;
    }

    public void onEnableTenant() {
        this.init();
    }

    public void onDisableTenant() {
        this.destroy();
    }

    public void init() {
        this.initContext();
    }

    public void destroy() {
        this.companyHomeRefs.remove(this.tenantAdminService.getCurrentUserDomain());
    }

    private class ProcessorLifecycle
    extends AbstractLifecycleBean {
        private ProcessorLifecycle() {
        }

        protected void onBootstrap(ApplicationEvent event) {
            Repository.this.initContext();
        }

        protected void onShutdown(ApplicationEvent event) {
        }
    }
}

