/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Stack;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQueryFactory;
import org.alfresco.query.CannedQueryResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.model.filefolder.FileInfoImpl;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQuery;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQueryFactory;
import org.alfresco.repo.search.QueryParameterDefImpl;
import org.alfresco.repo.security.permissions.PermissionCheckedCollection;
import org.alfresco.repo.security.permissions.PermissionCheckedValue;
import org.alfresco.service.Auditable;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderServiceType;
import org.alfresco.service.cmr.model.FileFolderUtil;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.model.SubFolderFilter;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.FileFilterMode;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.SearchLanguageConversion;
import org.alfresco.util.registry.NamedObjectRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFolderServiceImpl
implements FileFolderService {
    private static final String CANNED_QUERY_FILEFOLDER_LIST = "fileFolderGetChildrenCannedQueryFactory";
    private static final String XPATH_QUERY_SHALLOW_ALL = "./*[like(@cm:name, $cm:name, false) and not (subtypeOf('" + ContentModel.TYPE_SYSTEM_FOLDER + "'))" + " and (subtypeOf('" + ContentModel.TYPE_FOLDER + "') or subtypeOf('" + ContentModel.TYPE_CONTENT + "')" + " or subtypeOf('" + ContentModel.TYPE_LINK + "'))]";
    private static final String XPATH_QUERY_DEEP_ALL = ".//*[like(@cm:name, $cm:name, false) and not (subtypeOf('" + ContentModel.TYPE_SYSTEM_FOLDER + "'))" + " and (subtypeOf('" + ContentModel.TYPE_FOLDER + "') or subtypeOf('" + ContentModel.TYPE_CONTENT + "')" + " or subtypeOf('" + ContentModel.TYPE_LINK + "'))]";
    private static final String XPATH_QUERY_DEEP_FOLDERS = ".//*[like(@cm:name, $cm:name, false) and not (subtypeOf('" + ContentModel.TYPE_SYSTEM_FOLDER + "'))" + " and (subtypeOf('" + ContentModel.TYPE_FOLDER + "'))]";
    private static final String XPATH_QUERY_DEEP_FILES = ".//*[like(@cm:name, $cm:name, false) and not (subtypeOf('" + ContentModel.TYPE_SYSTEM_FOLDER + "'))" + " and (subtypeOf('" + ContentModel.TYPE_CONTENT + "')" + " or subtypeOf('" + ContentModel.TYPE_LINK + "'))]";
    private static Log logger = LogFactory.getLog(FileFolderServiceImpl.class);
    private HiddenAspect hiddenAspect;
    private NamespaceService namespaceService;
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private CopyService copyService;
    private SearchService searchService;
    private ContentService contentService;
    private MimetypeService mimetypeService;
    private NamedObjectRegistry<CannedQueryFactory<NodeRef>> cannedQueryRegistry;
    private Set<String> systemNamespaces = new HashSet<String>(5);
    private List<String> systemPaths;
    private int defaultListMaxResults = 5000;
    private static final String LUCENE_MULTI_CHAR_WILDCARD = "*";

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setCopyService(CopyService copyService) {
        this.copyService = copyService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setHiddenAspect(HiddenAspect hiddenAspect) {
        this.hiddenAspect = hiddenAspect;
    }

    public void setCannedQueryRegistry(NamedObjectRegistry<CannedQueryFactory<NodeRef>> cannedQueryRegistry) {
        this.cannedQueryRegistry = cannedQueryRegistry;
    }

    public void setSystemNamespaces(List<String> systemNamespaces) {
        this.systemNamespaces.addAll(systemNamespaces);
    }

    public void setSystemPaths(List<String> systemPaths) {
        this.systemPaths = systemPaths;
    }

    public void setDefaultListMaxResults(int defaultListMaxResults) {
        this.defaultListMaxResults = defaultListMaxResults;
    }

    public void init() {
    }

    private List<FileInfo> toFileInfo(List<NodeRef> nodeRefs) throws InvalidTypeException {
        ArrayList<FileInfo> results = new ArrayList<FileInfo>(nodeRefs.size());
        FileFilterMode.Client client = FileFilterMode.getClient();
        for (NodeRef nodeRef : nodeRefs) {
            try {
                if (this.hiddenAspect.getVisibility(client, nodeRef) == HiddenAspect.Visibility.NotVisible) continue;
                FileInfo fileInfo = this.toFileInfo(nodeRef, true);
                results.add(fileInfo);
            }
            catch (InvalidNodeRefException inre) {
                logger.warn((Object)("toFileInfo: " + (Object)((Object)inre)));
            }
        }
        return results;
    }

    private FileInfo toFileInfo(NodeRef nodeRef, boolean addTranslations) throws InvalidTypeException {
        Map properties = this.nodeService.getProperties(nodeRef);
        QName typeQName = this.nodeService.getType(nodeRef);
        boolean isFolder = this.isFolder(typeQName);
        boolean isHidden = false;
        FileFilterMode.Client client = FileFilterMode.getClient();
        if (this.hiddenAspect.getVisibility(client, nodeRef) == HiddenAspect.Visibility.HiddenAttribute) {
            isHidden = true;
        }
        FileInfoImpl fileInfo = new FileInfoImpl(nodeRef, typeQName, isFolder, isHidden, properties);
        return fileInfo;
    }

    private boolean isFolder(QName typeQName) throws InvalidTypeException {
        FileFolderServiceType type = this.getType(typeQName);
        switch (type) {
            case FILE: {
                return false;
            }
            case FOLDER: {
                return true;
            }
            case SYSTEM_FOLDER: {
                throw new InvalidTypeException("This service should ignore type " + ContentModel.TYPE_SYSTEM_FOLDER);
            }
        }
        throw new InvalidTypeException("Type is not handled by this service: " + typeQName);
    }

    @Override
    public boolean exists(NodeRef nodeRef) {
        return this.nodeService.exists(nodeRef);
    }

    @Override
    public FileFolderServiceType getType(QName typeQName) {
        if (this.dictionaryService.isSubClass(typeQName, ContentModel.TYPE_FOLDER)) {
            if (this.dictionaryService.isSubClass(typeQName, ContentModel.TYPE_SYSTEM_FOLDER)) {
                return FileFolderServiceType.SYSTEM_FOLDER;
            }
            return FileFolderServiceType.FOLDER;
        }
        if (this.dictionaryService.isSubClass(typeQName, ContentModel.TYPE_CONTENT) || this.dictionaryService.isSubClass(typeQName, ContentModel.TYPE_LINK)) {
            return FileFolderServiceType.FILE;
        }
        return FileFolderServiceType.INVALID;
    }

    @Override
    public List<FileInfo> list(NodeRef contextNodeRef) {
        List<FileInfo> results = this.listSimple(contextNodeRef, true, true);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("List files and folders: \n   context: " + contextNodeRef + "\n" + "   results: " + results));
        }
        return results;
    }

    private PagingResults<FileInfo> getPagingResults(PagingRequest pagingRequest, final CannedQueryResults<NodeRef> results) {
        List nodeRefs = null;
        nodeRefs = results.getPageCount() > 0 ? (List)results.getPages().get(0) : Collections.emptyList();
        final Pair totalCount = pagingRequest.getRequestTotalCountMax() > 0 ? results.getTotalResultCount() : null;
        final ArrayList<FileInfo> nodeInfos = new ArrayList<FileInfo>(nodeRefs.size());
        FileFilterMode.Client client = FileFilterMode.getClient();
        for (NodeRef nodeRef : nodeRefs) {
            if (this.hiddenAspect.getVisibility(client, nodeRef) == HiddenAspect.Visibility.NotVisible) continue;
            nodeInfos.add(this.toFileInfo(nodeRef, true));
        }
        PermissionCheckedCollection.PermissionCheckedCollectionMixin.create(nodeInfos, nodeRefs);
        return new PagingResults<FileInfo>(){

            public String getQueryExecutionId() {
                return results.getQueryExecutionId();
            }

            public List<FileInfo> getPage() {
                return nodeInfos;
            }

            public boolean hasMoreItems() {
                return results.hasMoreItems();
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                return totalCount;
            }
        };
    }

    @Override
    @Auditable(parameters={"contextNodeRef", "files", "folders", "ignoreTypeQNames", "sortProps", "pagingRequest"})
    public PagingResults<FileInfo> list(NodeRef contextNodeRef, boolean files, boolean folders, Set<QName> ignoreTypeQNames, List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) {
        ParameterCheck.mandatory((String)"contextNodeRef", (Object)contextNodeRef);
        ParameterCheck.mandatory((String)"pagingRequest", (Object)pagingRequest);
        Set<QName> searchTypeQNames = this.buildTypes(files, folders, ignoreTypeQNames);
        CannedQueryResults<NodeRef> results = this.listImpl(contextNodeRef, null, searchTypeQNames, sortProps, pagingRequest);
        return this.getPagingResults(pagingRequest, results);
    }

    @Override
    public PagingResults<FileInfo> list(NodeRef contextNodeRef, boolean files, boolean folders, String pattern, Set<QName> ignoreQNameTypes, List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) {
        ParameterCheck.mandatory((String)"contextNodeRef", (Object)contextNodeRef);
        ParameterCheck.mandatory((String)"pagingRequest", (Object)pagingRequest);
        Set<QName> searchTypeQNames = this.buildTypes(files, folders, ignoreQNameTypes);
        CannedQueryResults<NodeRef> results = this.listImpl(contextNodeRef, pattern, searchTypeQNames, sortProps, pagingRequest);
        return this.getPagingResults(pagingRequest, results);
    }

    private CannedQueryResults<NodeRef> listImpl(NodeRef contextNodeRef, boolean files, boolean folders) {
        Set<QName> searchTypeQNames = this.buildTypes(files, folders, null);
        return this.listImpl(contextNodeRef, searchTypeQNames);
    }

    private CannedQueryResults<NodeRef> listImpl(NodeRef contextNodeRef, Set<QName> searchTypeQNames) {
        return this.listImpl(contextNodeRef, null, searchTypeQNames, null, new PagingRequest(this.defaultListMaxResults, null));
    }

    private CannedQueryResults<NodeRef> listImpl(NodeRef contextNodeRef, String pattern, Set<QName> searchTypeQNames, List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) {
        Long start = logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        GetChildrenCannedQueryFactory getChildrenCannedQueryFactory = (GetChildrenCannedQueryFactory)((Object)this.cannedQueryRegistry.getNamedObject(CANNED_QUERY_FILEFOLDER_LIST));
        GetChildrenCannedQuery cq = (GetChildrenCannedQuery)getChildrenCannedQueryFactory.getCannedQuery(contextNodeRef, pattern, searchTypeQNames, null, sortProps, pagingRequest);
        CannedQueryResults results = cq.execute();
        if (start != null) {
            int cnt = results.getPagedResultCount();
            int skipCount = pagingRequest.getSkipCount();
            int maxItems = pagingRequest.getMaxItems();
            boolean hasMoreItems = results.hasMoreItems();
            Pair totalCount = pagingRequest.getRequestTotalCountMax() > 0 ? results.getTotalResultCount() : null;
            int pageNum = skipCount / maxItems + 1;
            logger.debug((Object)("List: " + cnt + " items in " + (System.currentTimeMillis() - start) + " msecs [pageNum=" + pageNum + ",skip=" + skipCount + ",max=" + maxItems + ",hasMorePages=" + hasMoreItems + ",totalCount=" + totalCount + ",parentNodeRef=" + contextNodeRef + "]"));
        }
        return results;
    }

    @Override
    public List<FileInfo> listFiles(NodeRef contextNodeRef) {
        List<FileInfo> results = this.listSimple(contextNodeRef, true, false);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("List files: \n   context: " + contextNodeRef + "\n" + "   results: " + results));
        }
        return results;
    }

    @Override
    public List<FileInfo> listFolders(NodeRef contextNodeRef) {
        List<FileInfo> results = this.listSimple(contextNodeRef, false, true);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("List for folders: \n   context: " + contextNodeRef + "\n" + "   results: " + results));
        }
        return results;
    }

    @Override
    public List<FileInfo> listDeepFolders(NodeRef contextNodeRef, SubFolderFilter filter) {
        List<NodeRef> nodeRefs = this.listSimpleDeep(contextNodeRef, false, true, filter);
        List<FileInfo> results = this.toFileInfo(nodeRefs);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Deep search for files: \n   context: " + contextNodeRef + "\n" + "   results: " + results.size()));
        }
        return results;
    }

    @Override
    public NodeRef getLocalizedSibling(NodeRef nodeRef) {
        Locale userLocale = I18NUtil.getLocale();
        String name = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
        NodeRef parentNodeRef = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
        Pair<String, String> split = this.getExtension(name, false);
        String base = (String)split.getFirst();
        String ext = (String)split.getSecond();
        NodeRef resultNodeRef = nodeRef;
        ResourceBundle.Control resourceHelper = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_DEFAULT);
        List<Locale> candidateLocales = resourceHelper.getCandidateLocales(base, userLocale);
        for (Locale candidateLocale : candidateLocales) {
            String filename = resourceHelper.toBundleName(base, candidateLocale) + "." + ext;
            NodeRef foundNodeRef = this.searchSimple(parentNodeRef, filename);
            if (foundNodeRef == null) continue;
            resultNodeRef = foundNodeRef;
            break;
        }
        return resultNodeRef;
    }

    @Override
    public NodeRef searchSimple(NodeRef contextNodeRef, String name) {
        NodeRef childNodeRef = this.nodeService.getChildByName(contextNodeRef, ContentModel.ASSOC_CONTAINS, name);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Simple name search results: \n   parent: " + contextNodeRef + "\n" + "   name: " + name + "\n" + "   result: " + childNodeRef));
        }
        return childNodeRef;
    }

    @Override
    public List<FileInfo> search(NodeRef contextNodeRef, String namePattern, boolean includeSubFolders) {
        return this.search(contextNodeRef, namePattern, true, true, includeSubFolders);
    }

    @Override
    public List<FileInfo> search(NodeRef contextNodeRef, String namePattern, boolean fileSearch, boolean folderSearch, boolean includeSubFolders) {
        List<NodeRef> nodeRefs = this.searchInternal(contextNodeRef, namePattern, fileSearch, folderSearch, includeSubFolders);
        List<FileInfo> results = this.toFileInfo(nodeRefs);
        Iterator<FileInfo> iterator = results.iterator();
        while (iterator.hasNext()) {
            FileInfo file = iterator.next();
            if (file.isFolder() && !folderSearch) {
                iterator.remove();
                continue;
            }
            if (file.isFolder() || fileSearch) continue;
            iterator.remove();
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Deep search: \n   context: " + contextNodeRef + "\n" + "   pattern: " + namePattern + "\n" + "   files: " + fileSearch + "\n" + "   folders: " + folderSearch + "\n" + "   deep: " + includeSubFolders + "\n" + "   results: " + results));
        }
        return results;
    }

    private List<NodeRef> searchInternal(NodeRef contextNodeRef, String namePattern, boolean fileSearch, boolean folderSearch, boolean includeSubFolders) {
        if (!fileSearch && !folderSearch) {
            return Collections.emptyList();
        }
        if (namePattern == null) {
            namePattern = LUCENE_MULTI_CHAR_WILDCARD;
        }
        boolean anyName = namePattern.equals(LUCENE_MULTI_CHAR_WILDCARD);
        List nodeRefs = null;
        if (anyName) {
            nodeRefs = includeSubFolders ? this.listSimpleDeep(contextNodeRef, fileSearch, folderSearch, null) : this.listImpl(contextNodeRef, fileSearch, folderSearch).getPage();
        } else {
            QueryParameterDefinition[] params = null;
            if (namePattern != null) {
                namePattern = SearchLanguageConversion.convert((SearchLanguageConversion.LanguageDefinition)SearchLanguageConversion.DEF_LUCENE, (SearchLanguageConversion.LanguageDefinition)SearchLanguageConversion.DEF_XPATH_LIKE, (String)namePattern);
                params = new QueryParameterDefinition[]{new QueryParameterDefImpl(ContentModel.PROP_NAME, this.dictionaryService.getDataType(DataTypeDefinition.TEXT), true, namePattern)};
            }
            String query = null;
            query = includeSubFolders ? (!fileSearch && folderSearch ? XPATH_QUERY_DEEP_FOLDERS : (fileSearch && !folderSearch ? XPATH_QUERY_DEEP_FILES : XPATH_QUERY_DEEP_ALL)) : XPATH_QUERY_SHALLOW_ALL;
            nodeRefs = this.searchService.selectNodes(contextNodeRef, query, params, (NamespacePrefixResolver)this.namespaceService, false);
        }
        return nodeRefs;
    }

    private List<FileInfo> listSimple(NodeRef contextNodeRef, boolean files, boolean folders) throws InvalidTypeException {
        CannedQueryResults<NodeRef> cq = this.listImpl(contextNodeRef, files, folders);
        List nodeRefs = cq.getPage();
        List<FileInfo> results = this.toFileInfo(nodeRefs);
        return PermissionCheckedValue.PermissionCheckedValueMixin.create(results);
    }

    private Set<QName> buildTypes(boolean files, boolean folders, Set<QName> ignoreQNameTypes) {
        HashSet<QName> searchTypeQNames = new HashSet<QName>(100);
        if (folders) {
            searchTypeQNames.addAll(this.buildFolderTypes());
        }
        if (files) {
            searchTypeQNames.addAll(this.buildFileTypes());
        }
        if (ignoreQNameTypes != null) {
            searchTypeQNames.removeAll(ignoreQNameTypes);
        }
        return searchTypeQNames;
    }

    private Set<QName> buildFolderTypes() {
        HashSet<QName> folderTypeQNames = new HashSet<QName>(50);
        Collection qnames = this.dictionaryService.getSubTypes(ContentModel.TYPE_FOLDER, true);
        folderTypeQNames.addAll(qnames);
        folderTypeQNames.add(ContentModel.TYPE_FOLDER);
        qnames = this.dictionaryService.getSubTypes(ContentModel.TYPE_SYSTEM_FOLDER, true);
        folderTypeQNames.removeAll(qnames);
        folderTypeQNames.remove(ContentModel.TYPE_SYSTEM_FOLDER);
        return folderTypeQNames;
    }

    private Set<QName> buildFileTypes() {
        HashSet<QName> fileTypeQNames = new HashSet<QName>(50);
        Collection qnames = this.dictionaryService.getSubTypes(ContentModel.TYPE_CONTENT, true);
        fileTypeQNames.addAll(qnames);
        fileTypeQNames.add(ContentModel.TYPE_CONTENT);
        qnames = this.dictionaryService.getSubTypes(ContentModel.TYPE_LINK, true);
        fileTypeQNames.addAll(qnames);
        fileTypeQNames.add(ContentModel.TYPE_LINK);
        return fileTypeQNames;
    }

    private List<NodeRef> listSimpleDeep(NodeRef contextNodeRef, boolean files, boolean folders, SubFolderFilter folderFilter) {
        HashSet fileTypeQNames;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("searchSimpleDeep contextNodeRef:" + contextNodeRef));
        }
        ArrayList<NodeRef> result = new ArrayList<NodeRef>();
        Set<QName> folderTypeQNames = this.buildFolderTypes();
        HashSet hashSet = fileTypeQNames = files ? this.buildFileTypes() : new HashSet(0);
        if (!folders && !files) {
            return Collections.emptyList();
        }
        if (folderTypeQNames.size() == 0) {
            return Collections.emptyList();
        }
        Stack<NodeRef> toSearch = new Stack<NodeRef>();
        toSearch.push(contextNodeRef);
        while (!toSearch.empty()) {
            NodeRef currentDir = (NodeRef)toSearch.pop();
            List folderAssocRefs = this.nodeService.getChildAssocs(currentDir, folderTypeQNames);
            for (ChildAssociationRef folderRef : folderAssocRefs) {
                boolean include = true;
                if (folderFilter != null) {
                    include = folderFilter.isEnterSubfolder(folderRef);
                    if (include) {
                        toSearch.push(folderRef.getChildRef());
                    }
                } else {
                    toSearch.push(folderRef.getChildRef());
                }
                if (!folders || !include) continue;
                result.add(folderRef.getChildRef());
            }
            if (!files) continue;
            List fileAssocRefs = this.nodeService.getChildAssocs(currentDir, fileTypeQNames);
            for (ChildAssociationRef fileRef : fileAssocRefs) {
                result.add(fileRef.getChildRef());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("searchSimpleDeep finished size:" + result.size()));
        }
        return result;
    }

    @Override
    public FileInfo rename(NodeRef sourceNodeRef, String newName) throws FileExistsException, FileNotFoundException {
        return this.moveOrCopy(sourceNodeRef, null, null, newName, true);
    }

    @Override
    public FileInfo move(NodeRef sourceNodeRef, NodeRef targetParentRef, String newName) throws FileExistsException, FileNotFoundException {
        return this.moveOrCopy(sourceNodeRef, null, targetParentRef, newName, true);
    }

    @Override
    public FileInfo moveFrom(NodeRef sourceNodeRef, NodeRef sourceParentRef, NodeRef targetParentRef, String newName) throws FileExistsException, FileNotFoundException {
        return this.moveOrCopy(sourceNodeRef, sourceParentRef, targetParentRef, newName, true);
    }

    @Override
    public FileInfo move(NodeRef sourceNodeRef, NodeRef sourceParentRef, NodeRef targetParentRef, String newName) throws FileExistsException, FileNotFoundException {
        return this.moveOrCopy(sourceNodeRef, sourceParentRef, targetParentRef, newName, true);
    }

    @Override
    public FileInfo copy(NodeRef sourceNodeRef, NodeRef targetParentRef, String newName) throws FileExistsException, FileNotFoundException {
        return this.moveOrCopy(sourceNodeRef, null, targetParentRef, newName, false);
    }

    private FileInfo moveOrCopy(NodeRef sourceNodeRef, NodeRef sourceParentRef, NodeRef targetParentRef, String newName, boolean move) throws FileExistsException, FileNotFoundException {
        boolean changedParent;
        FileInfo beforeFileInfo = this.toFileInfo(sourceNodeRef, true);
        if (newName == null) {
            newName = beforeFileInfo.getName();
        }
        boolean nameChanged = !newName.equals(beforeFileInfo.getName());
        boolean isPrimaryParent = true;
        if (sourceParentRef != null) {
            isPrimaryParent = sourceParentRef.equals((Object)this.nodeService.getPrimaryParent(sourceNodeRef).getParentRef());
        }
        ChildAssociationRef assocRef = null;
        if (isPrimaryParent) {
            assocRef = this.nodeService.getPrimaryParent(sourceNodeRef);
        } else {
            List assocList = this.nodeService.getParentAssocs(sourceNodeRef);
            if (assocList != null) {
                for (ChildAssociationRef assocListEntry : assocList) {
                    if (!sourceParentRef.equals((Object)assocListEntry.getParentRef())) continue;
                    assocRef = assocListEntry;
                    break;
                }
            }
        }
        if (targetParentRef == null) {
            targetParentRef = assocRef.getParentRef();
        }
        boolean bl = changedParent = !targetParentRef.equals((Object)assocRef.getParentRef());
        if (!nameChanged && !changedParent) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Doing nothing - neither filename or parent has changed: \n   parent: " + targetParentRef + "\n" + "   before: " + beforeFileInfo + "\n" + "   new name: " + newName));
            }
            return beforeFileInfo;
        }
        QName existingQName = assocRef.getQName();
        QName qname = nameChanged && !this.systemNamespaces.contains(existingQName.getNamespaceURI()) ? QName.createQName((String)assocRef.getQName().getNamespaceURI(), (String)QName.createValidLocalName((String)newName)) : existingQName;
        QName targetParentType = this.nodeService.getType(targetParentRef);
        QName assocTypeQname = null;
        if (nameChanged && move) {
            assocTypeQname = assocRef.getTypeQName();
        } else if (this.dictionaryService.isSubClass(targetParentType, ContentModel.TYPE_FOLDER)) {
            assocTypeQname = ContentModel.ASSOC_CONTAINS;
        } else if (this.dictionaryService.isSubClass(targetParentType, ContentModel.TYPE_CONTAINER)) {
            assocTypeQname = ContentModel.ASSOC_CHILDREN;
        } else {
            throw new InvalidTypeException("Unexpected type (" + targetParentType + ") for target parent: " + targetParentRef);
        }
        NodeRef targetNodeRef = null;
        if (move) {
            if (!this.isSystemPath(sourceNodeRef)) {
                if (nameChanged) {
                    this.nodeService.setProperty(sourceNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)GUID.generate()));
                }
                try {
                    ChildAssociationRef newAssocRef = null;
                    if (isPrimaryParent) {
                        newAssocRef = this.nodeService.moveNode(sourceNodeRef, targetParentRef, assocTypeQname, qname);
                    } else {
                        this.nodeService.removeChild(sourceParentRef, sourceNodeRef);
                        newAssocRef = this.nodeService.addChild(targetParentRef, sourceNodeRef, assocRef.getTypeQName(), assocRef.getQName());
                    }
                    targetNodeRef = newAssocRef.getChildRef();
                }
                catch (DuplicateChildNodeNameException e) {
                    throw new FileExistsException(targetParentRef, newName);
                }
            } else {
                targetNodeRef = sourceNodeRef;
            }
        } else {
            try {
                targetNodeRef = this.copyService.copy(sourceNodeRef, targetParentRef, assocTypeQname, qname, true);
            }
            catch (DuplicateChildNodeNameException e) {
                throw new FileExistsException(targetParentRef, newName);
            }
        }
        String currentName = (String)((Object)this.nodeService.getProperty(targetNodeRef, ContentModel.PROP_NAME));
        if (!currentName.equals(newName)) {
            try {
                String newMimetype;
                String targetMimetype;
                this.nodeService.setProperty(targetNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)newName));
                ContentData contentData = (ContentData)this.nodeService.getProperty(targetNodeRef, ContentModel.PROP_CONTENT);
                String oldExt = (String)this.getExtension(beforeFileInfo.getName(), true).getSecond();
                String newExt = (String)this.getExtension(newName, true).getSecond();
                if (!(contentData == null || newExt.length() == 0 || "tmp".equalsIgnoreCase(newExt) || newExt.equalsIgnoreCase(oldExt) || (targetMimetype = contentData.getMimetype()).equalsIgnoreCase(newMimetype = this.mimetypeService.guessMimetype(newName)))) {
                    contentData = ContentData.setMimetype((ContentData)contentData, (String)newMimetype);
                    this.nodeService.setProperty(targetNodeRef, ContentModel.PROP_CONTENT, (Serializable)contentData);
                }
            }
            catch (DuplicateChildNodeNameException e) {
                throw new FileExistsException(targetParentRef, newName);
            }
        }
        FileInfo afterFileInfo = this.toFileInfo(targetNodeRef, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("" + (move ? "Moved" : "Copied") + " node: \n" + "   parent: " + targetParentRef + "\n" + "   before: " + beforeFileInfo + "\n" + "   after: " + afterFileInfo));
        }
        return afterFileInfo;
    }

    private boolean isSystemPath(NodeRef nodeRef) {
        Path path = this.nodeService.getPath(nodeRef);
        String prefixedPath = path.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        return this.systemPaths.contains(prefixedPath);
    }

    @Override
    public FileInfo create(NodeRef parentNodeRef, String name, QName typeQName) throws FileExistsException {
        return this.createImpl(parentNodeRef, name, typeQName, null);
    }

    @Override
    public FileInfo create(NodeRef parentNodeRef, String name, QName typeQName, QName assocQName) throws FileExistsException {
        return this.createImpl(parentNodeRef, name, typeQName, assocQName);
    }

    private FileInfo createImpl(NodeRef parentNodeRef, String name, QName typeQName, QName assocQName) throws FileExistsException {
        HashMap<QName, String> properties = new HashMap<QName, String>(11);
        properties.put(ContentModel.PROP_NAME, name);
        if (assocQName == null) {
            assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)name));
        }
        ChildAssociationRef assocRef = null;
        try {
            assocRef = this.nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CONTAINS, assocQName, typeQName, properties);
        }
        catch (DuplicateChildNodeNameException e) {
            throw new FileExistsException(parentNodeRef, name);
        }
        NodeRef nodeRef = assocRef.getChildRef();
        FileInfo fileInfo = this.toFileInfo(nodeRef, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created: \n   parent: " + parentNodeRef + "\n" + "   created: " + fileInfo));
        }
        return fileInfo;
    }

    @Override
    public void delete(NodeRef nodeRef) {
        this.nodeService.deleteNode(nodeRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleted: \n   node: " + nodeRef));
        }
    }

    public FileInfo makeFolders(NodeRef parentNodeRef, List<String> pathElements, QName folderTypeQName) {
        return FileFolderUtil.makeFolders(this, parentNodeRef, pathElements, folderTypeQName);
    }

    public static FileInfo makeFolders(FileFolderService service, NodeRef parentNodeRef, List<String> pathElements, QName folderTypeQName) {
        return FileFolderUtil.makeFolders(service, parentNodeRef, pathElements, folderTypeQName);
    }

    @Override
    public List<FileInfo> getNamePath(NodeRef rootNodeRef, NodeRef nodeRef) throws FileNotFoundException {
        if (rootNodeRef == null) {
            rootNodeRef = this.nodeService.getRootNode(nodeRef.getStoreRef());
        }
        try {
            ArrayList<FileInfo> results = new ArrayList<FileInfo>(10);
            Path path = this.nodeService.getPath(nodeRef);
            boolean foundRoot = false;
            for (Path.Element element : path) {
                Path.ChildAssocElement assocElement = (Path.ChildAssocElement)element;
                NodeRef childNodeRef = assocElement.getRef().getChildRef();
                if (childNodeRef.equals((Object)rootNodeRef)) {
                    foundRoot = true;
                    continue;
                }
                if (!foundRoot) continue;
                FileInfo pathInfo = this.toFileInfo(childNodeRef, true);
                if (!results.isEmpty() && !results.get(results.size() - 1).isFolder()) {
                    throw new InvalidTypeException("File is not the last element in path: files cannot contain other files.");
                }
                results.add(pathInfo);
            }
            if (!foundRoot || results.size() == 0) {
                throw new FileNotFoundException(nodeRef);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Built name path for node: \n   root: " + rootNodeRef + "\n" + "   node: " + nodeRef + "\n" + "   path: " + results));
            }
            return results;
        }
        catch (InvalidNodeRefException e) {
            throw new FileNotFoundException(nodeRef);
        }
    }

    @Override
    public FileInfo resolveNamePath(NodeRef rootNodeRef, List<String> pathElements) throws FileNotFoundException {
        return this.resolveNamePath(rootNodeRef, pathElements, true);
    }

    @Override
    public FileInfo resolveNamePath(NodeRef rootNodeRef, List<String> pathElements, boolean mustExist) throws FileNotFoundException {
        if (pathElements.size() == 0) {
            throw new IllegalArgumentException("Path elements list is empty");
        }
        NodeRef parentNodeRef = rootNodeRef;
        StringBuilder currentPath = new StringBuilder(pathElements.size() << 4);
        int folderCount = pathElements.size() - 1;
        for (int i = 0; i < folderCount; ++i) {
            String pathElement = pathElements.get(i);
            NodeRef folderNodeRef = this.searchSimple(parentNodeRef, pathElement);
            if (folderNodeRef == null) {
                StringBuilder sb = new StringBuilder(128);
                sb.append("Folder not found: " + currentPath);
                throw new FileNotFoundException(sb.toString());
            }
            parentNodeRef = folderNodeRef;
        }
        String pathElement = pathElements.get(pathElements.size() - 1);
        NodeRef fileNodeRef = this.searchSimple(parentNodeRef, pathElement);
        if (fileNodeRef == null) {
            if (mustExist) {
                throw new FileNotFoundException("File not found: " + currentPath);
            }
            return null;
        }
        FileInfo result = this.getFileInfo(fileNodeRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resoved path element: \n   root: " + rootNodeRef + "\n" + "   path: " + currentPath + "\n" + "   node: " + result));
        }
        return result;
    }

    @Override
    public FileInfo getFileInfo(NodeRef nodeRef) {
        try {
            return this.toFileInfo(nodeRef, true);
        }
        catch (InvalidTypeException e) {
            return null;
        }
    }

    @Override
    public ContentReader getReader(NodeRef nodeRef) {
        FileInfo fileInfo = this.toFileInfo(nodeRef, false);
        if (fileInfo.isFolder()) {
            throw new InvalidTypeException("Unable to get a content reader for a folder: " + fileInfo);
        }
        return this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
    }

    @Override
    public ContentWriter getWriter(NodeRef nodeRef) {
        FileInfo fileInfo = this.toFileInfo(nodeRef, false);
        if (fileInfo.isFolder()) {
            throw new InvalidTypeException("Unable to get a content writer for a folder: " + fileInfo);
        }
        ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        if (writer.getMimetype() == null) {
            String name = fileInfo.getName();
            writer.guessMimetype(name);
        }
        return writer;
    }

    private Pair<String, String> getExtension(String name, boolean useLastDot) {
        String ext = "";
        String base = name;
        if (name != null) {
            int index;
            name = name.trim();
            int n = index = useLastDot ? name.lastIndexOf(46) : name.indexOf(46);
            if (index > -1 && index < name.length() - 1) {
                base = name.substring(0, index);
                ext = name.substring(index + 1);
            }
        }
        return new Pair((Object)base, (Object)ext);
    }

    public static class InvalidTypeException
    extends RuntimeException {
        private static final long serialVersionUID = -310101369475434280L;

        public InvalidTypeException(String msg) {
            super(msg);
        }
    }
}

