/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.filefolder.FileInfoImpl;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.FileFilterMode;
import org.alfresco.util.PatternFilter;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilenameFilteringInterceptor
implements MethodInterceptor {
    private static Log logger = LogFactory.getLog(FilenameFilteringInterceptor.class);
    private NodeService nodeService;
    private PermissionService permissionService;
    private PatternFilter temporaryFiles;
    private PatternFilter systemPaths;
    private HiddenAspect hiddenAspect;
    private boolean enabled = true;

    public void setTemporaryFiles(PatternFilter temporaryFiles) {
        this.temporaryFiles = temporaryFiles;
    }

    public void setHiddenAspect(HiddenAspect hiddenAspect) {
        this.hiddenAspect = hiddenAspect;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setSystemPaths(PatternFilter systemPaths) {
        this.systemPaths = systemPaths;
    }

    public FileFilterMode.Mode getMode() {
        return FileFilterMode.getMode();
    }

    public FileFilterMode.Client getClient() {
        return FileFilterMode.getClient();
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    private void checkTemporaryAspect(boolean isTemporary, FileInfo fileInfo) {
        NodeRef nodeRef = fileInfo.getNodeRef();
        if (isTemporary) {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_TEMPORARY, null);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Applied temporary marker: " + fileInfo));
            }
        } else if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TEMPORARY)) {
            this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_TEMPORARY);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removed temporary marker: " + fileInfo));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object runAsSystem(MethodInvocation invocation) throws Throwable {
        Object ret = null;
        AuthenticationUtil.pushAuthentication();
        try {
            AuthenticationUtil.setRunAsUserSystem();
            ret = invocation.proceed();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            AuthenticationUtil.popAuthentication();
            throw throwable;
        }
        AuthenticationUtil.popAuthentication();
        return ret;
    }

    private boolean isSystemPath(NodeRef parentNodeRef, String filename) {
        boolean ret = false;
        Path path = this.nodeService.getPath(parentNodeRef);
        for (Path.ChildAssocElement elem : path) {
            QName qname = elem.getRef().getQName();
            if (qname == null || !this.systemPaths.isFiltered(qname.getLocalName())) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private int getSystemFileVisibilityMask() {
        int mask = 0;
        mask |= this.hiddenAspect.getClientVisibilityMask(FileFilterMode.Client.cifs, HiddenAspect.Visibility.HiddenAttribute);
        mask |= this.hiddenAspect.getClientVisibilityMask(FileFilterMode.Client.webdav, HiddenAspect.Visibility.Visible);
        mask |= this.hiddenAspect.getClientVisibilityMask(FileFilterMode.Client.nfs, HiddenAspect.Visibility.Visible);
        return mask |= this.hiddenAspect.getClientVisibilityMask(FileFilterMode.Client.ftp, HiddenAspect.Visibility.Visible);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        Object ret = null;
        if (this.enabled) {
            if (methodName.startsWith("create")) {
                NodeRef nodeRef = (NodeRef)invocation.getArguments()[0];
                String filename = (String)invocation.getArguments()[1];
                if (this.getMode() == FileFilterMode.Mode.ENHANCED) {
                    if (this.systemPaths.isFiltered(filename)) {
                        ret = this.runAsSystem(invocation);
                        FileInfoImpl fileInfo = (FileInfoImpl)ret;
                        this.permissionService.setPermission(fileInfo.getNodeRef(), "GROUP_EVERYONE", "FullControl", true);
                        this.checkTemporaryAspect(true, fileInfo);
                        this.hiddenAspect.hideNode(fileInfo, this.getSystemFileVisibilityMask());
                    } else {
                        ret = invocation.proceed();
                        FileInfoImpl fileInfo = (FileInfoImpl)ret;
                        if (this.isSystemPath(nodeRef, filename)) {
                            this.checkTemporaryAspect(true, fileInfo);
                            this.hiddenAspect.hideNode(fileInfo, this.getSystemFileVisibilityMask());
                        } else {
                            this.checkTemporaryAspect(this.temporaryFiles.isFiltered(filename), (FileInfo)ret);
                            this.hiddenAspect.checkHidden(fileInfo, false);
                        }
                    }
                } else {
                    ret = invocation.proceed();
                    FileInfoImpl fileInfo = (FileInfoImpl)ret;
                    this.checkTemporaryAspect(this.temporaryFiles.isFiltered(filename), fileInfo);
                }
            } else if (methodName.startsWith("rename") || methodName.startsWith("move") || methodName.startsWith("copy")) {
                ret = invocation.proceed();
                FileInfoImpl fileInfo = (FileInfoImpl)ret;
                String filename = fileInfo.getName();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Checking filename returned by " + methodName + ": " + filename));
                }
                this.checkTemporaryAspect(this.temporaryFiles.isFiltered(filename), fileInfo);
                if (this.getMode() == FileFilterMode.Mode.ENHANCED) {
                    this.hiddenAspect.checkHidden(fileInfo, true);
                }
            } else {
                ret = invocation.proceed();
            }
        } else {
            ret = invocation.proceed();
        }
        return ret;
    }
}

