/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryNamespaceComponent;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.imap.AlfrescoImapFolder;
import org.alfresco.repo.imap.AlfrescoImapUser;
import org.alfresco.repo.imap.ImapService;
import org.alfresco.repo.model.filefolder.FilenameFilteringInterceptor;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.FileFilterMode;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HiddenAspectTest {
    @Rule
    public TestName name = new TestName();
    private static final ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private HiddenAspect hiddenAspect;
    private TransactionService transactionService;
    private NodeDAO nodeDAO;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private MutableAuthenticationService authenticationService;
    private UserTransaction txn;
    private SearchService searchService;
    private DictionaryNamespaceComponent namespacePrefixResolver;
    private ImapService imapService;
    private PersonService personService;
    private FilenameFilteringInterceptor interceptor;
    private StoreRef storeRef;
    private NodeRef rootNodeRef;
    private NodeRef topNodeRef;
    private final String MAILBOX_NAME_A = "mailbox_a";
    private final String MAILBOX_NAME_B = ".mailbox_a";
    private String anotherUserName;
    private AlfrescoImapUser user;

    @Before
    public void setup() throws SystemException, NotSupportedException {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.nodeService = serviceRegistry.getNodeService();
        this.fileFolderService = serviceRegistry.getFileFolderService();
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("AuthenticationService");
        this.hiddenAspect = (HiddenAspect)ctx.getBean("hiddenAspect");
        this.interceptor = (FilenameFilteringInterceptor)ctx.getBean("filenameFilteringInterceptor");
        this.namespacePrefixResolver = (DictionaryNamespaceComponent)ctx.getBean("namespaceService");
        this.imapService = serviceRegistry.getImapService();
        this.personService = serviceRegistry.getPersonService();
        this.searchService = serviceRegistry.getSearchService();
        this.nodeDAO = (NodeDAO)ctx.getBean("nodeDAO");
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.storeRef = this.nodeService.createStore("workspace", this.getName() + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        this.topNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"working root"), ContentModel.TYPE_FOLDER).getChildRef();
        this.anotherUserName = "user" + System.currentTimeMillis();
        PropertyMap testUser = new PropertyMap();
        testUser.put(ContentModel.PROP_USERNAME, this.anotherUserName);
        testUser.put(ContentModel.PROP_FIRSTNAME, this.anotherUserName);
        testUser.put(ContentModel.PROP_LASTNAME, this.anotherUserName);
        testUser.put(ContentModel.PROP_EMAIL, this.anotherUserName + "@alfresco.com");
        testUser.put(ContentModel.PROP_JOBTITLE, "jobTitle");
        this.personService.createPerson(testUser);
        this.authenticationService.createAuthentication(this.anotherUserName, this.anotherUserName.toCharArray());
        this.user = new AlfrescoImapUser(this.anotherUserName + "@alfresco.com", this.anotherUserName, this.anotherUserName);
    }

    private String getName() {
        return this.name.getMethodName();
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.txn.getStatus() != 4 && this.txn.getStatus() != 3) {
                this.txn.rollback();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHiddenFilesEnhancedClient() {
        FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.webdav);
        try {
            NodeRef parent = this.fileFolderService.create(this.topNodeRef, "New Folder", ContentModel.TYPE_FOLDER).getNodeRef();
            NodeRef child = this.fileFolderService.create(parent, "file.tmp", ContentModel.TYPE_CONTENT).getNodeRef();
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_TEMPORARY));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_HIDDEN));
            List<FileInfo> children = this.fileFolderService.list(parent);
            Assert.assertEquals((long)1L, (long)children.size());
            parent = this.fileFolderService.create(this.topNodeRef, "abc", ContentModel.TYPE_FOLDER).getNodeRef();
            child = this.fileFolderService.create(parent, ".TemporaryItems", ContentModel.TYPE_FOLDER).getNodeRef();
            NodeRef child1 = this.fileFolderService.create(child, "inTemporaryItems", ContentModel.TYPE_FOLDER).getNodeRef();
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_TEMPORARY));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child1, ContentModel.ASPECT_TEMPORARY));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child1, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child1, ContentModel.ASPECT_INDEX_CONTROL));
            ResultSet results = this.searchForName(".TemporaryItems");
            Assert.assertEquals((String)"", (long)0L, (long)results.length());
            children = this.fileFolderService.list(parent);
            Assert.assertEquals((long)1L, (long)children.size());
            FileFilterMode.Client saveClient = FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.script);
            try {
                children = this.fileFolderService.list(parent);
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                FileFilterMode.setClient((FileFilterMode.Client)saveClient);
                throw throwable;
            }
            FileFilterMode.setClient((FileFilterMode.Client)saveClient);
            Assert.assertEquals((long)0L, (long)children.size());
            parent = this.fileFolderService.create(this.topNodeRef, "Folder 2", ContentModel.TYPE_FOLDER).getNodeRef();
            child = this.fileFolderService.create(parent, "Thumbs.db", ContentModel.TYPE_CONTENT).getNodeRef();
            Assert.assertFalse((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_TEMPORARY));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_INDEX_CONTROL));
            results = this.searchForName("Thumbs.db");
            Assert.assertEquals((String)"", (long)0L, (long)results.length());
            children = this.fileFolderService.list(parent);
            Assert.assertEquals((long)1L, (long)children.size());
            Assert.assertEquals((Object)((Object)HiddenAspect.Visibility.Visible), (Object)((Object)this.hiddenAspect.getVisibility(FileFilterMode.Client.ftp, child)));
            Assert.assertEquals((Object)((Object)HiddenAspect.Visibility.Visible), (Object)((Object)this.hiddenAspect.getVisibility(FileFilterMode.Client.nfs, child)));
            Assert.assertEquals((Object)((Object)HiddenAspect.Visibility.Visible), (Object)((Object)this.hiddenAspect.getVisibility(FileFilterMode.Client.webdav, child)));
            Assert.assertEquals((Object)((Object)HiddenAspect.Visibility.HiddenAttribute), (Object)((Object)this.hiddenAspect.getVisibility(FileFilterMode.Client.cifs, child)));
            Assert.assertEquals((Object)((Object)HiddenAspect.Visibility.NotVisible), (Object)((Object)this.hiddenAspect.getVisibility(FileFilterMode.Client.script, child)));
            Assert.assertEquals((Object)((Object)HiddenAspect.Visibility.NotVisible), (Object)((Object)this.hiddenAspect.getVisibility(FileFilterMode.Client.webclient, child)));
            NodeRef node = this.fileFolderService.create(this.topNodeRef, "surf-config", ContentModel.TYPE_FOLDER).getNodeRef();
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
            results = this.searchForName("surf-config");
            Assert.assertEquals((String)"", (long)0L, (long)results.length());
            for (FileFilterMode.Client client : this.hiddenAspect.getClients()) {
                Assert.assertEquals((Object)((Object)HiddenAspect.Visibility.NotVisible), (Object)((Object)this.hiddenAspect.getVisibility(client, node)));
            }
            node = this.fileFolderService.create(this.topNodeRef, ".DS_Store", ContentModel.TYPE_CONTENT).getNodeRef();
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
            results = this.searchForName(".DS_Store");
            Assert.assertEquals((String)"", (long)0L, (long)results.length());
            for (FileFilterMode.Client client : this.hiddenAspect.getClients()) {
                if (client == FileFilterMode.Client.cifs) {
                    Assert.assertEquals((String)("Should have hidden attribute set for client " + client), (Object)((Object)HiddenAspect.Visibility.HiddenAttribute), (Object)((Object)this.hiddenAspect.getVisibility(client, node)));
                    continue;
                }
                if (client == FileFilterMode.Client.webdav || client == FileFilterMode.Client.nfs || client == FileFilterMode.Client.ftp) {
                    Assert.assertEquals((String)("Should be visible for client " + client), (Object)((Object)HiddenAspect.Visibility.Visible), (Object)((Object)this.hiddenAspect.getVisibility(client, node)));
                    continue;
                }
                Assert.assertEquals((String)("Should not be visible for client " + client), (Object)((Object)HiddenAspect.Visibility.NotVisible), (Object)((Object)this.hiddenAspect.getVisibility(client, node)));
            }
            node = this.fileFolderService.create(this.topNodeRef, "._resourceFork", ContentModel.TYPE_FOLDER).getNodeRef();
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
            results = this.searchForName("._resourceFork");
            Assert.assertEquals((String)"", (long)0L, (long)results.length());
            for (FileFilterMode.Client client : this.hiddenAspect.getClients()) {
                Assert.assertEquals((Object)((Object)HiddenAspect.Visibility.NotVisible), (Object)((Object)this.hiddenAspect.getVisibility(client, node)));
            }
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            FileFilterMode.clearClient();
            throw throwable;
        }
        FileFilterMode.clearClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImap() {
        FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.webdav);
        try {
            this.imapService.getOrCreateMailbox(this.user, "mailbox_a", false, true);
            this.imapService.renameMailbox(this.user, "mailbox_a", ".mailbox_a");
            Assert.assertFalse((String)"Can't rename mailbox", (boolean)this.checkMailbox(this.user, "mailbox_a"));
            Assert.assertTrue((String)"Can't rename mailbox", (boolean)this.checkMailbox(this.user, ".mailbox_a"));
            Assert.assertEquals((String)"Can't rename mailbox", (long)0L, (long)this.numMailboxes(this.user, "mailbox_a"));
            Assert.assertEquals((String)"Can't rename mailbox", (long)1L, (long)this.numMailboxes(this.user, ".mailbox_a"));
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            FileFilterMode.clearClient();
            throw throwable;
        }
        FileFilterMode.clearClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRename() {
        FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.webdav);
        try {
            String nodeName = GUID.generate();
            NodeRef node = this.fileFolderService.create(this.topNodeRef, nodeName, ContentModel.TYPE_FOLDER).getNodeRef();
            NodeRef node11 = this.fileFolderService.create(node, nodeName + ".11", ContentModel.TYPE_FOLDER).getNodeRef();
            NodeRef node12 = this.fileFolderService.create(node, nodeName + ".12", ContentModel.TYPE_CONTENT).getNodeRef();
            NodeRef node21 = this.fileFolderService.create(node11, nodeName + ".21", ContentModel.TYPE_FOLDER).getNodeRef();
            NodeRef node22 = this.fileFolderService.create(node11, nodeName + ".22", ContentModel.TYPE_CONTENT).getNodeRef();
            NodeRef node31 = this.fileFolderService.create(node21, ".31", ContentModel.TYPE_FOLDER).getNodeRef();
            NodeRef node41 = this.fileFolderService.create(node31, nodeName + ".41", ContentModel.TYPE_CONTENT).getNodeRef();
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node11, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node11, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node12, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node12, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node21, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node21, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node22, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node22, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node31, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node31, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node41, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node41, ContentModel.ASPECT_INDEX_CONTROL));
            ResultSet results = this.searchForName(nodeName);
            Assert.assertEquals((String)"", (long)1L, (long)results.length());
            try {
                this.fileFolderService.rename(node, "." + nodeName);
            }
            catch (FileExistsException e) {
                Assert.fail();
            }
            catch (FileNotFoundException e) {
                Assert.fail();
            }
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node11, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node11, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node12, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node12, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node21, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node21, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node22, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node22, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node31, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node31, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node41, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node41, ContentModel.ASPECT_INDEX_CONTROL));
            results = this.searchForName(nodeName);
            Assert.assertEquals((String)"", (long)0L, (long)results.length());
            results = this.searchForName("." + nodeName);
            Assert.assertEquals((String)"", (long)0L, (long)results.length());
            try {
                this.fileFolderService.rename(node, nodeName);
            }
            catch (FileExistsException e) {
                Assert.fail();
            }
            catch (FileNotFoundException e) {
                Assert.fail();
            }
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node11, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node11, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node12, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node12, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node21, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node21, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node22, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node22, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node31, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node31, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node41, ContentModel.ASPECT_HIDDEN));
            Assert.assertTrue((boolean)this.nodeService.hasAspect(node41, ContentModel.ASPECT_INDEX_CONTROL));
            results = this.searchForName(nodeName);
            Assert.assertEquals((String)"", (long)1L, (long)results.length());
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            FileFilterMode.clearClient();
            throw throwable;
        }
        FileFilterMode.clearClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHiddenFilesBasicClient() {
        FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.imap);
        try {
            NodeRef parent = this.fileFolderService.create(this.topNodeRef, "New Folder", ContentModel.TYPE_FOLDER).getNodeRef();
            NodeRef child = this.fileFolderService.create(parent, "file.tmp", ContentModel.TYPE_CONTENT).getNodeRef();
            Assert.assertTrue((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_TEMPORARY));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_INDEX_CONTROL));
            ResultSet results = this.searchForName("file.tmp");
            Assert.assertEquals((String)"", (long)1L, (long)results.length());
            List<FileInfo> children = this.fileFolderService.list(parent);
            Assert.assertEquals((long)1L, (long)children.size());
            parent = this.fileFolderService.create(this.topNodeRef, ".TemporaryItems", ContentModel.TYPE_FOLDER).getNodeRef();
            child = this.fileFolderService.create(parent, "inTemporaryItems", ContentModel.TYPE_FOLDER).getNodeRef();
            Assert.assertFalse((boolean)this.nodeService.hasAspect(parent, ContentModel.ASPECT_TEMPORARY));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(parent, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(parent, ContentModel.ASPECT_INDEX_CONTROL));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_TEMPORARY));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_INDEX_CONTROL));
            results = this.searchForName(".TemporaryItems");
            Assert.assertEquals((String)"", (long)1L, (long)results.length());
            children = this.fileFolderService.list(parent);
            Assert.assertEquals((long)1L, (long)children.size());
            parent = this.fileFolderService.create(this.topNodeRef, "Folder 2", ContentModel.TYPE_FOLDER).getNodeRef();
            child = this.fileFolderService.create(parent, "Thumbs.db", ContentModel.TYPE_CONTENT).getNodeRef();
            Assert.assertFalse((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_TEMPORARY));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(child, ContentModel.ASPECT_INDEX_CONTROL));
            results = this.searchForName("Thumbs.db");
            Assert.assertEquals((String)"", (long)1L, (long)results.length());
            children = this.fileFolderService.list(parent);
            Assert.assertEquals((long)1L, (long)children.size());
            NodeRef node = this.fileFolderService.create(this.topNodeRef, "surf-config", ContentModel.TYPE_FOLDER).getNodeRef();
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
            results = this.searchForName("surf-config");
            Assert.assertEquals((String)"", (long)1L, (long)results.length());
            node = this.fileFolderService.create(this.topNodeRef, ".DS_Store", ContentModel.TYPE_CONTENT).getNodeRef();
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
            results = this.searchForName(".DS_Store");
            Assert.assertEquals((String)"", (long)1L, (long)results.length());
            for (FileFilterMode.Client client : this.hiddenAspect.getClients()) {
                Assert.assertEquals((String)("Should be visible for client " + client), (Object)((Object)HiddenAspect.Visibility.Visible), (Object)((Object)this.hiddenAspect.getVisibility(client, node)));
            }
            node = this.fileFolderService.create(this.topNodeRef, "._resourceFork", ContentModel.TYPE_FOLDER).getNodeRef();
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
            results = this.searchForName("._resourceFork");
            Assert.assertEquals((String)"", (long)1L, (long)results.length());
            children = this.fileFolderService.list(parent);
            Assert.assertEquals((long)1L, (long)children.size());
            String nodeName = "Node" + System.currentTimeMillis();
            node = this.fileFolderService.create(this.topNodeRef, nodeName, ContentModel.TYPE_CONTENT).getNodeRef();
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
            results = this.searchForName(nodeName);
            Assert.assertEquals((String)"", (long)1L, (long)results.length());
            try {
                this.fileFolderService.rename(node, "." + nodeName);
            }
            catch (FileExistsException e) {
                Assert.fail();
            }
            catch (FileNotFoundException e) {
                Assert.fail();
            }
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
            results = this.searchForName(nodeName);
            Assert.assertEquals((String)"", (long)1L, (long)results.length());
            results = this.searchForName("." + nodeName);
            Assert.assertEquals((String)"", (long)1L, (long)results.length());
            try {
                this.fileFolderService.rename(node, nodeName);
            }
            catch (FileExistsException e) {
                Assert.fail();
            }
            catch (FileNotFoundException e) {
                Assert.fail();
            }
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_HIDDEN));
            Assert.assertFalse((boolean)this.nodeService.hasAspect(node, ContentModel.ASPECT_INDEX_CONTROL));
            results = this.searchForName("." + nodeName);
            Assert.assertEquals((String)"", (long)1L, (long)results.length());
            this.imapService.getOrCreateMailbox(this.user, "mailbox_a", false, true);
            this.imapService.renameMailbox(this.user, "mailbox_a", ".mailbox_a");
            Assert.assertFalse((String)"Can't rename mailbox", (boolean)this.checkMailbox(this.user, "mailbox_a"));
            Assert.assertTrue((String)"Can't rename mailbox", (boolean)this.checkMailbox(this.user, ".mailbox_a"));
            Assert.assertEquals((String)"Can't rename mailbox", (long)0L, (long)this.numMailboxes(this.user, "mailbox_a"));
            Assert.assertEquals((String)"Can't rename mailbox", (long)1L, (long)this.numMailboxes(this.user, ".mailbox_a"));
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            FileFilterMode.clearClient();
            throw throwable;
        }
        FileFilterMode.clearClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckHidden() throws Exception {
        String nodeName = GUID.generate();
        this.interceptor.setEnabled(false);
        try {
            NodeRef node = this.fileFolderService.create(this.topNodeRef, nodeName, ContentModel.TYPE_FOLDER).getNodeRef();
            NodeRef node11 = this.fileFolderService.create(node, nodeName + ".11", ContentModel.TYPE_FOLDER).getNodeRef();
            NodeRef node12 = this.fileFolderService.create(node, ".12", ContentModel.TYPE_CONTENT).getNodeRef();
            NodeRef node21 = this.fileFolderService.create(node11, nodeName + ".21", ContentModel.TYPE_FOLDER).getNodeRef();
            NodeRef node22 = this.fileFolderService.create(node11, nodeName + ".22", ContentModel.TYPE_CONTENT).getNodeRef();
            NodeRef node31 = this.fileFolderService.create(node21, ".31", ContentModel.TYPE_FOLDER).getNodeRef();
            NodeRef node41 = this.fileFolderService.create(node31, nodeName + ".41", ContentModel.TYPE_CONTENT).getNodeRef();
            Assert.assertEquals((long)1L, (long)this.searchForName(".12").length());
            Assert.assertEquals((long)1L, (long)this.searchForName(".31").length());
            Assert.assertEquals((long)1L, (long)this.searchForName(nodeName + ".41").length());
            this.txn.commit();
            Object var10_9 = null;
            this.interceptor.setEnabled(true);
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.interceptor.setEnabled(true);
            throw throwable;
        }
    }

    private List<NodeRef> getHiddenNodes(final StoreRef storeRef) {
        final ArrayList<NodeRef> nodes = new ArrayList<NodeRef>(20);
        NodeDAO.NodeRefQueryCallback resultsCallback = new NodeDAO.NodeRefQueryCallback(){

            @Override
            public boolean handle(Pair<Long, NodeRef> nodePair) {
                if (storeRef == null || ((NodeRef)nodePair.getSecond()).getStoreRef().equals((Object)storeRef)) {
                    nodes.add(nodePair.getSecond());
                }
                return true;
            }
        };
        this.nodeDAO.getNodesWithAspects(Collections.singleton(ContentModel.ASPECT_HIDDEN), 0L, Long.MAX_VALUE, resultsCallback);
        return nodes;
    }

    private int numMailboxes(AlfrescoImapUser user, String mailboxName) {
        int numMailboxes = 0;
        try {
            List<AlfrescoImapFolder> folders = this.imapService.listMailboxes(user, mailboxName, false);
            numMailboxes = folders.size();
        }
        catch (AlfrescoRuntimeException e) {
            Assert.fail((String)("Unexpected exception: " + e.getMessage()));
        }
        return numMailboxes;
    }

    private boolean checkMailbox(AlfrescoImapUser user, String mailboxName) {
        try {
            this.imapService.getOrCreateMailbox(user, mailboxName, true, false);
        }
        catch (AlfrescoRuntimeException e) {
            return false;
        }
        return true;
    }

    private ResultSet searchForName(String name) {
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_NAME.toString()) + ":\"" + name + "\"");
        sp.addLocale(new Locale("en"));
        return this.searchService.query(sp);
    }
}

