/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.ml.tools;

import java.util.Locale;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.ml.tools.AbstractMultilingualTestCases;
import org.alfresco.service.cmr.repository.NodeRef;

public class MLContainerTypeTest
extends AbstractMultilingualTestCases {
    public void testEditLocale() throws Exception {
        NodeRef trans1 = this.createContent();
        NodeRef trans2 = this.createContent();
        NodeRef trans3 = this.createContent();
        NodeRef empty = null;
        this.multilingualContentService.makeTranslation(trans1, Locale.FRENCH);
        NodeRef mlContainer = this.multilingualContentService.getTranslationContainer(trans1);
        this.multilingualContentService.addTranslation(trans2, trans1, Locale.GERMAN);
        this.multilingualContentService.addTranslation(trans3, trans1, Locale.ITALIAN);
        empty = this.multilingualContentService.addEmptyTranslation(trans1, "EMPTY_" + System.currentTimeMillis(), Locale.JAPANESE);
        MLContainerTypeTest.assertFalse((String)"The setting of the locale of a mlContainer must throws an exception", (boolean)this.setLocaleProp(mlContainer, null));
        MLContainerTypeTest.assertEquals((String)"The locale of the mlContainer would not be changed", (Object)Locale.FRENCH, (Object)this.nodeService.getProperty(mlContainer, ContentModel.PROP_LOCALE));
        MLContainerTypeTest.assertTrue((String)"The setting of the locale of a mlContainer as a non-existing translation language must throws an exception", (boolean)this.setLocaleProp(mlContainer, Locale.US));
        MLContainerTypeTest.assertEquals((String)"The locale of the mlContainer would not be changed", (Object)Locale.FRENCH, (Object)this.nodeService.getProperty(mlContainer, ContentModel.PROP_LOCALE));
        MLContainerTypeTest.assertTrue((String)"The setting of the locale of a mlContainer as an empty translation language must throws an exception", (boolean)this.setLocaleProp(mlContainer, Locale.JAPANESE));
        MLContainerTypeTest.assertEquals((String)"The locale of the mlContainer would not be changed", (Object)Locale.FRENCH, (Object)this.nodeService.getProperty(mlContainer, ContentModel.PROP_LOCALE));
        MLContainerTypeTest.assertFalse((String)"The setting of the locale of a mlContainer as an existing and a non-empty translation DOESN'T throw an excpetion", (boolean)this.setLocaleProp(mlContainer, Locale.ITALIAN));
        MLContainerTypeTest.assertEquals((String)"The locale of the mlContainer would be changed", (Object)Locale.ITALIAN, (Object)this.nodeService.getProperty(mlContainer, ContentModel.PROP_LOCALE));
    }

    private boolean setLocaleProp(NodeRef node, Locale locale) throws Exception {
        Map props = this.nodeService.getProperties(node);
        props.put(ContentModel.PROP_LOCALE, locale);
        boolean exceptionCatched = false;
        try {
            this.nodeService.setProperties(node, props);
        }
        catch (IllegalArgumentException ignore) {
            exceptionCatched = true;
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        return exceptionCatched;
    }
}

