/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.AssociationPolicyDelegate;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNodeServiceImpl
implements NodeService {
    private static Log logger = LogFactory.getLog(AbstractNodeServiceImpl.class);
    private String uuid;
    private PolicyComponent policyComponent;
    protected DictionaryService dictionaryService;
    protected TransactionService transactionService;
    protected TenantService tenantService;
    protected Set<String> storesToIgnorePolicies = Collections.emptySet();
    private ClassPolicyDelegate<NodeServicePolicies.BeforeCreateStorePolicy> beforeCreateStoreDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.OnCreateStorePolicy> onCreateStoreDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.BeforeCreateNodePolicy> beforeCreateNodeDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.OnCreateNodePolicy> onCreateNodeDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.OnMoveNodePolicy> onMoveNodeDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.BeforeUpdateNodePolicy> beforeUpdateNodeDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.OnUpdateNodePolicy> onUpdateNodeDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.OnUpdatePropertiesPolicy> onUpdatePropertiesDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.BeforeDeleteNodePolicy> beforeDeleteNodeDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.OnDeleteNodePolicy> onDeleteNodeDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.OnRestoreNodePolicy> onRestoreNodePolicy;
    private ClassPolicyDelegate<NodeServicePolicies.BeforeAddAspectPolicy> beforeAddAspectDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.OnAddAspectPolicy> onAddAspectDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.BeforeRemoveAspectPolicy> beforeRemoveAspectDelegate;
    private ClassPolicyDelegate<NodeServicePolicies.OnRemoveAspectPolicy> onRemoveAspectDelegate;
    private AssociationPolicyDelegate<NodeServicePolicies.BeforeCreateNodeAssociationPolicy> beforeCreateNodeAssociationDelegate;
    private AssociationPolicyDelegate<NodeServicePolicies.OnCreateNodeAssociationPolicy> onCreateNodeAssociationDelegate;
    private AssociationPolicyDelegate<NodeServicePolicies.OnCreateChildAssociationPolicy> onCreateChildAssociationDelegate;
    private AssociationPolicyDelegate<NodeServicePolicies.BeforeDeleteChildAssociationPolicy> beforeDeleteChildAssociationDelegate;
    private AssociationPolicyDelegate<NodeServicePolicies.OnDeleteChildAssociationPolicy> onDeleteChildAssociationDelegate;
    private AssociationPolicyDelegate<NodeServicePolicies.OnCreateAssociationPolicy> onCreateAssociationDelegate;
    private AssociationPolicyDelegate<NodeServicePolicies.OnDeleteAssociationPolicy> onDeleteAssociationDelegate;

    protected AbstractNodeServiceImpl() {
        this.uuid = GUID.generate();
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setStoresToIgnorePolicies(Set<String> storesToIgnorePolicies) {
        this.storesToIgnorePolicies = storesToIgnorePolicies;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractNodeServiceImpl)) {
            return false;
        }
        AbstractNodeServiceImpl that = (AbstractNodeServiceImpl)obj;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public void init() {
        this.beforeCreateStoreDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.BeforeCreateStorePolicy.class);
        this.onCreateStoreDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.OnCreateStorePolicy.class);
        this.beforeCreateNodeDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.BeforeCreateNodePolicy.class);
        this.onCreateNodeDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.OnCreateNodePolicy.class);
        this.onMoveNodeDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.OnMoveNodePolicy.class);
        this.beforeUpdateNodeDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.BeforeUpdateNodePolicy.class);
        this.onUpdateNodeDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.OnUpdateNodePolicy.class);
        this.onUpdatePropertiesDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.OnUpdatePropertiesPolicy.class);
        this.beforeDeleteNodeDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.BeforeDeleteNodePolicy.class);
        this.onDeleteNodeDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.OnDeleteNodePolicy.class);
        this.onRestoreNodePolicy = this.policyComponent.registerClassPolicy(NodeServicePolicies.OnRestoreNodePolicy.class);
        this.beforeAddAspectDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.BeforeAddAspectPolicy.class);
        this.onAddAspectDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.OnAddAspectPolicy.class);
        this.beforeRemoveAspectDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.BeforeRemoveAspectPolicy.class);
        this.onRemoveAspectDelegate = this.policyComponent.registerClassPolicy(NodeServicePolicies.OnRemoveAspectPolicy.class);
        this.beforeCreateNodeAssociationDelegate = this.policyComponent.registerAssociationPolicy(NodeServicePolicies.BeforeCreateNodeAssociationPolicy.class);
        this.onCreateNodeAssociationDelegate = this.policyComponent.registerAssociationPolicy(NodeServicePolicies.OnCreateNodeAssociationPolicy.class);
        this.onCreateChildAssociationDelegate = this.policyComponent.registerAssociationPolicy(NodeServicePolicies.OnCreateChildAssociationPolicy.class);
        this.beforeDeleteChildAssociationDelegate = this.policyComponent.registerAssociationPolicy(NodeServicePolicies.BeforeDeleteChildAssociationPolicy.class);
        this.onDeleteChildAssociationDelegate = this.policyComponent.registerAssociationPolicy(NodeServicePolicies.OnDeleteChildAssociationPolicy.class);
        this.onCreateAssociationDelegate = this.policyComponent.registerAssociationPolicy(NodeServicePolicies.OnCreateAssociationPolicy.class);
        this.onDeleteAssociationDelegate = this.policyComponent.registerAssociationPolicy(NodeServicePolicies.OnDeleteAssociationPolicy.class);
    }

    private boolean ignorePolicy(StoreRef storeRef) {
        return this.storesToIgnorePolicies.contains(this.tenantService.getBaseName(storeRef).toString());
    }

    private boolean ignorePolicy(NodeRef nodeRef) {
        return this.storesToIgnorePolicies.contains(this.tenantService.getBaseName(nodeRef.getStoreRef()).toString());
    }

    protected void invokeBeforeCreateStore(QName nodeTypeQName, StoreRef storeRef) {
        if (this.ignorePolicy(storeRef)) {
            return;
        }
        NodeServicePolicies.BeforeCreateStorePolicy policy = this.beforeCreateStoreDelegate.get(nodeTypeQName);
        policy.beforeCreateStore(nodeTypeQName, storeRef);
    }

    protected void invokeOnCreateStore(NodeRef rootNodeRef) {
        if (this.ignorePolicy(rootNodeRef)) {
            return;
        }
        Set<QName> qnames = this.getTypeAndAspectQNames(rootNodeRef);
        NodeServicePolicies.OnCreateStorePolicy policy = this.onCreateStoreDelegate.get(qnames);
        policy.onCreateStore(rootNodeRef);
    }

    protected void invokeBeforeCreateNode(NodeRef parentNodeRef, QName assocTypeQName, QName assocQName, QName childNodeTypeQName) {
        if (this.ignorePolicy(parentNodeRef)) {
            return;
        }
        NodeServicePolicies.BeforeCreateNodePolicy policy = this.beforeCreateNodeDelegate.get(childNodeTypeQName);
        policy.beforeCreateNode(parentNodeRef, assocTypeQName, assocQName, childNodeTypeQName);
    }

    protected void invokeOnCreateNode(ChildAssociationRef childAssocRef) {
        NodeRef childNodeRef = childAssocRef.getChildRef();
        if (this.ignorePolicy(childNodeRef)) {
            return;
        }
        Set<QName> qnames = this.getTypeAndAspectQNames(childNodeRef);
        NodeServicePolicies.OnCreateNodePolicy policy = this.onCreateNodeDelegate.get(childNodeRef, qnames);
        policy.onCreateNode(childAssocRef);
    }

    protected void invokeOnMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        NodeRef childNodeRef = newChildAssocRef.getChildRef();
        if (this.ignorePolicy(childNodeRef)) {
            return;
        }
        Set<QName> qnames = this.getTypeAndAspectQNames(childNodeRef);
        NodeServicePolicies.OnMoveNodePolicy policy = this.onMoveNodeDelegate.get(childNodeRef, qnames);
        policy.onMoveNode(oldChildAssocRef, newChildAssocRef);
    }

    protected void invokeBeforeUpdateNode(NodeRef nodeRef) {
        if (this.ignorePolicy(nodeRef)) {
            return;
        }
        Set<QName> qnames = this.getTypeAndAspectQNames(nodeRef);
        NodeServicePolicies.BeforeUpdateNodePolicy policy = this.beforeUpdateNodeDelegate.get(nodeRef, qnames);
        policy.beforeUpdateNode(nodeRef);
    }

    protected void invokeOnUpdateNode(NodeRef nodeRef) {
        if (this.ignorePolicy(nodeRef)) {
            return;
        }
        Set<QName> qnames = this.getTypeAndAspectQNames(nodeRef);
        NodeServicePolicies.OnUpdateNodePolicy policy = this.onUpdateNodeDelegate.get(nodeRef, qnames);
        policy.onUpdateNode(nodeRef);
    }

    protected void invokeOnUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (this.ignorePolicy(nodeRef)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            if (before == null) {
                logger.debug((Object)("The properties are being set for the first time.  (nodeRef=" + nodeRef.toString() + ")"));
            } else if (after == null) {
                logger.debug((Object)("All the properties are being cleared.  (nodeRef=" + nodeRef.toString() + ")"));
            } else {
                logger.debug((Object)("The following properties have been updated:  (nodeRef=" + nodeRef.toString() + ")"));
                for (Map.Entry<QName, Serializable> entry : after.entrySet()) {
                    Serializable beforeValue = before.get(entry.getKey());
                    if (beforeValue == null) {
                        logger.debug((Object)("   - The property " + entry.getKey().toString() + " has been set for the first time."));
                        continue;
                    }
                    if (beforeValue.equals(entry.getValue())) continue;
                    logger.debug((Object)("   - The property " + entry.getKey().toString() + " has been updated."));
                }
            }
        }
        Set<QName> qnames = this.getTypeAndAspectQNames(nodeRef);
        NodeServicePolicies.OnUpdatePropertiesPolicy policy = this.onUpdatePropertiesDelegate.get(nodeRef, qnames);
        policy.onUpdateProperties(nodeRef, before, after);
    }

    protected void invokeBeforeDeleteNode(NodeRef nodeRef) {
        if (this.ignorePolicy(nodeRef)) {
            return;
        }
        Set<QName> qnames = this.getTypeAndAspectQNames(nodeRef);
        NodeServicePolicies.BeforeDeleteNodePolicy policy = this.beforeDeleteNodeDelegate.get(nodeRef, qnames);
        policy.beforeDeleteNode(nodeRef);
    }

    protected void invokeOnDeleteNode(ChildAssociationRef childAssocRef, QName childNodeTypeQName, Set<QName> childAspectQnames, boolean isArchivedNode) {
        NodeRef childNodeRef = childAssocRef.getChildRef();
        HashSet<QName> qnames = null;
        if (this.ignorePolicy(childNodeRef)) {
            if (childAspectQnames.contains(ContentModel.ASPECT_VERSIONABLE) || childNodeTypeQName.equals((Object)ContentModel.ASPECT_VERSIONABLE)) {
                qnames = new HashSet(1);
                qnames.add(ContentModel.ASPECT_VERSIONABLE);
            }
        } else {
            qnames = new HashSet<QName>(childAspectQnames.size() + 1);
            qnames.addAll(childAspectQnames);
            qnames.add(childNodeTypeQName);
        }
        if (qnames != null) {
            NodeServicePolicies.OnDeleteNodePolicy policy = this.onDeleteNodeDelegate.get(childAssocRef.getChildRef(), qnames);
            policy.onDeleteNode(childAssocRef, isArchivedNode);
        }
    }

    protected void invokeOnRestoreNode(ChildAssociationRef childAssocRef) {
        NodeRef childNodeRef = childAssocRef.getChildRef();
        Set<QName> qnames = this.getTypeAndAspectQNames(childNodeRef);
        NodeServicePolicies.OnRestoreNodePolicy policy = this.onRestoreNodePolicy.get(childAssocRef.getChildRef(), qnames);
        policy.onRestoreNode(childAssocRef);
    }

    protected void invokeBeforeAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        if (this.ignorePolicy(nodeRef)) {
            return;
        }
        NodeServicePolicies.BeforeAddAspectPolicy policy = this.beforeAddAspectDelegate.get(nodeRef, aspectTypeQName);
        policy.beforeAddAspect(nodeRef, aspectTypeQName);
    }

    protected void invokeOnAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        if (this.ignorePolicy(nodeRef)) {
            return;
        }
        NodeServicePolicies.OnAddAspectPolicy policy = this.onAddAspectDelegate.get(nodeRef, aspectTypeQName);
        policy.onAddAspect(nodeRef, aspectTypeQName);
    }

    protected void invokeBeforeRemoveAspect(NodeRef nodeRef, QName aspectTypeQName) {
        if (this.ignorePolicy(nodeRef)) {
            return;
        }
        NodeServicePolicies.BeforeRemoveAspectPolicy policy = this.beforeRemoveAspectDelegate.get(nodeRef, aspectTypeQName);
        policy.beforeRemoveAspect(nodeRef, aspectTypeQName);
    }

    protected void invokeOnRemoveAspect(NodeRef nodeRef, QName aspectTypeQName) {
        if (this.ignorePolicy(nodeRef)) {
            return;
        }
        NodeServicePolicies.OnRemoveAspectPolicy policy = this.onRemoveAspectDelegate.get(nodeRef, aspectTypeQName);
        policy.onRemoveAspect(nodeRef, aspectTypeQName);
    }

    protected void invokeBeforeCreateNodeAssociation(NodeRef parentNodeRef, QName assocTypeQName, QName assocQName) {
        if (this.ignorePolicy(parentNodeRef)) {
            return;
        }
        Set<QName> qnames = this.getTypeAndAspectQNames(parentNodeRef);
        NodeServicePolicies.BeforeCreateNodeAssociationPolicy policy = this.beforeCreateNodeAssociationDelegate.get(parentNodeRef, qnames, assocTypeQName);
        policy.beforeCreateNodeAssociation(parentNodeRef, assocTypeQName, assocQName);
    }

    protected void invokeOnCreateNodeAssociation(ChildAssociationRef childAssocRef) {
        NodeRef parentNodeRef = childAssocRef.getParentRef();
        if (this.ignorePolicy(parentNodeRef)) {
            return;
        }
        QName assocTypeQName = childAssocRef.getTypeQName();
        Set<QName> qnames = this.getTypeAndAspectQNames(parentNodeRef);
        NodeServicePolicies.OnCreateNodeAssociationPolicy policy = this.onCreateNodeAssociationDelegate.get(parentNodeRef, qnames, assocTypeQName);
        policy.onCreateNodeAssociation(childAssocRef);
    }

    protected void invokeOnCreateChildAssociation(ChildAssociationRef childAssocRef, boolean isNewNode) {
        NodeRef parentNodeRef = childAssocRef.getParentRef();
        if (this.ignorePolicy(parentNodeRef)) {
            return;
        }
        QName assocTypeQName = childAssocRef.getTypeQName();
        Set<QName> qnames = this.getTypeAndAspectQNames(parentNodeRef);
        NodeServicePolicies.OnCreateChildAssociationPolicy policy = this.onCreateChildAssociationDelegate.get(parentNodeRef, qnames, assocTypeQName);
        policy.onCreateChildAssociation(childAssocRef, isNewNode);
    }

    protected void invokeBeforeDeleteChildAssociation(ChildAssociationRef childAssocRef) {
        NodeRef parentNodeRef = childAssocRef.getParentRef();
        if (this.ignorePolicy(parentNodeRef)) {
            return;
        }
        QName assocTypeQName = childAssocRef.getTypeQName();
        Set<QName> qnames = this.getTypeAndAspectQNames(parentNodeRef);
        NodeServicePolicies.BeforeDeleteChildAssociationPolicy policy = this.beforeDeleteChildAssociationDelegate.get(parentNodeRef, qnames, assocTypeQName);
        policy.beforeDeleteChildAssociation(childAssocRef);
    }

    protected void invokeOnDeleteChildAssociation(ChildAssociationRef childAssocRef) {
        NodeRef parentNodeRef = childAssocRef.getParentRef();
        if (this.ignorePolicy(parentNodeRef)) {
            return;
        }
        QName assocTypeQName = childAssocRef.getTypeQName();
        Set<QName> qnames = this.getTypeAndAspectQNames(parentNodeRef);
        NodeServicePolicies.OnDeleteChildAssociationPolicy policy = this.onDeleteChildAssociationDelegate.get(parentNodeRef, qnames, assocTypeQName);
        policy.onDeleteChildAssociation(childAssocRef);
    }

    protected void invokeOnCreateAssociation(AssociationRef nodeAssocRef) {
        NodeRef sourceNodeRef = nodeAssocRef.getSourceRef();
        if (this.ignorePolicy(sourceNodeRef)) {
            return;
        }
        QName assocTypeQName = nodeAssocRef.getTypeQName();
        Set<QName> qnames = this.getTypeAndAspectQNames(sourceNodeRef);
        NodeServicePolicies.OnCreateAssociationPolicy policy = this.onCreateAssociationDelegate.get(sourceNodeRef, qnames, assocTypeQName);
        policy.onCreateAssociation(nodeAssocRef);
    }

    protected void invokeOnDeleteAssociation(AssociationRef nodeAssocRef) {
        NodeRef sourceNodeRef = nodeAssocRef.getSourceRef();
        if (this.ignorePolicy(sourceNodeRef)) {
            return;
        }
        QName assocTypeQName = nodeAssocRef.getTypeQName();
        Set<QName> qnames = this.getTypeAndAspectQNames(sourceNodeRef);
        NodeServicePolicies.OnDeleteAssociationPolicy policy = this.onDeleteAssociationDelegate.get(sourceNodeRef, qnames, assocTypeQName);
        policy.onDeleteAssociation(nodeAssocRef);
    }

    protected Set<QName> getTypeAndAspectQNames(NodeRef nodeRef) {
        Set<QName> qnames = null;
        try {
            Set aspectQNames = this.getAspects(nodeRef);
            QName typeQName = this.getType(nodeRef);
            qnames = new HashSet<QName>(aspectQNames.size() + 1);
            qnames.addAll(aspectQNames);
            qnames.add(typeQName);
        }
        catch (InvalidNodeRefException e) {
            qnames = Collections.emptySet();
        }
        return qnames;
    }

    protected String generateGuid(Map<QName, Serializable> preCreationProperties) {
        String uuid = (String)((Object)preCreationProperties.get(ContentModel.PROP_NODE_UUID));
        if (uuid != null && uuid.length() > 50) {
            throw new IllegalArgumentException("Explicit UUID may not be greater than 50 characters: " + uuid);
        }
        return uuid;
    }

    public List<ChildAssociationRef> getParentAssocs(NodeRef nodeRef) throws InvalidNodeRefException {
        return this.getParentAssocs(nodeRef, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL);
    }

    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef) throws InvalidNodeRefException {
        return this.getChildAssocs(nodeRef, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL);
    }

    protected Map<QName, Serializable> getDefaultProperties(QName typeQName) {
        ClassDefinition classDefinition = this.dictionaryService.getClass(typeQName);
        if (classDefinition == null) {
            return Collections.emptyMap();
        }
        return this.getDefaultProperties(classDefinition);
    }

    protected Map<QName, Serializable> getDefaultProperties(ClassDefinition classDefinition) {
        PropertyMap properties = new PropertyMap();
        for (Map.Entry entry : classDefinition.getDefaultValues().entrySet()) {
            Serializable value = (Serializable)entry.getValue();
            PropertyDefinition prop = this.dictionaryService.getProperty((QName)entry.getKey());
            if (prop == null) continue;
            if (DataTypeDefinition.BOOLEAN.equals((Object)prop.getDataType().getName()) && value instanceof String) {
                if (((String)((Object)value)).toUpperCase().equals("TRUE")) {
                    value = Boolean.TRUE;
                } else if (((String)((Object)value)).toUpperCase().equals("FALSE")) {
                    value = Boolean.FALSE;
                }
            }
            properties.put(entry.getKey(), value);
        }
        return properties;
    }

    public List<NodeRef> findNodes(NodeService.FindNodeParameters params) {
        throw new UnsupportedOperationException();
    }

    public final boolean removeSeconaryChildAssociation(ChildAssociationRef childAssocRef) {
        return this.removeSecondaryChildAssociation(childAssocRef);
    }
}

