/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class ConcurrentNodeServiceTest
extends TestCase {
    public static final String NAMESPACE = "http://www.alfresco.org/test/BaseNodeServiceTest";
    public static final String TEST_PREFIX = "test";
    public static final QName TYPE_QNAME_TEST_CONTENT = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"content");
    public static final QName ASPECT_QNAME_TEST_TITLED = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"titled");
    public static final QName PROP_QNAME_TEST_TITLE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"title");
    public static final QName PROP_QNAME_TEST_MIMETYPE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"mimetype");
    public static final int COUNT = 10;
    public static final int REPEATS = 20;
    private static Log logger = LogFactory.getLog(ConcurrentNodeServiceTest.class);
    static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private NodeService nodeService;
    private NodeDAO nodeDAO;
    private TransactionService transactionService;
    private NodeRef rootNodeRef;
    private AuthenticationComponent authenticationComponent;

    protected void setUp() throws Exception {
        DictionaryDAO dictionaryDao = (DictionaryDAO)ctx.getBean("dictionaryDAO");
        ClassLoader cl = BaseNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("alfresco/model/systemModel.xml");
        ConcurrentNodeServiceTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        modelStream = cl.getResourceAsStream("org/alfresco/repo/node/BaseNodeServiceTest_model.xml");
        ConcurrentNodeServiceTest.assertNotNull((Object)modelStream);
        model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.nodeService = serviceRegistry.getNodeService();
        this.nodeDAO = (NodeDAO)ctx.getBean("nodeDAO");
        this.transactionService = serviceRegistry.getTransactionService();
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        RetryingTransactionHelper.RetryingTransactionCallback<Object> createRootNodeCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                StoreRef storeRef = ConcurrentNodeServiceTest.this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
                ConcurrentNodeServiceTest.this.rootNodeRef = ConcurrentNodeServiceTest.this.nodeService.getRootNode(storeRef);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(createRootNodeCallback);
    }

    protected void tearDown() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        super.tearDown();
    }

    public void testMultiThreaded_PropertyWrites() throws Exception {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        int loops = 1000;
        QName[] properties = new QName[]{QName.createQName((String)"test1", (String)"MadeUp1"), QName.createQName((String)"test2", (String)"MadeUp2"), QName.createQName((String)"test3", (String)"MadeUp3"), QName.createQName((String)"test4", (String)"MadeUp4"), QName.createQName((String)"test5", (String)"MadeUp5")};
        final int[] propCounts = new int[properties.length];
        int propNum = 0;
        while (propNum < properties.length) {
            final QName property = properties[propNum];
            final int propNumFinal = propNum++;
            this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    ConcurrentNodeServiceTest.this.nodeService.removeProperty(ConcurrentNodeServiceTest.this.rootNodeRef, property);
                    return null;
                }
            });
            Thread t = new Thread(new Runnable(){

                public synchronized void run() {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    logger.info((Object)("About to start updating property " + property));
                    AuthenticationUtil.setRunAsUserSystem();
                    for (int i = 0; i < 1000; ++i) {
                        RetryingTransactionHelper.RetryingTransactionCallback<Integer> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

                            @Override
                            public Integer execute() throws Throwable {
                                ConcurrentNodeServiceTest.this.nodeDAO.setCheckNodeConsistency();
                                int current = 0;
                                Serializable obj = ConcurrentNodeServiceTest.this.nodeService.getProperty(ConcurrentNodeServiceTest.this.rootNodeRef, property);
                                if (obj != null && obj instanceof Integer) {
                                    current = (Integer)obj;
                                }
                                ConcurrentNodeServiceTest.this.nodeService.setProperty(ConcurrentNodeServiceTest.this.rootNodeRef, property, (Serializable)Integer.valueOf(++current));
                                int expectedCurrent = propCounts[propNumFinal];
                                if (expectedCurrent != current - 1) {
                                    System.out.println("Found difference: " + Thread.currentThread().getName() + " " + current);
                                }
                                return current;
                            }
                        };
                        try {
                            RetryingTransactionHelper txnHelper = ConcurrentNodeServiceTest.this.transactionService.getRetryingTransactionHelper();
                            txnHelper.setMaxRetries(1000);
                            Integer newCount = txnHelper.doInTransaction(callback, false, true);
                            propCounts[propNumFinal] = newCount;
                            continue;
                        }
                        catch (Throwable e) {
                            logger.error((Object)"Failed to set value: ", e);
                        }
                    }
                    logger.info((Object)("Finished updating property " + property));
                }
            }, "Thread-" + property);
            threads.add(t);
            t.start();
        }
        logger.info((Object)"Releasing the property update threads");
        for (Thread t : threads) {
            t.interrupt();
        }
        for (Thread t : threads) {
            t.join();
        }
        Map nodeProperties = this.nodeService.getProperties(this.rootNodeRef);
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < properties.length; ++i) {
            Integer value = (Integer)nodeProperties.get(properties[i]);
            if (value == null) {
                errors.add("\n   Prop " + properties[i] + " : " + value);
                continue;
            }
            if (value.equals(new Integer(1000))) continue;
            errors.add("\n   Prop " + properties[i] + " : " + value);
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Incorrect counts recieved for 1000 loops.");
            for (String error : errors) {
                sb.append(error);
            }
            ConcurrentNodeServiceTest.fail((String)sb.toString());
        }
    }

    public void testMultithreaded_AspectWrites() throws Exception {
        int i;
        Thread[] threads = new Thread[2];
        int loops = 10;
        for (i = 0; i < threads.length; ++i) {
            final String name = "Thread-" + i + "-";
            Runnable runnable = new Runnable(){

                public void run() {
                    AuthenticationUtil.setRunAsUserSystem();
                    for (int loop = 0; loop < 10; ++loop) {
                        final String nameWithLoop = name + loop;
                        RetryingTransactionHelper.RetryingTransactionCallback<Void> runCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                            @Override
                            public Void execute() throws Throwable {
                                QName qname = QName.createQName((String)ConcurrentNodeServiceTest.NAMESPACE, (String)nameWithLoop);
                                ConcurrentNodeServiceTest.this.nodeService.addAspect(ConcurrentNodeServiceTest.this.rootNodeRef, qname, null);
                                return null;
                            }
                        };
                        RetryingTransactionHelper txnHelper = ConcurrentNodeServiceTest.this.transactionService.getRetryingTransactionHelper();
                        txnHelper.setMaxRetries(40);
                        try {
                            txnHelper.doInTransaction(runCallback);
                            continue;
                        }
                        catch (Throwable e) {
                            logger.error((Object)e);
                        }
                    }
                }
            };
            threads[i] = new Thread(runnable, name);
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
        Set aspects = this.nodeService.getAspects(this.rootNodeRef);
        for (int i2 = 0; i2 < threads.length; ++i2) {
            for (int j = 0; j < 10; ++j) {
                String nameWithLoop = "Thread-" + i2 + "-" + j;
                QName qname = QName.createQName((String)NAMESPACE, (String)nameWithLoop);
                ConcurrentNodeServiceTest.assertTrue((String)("Missing aspect: " + nameWithLoop), (boolean)aspects.contains(qname));
            }
        }
    }
}

