/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.index;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.Transaction;
import org.alfresco.repo.node.index.AbstractReindexComponent;
import org.alfresco.repo.node.index.IndexTransactionTracker;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullIndexRecoveryComponent
extends AbstractReindexComponent {
    private static final String ERR_INDEX_OUT_OF_DATE = "index.recovery.out_of_date";
    private static final String MSG_TRACKING_STARTING = "index.tracking.starting";
    private static final String MSG_TRACKING_COMPLETE = "index.tracking.complete";
    private static final String MSG_TRACKING_PROGRESS = "index.tracking.progress";
    private static final String MSG_RECOVERY_STARTING = "index.recovery.starting";
    private static final String MSG_RECOVERY_COMPLETE = "index.recovery.complete";
    private static final String MSG_RECOVERY_PROGRESS = "index.recovery.progress";
    private static final String MSG_RECOVERY_TERMINATED = "index.recovery.terminated";
    private static final String MSG_RECOVERY_ERROR = "index.recovery.error";
    private static Log logger = LogFactory.getLog(FullIndexRecoveryComponent.class);
    private RecoveryMode recoveryMode;
    private boolean lockServer;
    private IndexTransactionTracker indexTracker;
    private boolean stopOnError;
    private int maxTransactionsPerLuceneCommit = 100;
    private final QName vetoName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"FullIndexRecoveryComponent");
    private static final int MAX_TRANSACTIONS_PER_ITERATION = 1000;
    private static final long MIN_SAMPLE_TIME = 10000L;

    public FullIndexRecoveryComponent() {
        this.recoveryMode = RecoveryMode.VALIDATE;
    }

    public void setRecoveryMode(String recoveryMode) {
        this.recoveryMode = RecoveryMode.valueOf(recoveryMode);
    }

    public void setMaxTransactionsPerLuceneCommit(int maxTransactionsPerLuceneCommit) {
        this.maxTransactionsPerLuceneCommit = maxTransactionsPerLuceneCommit;
    }

    public void setLockServer(boolean lockServer) {
        this.lockServer = lockServer;
    }

    public void setIndexTracker(IndexTransactionTracker indexTracker) {
        this.indexTracker = indexTracker;
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reindexImpl() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Performing index recovery for type: " + (Object)((Object)this.recoveryMode)));
        }
        if (this.recoveryMode == RecoveryMode.NONE) {
            return;
        }
        boolean allowWrite = !this.transactionService.isReadOnly();
        try {
            if (this.lockServer) {
                this.transactionService.setAllowWrite(false, this.vetoName);
            }
            List<Transaction> startTxns = this.nodeDAO.getTxnsByCommitTimeAscending(Long.MIN_VALUE, Long.MAX_VALUE, 1000, null, false);
            AbstractReindexComponent.InIndex startAllPresent = this.areTxnsInStartSample(startTxns);
            List<Transaction> endTxns = this.nodeDAO.getTxnsByCommitTimeDescending(Long.MIN_VALUE, Long.MAX_VALUE, 1000, null, false);
            AbstractReindexComponent.InIndex endAllPresent = this.areAllTxnsInEndSample(endTxns);
            switch (this.recoveryMode) {
                case AUTO: {
                    if (startAllPresent == AbstractReindexComponent.InIndex.NO) {
                        this.performFullRecovery();
                        break;
                    }
                    if (endAllPresent != AbstractReindexComponent.InIndex.NO) break;
                    this.performPartialRecovery();
                    break;
                }
                case VALIDATE: {
                    if (startAllPresent != AbstractReindexComponent.InIndex.NO && endAllPresent != AbstractReindexComponent.InIndex.NO) break;
                    logger.warn((Object)I18NUtil.getMessage((String)ERR_INDEX_OUT_OF_DATE));
                    break;
                }
                case FULL: {
                    this.performFullRecovery();
                }
            }
            Object var7_6 = null;
            this.transactionService.setAllowWrite(true, this.vetoName);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.transactionService.setAllowWrite(true, this.vetoName);
            throw throwable;
        }
    }

    protected AbstractReindexComponent.InIndex areAllTxnsInEndSample(List<Transaction> txns) {
        int count = 0;
        int yesCount = 0;
        for (Transaction txn : txns) {
            ++count;
            AbstractReindexComponent.InIndex inIndex = this.isTxnPresentInIndex(txn, true);
            if (inIndex == AbstractReindexComponent.InIndex.NO) {
                return AbstractReindexComponent.InIndex.NO;
            }
            if (inIndex != AbstractReindexComponent.InIndex.YES || ++yesCount <= 1 || count < 10) continue;
            return AbstractReindexComponent.InIndex.YES;
        }
        return AbstractReindexComponent.InIndex.INDETERMINATE;
    }

    protected AbstractReindexComponent.InIndex areTxnsInStartSample(List<Transaction> txns) {
        int count = 0;
        AbstractReindexComponent.InIndex current = AbstractReindexComponent.InIndex.INDETERMINATE;
        for (Transaction txn : txns) {
            ++count;
            current = this.isTxnPresentInIndex(txn, true);
            if (current == AbstractReindexComponent.InIndex.NO) {
                return AbstractReindexComponent.InIndex.NO;
            }
            if (current != AbstractReindexComponent.InIndex.YES || count < 10) continue;
            return AbstractReindexComponent.InIndex.YES;
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performPartialRecovery() {
        IndexTransactionTracker.IndexTransactionTrackerListener trackerListener = new IndexTransactionTracker.IndexTransactionTrackerListener(){
            long lastLogged = 0L;

            public void indexedTransactions(long fromTimeInclusive, long toTimeExclusive) {
                long now = System.currentTimeMillis();
                if (now - this.lastLogged < 10000L) {
                    return;
                }
                this.lastLogged = now;
                Date toTimeDate = new Date(toTimeExclusive);
                String msgAutoProgress = I18NUtil.getMessage((String)FullIndexRecoveryComponent.MSG_TRACKING_PROGRESS, (Object[])new Object[]{toTimeDate.toString()});
                logger.info((Object)msgAutoProgress);
            }
        };
        try {
            this.indexTracker.setListener(trackerListener);
            logger.info((Object)I18NUtil.getMessage((String)MSG_TRACKING_STARTING));
            this.indexTracker.reindex();
            logger.info((Object)I18NUtil.getMessage((String)MSG_TRACKING_COMPLETE));
            Object var3_2 = null;
            this.indexTracker.setListener(null);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.indexTracker.setListener(null);
            throw throwable;
        }
    }

    private void performFullRecovery() {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteWork = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Exception {
                for (StoreRef storeRef : FullIndexRecoveryComponent.this.nodeService.getStores()) {
                    if (storeRef.getProtocol().equals("avm")) continue;
                    FullIndexRecoveryComponent.this.indexer.deleteIndex(storeRef);
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(deleteWork, true, true);
        int txnCount = this.nodeDAO.getTransactionCount();
        String msgStart = I18NUtil.getMessage((String)MSG_RECOVERY_STARTING, (Object[])new Object[]{txnCount});
        logger.info((Object)msgStart);
        int processedCount = 0;
        long fromTimeInclusive = this.nodeDAO.getMinTxnCommitTime();
        long maxToTimeExclusive = this.nodeDAO.getMaxTxnCommitTime() + 1L;
        long toTimeExclusive = fromTimeInclusive + 10000L;
        long sampleStartTimeInclusive = fromTimeInclusive;
        long sampleEndTimeExclusive = -1L;
        long txnsPerSample = 0L;
        ArrayList<Long> lastTxnIds = new ArrayList<Long>(1000);
        while (true) {
            boolean startedSampleForQuery = false;
            List<Transaction> nextTxns = this.nodeDAO.getTxnsByCommitTimeAscending(fromTimeInclusive, toTimeExclusive, 1000, lastTxnIds, false);
            if (nextTxns.size() == 0 && toTimeExclusive >= maxToTimeExclusive) break;
            ArrayList<Long> txnIdBuffer = new ArrayList<Long>(this.maxTransactionsPerLuceneCommit);
            Iterator<Transaction> txnIterator = nextTxns.iterator();
            while (txnIterator.hasNext()) {
                Transaction txn = txnIterator.next();
                Long txnId = txn.getId();
                long txnCommitTime = txn.getCommitTimeMs();
                if (lastTxnIds.isEmpty() || txnCommitTime != fromTimeInclusive) {
                    if (!startedSampleForQuery) {
                        sampleStartTimeInclusive = txnCommitTime;
                        sampleEndTimeExclusive = -1L;
                        txnsPerSample = 0L;
                        startedSampleForQuery = true;
                    } else {
                        txnsPerSample += (long)lastTxnIds.size();
                        sampleEndTimeExclusive = txnCommitTime;
                    }
                    lastTxnIds.clear();
                    fromTimeInclusive = txnCommitTime;
                }
                lastTxnIds.add(txnId);
                if (this.isShuttingDown()) {
                    String msgTerminated = I18NUtil.getMessage((String)MSG_RECOVERY_TERMINATED);
                    logger.warn((Object)msgTerminated);
                    return;
                }
                if (this.stopOnError) {
                    this.reindexTransaction(txnId);
                } else {
                    txnIdBuffer.add(txnId);
                    if (!txnIterator.hasNext() || txnIdBuffer.size() >= this.maxTransactionsPerLuceneCommit) {
                        try {
                            this.reindexTransactionAsynchronously(txnIdBuffer, true);
                        }
                        catch (Throwable e) {
                            String msgError = I18NUtil.getMessage((String)MSG_RECOVERY_ERROR, (Object[])new Object[]{txnId, e.getMessage()});
                            logger.info((Object)msgError, e);
                        }
                        txnIdBuffer = new ArrayList(this.maxTransactionsPerLuceneCommit);
                    }
                }
                double before = (double)processedCount / (double)txnCount * 10.0;
                double after = (double)(++processedCount) / (double)txnCount * 10.0;
                if (!(Math.floor(before) < Math.floor(after))) continue;
                int complete = (int)Math.floor(after) * 10;
                String msgProgress = I18NUtil.getMessage((String)MSG_RECOVERY_PROGRESS, (Object[])new Object[]{complete});
                logger.info((Object)msgProgress);
            }
            this.waitForAsynchronousReindexing();
            if (nextTxns.size() < 1000) {
                if (!lastTxnIds.isEmpty()) {
                    txnsPerSample += (long)lastTxnIds.size();
                    lastTxnIds.clear();
                }
                fromTimeInclusive = toTimeExclusive;
                sampleEndTimeExclusive = toTimeExclusive;
            }
            long sampleTime = txnsPerSample == 0L ? 10000L : Math.max(10000L, 1000L * (sampleEndTimeExclusive - sampleStartTimeInclusive) / txnsPerSample);
            toTimeExclusive = fromTimeInclusive + sampleTime;
        }
        String msgDone = I18NUtil.getMessage((String)MSG_RECOVERY_COMPLETE);
        logger.info((Object)msgDone);
    }

    public void reindexTransaction(final long txnId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Reindexing transaction: " + txnId));
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Object> reindexWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                List<NodeRef.Status> nodeStatuses = FullIndexRecoveryComponent.this.nodeDAO.getTxnChanges(txnId);
                for (NodeRef.Status nodeStatus : nodeStatuses) {
                    NodeRef nodeRef = nodeStatus.getNodeRef();
                    if (nodeStatus.isDeleted()) {
                        ChildAssociationRef assocRef = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, null, null, nodeRef);
                        FullIndexRecoveryComponent.this.indexer.deleteNode(assocRef);
                        continue;
                    }
                    FullIndexRecoveryComponent.this.indexer.updateNode(nodeRef);
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(reindexWork, true, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RecoveryMode {
        NONE,
        VALIDATE,
        AUTO,
        FULL;

    }
}

