/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.nodelocator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.nodelocator.AbstractNodeLocator;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathNodeLocator
extends AbstractNodeLocator {
    public static final String NAME = "xpath";
    public static final String QUERY_KEY = "query";
    public static final String STORE_TYPE_KEY = "store_type";
    public static final String STORE_ID_KEY = "store_id";
    private SearchService searchService;
    private StoreRef defaultStore;

    @Override
    public NodeRef getNode(NodeRef source, Map<String, Serializable> params) {
        String query = (String)((Object)params.get(QUERY_KEY));
        ParameterCheck.mandatoryString((String)QUERY_KEY, (String)query);
        StoreRef store = null;
        if (source != null) {
            store = source.getStoreRef();
        } else {
            String storeType = (String)((Object)params.get(STORE_TYPE_KEY));
            String storeId = (String)((Object)params.get(STORE_ID_KEY));
            store = storeType != null && storeId != null ? new StoreRef(storeType, storeId) : this.defaultStore;
        }
        try {
            ResultSet results = this.searchService.query(store, NAME, query);
            List nodes = results.getNodeRefs();
            if (nodes.size() > 0) {
                return (NodeRef)nodes.get(0);
            }
        }
        catch (Exception e) {
            String msg = "Error while searching XPath. StoreRef: " + store + " Query: " + query;
            throw new AlfrescoRuntimeException(msg, (Throwable)e);
        }
        return null;
    }

    @Override
    public List<ParameterDefinition> getParameterDefinitions() {
        ArrayList<ParameterDefinition> paramDefs = new ArrayList<ParameterDefinition>(2);
        paramDefs.add(new ParameterDefinitionImpl(QUERY_KEY, DataTypeDefinition.TEXT, true, "Query"));
        paramDefs.add(new ParameterDefinitionImpl(STORE_TYPE_KEY, DataTypeDefinition.TEXT, false, "Store Type"));
        paramDefs.add(new ParameterDefinitionImpl(STORE_ID_KEY, DataTypeDefinition.TEXT, false, "Store Id"));
        return paramDefs;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setDefaultStore(String defaultStoreStr) {
        this.defaultStore = new StoreRef(defaultStoreStr);
    }
}

