/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.notification;

import java.io.Serializable;
import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.notification.NotificationContext;
import org.alfresco.service.cmr.notification.NotificationProvider;
import org.alfresco.service.cmr.notification.NotificationService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseAlfrescoTestCase;
import org.alfresco.util.GUID;
import org.alfresco.util.RetryingTransactionHelperTestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NotificationServiceImplSystemTest
extends BaseAlfrescoTestCase {
    private static final String FROM_USER = "fromUser" + GUID.generate();
    private static final String FROM_EMAIL = "test@alfresco.com";
    private static final String FROM_FIRST_NAME = "Grace";
    private static final String FROM_LAST_NAME = "Wetherall";
    private static final String TO_USER1 = "userOne" + GUID.generate();
    private static final String TO_USER2 = "userTwo" + GUID.generate();
    private static final String TO_USER3 = "userThree" + GUID.generate();
    private static final String EMAIL = "rwetherall@alfresco.com";
    private static final String PASSWORD = "password";
    private static final String FIRST_NAME = "Peter";
    private static final String LAST_NAME = "Wetherall";
    private static final String SUBJECT = "Notification Test";
    private static final String BODY = "This is a test notification from org.alfresco.repo.notification.NotificationServiceImplSystemTest.  Please do not respond!";
    private static final String TEMPLATE = "<html>   <body bgcolour='#dddddd'>      <p>This is a test notification from org.alfresco.repo.notification.NotificationServiceImplSystemTest.  Please do not respond!</p>      <br>      Template context:<br><br>      userhome: ${userhome}<br>      companyhome: ${companyhome}<br>      productname: ${productName}<br>";
    private NotificationService notificationService;
    private MutableAuthenticationService authenticationService;
    private PersonService personService;
    private Repository repository;
    private FileFolderService fileFolderService;
    private NodeRef fromPerson;
    private NodeRef toPerson1;
    private NodeRef toPerson2;
    private NodeRef toPerson3;
    private NodeRef template;
    private NotificationContext contextSentFromTest = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.contextSentFromTest = null;
        this.notificationService = (NotificationService)this.ctx.getBean("NotificationService");
        this.authenticationService = (MutableAuthenticationService)this.ctx.getBean("AuthenticationService");
        this.personService = (PersonService)this.ctx.getBean("PersonService");
        this.repository = (Repository)this.ctx.getBean("repositoryHelper");
        this.fileFolderService = (FileFolderService)this.ctx.getBean("FileFolderService");
        this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                NotificationServiceImplSystemTest.this.fromPerson = NotificationServiceImplSystemTest.this.createPerson(FROM_USER, NotificationServiceImplSystemTest.PASSWORD, NotificationServiceImplSystemTest.FROM_FIRST_NAME, "Wetherall", NotificationServiceImplSystemTest.FROM_EMAIL);
                NotificationServiceImplSystemTest.this.toPerson1 = NotificationServiceImplSystemTest.this.createPerson(TO_USER1, NotificationServiceImplSystemTest.PASSWORD, NotificationServiceImplSystemTest.FIRST_NAME, "Wetherall", NotificationServiceImplSystemTest.EMAIL);
                NotificationServiceImplSystemTest.this.toPerson2 = NotificationServiceImplSystemTest.this.createPerson(TO_USER2, NotificationServiceImplSystemTest.PASSWORD, NotificationServiceImplSystemTest.FIRST_NAME, "Wetherall", NotificationServiceImplSystemTest.EMAIL);
                NotificationServiceImplSystemTest.this.toPerson3 = NotificationServiceImplSystemTest.this.createPerson(TO_USER3, NotificationServiceImplSystemTest.PASSWORD, NotificationServiceImplSystemTest.FIRST_NAME, "Wetherall", NotificationServiceImplSystemTest.EMAIL);
                NodeRef companyHome = NotificationServiceImplSystemTest.this.repository.getCompanyHome();
                NotificationServiceImplSystemTest.this.template = NotificationServiceImplSystemTest.this.fileFolderService.create(companyHome, "testTemplate" + GUID.generate() + ".ftl", ContentModel.TYPE_CONTENT).getNodeRef();
                ContentWriter writer = NotificationServiceImplSystemTest.this.contentService.getWriter(NotificationServiceImplSystemTest.this.template, ContentModel.PROP_CONTENT, true);
                writer.setEncoding("UTF-8");
                writer.setMimetype("text/plain");
                writer.putContent(NotificationServiceImplSystemTest.TEMPLATE);
                return null;
            }
        });
    }

    protected void tearDown() throws Exception {
        this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                NotificationServiceImplSystemTest.this.nodeService.deleteNode(NotificationServiceImplSystemTest.this.template);
                return null;
            }
        });
        super.tearDown();
    }

    private NodeRef createPerson(String userName, String password, String firstName, String lastName, String email) {
        NodeRef person = null;
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, password.toCharArray());
            HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(7);
            properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
            properties.put(ContentModel.PROP_FIRSTNAME, (Serializable)((Object)firstName));
            properties.put(ContentModel.PROP_LASTNAME, (Serializable)((Object)lastName));
            properties.put(ContentModel.PROP_EMAIL, (Serializable)((Object)email));
            person = this.personService.createPerson(properties);
        } else {
            person = this.personService.getPerson(userName);
        }
        return person;
    }

    protected boolean useSpacesStore() {
        return true;
    }

    public void testSimpleEmailNotification() {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            @Override
            public Void run() {
                NotificationContext context = new NotificationContext();
                context.setFrom(NotificationServiceImplSystemTest.FROM_EMAIL);
                context.addTo(TO_USER1);
                context.setSubject(NotificationServiceImplSystemTest.SUBJECT);
                context.setBody(NotificationServiceImplSystemTest.BODY);
                NotificationServiceImplSystemTest.this.notificationService.sendNotification("email", context);
                return null;
            }
        });
    }

    public void testTemplateEmailNotification() {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            @Override
            public Void run() {
                NotificationContext context = new NotificationContext();
                context.setFrom(NotificationServiceImplSystemTest.FROM_EMAIL);
                context.addTo(TO_USER1);
                context.setSubject(NotificationServiceImplSystemTest.SUBJECT);
                context.setBodyTemplate(NotificationServiceImplSystemTest.this.template);
                HashMap<String, Serializable> templateArgs = new HashMap<String, Serializable>(1);
                templateArgs.put("template", (Serializable)NotificationServiceImplSystemTest.this.template);
                context.setTemplateArgs(templateArgs);
                NotificationServiceImplSystemTest.this.notificationService.sendNotification("email", context);
                return null;
            }
        });
    }

    public void testTestNotificationProvider() throws Exception {
        NotificationReceiver receiver = new NotificationReceiver(){

            public void receiveNotification(NotificationContext notificationContext) {
                NotificationServiceImplSystemTest.this.contextSentFromTest = notificationContext;
            }
        };
        TestNotificationProvider testNP = new TestNotificationProvider();
        testNP.setNotificationService(this.notificationService);
        testNP.setNotificationReceiver(receiver);
        testNP.init();
        NotificationServiceImplSystemTest.assertTrue((boolean)this.notificationService.getNotificationProviders().contains(TestNotificationProvider.NAME));
        NotificationContext context = new NotificationContext();
        String to = "FAO: test object";
        context.addTo("FAO: test object");
        this.notificationService.sendNotification(TestNotificationProvider.NAME, context);
        NotificationServiceImplSystemTest.assertNotNull((String)"notification context was null.", (Object)this.contextSentFromTest);
        NotificationServiceImplSystemTest.assertTrue((String)"notification context did not contain correct 'to' entry", (boolean)this.contextSentFromTest.getTo().contains("FAO: test object"));
    }

    public static interface NotificationReceiver {
        public void receiveNotification(NotificationContext var1);
    }

    public static class TestNotificationProvider
    implements NotificationProvider {
        public static final String NAME = TestNotificationProvider.class.getSimpleName();
        private static Log log = LogFactory.getLog(TestNotificationProvider.class);
        private NotificationService notificationService;
        private NotificationReceiver notificationReceiver;

        public void setNotificationService(NotificationService notificationService) {
            this.notificationService = notificationService;
        }

        public void setNotificationReceiver(NotificationReceiver notificationReceiver) {
            this.notificationReceiver = notificationReceiver;
        }

        public void init() {
            this.notificationService.register(this);
        }

        public String getName() {
            return NAME;
        }

        public void sendNotification(NotificationContext notificationContext) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Sending notification.");
            }
            this.notificationReceiver.receiveNotification(notificationContext);
        }
    }
}

