/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.PolicyException;
import org.springframework.extensions.surf.util.ParameterCheck;

public abstract class BaseBehaviour
implements Behaviour {
    protected Behaviour.NotificationFrequency frequency = Behaviour.NotificationFrequency.EVERY_EVENT;
    private StackThreadLocal disabled = new StackThreadLocal();
    protected Map<Class, Object> proxies = new HashMap<Class, Object>();

    public BaseBehaviour() {
    }

    public BaseBehaviour(Behaviour.NotificationFrequency frequency) {
        ParameterCheck.mandatory((String)"Frequency", (Object)((Object)frequency));
        this.frequency = frequency;
    }

    public void setNotificationFrequency(Behaviour.NotificationFrequency frequency) {
        this.frequency = frequency;
    }

    public void disable() {
        Stack stack = (Stack)this.disabled.get();
        stack.push(this.hashCode());
    }

    public void enable() {
        Stack stack = (Stack)this.disabled.get();
        if (!((Integer)stack.peek()).equals(this.hashCode())) {
            throw new PolicyException("Cannot enable " + this.toString() + " at this time - mismatched with disable calls");
        }
        stack.pop();
    }

    public boolean isEnabled() {
        Stack stack = (Stack)this.disabled.get();
        return stack.search(this.hashCode()) == -1;
    }

    public Behaviour.NotificationFrequency getNotificationFrequency() {
        return this.frequency;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StackThreadLocal
    extends ThreadLocal<Stack<Integer>> {
        StackThreadLocal() {
        }

        @Override
        protected Stack<Integer> initialValue() {
            return new Stack<Integer>();
        }
    }
}

