/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourBinding;
import org.alfresco.repo.policy.BehaviourChangeObserver;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.BehaviourIndex;
import org.alfresco.repo.policy.Policy;
import org.alfresco.repo.policy.PolicyComponentImpl;
import org.alfresco.repo.policy.PolicyFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CachedPolicyFactory<B extends BehaviourBinding, P extends Policy>
extends PolicyFactory<B, P> {
    private static final Log logger = LogFactory.getLog(PolicyComponentImpl.class);
    private BehaviourFilter behaviourFilter = null;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<B, P> singleCache = new HashMap<B, P>();
    private Map<B, Collection<P>> listCache = new HashMap<B, Collection<P>>();

    CachedPolicyFactory(Class<P> policyClass, BehaviourIndex<B> index) {
        super(policyClass, index);
        this.behaviourFilter = index.getFilter();
        index.addChangeObserver(new BehaviourChangeObserver<B>(){

            @Override
            public void addition(B binding, Behaviour behaviour) {
                CachedPolicyFactory.this.clearCache("aggregate delegate", CachedPolicyFactory.this.singleCache, binding);
                CachedPolicyFactory.this.clearCache("delegate collection", CachedPolicyFactory.this.listCache, binding);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public P create(B binding) {
        Policy policy;
        if (this.behaviourFilter != null && this.behaviourFilter.isActivated()) {
            return super.create(binding);
        }
        this.lock.readLock().lock();
        try {
            Policy policyInterface = (Policy)this.singleCache.get(binding);
            if (policyInterface == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    policyInterface = (Policy)this.singleCache.get(binding);
                    if (policyInterface == null) {
                        policyInterface = super.create(binding);
                        this.singleCache.put(binding, policyInterface);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Cached delegate interface " + policyInterface + " for " + binding + " and policy " + this.getPolicyClass()));
                        }
                    }
                    Object var4_3 = null;
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                    throw throwable;
                }
            }
            policy = policyInterface;
            Object var6_7 = null;
            this.lock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.lock.readLock().unlock();
            throw throwable;
        }
        return (P)policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<P> createList(B binding) {
        if (this.behaviourFilter != null && this.behaviourFilter.isActivated()) {
            return super.createList(binding);
        }
        this.lock.readLock().lock();
        try {
            Collection<P> policyInterfaces = this.listCache.get(binding);
            if (policyInterfaces == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    policyInterfaces = this.listCache.get(binding);
                    if (policyInterfaces == null) {
                        policyInterfaces = super.createList(binding);
                        this.listCache.put(binding, policyInterfaces);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Cached delegate interface collection " + policyInterfaces + " for " + binding + " and policy " + this.getPolicyClass()));
                        }
                    }
                    Object var4_3 = null;
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                    throw throwable;
                }
            }
            Collection<P> collection = policyInterfaces;
            Object var6_7 = null;
            this.lock.readLock().unlock();
            return collection;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.lock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache(String cacheDescription, Map<B, ?> cache, B binding) {
        if (binding == null) {
            this.lock.writeLock().lock();
            try {
                cache.clear();
                if (logger.isDebugEnabled() && !cache.isEmpty()) {
                    logger.debug((Object)("Cleared " + cacheDescription + " cache (all class bindings) for policy " + this.getPolicyClass()));
                }
                Object var5_4 = null;
                this.lock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.lock.writeLock().unlock();
                throw throwable;
            }
        }
        ArrayList<BehaviourBinding> invalidBindings = new ArrayList<BehaviourBinding>();
        Iterator<Object> i$ = cache.keySet().iterator();
        block4: while (i$.hasNext()) {
            BehaviourBinding cachedBinding;
            for (BehaviourBinding generalisedBinding = cachedBinding = (BehaviourBinding)i$.next(); generalisedBinding != null; generalisedBinding = generalisedBinding.generaliseBinding()) {
                if (!generalisedBinding.equals(binding)) continue;
                invalidBindings.add(cachedBinding);
                continue block4;
            }
        }
        if (invalidBindings.size() > 0) {
            this.lock.writeLock().lock();
            try {
                for (BehaviourBinding invalidBinding : invalidBindings) {
                    cache.remove(invalidBinding);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Cleared " + cacheDescription + " cache for " + invalidBinding + " and policy " + this.getPolicyClass()));
                }
                Object var9_11 = null;
                this.lock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                this.lock.writeLock().unlock();
                throw throwable;
            }
        }
    }
}

