/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.Policy;
import org.alfresco.repo.policy.PolicyDefinition;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.util.GUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionBehaviourQueue
implements TransactionListener {
    private String id = GUID.generate();
    private static final String QUEUE_CONTEXT_KEY = TransactionBehaviourQueue.class.getName() + ".context";

    public <P extends Policy> void queue(Behaviour behaviour, PolicyDefinition<P> definition, P policyInterface, Method method, Object[] args) {
        ExecutionInstanceKey key;
        ExecutionContext executionContext;
        QueueContext queueContext = (QueueContext)AlfrescoTransactionSupport.getResource(QUEUE_CONTEXT_KEY);
        if (queueContext == null) {
            queueContext = new QueueContext();
            AlfrescoTransactionSupport.bindResource(QUEUE_CONTEXT_KEY, queueContext);
            AlfrescoTransactionSupport.bindListener(this);
        }
        if ((executionContext = queueContext.index.get(key = new ExecutionInstanceKey(behaviour, definition.getArguments(), args))) == null) {
            executionContext = new ExecutionContext();
            executionContext.method = method;
            executionContext.args = args;
            executionContext.policyInterface = policyInterface;
            if (!queueContext.committed) {
                queueContext.queue.offer(executionContext);
            } else {
                this.execute(executionContext);
            }
            queueContext.index.put(key, executionContext);
        } else {
            Policy.Arg[] argDefs = definition.getArguments();
            for (int i = 0; i < argDefs.length; ++i) {
                if (!argDefs[i].equals((Object)Policy.Arg.END_VALUE)) continue;
                executionContext.args[i] = args[i];
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void beforeCommit(boolean readOnly) {
        QueueContext queueContext = (QueueContext)AlfrescoTransactionSupport.getResource(QUEUE_CONTEXT_KEY);
        ExecutionContext context = queueContext.queue.poll();
        while (context != null) {
            this.execute(context);
            context = queueContext.queue.poll();
        }
        queueContext.committed = true;
    }

    @Override
    public void beforeCompletion() {
    }

    @Override
    public void afterCommit() {
    }

    @Override
    public void afterRollback() {
    }

    private void execute(ExecutionContext context) {
        try {
            context.method.invoke(context.policyInterface, context.args);
        }
        catch (IllegalArgumentException e) {
            throw new AlfrescoRuntimeException("Failed to execute transaction-level behaviour " + context.method + " in transaction " + AlfrescoTransactionSupport.getTransactionId(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new AlfrescoRuntimeException("Failed to execute transaction-level behaviour " + context.method + " in transaction " + AlfrescoTransactionSupport.getTransactionId(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new AlfrescoRuntimeException("Failed to execute transaction-level behaviour " + context.method + " in transaction " + AlfrescoTransactionSupport.getTransactionId(), e.getTargetException());
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TransactionBehaviourQueue) {
            TransactionBehaviourQueue that = (TransactionBehaviourQueue)obj;
            return this.id.equals(that.id);
        }
        return false;
    }

    private class QueueContext {
        Queue<ExecutionContext> queue = new LinkedList<ExecutionContext>();
        Map<ExecutionInstanceKey, ExecutionContext> index = new HashMap<ExecutionInstanceKey, ExecutionContext>();
        boolean committed = false;

        private QueueContext() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExecutionContext<P extends Policy> {
        Method method;
        Object[] args;
        P policyInterface;

        private ExecutionContext() {
        }
    }

    private class ExecutionInstanceKey {
        Behaviour behaviour;
        ArrayList<Object> keys = new ArrayList();

        public ExecutionInstanceKey(Behaviour behaviour, Policy.Arg[] argDefs, Object[] args) {
            this.behaviour = behaviour;
            for (int i = 0; i < argDefs.length; ++i) {
                if (!argDefs[i].equals((Object)Policy.Arg.KEY)) continue;
                this.keys.add(args[i]);
            }
        }

        public int hashCode() {
            int key = this.behaviour.hashCode();
            for (int i = 0; i < this.keys.size(); ++i) {
                key = 37 * key + this.keys.get(i).hashCode();
            }
            return key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ExecutionInstanceKey) {
                ExecutionInstanceKey that = (ExecutionInstanceKey)obj;
                if (this.behaviour.equals(that.behaviour)) {
                    if (this.keys.size() != that.keys.size()) {
                        return false;
                    }
                    if (this.keys.containsAll(that.keys)) {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
    }
}

