/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import org.alfresco.repo.publishing.PublishingTestHelper;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.person.TestPersonManager;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.publishing.PublishingService;
import org.alfresco.service.cmr.publishing.channels.ChannelService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractPublishingIntegrationTest
extends BaseSpringTest {
    protected static final String channelTypeId = "MockChannelType";
    protected ServiceRegistry serviceRegistry;
    protected NodeService nodeService;
    protected PublishingTestHelper testHelper;
    protected TestPersonManager personManager;
    protected String username;

    @Before
    public void onSetUp() throws Exception {
        super.onSetUp();
        this.serviceRegistry = (ServiceRegistry)this.getApplicationContext().getBean("ServiceRegistry");
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        SiteService siteService = this.serviceRegistry.getSiteService();
        FileFolderService fileFolderService = this.serviceRegistry.getFileFolderService();
        PermissionService permissionService = this.serviceRegistry.getPermissionService();
        this.nodeService = this.serviceRegistry.getNodeService();
        ChannelService channelService = (ChannelService)this.getApplicationContext().getBean("ChannelService");
        PublishingService publishingService = (PublishingService)this.getApplicationContext().getBean("PublishingService");
        MutableAuthenticationService authenticationService = (MutableAuthenticationService)this.getApplicationContext().getBean(ServiceRegistry.AUTHENTICATION_SERVICE.getLocalName());
        PersonService personService = (PersonService)this.getApplicationContext().getBean(ServiceRegistry.PERSON_SERVICE.getLocalName());
        this.personManager = new TestPersonManager(authenticationService, personService, this.nodeService);
        this.testHelper = new PublishingTestHelper(channelService, publishingService, siteService, fileFolderService, permissionService);
        this.username = GUID.generate();
        this.personManager.createPerson(this.username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void onTearDown() throws Exception {
        try {
            this.testHelper.tearDown();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.onTearDown();
            throw throwable;
        }
        super.onTearDown();
    }
}

