/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.NodeUtils;
import org.alfresco.repo.publishing.AbstractChannelType;
import org.alfresco.repo.publishing.ChannelImpl;
import org.alfresco.repo.publishing.PublishingEventHelper;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.publishing.channels.ChannelService;
import org.alfresco.service.cmr.publishing.channels.ChannelType;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.Pair;
import org.alfresco.util.collections.CollectionUtils;
import org.alfresco.util.collections.Filter;
import org.alfresco.util.collections.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelHelper {
    public static final String NAME = "channelHelper";
    private NodeService nodeService;
    private DictionaryService dictionaryService;
    private FileFolderService fileFolderService;
    private PermissionService permissionService;
    private ServiceRegistry serviceRegistry;
    private PublishingEventHelper eventHelper;

    public ChannelHelper() {
    }

    public ChannelHelper(ServiceRegistry serviceRegistry, PublishingEventHelper eventHelper) {
        this.serviceRegistry = serviceRegistry;
        this.eventHelper = eventHelper;
    }

    public NodeRef createChannelNode(NodeRef parent, ChannelType channelType, String channelName, Map<QName, Serializable> props) {
        QName channelQName = this.getChannelQName(channelName);
        QName channelNodeType = channelType.getChannelNodeType();
        ChildAssociationRef channelAssoc = this.nodeService.createNode(parent, ContentModel.ASSOC_CONTAINS, channelQName, channelNodeType, props);
        NodeRef channelNode = channelAssoc.getChildRef();
        this.permissionService.setPermission(channelNode, "GROUP_EVERYONE", "ReadAssociations", true);
        return channelNode;
    }

    public Channel buildChannelObject(NodeRef nodeRef, ChannelService channelService) {
        if (nodeRef == null || !this.nodeService.exists(nodeRef)) {
            return null;
        }
        Map props = this.nodeService.getProperties(nodeRef);
        String channelTypeId = (String)props.get(PublishingModel.PROP_CHANNEL_TYPE_ID);
        ChannelType channelType = channelService.getChannelType(channelTypeId);
        String name = (String)props.get(ContentModel.PROP_NAME);
        return new ChannelImpl(this.serviceRegistry, (AbstractChannelType)channelType, nodeRef, name, this, this.eventHelper);
    }

    public NodeRef mapSourceToEnvironment(NodeRef source, NodeRef channelNode) {
        return ChannelHelper.mapSourceToEnvironment(source, channelNode, this.nodeService);
    }

    public static NodeRef mapSourceToEnvironment(NodeRef source, final NodeRef channelNode, final NodeService nodeService) {
        Filter<AssociationRef> acceptor;
        if (source == null || channelNode == null) {
            return null;
        }
        List sourceAssocs = nodeService.getSourceAssocs(source, (QNamePattern)PublishingModel.ASSOC_SOURCE);
        AssociationRef assoc = (AssociationRef)CollectionUtils.findFirst((Collection)sourceAssocs, (Function)(acceptor = new Filter<AssociationRef>(){

            public Boolean apply(AssociationRef assoc) {
                NodeRef publishedNode = assoc.getSourceRef();
                NodeRef parent = nodeService.getPrimaryParent(publishedNode).getParentRef();
                return channelNode.equals((Object)parent);
            }
        }));
        return assoc == null ? null : assoc.getSourceRef();
    }

    public NodeRef mapEnvironmentToSource(NodeRef publishedNode) {
        return ChannelHelper.mapEnvironmentToSource(publishedNode, this.nodeService);
    }

    public static NodeRef mapEnvironmentToSource(NodeRef publishedNode, NodeService nodeService) {
        List assocs = nodeService.getTargetAssocs(publishedNode, (QNamePattern)PublishingModel.ASSOC_SOURCE);
        return NodeUtils.getSingleAssocNode(assocs, true);
    }

    public Pair<NodeRef, String> findChannelAndType(NodeRef node) {
        NodeRef parent;
        ChildAssociationRef parentAssoc;
        Pair<NodeRef, String> result = this.getChannelAndTypeIfChannel(node);
        if (result == null && (result = this.getChannelAndType(node)) == null && (parentAssoc = this.nodeService.getPrimaryParent(node)) != null && (parent = parentAssoc.getParentRef()) != null) {
            result = this.findChannelAndType(parent);
        }
        return result;
    }

    public Map<QName, Serializable> getChannelProperties(NodeRef channel) {
        return this.nodeService.getProperties(channel);
    }

    public AssociationRef createMapping(NodeRef source, NodeRef publishedNode) {
        AssociationRef assoc = this.nodeService.createAssociation(publishedNode, source, PublishingModel.ASSOC_SOURCE);
        return assoc;
    }

    public boolean canPublish(NodeRef nodeToPublish, ChannelType type) {
        if (!type.canPublish()) {
            return false;
        }
        FileInfo file = this.fileFolderService.getFileInfo(nodeToPublish);
        ContentData contentData = file.getContentData();
        String mimetype = contentData == null ? null : contentData.getMimetype();
        boolean isContentTypeSupported = this.isContentTypeSupported(file.getType(), type);
        boolean isMimetypeSupported = this.isMimetypeSupported(mimetype, type);
        return isContentTypeSupported && isMimetypeSupported;
    }

    private boolean isMimetypeSupported(String mimetype, ChannelType type) {
        Set<String> supportedMimetypes = type.getSupportedMimeTypes();
        if (supportedMimetypes == null || supportedMimetypes.isEmpty()) {
            return true;
        }
        return supportedMimetypes.contains(mimetype);
    }

    private boolean isContentTypeSupported(QName contentType, ChannelType type) {
        Set<QName> supportedContentTypes = type.getSupportedContentTypes();
        if (supportedContentTypes == null || supportedContentTypes.isEmpty()) {
            return true;
        }
        for (QName supportedType : supportedContentTypes) {
            if (!contentType.equals((Object)supportedType) && !this.dictionaryService.isSubClass(contentType, supportedType)) continue;
            return true;
        }
        return false;
    }

    private QName getChannelQName(String channelName) {
        return QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)channelName);
    }

    private Pair<NodeRef, String> getChannelAndTypeIfChannel(NodeRef node) {
        QName type = this.nodeService.getType(node);
        if (this.dictionaryService.isSubClass(type, PublishingModel.TYPE_DELIVERY_CHANNEL)) {
            TypeDefinition typeDef;
            PropertyDefinition channelTypeProp;
            String channelTypeId = (String)((Object)this.nodeService.getProperty(node, PublishingModel.PROP_CHANNEL_TYPE_ID));
            if (channelTypeId == null && (channelTypeProp = (PropertyDefinition)(typeDef = this.dictionaryService.getType(type)).getProperties().get(PublishingModel.PROP_CHANNEL_TYPE_ID)) != null) {
                channelTypeId = channelTypeProp.getDefaultValue();
            }
            return new Pair((Object)node, (Object)channelTypeId);
        }
        return null;
    }

    public List<Channel> getAllChannels(NodeRef channelContainer, ChannelService channelService) {
        List<ChildAssociationRef> channelAssocs = this.getChannelAssocs(channelContainer);
        return CollectionUtils.transform(channelAssocs, this.getChannelTransformer(channelService, false));
    }

    public List<Channel> getChannelsForTypes(final NodeRef containerNode, List<ChannelType> types, final ChannelService channelService, final boolean checkPermissions) {
        return CollectionUtils.transformFlat(types, (Function)new Function<ChannelType, List<Channel>>(){

            public List<Channel> apply(ChannelType channelType) {
                return ChannelHelper.this.getChannelsByType(containerNode, channelType.getId(), channelService, checkPermissions);
            }
        });
    }

    public List<Channel> getChannelsByType(NodeRef containerNode, String channelTypeId, ChannelService channelService, boolean checkPermissions) {
        List<ChildAssociationRef> channelAssocs = this.getChannelAssocsByType(containerNode, channelTypeId);
        return CollectionUtils.transform(channelAssocs, this.getChannelTransformer(channelService, checkPermissions));
    }

    public List<Channel> filterAuthorisedChannels(Collection<Channel> channels) {
        return CollectionUtils.filter(channels, (Function)new Filter<Channel>(){

            public Boolean apply(Channel value) {
                return value.isAuthorised();
            }
        });
    }

    public List<ChannelType> getReleventChannelTypes(final NodeRef nodeToPublish, Collection<ChannelType> channelTypes) {
        return CollectionUtils.filter(channelTypes, (Function)new Filter<ChannelType>(){

            public Boolean apply(ChannelType type) {
                return ChannelHelper.this.canPublish(nodeToPublish, type);
            }
        });
    }

    public List<ChannelType> getStatusUpdateChannelTypes(Collection<ChannelType> channelTypes) {
        return CollectionUtils.filter(channelTypes, (Function)new Filter<ChannelType>(){

            public Boolean apply(ChannelType type) {
                return type.canPublishStatusUpdates();
            }
        });
    }

    public void addPublishedAspect(NodeRef publishedNode, NodeRef channelNode) {
        this.nodeService.addAspect(publishedNode, PublishingModel.ASPECT_PUBLISHED, null);
    }

    private List<ChildAssociationRef> getChannelAssocs(NodeRef channelContainer) {
        if (channelContainer == null) {
            return null;
        }
        Collection channelNodeTypes = this.dictionaryService.getSubTypes(PublishingModel.TYPE_DELIVERY_CHANNEL, true);
        HashSet childNodeTypeQNames = new HashSet(channelNodeTypes);
        return this.nodeService.getChildAssocs(channelContainer, childNodeTypeQNames);
    }

    private List<ChildAssociationRef> getChannelAssocsByType(NodeRef channelContainer, String channelTypeId) {
        if (channelContainer == null) {
            return null;
        }
        return this.nodeService.getChildAssocsByPropertyValue(channelContainer, PublishingModel.PROP_CHANNEL_TYPE_ID, (Serializable)((Object)channelTypeId));
    }

    private Pair<NodeRef, String> getChannelAndType(NodeRef node) {
        NodeRef channel = (NodeRef)this.nodeService.getProperty(node, PublishingModel.PROP_CHANNEL);
        if (channel != null) {
            String channelType = (String)((Object)this.nodeService.getProperty(node, PublishingModel.PROP_CHANNEL_TYPE));
            return new Pair((Object)channel, (Object)channelType);
        }
        return null;
    }

    private Function<ChildAssociationRef, Channel> getChannelTransformer(final ChannelService channelService, final boolean checkPermissions) {
        return new Function<ChildAssociationRef, Channel>(){

            public Channel apply(ChildAssociationRef value) {
                NodeRef channelNode = value.getChildRef();
                if (checkPermissions && !ChannelHelper.this.hasPublishPermissions(channelNode)) {
                    return null;
                }
                return ChannelHelper.this.buildChannelObject(channelNode, channelService);
            }
        };
    }

    public boolean hasPublishPermissions(NodeRef channelNode) {
        AccessStatus access = this.permissionService.hasPermission(channelNode, "AddChildren");
        return AccessStatus.ALLOWED == access;
    }

    public boolean isChannelAuthorised(NodeRef channelNode) {
        Boolean isAuthorised = Boolean.FALSE;
        if (this.nodeService.exists(channelNode)) {
            isAuthorised = (Boolean)this.nodeService.getProperty(channelNode, PublishingModel.PROP_AUTHORISATION_COMPLETE);
        }
        return isAuthorised;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setEventHelper(PublishingEventHelper eventHelper) {
        this.eventHelper = eventHelper;
    }
}

