/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import junit.framework.TestCase;
import org.alfresco.repo.publishing.AbstractChannelType;
import org.alfresco.repo.publishing.ChannelHelper;
import org.alfresco.repo.publishing.ChannelImpl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class ChannelImplTest
extends TestCase {
    public void testUpdateStatus() throws Exception {
        int maxLength = 30;
        AbstractChannelType channelType = this.mockChannelType(maxLength);
        ChannelHelper helper = (ChannelHelper)Mockito.mock(ChannelHelper.class);
        Mockito.when(helper.getChannelProperties((NodeRef)Matchers.any(NodeRef.class))).thenReturn(null);
        NodeRef node = new NodeRef("test://channel/node");
        ChannelImpl channel = new ChannelImpl(null, channelType, node, "Name", helper, null);
        String msg = "Here is a message";
        channel.sendStatusUpdate(msg, null);
        ((AbstractChannelType)Mockito.verify((Object)channelType)).sendStatusUpdate(channel, msg);
    }

    public void testUpdateStatusTruncates() throws Exception {
        int maxLength = 30;
        AbstractChannelType channelType = this.mockChannelType(maxLength);
        ChannelHelper helper = (ChannelHelper)Mockito.mock(ChannelHelper.class);
        Mockito.when(helper.getChannelProperties((NodeRef)Matchers.any(NodeRef.class))).thenReturn(null);
        NodeRef node = new NodeRef("test://channel/node");
        ChannelImpl channel = new ChannelImpl(null, channelType, node, "Name", helper, null);
        String msg = "Here is a much longer message to truncate.";
        String expMsg = msg.substring(0, maxLength);
        channel.sendStatusUpdate(msg, null);
        ((AbstractChannelType)Mockito.verify((Object)channelType)).sendStatusUpdate(channel, expMsg);
    }

    public void testUpdateStatusTruncatesWithUrl() throws Exception {
        int maxLength = 30;
        AbstractChannelType channelType = this.mockChannelType(maxLength);
        ChannelHelper helper = (ChannelHelper)Mockito.mock(ChannelHelper.class);
        Mockito.when(helper.getChannelProperties((NodeRef)Matchers.any(NodeRef.class))).thenReturn(null);
        NodeRef node = new NodeRef("test://channel/node");
        ChannelImpl channel = new ChannelImpl(null, channelType, node, "Name", helper, null);
        String nodeUrl = "http://foo/bar";
        int endpoint = maxLength - nodeUrl.length();
        String msg = "Here is a much longer message to truncate.";
        String expMsg = msg.substring(0, endpoint) + nodeUrl;
        channel.sendStatusUpdate(msg, nodeUrl);
        ((AbstractChannelType)Mockito.verify((Object)channelType)).sendStatusUpdate(channel, expMsg);
    }

    public void testUpdateStatusNoMaxLength() throws Exception {
        AbstractChannelType channelType = this.mockChannelType(0);
        ChannelHelper helper = (ChannelHelper)Mockito.mock(ChannelHelper.class);
        Mockito.when(helper.getChannelProperties((NodeRef)Matchers.any(NodeRef.class))).thenReturn(null);
        NodeRef node = new NodeRef("test://channel/node");
        ChannelImpl channel = new ChannelImpl(null, channelType, node, "Name", helper, null);
        String nodeUrl = "http://foo/bar";
        String msg = "Here is a much longer message to truncate.";
        String expMsg = msg + nodeUrl;
        channel.sendStatusUpdate(msg, nodeUrl);
        ((AbstractChannelType)Mockito.verify((Object)channelType)).sendStatusUpdate(channel, expMsg);
    }

    private AbstractChannelType mockChannelType(int maxLength) {
        AbstractChannelType channelType = (AbstractChannelType)Mockito.mock(AbstractChannelType.class);
        Mockito.when((Object)channelType.canPublishStatusUpdates()).thenReturn((Object)true);
        Mockito.when((Object)channelType.getMaximumStatusLength()).thenReturn((Object)maxLength);
        return channelType;
    }
}

