/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.service.cmr.publishing.PublishingDetails;
import org.alfresco.service.cmr.repository.NodeRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublishingDetailsImpl
implements PublishingDetails {
    private final Set<NodeRef> nodesToPublish = new HashSet<NodeRef>();
    private final Set<NodeRef> nodesToUnpublish = new HashSet<NodeRef>();
    private final Set<String> statusChannels = new HashSet<String>();
    private NodeRef nodeToLinkTo = null;
    private String message = null;
    private Calendar schedule = null;
    private String comment = null;
    private String publishChannelId = null;

    @Override
    public PublishingDetails addNodesToPublish(NodeRef ... nodesToAdd) {
        return this.addNodesToPublish(Arrays.asList(nodesToAdd));
    }

    @Override
    public PublishingDetails addNodesToUnpublish(NodeRef ... nodesToRemove) {
        return this.addNodesToUnpublish(Arrays.asList(nodesToRemove));
    }

    @Override
    public PublishingDetails addNodesToUnpublish(Collection<NodeRef> nodesToRemove) {
        this.nodesToUnpublish.addAll(nodesToRemove);
        return this;
    }

    @Override
    public PublishingDetails addNodesToPublish(Collection<NodeRef> nodesToAdd) {
        this.nodesToPublish.addAll(nodesToAdd);
        return this;
    }

    @Override
    public PublishingDetails setPublishChannelId(String publishChannelId) {
        this.publishChannelId = publishChannelId;
        return this;
    }

    @Override
    public PublishingDetails setComment(String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public PublishingDetails setSchedule(Calendar schedule) {
        this.schedule = schedule;
        return this;
    }

    @Override
    public PublishingDetails setStatusMessage(String message) {
        this.message = message;
        return this;
    }

    @Override
    public PublishingDetails setStatusNodeToLinkTo(NodeRef nodeToLinkTo) {
        this.nodeToLinkTo = nodeToLinkTo;
        return this;
    }

    @Override
    public PublishingDetails addStatusUpdateChannels(Collection<String> channelIds) {
        this.statusChannels.addAll(channelIds);
        return this;
    }

    @Override
    public PublishingDetails addStatusUpdateChannels(String ... channelIds) {
        return this.addStatusUpdateChannels(Arrays.asList(channelIds));
    }

    @Override
    public Set<NodeRef> getNodesToPublish() {
        return this.nodesToPublish;
    }

    @Override
    public Set<NodeRef> getNodesToUnpublish() {
        return this.nodesToUnpublish;
    }

    public Set<String> getStatusChannels() {
        return this.statusChannels;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public String getStatusMessage() {
        return this.message;
    }

    @Override
    public NodeRef getNodeToLinkTo() {
        return this.nodeToLinkTo;
    }

    @Override
    public String getPublishChannelId() {
        return this.publishChannelId;
    }

    @Override
    public Calendar getSchedule() {
        return this.schedule;
    }

    @Override
    public Set<String> getStatusUpdateChannels() {
        return this.statusChannels;
    }
}

