/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import junit.framework.Assert;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.publishing.NodeSnapshotSerializer;
import org.alfresco.repo.publishing.PublishingDetailsImpl;
import org.alfresco.repo.publishing.PublishingEventHelper;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.service.cmr.publishing.PublishingDetails;
import org.alfresco.service.cmr.publishing.PublishingEvent;
import org.alfresco.service.cmr.publishing.Status;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:test/alfresco/test-web-publishing-context.xml"})
public class PublishingEventHelperTest {
    @Resource(name="publishingEventHelper")
    PublishingEventHelper helper;
    @Resource(name="NodeService")
    NodeService nodeService;
    @Resource(name="ContentService")
    ContentService contentService;
    @Resource(name="PermissionService")
    PermissionService permissionService;

    @Test
    public void testGetPublishingEventNode() throws Exception {
        NodeRef eventNode = this.helper.getPublishingEventNode(null);
        Assert.assertNull((String)"If id is null event shoudl be null!", (Object)eventNode);
        eventNode = this.helper.getPublishingEventNode("foo");
        Assert.assertNull((String)"If id is invalid event shoudl be null!", (Object)eventNode);
        String nonExistantId = "foo://bar/nonExistantId";
        eventNode = this.helper.getPublishingEventNode(nonExistantId);
        Assert.assertNull((String)"If event node does not exist event shoudl be null!", (Object)eventNode);
        String nonPublishingEventId = "foo://bar/nonPublishingEventId";
        NodeRef nonPublishingEventNode = new NodeRef(nonPublishingEventId);
        Mockito.when((Object)this.nodeService.exists(nonPublishingEventNode)).thenReturn((Object)true);
        eventNode = this.helper.getPublishingEventNode(nonPublishingEventId);
        Assert.assertNull((String)"Event shoudl exist!", (Object)eventNode);
        String publishingEventId = "foo://bar/publishingEventId";
        NodeRef publishingEventNode = new NodeRef(publishingEventId);
        Mockito.when((Object)this.nodeService.exists(publishingEventNode)).thenReturn((Object)true);
        Mockito.when((Object)this.nodeService.getType(publishingEventNode)).thenReturn((Object)PublishingModel.TYPE_PUBLISHING_EVENT);
        eventNode = this.helper.getPublishingEventNode(publishingEventId);
        Assert.assertNotNull((String)"Event shoudl exist!", (Object)eventNode);
    }

    @Test
    public void testGetPublishingEvent() throws Exception {
        ContentReader reader = (ContentReader)Mockito.mock(ContentReader.class);
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)reader.getContentInputStream()).thenReturn((Object)inputStream);
        Mockito.when((Object)this.contentService.getReader((NodeRef)Matchers.any(NodeRef.class), (QName)Matchers.any(QName.class))).thenReturn((Object)reader);
        NodeSnapshotSerializer serializer = (NodeSnapshotSerializer)Mockito.mock(NodeSnapshotSerializer.class);
        this.helper.setSerializer(serializer);
        PublishingEvent result = this.helper.getPublishingEvent((NodeRef)null);
        Assert.assertNull((Object)result);
        String comment = "The comment";
        Status status = Status.COMPLETED;
        Date modified = new Date();
        Date created = new Date(modified.getTime() - 3600000L);
        String creatorName = "The creator";
        String modifierName = "The modifier";
        Calendar schedule = Calendar.getInstance();
        schedule.add(2, 6);
        Date scheduledTime = schedule.getTime();
        String scheduledTimeZone = schedule.getTimeZone().getID();
        HashMap<QName, Object> props = new HashMap<QName, Object>();
        props.put(PublishingModel.PROP_PUBLISHING_EVENT_COMMENT, comment);
        props.put(PublishingModel.PROP_PUBLISHING_EVENT_STATUS, status.name());
        props.put(PublishingModel.PROP_PUBLISHING_EVENT_TIME, scheduledTime);
        props.put(PublishingModel.PROP_PUBLISHING_EVENT_TIME_ZONE, scheduledTimeZone);
        props.put(ContentModel.PROP_CREATED, created);
        props.put(ContentModel.PROP_CREATOR, creatorName);
        props.put(ContentModel.PROP_MODIFIED, modified);
        props.put(ContentModel.PROP_MODIFIER, modifierName);
        NodeRef eventNode = new NodeRef("foo://bar/eventNode");
        Mockito.when((Object)this.nodeService.getProperties(eventNode)).thenReturn(props);
        result = this.helper.getPublishingEvent(eventNode);
        Assert.assertEquals((String)eventNode.toString(), (String)result.getId());
        Assert.assertEquals((String)comment, (String)result.getComment());
        Assert.assertEquals((Object)((Object)status), (Object)((Object)result.getStatus()));
        Assert.assertEquals((Object)schedule, (Object)result.getScheduledTime());
        Assert.assertEquals((Object)created, (Object)result.getCreatedTime());
        Assert.assertEquals((String)creatorName, (String)result.getCreator());
        Assert.assertEquals((Object)modified, (Object)result.getModifiedTime());
        Assert.assertEquals((String)modifierName, (String)result.getModifier());
    }

    @Test
    public void testCreateNode() throws Exception {
        Mockito.when((Object)this.permissionService.hasPermission((NodeRef)Matchers.any(NodeRef.class), Matchers.anyString())).thenReturn((Object)AccessStatus.ALLOWED);
        ContentWriter writer = (ContentWriter)Mockito.mock(ContentWriter.class);
        Mockito.when((Object)this.contentService.getWriter((NodeRef)Matchers.any(NodeRef.class), (QName)Matchers.eq((Object)PublishingModel.PROP_PUBLISHING_EVENT_PAYLOAD), Matchers.eq((boolean)true))).thenReturn((Object)writer);
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        Mockito.when((Object)writer.getContentOutputStream()).thenReturn((Object)outputStream);
        NodeSnapshotSerializer serializer = (NodeSnapshotSerializer)Mockito.mock(NodeSnapshotSerializer.class);
        this.helper.setSerializer(serializer);
        NodeRef queue = new NodeRef("foo://bar/queue");
        NodeRef event = new NodeRef("foo://bar/event");
        ChildAssociationRef childAssoc = new ChildAssociationRef(PublishingModel.ASSOC_PUBLISHING_EVENT, queue, null, event);
        Mockito.when((Object)this.nodeService.createNode((NodeRef)Matchers.any(NodeRef.class), (QName)Matchers.any(QName.class), (QName)Matchers.any(QName.class), (QName)Matchers.any(QName.class), Matchers.anyMap())).thenReturn((Object)childAssoc);
        String channelId = "test://channel/id";
        Calendar schedule = Calendar.getInstance();
        String comment = "The comment";
        PublishingDetails details = new PublishingDetailsImpl().setSchedule(schedule).setPublishChannelId(channelId).setComment(comment);
        NodeRef result = this.helper.createNode(queue, details);
        Assert.assertEquals((Object)event, (Object)result);
        ArgumentCaptor argument = ArgumentCaptor.forClass(Map.class);
        ((NodeService)Mockito.verify((Object)this.nodeService)).createNode((NodeRef)Matchers.eq((Object)queue), (QName)Matchers.eq((Object)PublishingModel.ASSOC_PUBLISHING_EVENT), (QName)Matchers.any(QName.class), (QName)Matchers.eq((Object)PublishingModel.TYPE_PUBLISHING_EVENT), (Map)argument.capture());
        Map props = (Map)argument.getValue();
        Assert.assertNotNull(props.get(ContentModel.PROP_NAME));
        Assert.assertEquals((Object)channelId, props.get(PublishingModel.PROP_PUBLISHING_EVENT_CHANNEL));
        Assert.assertEquals((Object)comment, props.get(PublishingModel.PROP_PUBLISHING_EVENT_COMMENT));
        Assert.assertEquals((Object)schedule.getTime(), props.get(PublishingModel.PROP_PUBLISHING_EVENT_TIME));
        Assert.assertEquals((Object)schedule.getTimeZone().getID(), props.get(PublishingModel.PROP_PUBLISHING_EVENT_TIME_ZONE));
    }
}

