/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.util.Calendar;
import java.util.Date;
import org.alfresco.repo.publishing.MutablePublishingEventImpl;
import org.alfresco.service.cmr.publishing.MutablePublishingEvent;
import org.alfresco.service.cmr.publishing.PublishingEvent;
import org.alfresco.service.cmr.publishing.PublishingPackage;
import org.alfresco.service.cmr.publishing.Status;
import org.alfresco.service.cmr.publishing.StatusUpdate;

public class PublishingEventImpl
implements PublishingEvent {
    private final String id;
    private final Status status;
    private final String channelId;
    private final PublishingPackage publishingPackage;
    private final Date createdTime;
    private final String creator;
    private final Date modifiedTime;
    private final String modifier;
    private final StatusUpdate statusUpdate;
    protected final Calendar scheduledTime;
    protected String comment;

    public PublishingEventImpl(String id, Status status, String channelName, PublishingPackage publishingPackage, Date createdTime, String creator, Date modifiedTime, String modifier, Calendar scheduledTime, String comment, StatusUpdate statusUpdate) {
        this.id = id;
        this.status = status;
        this.channelId = channelName;
        this.publishingPackage = publishingPackage;
        this.createdTime = createdTime;
        this.creator = creator;
        this.modifiedTime = modifiedTime;
        this.modifier = modifier;
        this.scheduledTime = scheduledTime;
        this.comment = comment;
        this.statusUpdate = statusUpdate;
    }

    public PublishingEventImpl(PublishingEvent event) {
        this(event.getId(), event.getStatus(), event.getChannelId(), event.getPackage(), event.getCreatedTime(), event.getCreator(), event.getModifiedTime(), event.getModifier(), event.getScheduledTime(), event.getComment(), event.getStatusUpdate());
    }

    public String getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public Calendar getScheduledTime() {
        return (Calendar)this.scheduledTime.clone();
    }

    public PublishingPackage getPackage() {
        return this.publishingPackage;
    }

    public Date getCreatedTime() {
        return new Date(this.createdTime.getTime());
    }

    public String getCreator() {
        return this.creator;
    }

    public Date getModifiedTime() {
        return new Date(this.modifiedTime.getTime());
    }

    public String getModifier() {
        return this.modifier;
    }

    public String getComment() {
        return this.comment;
    }

    public StatusUpdate getStatusUpdate() {
        return this.statusUpdate;
    }

    public MutablePublishingEvent edit() {
        return new MutablePublishingEventImpl(this);
    }

    public int compareTo(PublishingEvent event) {
        if (event == null) {
            return 1;
        }
        Date eventTime = event.getCreatedTime();
        if (eventTime == null) {
            return 1;
        }
        return (int)(this.createdTime.getTime() - eventTime.getTime());
    }
}

