/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.io.Serializable;
import java.util.Set;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.publishing.ChannelImpl;
import org.alfresco.repo.publishing.PublishingEventHelper;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.publishing.PublishingEvent;
import org.alfresco.service.cmr.publishing.Status;
import org.alfresco.service.cmr.publishing.StatusUpdate;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.publishing.channels.ChannelService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.urlshortening.UrlShortener;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PublishingEventProcessor {
    private static final Log log = LogFactory.getLog(PublishingEventProcessor.class);
    private PublishingEventHelper eventHelper;
    private ChannelService channelService;
    private NodeService nodeService;
    private BehaviourFilter behaviourFilter;
    private UrlShortener urlShortener;
    private TransactionService transactionService;

    public void processEventNode(NodeRef eventNode) {
        ParameterCheck.mandatory((String)"eventNode", (Object)eventNode);
        try {
            this.updateEventStatus(eventNode, Status.IN_PROGRESS);
            final PublishingEvent event = this.eventHelper.getPublishingEvent(eventNode);
            String channelName = event.getChannelId();
            final ChannelImpl channel = (ChannelImpl)this.channelService.getChannelById(channelName);
            if (channel == null) {
                this.fail(eventNode, "No channel found");
            } else {
                this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void execute() throws Throwable {
                        try {
                            PublishingEventProcessor.this.behaviourFilter.disableBehaviour();
                            channel.publishEvent(event);
                            PublishingEventProcessor.this.sendStatusUpdate(channel, event.getStatusUpdate());
                            Object var2_1 = null;
                            PublishingEventProcessor.this.behaviourFilter.enableBehaviour();
                        }
                        catch (Throwable throwable) {
                            Object var2_2 = null;
                            PublishingEventProcessor.this.behaviourFilter.enableBehaviour();
                            throw throwable;
                        }
                        return null;
                    }
                }, false, true);
                this.updateEventStatus(eventNode, Status.COMPLETED);
            }
        }
        catch (Exception e) {
            log.error((Object)("Caught exception while processing publishing event " + eventNode), (Throwable)e);
            this.fail(eventNode, e.getMessage());
        }
    }

    public void sendStatusUpdate(Channel publishChannel, StatusUpdate update) {
        if (update == null) {
            return;
        }
        String message = update.getMessage();
        String nodeUrl = this.getNodeUrl(publishChannel, update);
        Set<String> channels = update.getChannelIds();
        for (String channelId : channels) {
            Channel channel = this.channelService.getChannelById(channelId);
            if (channel == null) continue;
            channel.sendStatusUpdate(message, nodeUrl);
        }
    }

    private String getNodeUrl(Channel publishChannel, StatusUpdate update) {
        NodeRef node = update.getNodeToLinkTo();
        String nodeUrl = null;
        if (node != null && (nodeUrl = publishChannel.getUrl(node)) != null) {
            nodeUrl = " " + this.urlShortener.shortenUrl(nodeUrl);
        }
        return nodeUrl;
    }

    public void fail(NodeRef eventNode, String msg) {
        log.error((Object)("Failed to process publishing event " + eventNode + ": " + msg));
        this.updateEventStatus(eventNode, Status.FAILED);
    }

    private void updateEventStatus(final NodeRef eventNode, final Status status) {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                PublishingEventProcessor.this.nodeService.setProperty(eventNode, PublishingModel.PROP_PUBLISHING_EVENT_STATUS, (Serializable)((Object)status.name()));
                return null;
            }
        }, false, true);
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public void setPublishingEventHelper(PublishingEventHelper eventHelper) {
        this.eventHelper = eventHelper;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setUrlShortener(UrlShortener urlShortener) {
        this.urlShortener = urlShortener;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }
}

