/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing.facebook;

import org.alfresco.repo.node.encryption.MetadataEncryptor;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.repo.publishing.facebook.FacebookPublishingModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.springframework.social.connect.Connection;
import org.springframework.social.facebook.api.Facebook;
import org.springframework.social.facebook.connect.FacebookConnectionFactory;
import org.springframework.social.oauth2.AccessGrant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacebookPublishingHelper {
    private NodeService nodeService;
    private FacebookConnectionFactory connectionFactory;
    private MetadataEncryptor encryptor;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setConnectionFactory(FacebookConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public FacebookConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setEncryptor(MetadataEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public Connection<Facebook> getFacebookConnectionForChannel(NodeRef channelNode) {
        Connection connection = null;
        if (this.nodeService.exists(channelNode) && this.nodeService.hasAspect(channelNode, FacebookPublishingModel.ASPECT_DELIVERY_CHANNEL)) {
            String tokenValue = (String)((Object)this.encryptor.decrypt(PublishingModel.PROP_OAUTH2_TOKEN, this.nodeService.getProperty(channelNode, PublishingModel.PROP_OAUTH2_TOKEN)));
            Boolean danceComplete = (Boolean)this.nodeService.getProperty(channelNode, PublishingModel.PROP_AUTHORISATION_COMPLETE);
            if (danceComplete.booleanValue()) {
                AccessGrant token = new AccessGrant(tokenValue);
                connection = this.connectionFactory.createConnection(token);
            }
        }
        return connection;
    }
}

