/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing.slideshare;

import com.benfante.jslideshare.messages.SlideshowInfo;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.publishing.AbstractChannelType;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.repo.publishing.slideshare.SlideShareApi;
import org.alfresco.repo.publishing.slideshare.SlideSharePublishingHelper;
import org.alfresco.repo.publishing.slideshare.SlideSharePublishingModel;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlideShareChannelType
extends AbstractChannelType {
    public static final String ID = "slideshare";
    private static final Log log = LogFactory.getLog(SlideShareChannelType.class);
    private static final int STATUS_QUEUED = 0;
    private static final int STATUS_SUCCEEDED = 2;
    private static final int STATUS_FAILED = 3;
    private static final int STATUS_TIMED_OUT = 10;
    private static final String ERROR_SLIDESHARE_CONVERSION_FAILED = "publish.slideshare.conversionFailed";
    private static final String ERROR_SLIDESHARE_CONVERSION_TIMED_OUT = "publish.slideshare.conversionTimedOut";
    private SlideSharePublishingHelper publishingHelper;
    private ContentService contentService;
    private TaggingService taggingService;
    private long timeoutMilliseconds = 3600000L;

    public void setPublishingHelper(SlideSharePublishingHelper publishingHelper) {
        this.publishingHelper = publishingHelper;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    public void setTimeoutMilliseconds(long timeoutMilliseconds) {
        this.timeoutMilliseconds = timeoutMilliseconds;
    }

    @Override
    public boolean canPublish() {
        return true;
    }

    @Override
    public boolean canPublishStatusUpdates() {
        return false;
    }

    @Override
    public boolean canUnpublish() {
        return true;
    }

    @Override
    public QName getChannelNodeType() {
        return SlideSharePublishingModel.TYPE_DELIVERY_CHANNEL;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public Set<String> getSupportedMimeTypes() {
        return this.publishingHelper.getAllowedMimeTypes().keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(NodeRef nodeToPublish, Map<QName, Serializable> properties) {
        block19: {
            NodeService nodeService = this.getNodeService();
            Pair<String, String> usernamePassword = this.publishingHelper.getSlideShareCredentialsFromChannelProperties(properties);
            if (usernamePassword == null) {
                throw new AlfrescoRuntimeException("publish.failed.no_credentials_found");
            }
            SlideShareApi api = this.publishingHelper.getSlideShareApi((String)usernamePassword.getFirst(), (String)usernamePassword.getSecond());
            ContentReader reader = this.contentService.getReader(nodeToPublish, ContentModel.PROP_CONTENT);
            if (reader.exists()) {
                String mime = reader.getMimetype();
                String extension = this.publishingHelper.getAllowedMimeTypes().get(mime);
                if (extension == null) {
                    extension = "";
                }
                boolean deleteContentFileOnCompletion = false;
                File tempDir = TempFileProvider.getLongLifeTempDir((String)ID);
                File contentFile = TempFileProvider.createTempFile((String)ID, (String)extension, (File)tempDir);
                reader.getContent(contentFile);
                deleteContentFileOnCompletion = true;
                try {
                    String description;
                    String name = (String)((Object)nodeService.getProperty(nodeToPublish, ContentModel.PROP_NAME));
                    String title = (String)((Object)nodeService.getProperty(nodeToPublish, ContentModel.PROP_TITLE));
                    if (title == null || title.length() == 0) {
                        title = name;
                    }
                    if ((description = (String)((Object)nodeService.getProperty(nodeToPublish, ContentModel.PROP_DESCRIPTION))) == null || description.length() == 0) {
                        description = title;
                    }
                    List<String> tagList = this.taggingService.getTags(nodeToPublish);
                    StringBuilder tags = new StringBuilder();
                    for (String tag : tagList) {
                        tags.append(tag);
                        tags.append(' ');
                    }
                    String assetId = api.uploadSlideshow((String)usernamePassword.getFirst(), (String)usernamePassword.getSecond(), title, contentFile, description, tags.toString(), false, false, false, false, false);
                    String url = null;
                    int status = 0;
                    boolean finished = false;
                    long timeoutTime = System.currentTimeMillis() + this.timeoutMilliseconds;
                    while (!finished) {
                        SlideshowInfo slideInfo = api.getSlideshowInfo(assetId, "");
                        if (slideInfo != null) {
                            if (url == null) {
                                url = slideInfo.getUrl();
                                if (log.isInfoEnabled()) {
                                    log.info((Object)("SlideShare has provided a URL for asset " + assetId + ": " + url));
                                }
                            }
                            status = slideInfo.getStatus();
                        }
                        if (finished = status == 3 || status == 2) continue;
                        if (System.currentTimeMillis() < timeoutTime) {
                            try {
                                Thread.sleep(30000L);
                            }
                            catch (InterruptedException e) {}
                            continue;
                        }
                        status = 10;
                        finished = true;
                    }
                    if (status == 2) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("File " + name + " has been published to SlideShare with id " + assetId + " at URL " + url));
                        }
                    } else {
                        throw new AlfrescoRuntimeException(status == 3 ? ERROR_SLIDESHARE_CONVERSION_FAILED : ERROR_SLIDESHARE_CONVERSION_TIMED_OUT);
                    }
                    nodeService.addAspect(nodeToPublish, SlideSharePublishingModel.ASPECT_ASSET, null);
                    nodeService.setProperty(nodeToPublish, PublishingModel.PROP_ASSET_ID, (Serializable)((Object)assetId));
                    nodeService.setProperty(nodeToPublish, PublishingModel.PROP_ASSET_URL, (Serializable)((Object)url));
                    Object var26_24 = null;
                    if (!deleteContentFileOnCompletion) break block19;
                    contentFile.delete();
                }
                catch (Throwable throwable) {
                    Object var26_25 = null;
                    if (deleteContentFileOnCompletion) {
                        contentFile.delete();
                    }
                    throw throwable;
                }
                {
                }
            }
        }
    }

    @Override
    public void unpublish(NodeRef nodeToUnpublish, Map<QName, Serializable> properties) {
        String assetId;
        NodeService nodeService = this.getNodeService();
        if (nodeService.hasAspect(nodeToUnpublish, SlideSharePublishingModel.ASPECT_ASSET) && (assetId = (String)((Object)nodeService.getProperty(nodeToUnpublish, PublishingModel.PROP_ASSET_ID))) != null) {
            Pair<String, String> usernamePassword = this.publishingHelper.getSlideShareCredentialsFromChannelProperties(properties);
            if (usernamePassword == null) {
                throw new AlfrescoRuntimeException("publish.failed.no_credentials_found");
            }
            SlideShareApi api = this.publishingHelper.getSlideShareApi((String)usernamePassword.getFirst(), (String)usernamePassword.getSecond());
            api.deleteSlideshow((String)usernamePassword.getFirst(), (String)usernamePassword.getSecond(), assetId);
            nodeService.removeAspect(nodeToUnpublish, SlideSharePublishingModel.ASPECT_ASSET);
            nodeService.removeAspect(nodeToUnpublish, PublishingModel.ASPECT_ASSET);
        }
    }
}

