/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing.slideshare;

import com.benfante.jslideshare.SlideShareAPI;
import com.benfante.jslideshare.SlideShareConnector;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.repo.node.encryption.MetadataEncryptor;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.repo.publishing.slideshare.SlideShareApi;
import org.alfresco.repo.publishing.slideshare.SlideShareApiImpl;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlideSharePublishingHelper {
    private static final Map<String, String> DEFAULT_MIME_TYPES = new TreeMap<String, String>();
    private Map<String, String> allowedMimeTypes = Collections.unmodifiableMap(DEFAULT_MIME_TYPES);
    private SlideShareConnector slideshareConnector;
    private MetadataEncryptor encryptor;

    public void setSlideshareConnector(SlideShareConnector slideshareConnector) {
        this.slideshareConnector = slideshareConnector;
    }

    public Map<String, String> getAllowedMimeTypes() {
        return this.allowedMimeTypes;
    }

    public void setAllowedMimeTypes(Map<String, String> allowedMimeTypes) {
        this.allowedMimeTypes = Collections.unmodifiableMap(allowedMimeTypes);
    }

    public void setEncryptor(MetadataEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public SlideShareAPI getSlideShareApi() {
        return this.createApiObject();
    }

    private SlideShareApiImpl createApiObject() {
        return new SlideShareApiImpl(this.slideshareConnector);
    }

    public Pair<String, String> getSlideShareCredentialsFromChannelProperties(Map<QName, Serializable> channelProperties) {
        Pair result = null;
        String username = (String)((Object)this.encryptor.decrypt(PublishingModel.PROP_CHANNEL_USERNAME, channelProperties.get(PublishingModel.PROP_CHANNEL_USERNAME)));
        String password = (String)((Object)this.encryptor.decrypt(PublishingModel.PROP_CHANNEL_PASSWORD, channelProperties.get(PublishingModel.PROP_CHANNEL_PASSWORD)));
        if (username != null && password != null) {
            result = new Pair((Object)username, (Object)password);
        }
        return result;
    }

    public SlideShareApi getSlideShareApi(String username, String password) {
        SlideShareApiImpl api = this.createApiObject();
        api.setUsername(username);
        api.setPassword(password);
        return api;
    }

    static {
        DEFAULT_MIME_TYPES.put("application/vnd.ms-powerpoint", ".ppt");
        DEFAULT_MIME_TYPES.put("application/pdf", ".pdf");
        DEFAULT_MIME_TYPES.put("application/vnd.oasis.opendocument.presentation", ".odp");
        DEFAULT_MIME_TYPES.put("application/vnd.openxmlformats-officedocument.presentationml.presentation", ".pptx");
        DEFAULT_MIME_TYPES.put("application/vnd.apple.keynote", "");
        DEFAULT_MIME_TYPES.put("application/vnd.apple.pages", "");
        DEFAULT_MIME_TYPES.put("text/plain", ".txt");
        DEFAULT_MIME_TYPES.put("application/vnd.oasis.opendocument.text", ".odt");
        DEFAULT_MIME_TYPES.put("text/csv", ".csv");
        DEFAULT_MIME_TYPES.put("application/vnd.ms-excel", ".xls");
        DEFAULT_MIME_TYPES.put("application/vnd.openxmlformats-officedocument.wordprocessingml.document", ".docx");
        DEFAULT_MIME_TYPES.put("application/vnd.oasis.opendocument.spreadsheet", ".ods");
    }
}

