/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing.slideshare;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.publishing.Environment;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.repo.publishing.PublishingQueueImpl;
import org.alfresco.repo.publishing.slideshare.SlideShareChannelType;
import org.alfresco.repo.publishing.slideshare.SlideSharePublishingModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.publishing.channels.ChannelService;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.junit.Assert;
import org.springframework.core.io.ClassPathResource;

public class SlideShareTest
extends BaseSpringTest {
    protected ServiceRegistry serviceRegistry;
    protected SiteService siteService;
    protected FileFolderService fileFolderService;
    protected NodeService nodeService;
    protected String siteId;
    protected PublishingQueueImpl queue;
    protected Environment environment;
    protected NodeRef docLib;
    protected Map<String, String> testFiles = new TreeMap<String, String>();
    protected Map<NodeRef, String> testNodeMap = new HashMap<NodeRef, String>();
    private ChannelService channelService;
    private RetryingTransactionHelper transactionHelper;

    public void onSetUp() throws Exception {
        this.serviceRegistry = (ServiceRegistry)this.getApplicationContext().getBean("ServiceRegistry");
        this.channelService = (ChannelService)this.getApplicationContext().getBean("channelService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.siteService = this.serviceRegistry.getSiteService();
        this.fileFolderService = this.serviceRegistry.getFileFolderService();
        this.nodeService = this.serviceRegistry.getNodeService();
        this.transactionHelper = this.serviceRegistry.getRetryingTransactionHelper();
        this.siteId = GUID.generate();
        this.siteService.createSite("test", this.siteId, "Site created by publishing test", "Site created by publishing test", SiteVisibility.PUBLIC);
        this.docLib = this.siteService.createContainer(this.siteId, "documentLibrary", ContentModel.TYPE_FOLDER, null);
        this.testFiles.put("test/alfresco/TestPresentation.pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        this.testFiles.put("test/alfresco/TestPresentation2.ppt", "application/vnd.ms-powerpoint");
        this.testFiles.put("test/alfresco/TestPresentation3.odp", "application/vnd.oasis.opendocument.presentation");
        this.testFiles.put("test/alfresco/TestPresentation4.pdf", "application/pdf");
    }

    public void onTearDown() {
        this.siteService.deleteSite(this.siteId);
    }

    public void testBlank() {
    }

    public void xtestSlideSharePublishAndUnpublishActions() throws Exception {
        final SlideShareChannelType channelType = (SlideShareChannelType)this.channelService.getChannelType("slideshare");
        final String channelName = GUID.generate();
        final List<NodeRef> nodes = this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<List<NodeRef>>(){

            @Override
            public List<NodeRef> execute() throws Throwable {
                ArrayList<NodeRef> createdTestNodes = new ArrayList<NodeRef>();
                HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
                props.put(PublishingModel.PROP_CHANNEL_USERNAME, (Serializable)((Object)"YOUR_USER_NAME"));
                props.put(PublishingModel.PROP_CHANNEL_PASSWORD, (Serializable)((Object)"YOUR_PASSWORD"));
                Channel channel = SlideShareTest.this.channelService.createChannel("slideshare", channelName, props);
                NodeRef channelNode = channel.getNodeRef();
                for (Map.Entry<String, String> testFileInfoEntry : SlideShareTest.this.testFiles.entrySet()) {
                    NodeRef nodeRef = this.createTestNode(channelNode, testFileInfoEntry.getKey(), testFileInfoEntry.getValue());
                    createdTestNodes.add(nodeRef);
                    SlideShareTest.this.testNodeMap.put(nodeRef, testFileInfoEntry.getKey());
                }
                return createdTestNodes;
            }

            private NodeRef createTestNode(NodeRef parent, String fileLocation, String mimeType) throws ContentIOException, IOException {
                ClassPathResource file = new ClassPathResource(fileLocation);
                HashMap<QName, String> props = new HashMap<QName, String>();
                props.put(ContentModel.PROP_NAME, "Presentation " + GUID.generate());
                NodeRef node = SlideShareTest.this.nodeService.createNode(parent, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)GUID.generate()), ContentModel.TYPE_CONTENT, props).getChildRef();
                ContentService contentService = SlideShareTest.this.serviceRegistry.getContentService();
                ContentWriter writer = contentService.getWriter(node, ContentModel.PROP_CONTENT, true);
                writer.setMimetype(mimeType);
                writer.putContent(file.getFile());
                return node;
            }
        });
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                Map props;
                Map<QName, Serializable> channelProperties = SlideShareTest.this.channelService.getChannelByName(channelName).getProperties();
                for (NodeRef node : nodes) {
                    channelType.publish(node, channelProperties);
                    props = SlideShareTest.this.nodeService.getProperties(node);
                    Assert.assertTrue((boolean)SlideShareTest.this.nodeService.hasAspect(node, SlideSharePublishingModel.ASPECT_ASSET));
                    Assert.assertNotNull(props.get(PublishingModel.PROP_ASSET_ID));
                    Assert.assertNotNull(props.get(PublishingModel.PROP_ASSET_URL));
                    System.out.println("Published test file: " + SlideShareTest.this.testNodeMap.get(node));
                    System.out.println("SlideShare id: " + props.get(PublishingModel.PROP_ASSET_ID));
                    System.out.println("SlideShare URL: " + props.get(PublishingModel.PROP_ASSET_URL));
                }
                for (NodeRef node : nodes) {
                    props = SlideShareTest.this.nodeService.getProperties(node);
                    channelType.unpublish(node, channelProperties);
                    props = SlideShareTest.this.nodeService.getProperties(node);
                    Assert.assertFalse((boolean)SlideShareTest.this.nodeService.hasAspect(node, SlideSharePublishingModel.ASPECT_ASSET));
                    Assert.assertNull(props.get(PublishingModel.PROP_ASSET_ID));
                    Assert.assertNull(props.get(PublishingModel.PROP_ASSET_URL));
                    System.out.println("Unpublished test file: " + SlideShareTest.this.testNodeMap.get(node));
                }
                return null;
            }
        });
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                for (NodeRef node : nodes) {
                    SlideShareTest.this.nodeService.deleteNode(node);
                }
                return null;
            }
        });
    }
}

