/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing.youtube;

import com.google.gdata.client.media.MediaService;
import com.google.gdata.client.media.ResumableGDataFileUploader;
import com.google.gdata.client.uploader.ProgressListener;
import com.google.gdata.client.uploader.ResumableHttpFileUploader;
import com.google.gdata.client.youtube.YouTubeService;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.media.MediaFileSource;
import com.google.gdata.data.media.mediarss.MediaCategory;
import com.google.gdata.data.media.mediarss.MediaContent;
import com.google.gdata.data.media.mediarss.MediaDescription;
import com.google.gdata.data.media.mediarss.MediaKeywords;
import com.google.gdata.data.media.mediarss.MediaTitle;
import com.google.gdata.data.youtube.VideoEntry;
import com.google.gdata.data.youtube.YouTubeMediaGroup;
import com.google.gdata.util.ServiceException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.publishing.AbstractChannelType;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.repo.publishing.youtube.YouTubePublishingHelper;
import org.alfresco.repo.publishing.youtube.YouTubePublishingModel;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YouTubeChannelType
extends AbstractChannelType {
    private static final Log log = LogFactory.getLog(YouTubeChannelType.class);
    private static final Set<String> DEFAULT_SUPPORTED_MIME_TYPES = CollectionUtils.unmodifiableSet((Object[])new String[]{"video/mpeg", "video/mp4", "video/x-flv", "video/3gpp", "video/x-msvideo", "video/quicktime", "video/x-ms-wmv"});
    public static final String RESUMABLE_UPLOAD_URL = "http://uploads.gdata.youtube.com/resumable/feeds/api/users/default/uploads";
    private static final int PROGRESS_UPDATE_INTERVAL = 1000;
    private static final int DEFAULT_CHUNK_SIZE = 10000000;
    private Set<String> supportedMimeTypes = DEFAULT_SUPPORTED_MIME_TYPES;
    public static final String ID = "youtube";
    private YouTubePublishingHelper youTubeHelper;
    private ContentService contentService;
    private TaggingService taggingService;

    public void setYouTubeHelper(YouTubePublishingHelper youTubeHelper) {
        this.youTubeHelper = youTubeHelper;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    public void setSupportedMimeTypes(Set<String> supportedMimeTypes) {
        this.supportedMimeTypes = Collections.unmodifiableSet(new TreeSet<String>(supportedMimeTypes));
    }

    @Override
    public boolean canPublish() {
        return true;
    }

    @Override
    public boolean canPublishStatusUpdates() {
        return false;
    }

    @Override
    public boolean canUnpublish() {
        return true;
    }

    @Override
    public QName getChannelNodeType() {
        return YouTubePublishingModel.TYPE_DELIVERY_CHANNEL;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public Set<String> getSupportedMimeTypes() {
        return this.supportedMimeTypes;
    }

    @Override
    public void publish(NodeRef nodeToPublish, Map<QName, Serializable> properties) {
        YouTubeService service = this.youTubeHelper.getYouTubeServiceFromChannelProperties(properties);
        if (service != null) {
            try {
                this.uploadVideo(service, nodeToPublish);
            }
            catch (Exception ex) {
                log.error((Object)"Failed to send asset to YouTube", (Throwable)ex);
                throw new AlfrescoRuntimeException("exception.publishing.youtube.publishFailed", (Throwable)ex);
            }
        }
    }

    @Override
    public void unpublish(NodeRef nodeToUnpublish, Map<QName, Serializable> properties) {
        YouTubeService service = this.youTubeHelper.getYouTubeServiceFromChannelProperties(properties);
        if (service != null) {
            try {
                this.removeVideo(service, nodeToUnpublish);
            }
            catch (Exception ex) {
                log.error((Object)"Failed to remove asset from YouTube", (Throwable)ex);
                throw new AlfrescoRuntimeException("exception.publishing.youtube.unpublishFailed", (Throwable)ex);
            }
        }
    }

    private void removeVideo(YouTubeService service, NodeRef nodeRef) throws MalformedURLException, IOException, ServiceException {
        String youtubeId;
        NodeService nodeService = this.getNodeService();
        if (nodeService.hasAspect(nodeRef, YouTubePublishingModel.ASPECT_ASSET) && (youtubeId = (String)((Object)nodeService.getProperty(nodeRef, PublishingModel.PROP_ASSET_ID))) != null) {
            String videoEntryUrl = "https://gdata.youtube.com/feeds/api/users/default/uploads/" + youtubeId;
            VideoEntry videoEntry = (VideoEntry)service.getEntry(new URL(videoEntryUrl), VideoEntry.class);
            videoEntry.delete();
            nodeService.removeAspect(nodeRef, YouTubePublishingModel.ASPECT_ASSET);
            nodeService.removeAspect(nodeRef, PublishingModel.ASPECT_ASSET);
        }
    }

    private void uploadVideo(YouTubeService service, NodeRef nodeRef) throws IOException, ServiceException, InterruptedException {
        NodeService nodeService = this.getNodeService();
        ContentReader reader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT);
        if (reader.exists()) {
            String videoDescription;
            File contentFile;
            boolean deleteContentFileOnCompletion = false;
            if (FileContentReader.class.isAssignableFrom(reader.getClass())) {
                contentFile = ((FileContentReader)reader).getFile();
            } else {
                File tempDir = TempFileProvider.getLongLifeTempDir((String)ID);
                contentFile = TempFileProvider.createTempFile((String)ID, (String)"", (File)tempDir);
                reader.getContent(contentFile);
                deleteContentFileOnCompletion = true;
            }
            MediaFileSource ms = new MediaFileSource(contentFile, reader.getMimetype());
            String videoName = (String)((Object)nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            String videoTitle = (String)((Object)nodeService.getProperty(nodeRef, ContentModel.PROP_TITLE));
            if (videoTitle == null || videoTitle.length() == 0) {
                videoTitle = videoName;
            }
            if ((videoDescription = (String)((Object)nodeService.getProperty(nodeRef, ContentModel.PROP_DESCRIPTION))) == null || videoDescription.length() == 0) {
                videoDescription = videoTitle;
            }
            VideoEntry newEntry = new VideoEntry();
            YouTubeMediaGroup mg = newEntry.getOrCreateMediaGroup();
            mg.addCategory(new MediaCategory("http://gdata.youtube.com/schemas/2007/categories.cat", "Tech"));
            mg.setTitle(new MediaTitle());
            mg.getTitle().setPlainTextContent(videoTitle);
            mg.setKeywords(new MediaKeywords());
            List<String> tags = this.taggingService.getTags(nodeRef);
            for (String tag : tags) {
                mg.getKeywords().addKeyword(tag);
            }
            mg.setDescription(new MediaDescription());
            mg.getDescription().setPlainTextContent(videoDescription);
            FileUploadProgressListener listener = new FileUploadProgressListener(videoName);
            ResumableGDataFileUploader uploader = new ResumableGDataFileUploader.Builder((MediaService)service, new URL(RESUMABLE_UPLOAD_URL), ms, (IEntry)newEntry).title(videoTitle).trackProgress((ProgressListener)listener, 1000L).chunkSize(10000000L).build();
            uploader.start();
            while (!uploader.isDone()) {
                Thread.sleep(1000L);
            }
            switch (uploader.getUploadState()) {
                case COMPLETE: {
                    VideoEntry entry = (VideoEntry)uploader.getResponse(VideoEntry.class);
                    String videoId = entry.getMediaGroup().getVideoId();
                    String contentUrl = ((MediaContent)entry.getMediaGroup().getContents().get(0)).getUrl();
                    String playerUrl = entry.getMediaGroup().getPlayer().getUrl();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Video content uploaded successfully: " + videoName));
                        log.debug((Object)("YouTube video id is " + videoId));
                        log.debug((Object)("YouTube content URL is " + contentUrl));
                        log.debug((Object)("YouTube video player URL is " + playerUrl));
                    }
                    nodeService.addAspect(nodeRef, YouTubePublishingModel.ASPECT_ASSET, null);
                    nodeService.setProperty(nodeRef, PublishingModel.PROP_ASSET_ID, (Serializable)((Object)videoId));
                    nodeService.setProperty(nodeRef, PublishingModel.PROP_ASSET_URL, (Serializable)((Object)playerUrl));
                    break;
                }
                case CLIENT_ERROR: {
                    log.error((Object)("Video content failed to upload: " + videoName));
                    break;
                }
                default: {
                    log.warn((Object)("Unknown upload state. Video content may not have uploaded: " + videoName + "(" + uploader.getUploadState() + ") :" + nodeRef));
                }
            }
            if (deleteContentFileOnCompletion) {
                contentFile.delete();
            }
        }
    }

    private class FileUploadProgressListener
    implements ProgressListener {
        String videoName;

        public FileUploadProgressListener(String videoName) {
            this.videoName = videoName;
        }

        public synchronized void progressChanged(ResumableHttpFileUploader uploader) {
            switch (uploader.getUploadState()) {
                case COMPLETE: {
                    log.info((Object)("Upload Completed: " + this.videoName));
                    break;
                }
                case CLIENT_ERROR: {
                    log.error((Object)("Upload Failed: " + this.videoName));
                    break;
                }
                case IN_PROGRESS: {
                    log.info((Object)(this.videoName + String.format("  %3.0f", uploader.getProgress() * 100.0) + "%"));
                    break;
                }
                case NOT_STARTED: {
                    log.info((Object)("Upload Not Started: " + this.videoName));
                }
            }
        }
    }
}

