/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.query;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.query.AbstractCannedQueryFactory;
import org.alfresco.query.CannedQueryPageDetails;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.query.NodeBackedEntity;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityBean;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQNameAwareCannedQueryFactory<R>
extends AbstractCannedQueryFactory<R> {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected MethodSecurityBean<R> methodSecurity;
    protected NodeDAO nodeDAO;
    protected QNameDAO qnameDAO;
    protected TenantService tenantService;
    protected CannedQueryDAO cannedQueryDAO;

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setCannedQueryDAO(CannedQueryDAO cannedQueryDAO) {
        this.cannedQueryDAO = cannedQueryDAO;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setMethodSecurity(MethodSecurityBean<R> methodSecurity) {
        this.methodSecurity = methodSecurity;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        PropertyCheck.mandatory((Object)((Object)this), (String)"methodSecurity", this.methodSecurity);
        PropertyCheck.mandatory((Object)((Object)this), (String)"nodeDAO", (Object)this.nodeDAO);
        PropertyCheck.mandatory((Object)((Object)this), (String)"qnameDAO", (Object)this.qnameDAO);
        PropertyCheck.mandatory((Object)((Object)this), (String)"cannedQueryDAO", (Object)this.cannedQueryDAO);
        PropertyCheck.mandatory((Object)((Object)this), (String)"tenantService", (Object)this.tenantService);
    }

    protected CannedQuerySortDetails createCQSortDetails(List<Pair<QName, Boolean>> sort) {
        ArrayList<Pair> details = new ArrayList<Pair>();
        for (Pair<QName, Boolean> sortProp : sort) {
            details.add(new Pair(sortProp.getFirst(), (Object)((Boolean)sortProp.getSecond() != false ? CannedQuerySortDetails.SortOrder.ASCENDING : CannedQuerySortDetails.SortOrder.DESCENDING)));
        }
        return new CannedQuerySortDetails(details);
    }

    protected CannedQueryPageDetails createCQPageDetails(PagingRequest pagingReq) {
        int maxItems;
        int skipCount = pagingReq.getSkipCount();
        if (skipCount == -1) {
            skipCount = 0;
        }
        if ((maxItems = pagingReq.getMaxItems()) == -1) {
            maxItems = Integer.MAX_VALUE;
        }
        CannedQueryPageDetails cqpd = new CannedQueryPageDetails(skipCount, maxItems);
        return cqpd;
    }

    protected Long getQNameId(QName qname) {
        Pair<Long, QName> qnamePair = this.qnameDAO.getQName(qname);
        if (qnamePair == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("QName does not exist: " + qname));
            }
            return null;
        }
        return (Long)qnamePair.getFirst();
    }

    protected Long getNodeId(NodeRef nodeRef) {
        Pair<Long, NodeRef> nodePair = this.nodeDAO.getNodePair(this.tenantService.getName(nodeRef));
        if (nodePair == null) {
            throw new InvalidNodeRefException("Node ref does not exist: " + nodeRef, nodeRef);
        }
        return (Long)nodePair.getFirst();
    }

    public CannedQuerySortDetails createDateAscendingCQSortDetails() {
        ArrayList<Pair> sort = new ArrayList<Pair>();
        sort.add(new Pair((Object)ContentModel.PROP_CREATED, (Object)CannedQuerySortDetails.SortOrder.ASCENDING));
        sort.add(new Pair((Object)ContentModel.PROP_MODIFIED, (Object)CannedQuerySortDetails.SortOrder.ASCENDING));
        return new CannedQuerySortDetails(sort);
    }

    public CannedQuerySortDetails createDateDescendingCQSortDetails() {
        ArrayList<Pair> sort = new ArrayList<Pair>();
        sort.add(new Pair((Object)ContentModel.PROP_CREATED, (Object)CannedQuerySortDetails.SortOrder.DESCENDING));
        sort.add(new Pair((Object)ContentModel.PROP_MODIFIED, (Object)CannedQuerySortDetails.SortOrder.DESCENDING));
        return new CannedQuerySortDetails(sort);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NestedComparator<R>
    implements Comparator<R> {
        private List<Pair<Comparator<R>, CannedQuerySortDetails.SortOrder>> comparators;

        public NestedComparator(List<Pair<Comparator<R>, CannedQuerySortDetails.SortOrder>> comparators) {
            this.comparators = comparators;
        }

        @Override
        public int compare(R entry1, R entry2) {
            for (Pair<Comparator<R>, CannedQuerySortDetails.SortOrder> pc : this.comparators) {
                int result = ((Comparator)pc.getFirst()).compare(entry1, entry2);
                if (result == 0) continue;
                if (pc.getSecond() == CannedQuerySortDetails.SortOrder.ASCENDING) {
                    return result;
                }
                return 0 - result;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeBackedEntityComparator
    extends PropertyBasedComparator<NodeBackedEntity> {
        public NodeBackedEntityComparator(QName comparableProperty) {
            super(comparableProperty);
        }

        @Override
        protected Comparable getProperty(NodeBackedEntity entity) {
            if (this.comparableProperty.equals((Object)ContentModel.PROP_CREATED)) {
                return entity.getCreatedDate();
            }
            if (this.comparableProperty.equals((Object)ContentModel.PROP_MODIFIED)) {
                return entity.getModifiedDate();
            }
            if (this.comparableProperty.equals((Object)ContentModel.PROP_CREATOR)) {
                return entity.getCreator();
            }
            if (this.comparableProperty.equals((Object)ContentModel.PROP_MODIFIER)) {
                return entity.getModifier();
            }
            if (this.comparableProperty.equals((Object)ContentModel.PROP_NAME)) {
                return entity.getName();
            }
            throw new IllegalArgumentException("Unsupported calendar sort property: " + this.comparableProperty);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class PropertyBasedComparator<R>
    implements Comparator<R> {
        protected QName comparableProperty;

        public PropertyBasedComparator(QName comparableProperty) {
            this.comparableProperty = comparableProperty;
        }

        protected abstract Comparable getProperty(R var1);

        @Override
        public int compare(R r1, R r2) {
            Comparable prop1 = this.getProperty(r1);
            Comparable prop2 = this.getProperty(r2);
            if (prop1 == null && prop2 == null) {
                return 0;
            }
            if (prop1 == null && prop2 != null) {
                return -1;
            }
            if (prop1 != null && prop2 == null) {
                return 1;
            }
            return prop1.compareTo(prop2);
        }
    }
}

