/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rating;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.rating.AbstractRatingRollupAlgorithm;
import org.alfresco.repo.rating.RatingNamingConventionsUtil;
import org.alfresco.repo.rating.RatingSchemeRegistry;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.rating.Rating;
import org.alfresco.service.cmr.rating.RatingScheme;
import org.alfresco.service.cmr.rating.RatingService;
import org.alfresco.service.cmr.rating.RatingServiceException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RatingServiceImpl
implements RatingService {
    private static final Log log = LogFactory.getLog(RatingServiceImpl.class);
    private RatingSchemeRegistry schemeRegistry;
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private BehaviourFilter behaviourFilter;
    private RatingNamingConventionsUtil ratingNamingConventions;

    public void setRatingSchemeRegistry(RatingSchemeRegistry schemeRegistry) {
        this.schemeRegistry = schemeRegistry;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setRollupNamingConventions(RatingNamingConventionsUtil namingConventions) {
        this.ratingNamingConventions = namingConventions;
    }

    @Override
    public Map<String, RatingScheme> getRatingSchemes() {
        return this.schemeRegistry.getRatingSchemes();
    }

    @Override
    public RatingScheme getRatingScheme(String ratingSchemeName) {
        return this.schemeRegistry.getRatingSchemes().get(ratingSchemeName);
    }

    @Override
    public void applyRating(final NodeRef targetNode, final float rating, final String ratingSchemeName) throws RatingServiceException {
        final String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        boolean isCreator = this.isCurrentUserNodeCreator(targetNode);
        if (isCreator && !this.getRatingScheme(ratingSchemeName).isSelfRatingAllowed()) {
            throw new RatingServiceException("Users can't rate their own content for scheme " + ratingSchemeName);
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                RatingServiceImpl.this.applyRating(targetNode, rating, ratingSchemeName, currentUser);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private boolean isCurrentUserNodeCreator(NodeRef targetNode) {
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        Serializable creator = this.nodeService.getProperty(targetNode, ContentModel.PROP_CREATOR);
        return currentUser.equals(creator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyRating(NodeRef targetNode, float rating, String ratingSchemeName, String userName) throws RatingServiceException {
        QName assocQName;
        List myRatingChildren;
        boolean rollupAspectIsDefined;
        RatingScheme ratingScheme;
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Applying rating ").append(rating).append(" in scheme ").append(ratingSchemeName).append(" as user ").append(userName).append(" on ").append(targetNode);
            log.debug((Object)msg.toString());
        }
        if ((ratingScheme = this.getRatingScheme(ratingSchemeName)) == null) {
            throw new RatingServiceException("Unrecognised rating scheme: " + ratingSchemeName);
        }
        if (rating < ratingScheme.getMinRating() || rating > ratingScheme.getMaxRating()) {
            throw new RatingServiceException("Rating " + rating + " violates range for " + ratingScheme);
        }
        QName rollupAspectName = this.ratingNamingConventions.getRollupAspectNameFor(ratingScheme);
        boolean bl = rollupAspectIsDefined = this.dictionaryService.getAspect(rollupAspectName) != null;
        if (!this.nodeService.hasAspect(targetNode, ContentModel.ASPECT_RATEABLE)) {
            this.behaviourFilter.disableBehaviour(targetNode, ContentModel.ASPECT_AUDITABLE);
            try {
                this.nodeService.addAspect(targetNode, ContentModel.ASPECT_RATEABLE, null);
                if (rollupAspectIsDefined) {
                    this.nodeService.addAspect(targetNode, rollupAspectName, null);
                }
            }
            finally {
                this.behaviourFilter.enableBehaviour(targetNode, ContentModel.ASPECT_AUDITABLE);
            }
        }
        if ((myRatingChildren = this.nodeService.getChildAssocs(targetNode, (QNamePattern)ContentModel.ASSOC_RATINGS, (QNamePattern)(assocQName = this.ratingNamingConventions.getRatingAssocNameFor(userName, ratingScheme.getName())))).isEmpty()) {
            HashMap<QName, Object> ratingProps = new HashMap<QName, Object>();
            ratingProps.put(ContentModel.PROP_RATING_SCORE, Float.valueOf(rating));
            ratingProps.put(ContentModel.PROP_RATED_AT, new Date());
            ratingProps.put(ContentModel.PROP_RATING_SCHEME, ratingSchemeName);
            this.behaviourFilter.disableBehaviour(targetNode, ContentModel.ASPECT_AUDITABLE);
            try {
                this.nodeService.createNode(targetNode, ContentModel.ASSOC_RATINGS, assocQName, ContentModel.TYPE_RATING, ratingProps);
            }
            finally {
                this.behaviourFilter.enableBehaviour(targetNode, ContentModel.ASPECT_AUDITABLE);
            }
        } else {
            NodeRef myPreviousRatingsNode = ((ChildAssociationRef)myRatingChildren.get(0)).getChildRef();
            HashMap<QName, Object> ratingProps = new HashMap<QName, Object>();
            ratingProps.put(ContentModel.PROP_RATING_SCHEME, ratingSchemeName);
            ratingProps.put(ContentModel.PROP_RATING_SCORE, Float.valueOf(rating));
            ratingProps.put(ContentModel.PROP_RATED_AT, new Date());
            this.nodeService.setProperties(myPreviousRatingsNode, ratingProps);
        }
        this.recalculateRatingRollups(targetNode, ratingScheme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateRatingRollups(NodeRef targetNode, RatingScheme ratingScheme) {
        QName rollupAspectName = this.ratingNamingConventions.getRollupAspectNameFor(ratingScheme);
        AspectDefinition rollupAspect = this.dictionaryService.getAspect(rollupAspectName);
        if (rollupAspect != null) {
            this.behaviourFilter.disableBehaviour(targetNode, ContentModel.ASPECT_AUDITABLE);
            try {
                for (AbstractRatingRollupAlgorithm rollupAlgorithm : ratingScheme.getPropertyRollups()) {
                    Serializable s = rollupAlgorithm.recalculate(targetNode);
                    QName rollupPropertyName = this.ratingNamingConventions.getRollupPropertyNameFor(ratingScheme, rollupAlgorithm.getRollupName());
                    this.nodeService.setProperty(targetNode, rollupPropertyName, s);
                    if (rollupAspect.getProperties().containsKey(rollupPropertyName) || !log.isDebugEnabled()) continue;
                    StringBuilder msg = new StringBuilder();
                    msg.append("Rating property rollup property ").append(rollupPropertyName).append(" on aspect ").append(rollupAspectName).append(" is not defined in the content model.");
                    log.debug((Object)msg.toString());
                }
            }
            finally {
                this.behaviourFilter.enableBehaviour(targetNode, ContentModel.ASPECT_AUDITABLE);
            }
        } else if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Rating property rollup aspect ").append(rollupAspectName).append(" is not defined in the content model & therefore the rollup was not persisted.");
            log.debug((Object)msg.toString());
        }
    }

    @Override
    public Rating getRatingByCurrentUser(NodeRef targetNode, String ratingSchemeName) {
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        return this.getRating(targetNode, ratingSchemeName, currentUser);
    }

    @Override
    public List<Rating> getRatingsByCurrentUser(NodeRef targetNode) {
        String fullyAuthenticatedUser = AuthenticationUtil.getFullyAuthenticatedUser();
        List<ChildAssociationRef> children = this.getRatingNodeChildren(targetNode, null, fullyAuthenticatedUser);
        ArrayList<Rating> result = new ArrayList<Rating>(children.size());
        for (ChildAssociationRef child : children) {
            result.add(this.convertNodeRefToRating(fullyAuthenticatedUser, child.getChildRef()));
        }
        return result;
    }

    private Rating getRating(NodeRef targetNode, String ratingSchemeName, String user) {
        List<ChildAssociationRef> ratingChildren = this.getRatingNodeChildren(targetNode, ratingSchemeName, user);
        if (ratingChildren.isEmpty()) {
            return null;
        }
        ChildAssociationRef ratingNodeAssoc = ratingChildren.get(0);
        return this.convertNodeRefToRating(user, ratingNodeAssoc.getChildRef());
    }

    private Rating convertNodeRefToRating(String user, NodeRef ratingNode) {
        Map properties = this.nodeService.getProperties(ratingNode);
        String existingRatingScheme = (String)properties.get(ContentModel.PROP_RATING_SCHEME);
        Float existingRatingScore = (Float)properties.get(ContentModel.PROP_RATING_SCORE);
        Date existingRatingDate = (Date)properties.get(ContentModel.PROP_RATED_AT);
        Rating result = new Rating(this.getRatingScheme(existingRatingScheme), existingRatingScore.floatValue(), user, existingRatingDate);
        return result;
    }

    @Override
    public Rating removeRatingByCurrentUser(NodeRef targetNode, String ratingScheme) {
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        return this.removeRating(targetNode, ratingScheme, currentUser);
    }

    private Rating removeRating(NodeRef targetNode, String ratingSchemeName, String user) {
        List<ChildAssociationRef> ratingChildren = this.getRatingNodeChildren(targetNode, ratingSchemeName, user);
        if (ratingChildren.isEmpty()) {
            return null;
        }
        ChildAssociationRef child = ratingChildren.get(0);
        Map properties = this.nodeService.getProperties(child.getChildRef());
        Rating result = null;
        if (ratingSchemeName.equals(properties.get(ContentModel.PROP_RATING_SCHEME))) {
            Float score = (Float)properties.get(ContentModel.PROP_RATING_SCORE);
            Date date = (Date)properties.get(ContentModel.PROP_RATED_AT);
            this.nodeService.deleteNode(child.getChildRef());
            this.recalculateRatingRollups(targetNode, this.getRatingScheme(ratingSchemeName));
            result = new Rating(this.getRatingScheme(ratingSchemeName), score.floatValue(), user, date);
        }
        return result;
    }

    @Override
    public float getTotalRating(NodeRef targetNode, String ratingSchemeName) {
        Serializable result = this.getRatingRollup(targetNode, ratingSchemeName, "Total");
        if (result == null) {
            result = new Float(0.0f);
        }
        return ((Float)result).floatValue();
    }

    @Override
    public float getAverageRating(NodeRef targetNode, String ratingSchemeName) {
        float totalRating = this.getTotalRating(targetNode, ratingSchemeName);
        int ratingCount = this.getRatingsCount(targetNode, ratingSchemeName);
        return ratingCount == 0 ? -1.0f : totalRating / (float)ratingCount;
    }

    @Override
    public int getRatingsCount(NodeRef targetNode, String ratingSchemeName) {
        Serializable result = this.getRatingRollup(targetNode, ratingSchemeName, "Count");
        if (result == null) {
            result = new Integer(0);
        }
        return (Integer)result;
    }

    @Override
    public Serializable getRatingRollup(NodeRef targetNode, String ratingSchemeName, String ratingRollupName) {
        RatingScheme scheme = this.schemeRegistry.getRatingSchemes().get(ratingSchemeName);
        if (scheme == null) {
            throw new RatingServiceException("Cannot retrieve rollup. Unrecognized rating scheme " + ratingSchemeName);
        }
        QName rollupAspectName = this.ratingNamingConventions.getRollupAspectNameFor(ratingSchemeName);
        Serializable result = null;
        if (this.nodeService.hasAspect(targetNode, rollupAspectName)) {
            QName rollupPropertyName = this.ratingNamingConventions.getRollupPropertyNameFor(ratingSchemeName, ratingRollupName);
            result = this.nodeService.getProperty(targetNode, rollupPropertyName);
        }
        return result;
    }

    List<ChildAssociationRef> getRatingNodeChildren(NodeRef targetNode, String ratingSchemeName, String user) {
        QNamePattern qnamePattern = this.ratingNamingConventions.getRatingAssocPatternForUser(user, ratingSchemeName);
        List results = this.nodeService.getChildAssocs(targetNode, (QNamePattern)ContentModel.ASSOC_RATINGS, qnamePattern);
        return results;
    }

    Rating getRatingFrom(NodeRef ratingNode) {
        ChildAssociationRef parentAssoc = this.nodeService.getPrimaryParent(ratingNode);
        String appliedBy = parentAssoc.getQName().getLocalName();
        Map properties = this.nodeService.getProperties(ratingNode);
        String schemeName = (String)properties.get(ContentModel.PROP_RATING_SCHEME);
        Float score = (Float)properties.get(ContentModel.PROP_RATING_SCORE);
        Date ratedAt = (Date)properties.get(ContentModel.PROP_RATED_AT);
        RatingScheme scheme = this.getRatingScheme(schemeName);
        Rating result = new Rating(scheme, score.floatValue(), appliedBy, ratedAt);
        return result;
    }
}

